/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.activities.action;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialActivityLocalServiceUtil;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class RSSAction
extends com.liferay.portal.struts.RSSAction {
    protected String exportToRSS(PortletRequest portletRequest, String title, String description, String format, double version, String displayStyle, List<SocialActivity> activities, ServiceContext serviceContext) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)title));
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        for (SocialActivity activity : activities) {
            SocialActivityFeedEntry activityFeedEntry = SocialActivityInterpreterLocalServiceUtil.interpret((String)"", (SocialActivity)activity, (ServiceContext)serviceContext);
            if (activityFeedEntry == null) continue;
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            String value = null;
            value = displayStyle.equals("title") ? "" : activityFeedEntry.getBody();
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            if (Validator.isNotNull((String)activityFeedEntry.getLink())) {
                syndEntry.setLink(activityFeedEntry.getLink());
            }
            syndEntry.setPublishedDate(new Date(activity.getCreateDate()));
            syndEntry.setTitle(HtmlUtil.extractText((String)activityFeedEntry.getTitle()));
            syndEntry.setUri(syndEntry.getLink());
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)format, (double)version));
        ArrayList<SyndLinkImpl> syndLinks = new ArrayList<SyndLinkImpl>();
        syndFeed.setLinks(syndLinks);
        SyndLinkImpl selfSyndLink = new SyndLinkImpl();
        syndLinks.add(selfSyndLink);
        String link = String.valueOf(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay)) + "/-/" + "activities/rss";
        selfSyndLink.setHref(link);
        selfSyndLink.setRel("self");
        SyndLinkImpl alternateSyndLink = new SyndLinkImpl();
        syndLinks.add(alternateSyndLink);
        alternateSyndLink.setHref(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
        alternateSyndLink.setRel("alternate");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(title);
        syndFeed.setUri(link);
        return RSSUtil.export((SyndFeed)syndFeed);
    }

    protected List<SocialActivity> getActivities(PortletRequest portletRequest, int max) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getScopeGroupId());
        int start = 0;
        if (group.isOrganization()) {
            return SocialActivityLocalServiceUtil.getOrganizationActivities((long)group.getOrganizationId(), (int)start, (int)max);
        }
        if (group.isRegularSite()) {
            return SocialActivityLocalServiceUtil.getGroupActivities((long)group.getGroupId(), (int)start, (int)max);
        }
        if (group.isUser()) {
            return SocialActivityLocalServiceUtil.getUserActivities((long)group.getClassPK(), (int)start, (int)max);
        }
        return Collections.emptyList();
    }

    @Override
    protected byte[] getRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String feedTitle = ParamUtil.getString((PortletRequest)resourceRequest, (String)"feedTitle");
        String format = ParamUtil.getString((PortletRequest)resourceRequest, (String)"type", (String)RSSUtil.FORMAT_DEFAULT);
        double version = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"version", (double)RSSUtil.VERSION_DEFAULT);
        String displayStyle = ParamUtil.getString((PortletRequest)resourceRequest, (String)"displayStyle", (String)RSSUtil.DISPLAY_STYLE_DEFAULT);
        int max = ParamUtil.getInteger((PortletRequest)resourceRequest, (String)"max", (int)SearchContainer.DEFAULT_DELTA);
        List<SocialActivity> activities = this.getActivities((PortletRequest)resourceRequest, max);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)resourceRequest);
        String rss = this.exportToRSS((PortletRequest)resourceRequest, feedTitle, null, format, version, displayStyle, activities, serviceContext);
        return rss.getBytes("UTF-8");
    }
}

