/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletSession;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;

public class PortletSessionImpl
implements LiferayPortletSession {
    private PortletContext _portletContext;
    private String _portletScope;
    private HttpSession _session;

    public PortletSessionImpl(HttpSession session, PortletContext portletContext, String portletName, long plid) {
        this._session = session;
        this._portletContext = portletContext;
        this._portletScope = this._getPortletScope(portletName, plid);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this._getPortletScopeName(name);
        return this._session.getAttribute(scopeName);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this._getPortletScopeName(name);
        }
        return this._session.getAttribute(name);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getAttributeMap(2);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> enu = this._getAttributeNames(scope, false);
        int portletScopeLength = this._portletScope.length();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            Object value = this._session.getAttribute(name);
            if (scope == 2) {
                if (name.length() <= portletScopeLength + 1 || !name.startsWith(String.valueOf(this._portletScope) + "?")) continue;
                name = name.substring(portletScopeLength + 1);
            }
            map.put(name, value);
        }
        return map;
    }

    public Enumeration<String> getAttributeNames() {
        return this._getAttributeNames(2, true);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        return this._getAttributeNames(scope, true);
    }

    public long getCreationTime() {
        return this._session.getCreationTime();
    }

    public HttpSession getHttpSession() {
        return this._session;
    }

    public String getId() {
        return this._session.getId();
    }

    public long getLastAccessedTime() {
        return this._session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this._session.getMaxInactiveInterval();
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public void invalidate() {
        this._session.invalidate();
    }

    public boolean isNew() {
        return this._session.isNew();
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this._getPortletScopeName(name);
        this._session.removeAttribute(scopeName);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this._getPortletScopeName(name);
        }
        this._session.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this._getPortletScopeName(name);
        this._session.setAttribute(scopeName, value);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this._getPortletScopeName(name);
        }
        this._session.setAttribute(name, value);
    }

    public void setHttpSession(HttpSession session) {
        this._session = session;
    }

    public void setMaxInactiveInterval(int interval) {
        this._session.setMaxInactiveInterval(interval);
    }

    private Enumeration<String> _getAttributeNames(int scope, boolean removePrefix) {
        if (scope != 2) {
            return this._session.getAttributeNames();
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        int portletScopeLength = this._portletScope.length();
        Enumeration enu = this._session.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (removePrefix) {
                if (name.length() <= portletScopeLength + 1 || !name.startsWith(String.valueOf(this._portletScope) + "?")) continue;
                name = name.substring(portletScopeLength + 1);
            }
            attributeNames.add(name);
        }
        return Collections.enumeration(attributeNames);
    }

    private String _getPortletScope(String portletName, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append("javax.portlet.p.");
        sb.append(portletName);
        sb.append("_LAYOUT_");
        sb.append(plid);
        return sb.toString();
    }

    private String _getPortletScopeName(String name) {
        return this._portletScope.concat("?").concat(name);
    }
}

