/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.webdav.methods.Method;
import javax.servlet.http.HttpServletRequest;

public class UnlockMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(UnlockMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        String token = this.getToken(webDAVRequest.getHttpServletRequest());
        if (!storage.isSupportsClassTwo()) {
            return 405;
        }
        if (storage.unlockResource(webDAVRequest, token)) {
            return 204;
        }
        return 412;
    }

    protected String getToken(HttpServletRequest request) {
        int index;
        String token = "";
        String value = GetterUtil.getString((String)request.getHeader("Lock-Token"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("\"Lock-Token\" header is " + value));
        }
        if (value.startsWith("<") && value.endsWith(">")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((index = value.indexOf("opaquelocktoken:")) >= 0 && (index += "opaquelocktoken:".length()) < value.length()) {
            token = GetterUtil.getString((String)value.substring(index));
        }
        return token;
    }
}

