/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.util.xml.XMLFormatter;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LockMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(LockMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            return this.doProcess(webDAVRequest);
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    protected int doProcess(WebDAVRequest webDAVRequest) throws Exception {
        Status status;
        block18: {
            WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
            if (!storage.isSupportsClassTwo()) {
                return 405;
            }
            HttpServletRequest request = webDAVRequest.getHttpServletRequest();
            HttpServletResponse response = webDAVRequest.getHttpServletResponse();
            Lock lock = null;
            status = null;
            String lockUuid = webDAVRequest.getLockUuid();
            long timeout = WebDAVUtil.getTimeout((HttpServletRequest)request);
            if (Validator.isNull((String)lockUuid)) {
                String owner = null;
                String xml = new String(FileUtil.getBytes((InputStream)request.getInputStream()));
                if (Validator.isNotNull((String)xml)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Request XML\n" + XMLFormatter.toString((String)xml)));
                    }
                    Document document = SAXReaderUtil.read((String)xml);
                    Element rootElement = document.getRootElement();
                    boolean exclusive = false;
                    Element lockscopeElement = rootElement.element("lockscope");
                    for (Element element : lockscopeElement.elements()) {
                        String name = GetterUtil.getString((String)element.getName());
                        if (!name.equals("exclusive")) continue;
                        exclusive = true;
                    }
                    if (!exclusive) {
                        return 400;
                    }
                    Element ownerElement = rootElement.element("owner");
                    owner = ownerElement.getTextTrim();
                    if (Validator.isNull((String)owner)) {
                        List hrefElements = ownerElement.elements("href");
                        for (Element hrefElement : hrefElements) {
                            owner = "<D:href>" + hrefElement.getTextTrim() + "</D:href>";
                        }
                    }
                } else {
                    _log.error((Object)"Empty request XML");
                    return 412;
                }
                status = storage.lockResource(webDAVRequest, owner, timeout);
                lock = (Lock)status.getObject();
            } else {
                try {
                    lock = storage.refreshResourceLock(webDAVRequest, lockUuid, timeout);
                    status = new Status(200);
                }
                catch (WebDAVException wde) {
                    if (wde.getCause() instanceof NoSuchLockException) {
                        return 412;
                    }
                    throw wde;
                }
            }
            if (lock == null) {
                return status.getCode();
            }
            long depth = WebDAVUtil.getDepth((HttpServletRequest)request);
            String xml = this.getResponseXML(lock, depth);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response XML\n" + xml));
            }
            String lockToken = "<opaquelocktoken:" + lock.getUuid() + ">";
            response.setContentType("text/xml; charset=UTF-8");
            response.setHeader("Lock-Token", lockToken);
            response.setStatus(status.getCode());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Returning lock token " + lockToken));
            }
            try {
                ServletResponseUtil.write((HttpServletResponse)response, (String)xml);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block18;
                _log.warn((Throwable)e2);
            }
        }
        return status.getCode();
    }

    protected String getResponseXML(Lock lock, long depth) throws Exception {
        StringBundler sb = new StringBundler(20);
        long timeoutSecs = lock.getExpirationTime() / 1000L;
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        sb.append("<D:prop xmlns:D=\"DAV:\">");
        sb.append("<D:lockdiscovery>");
        sb.append("<D:activelock>");
        sb.append("<D:locktype><D:write/></D:locktype>");
        sb.append("<D:lockscope><D:exclusive/></D:lockscope>");
        if (depth < 0L) {
            sb.append("<D:depth>Infinity</D:depth>");
        }
        sb.append("<D:owner>");
        sb.append(lock.getOwner());
        sb.append("</D:owner>");
        sb.append("<D:timeout>");
        if (timeoutSecs > 0L) {
            sb.append("Second-" + timeoutSecs);
        } else {
            sb.append("Infinite");
        }
        sb.append("</D:timeout>");
        sb.append("<D:locktoken><D:href>");
        sb.append("opaquelocktoken:");
        sb.append(lock.getUuid());
        sb.append("</D:href></D:locktoken>");
        sb.append("</D:activelock>");
        sb.append("</D:lockdiscovery>");
        sb.append("</D:prop>");
        return XMLFormatter.toString((String)sb.toString());
    }
}

