/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifyDynamicDataMapping
extends VerifyProcess {
    private long _ddlRecordSetClassNameId;
    private long _dlFileEntryMetadataClassNameId;

    protected FileEntry addFileEntry(long companyId, long userId, long groupId, long folderId, String fileName, String filePath, int status) throws Exception {
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        String title = fileName;
        int index = title.indexOf(46);
        if (index > 0) {
            title = title.substring(0, index);
        }
        File file = DLStoreUtil.getFile((long)companyId, (long)0L, (String)filePath);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        FileEntry fileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)groupId, (long)folderId, (String)fileName, (String)contentType, (String)title, (String)"", (String)"", (File)file, (ServiceContext)serviceContext);
        this.updateFileEntryStatus(fileEntry, status, serviceContext);
        return fileEntry;
    }

    @Override
    protected void doVerify() throws Exception {
        this._ddlRecordSetClassNameId = PortalUtil.getClassNameId(DDLRecordSet.class);
        this._dlFileEntryMetadataClassNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
        List structures = DDMStructureLocalServiceUtil.getStructures();
        for (DDMStructure structure : structures) {
            this.updateFileUploadReferences(structure);
        }
    }

    protected String getFileUploadPath(BaseModel<?> baseModel) throws Exception {
        StringBundler sb = new StringBundler(7);
        long primaryKey = 0L;
        String version = "";
        if (baseModel instanceof DDLRecordModel) {
            DDLRecord ddlRecord = (DDLRecord)baseModel;
            primaryKey = ddlRecord.getPrimaryKey();
            DDLRecordVersion ddlRecordVersion = ddlRecord.getRecordVersion();
            version = ddlRecordVersion.getVersion();
        } else {
            DLFileEntryMetadata dlFileEntryMetadata = (DLFileEntryMetadata)baseModel;
            primaryKey = dlFileEntryMetadata.getPrimaryKey();
            DLFileVersion dlFileVersion = dlFileEntryMetadata.getFileVersion();
            version = dlFileVersion.getVersion();
        }
        sb.append("ddm");
        sb.append("/");
        sb.append(baseModel.getModelClassName());
        sb.append("/");
        sb.append(primaryKey);
        sb.append("/");
        sb.append(version);
        return sb.toString();
    }

    protected String getJSON(FileEntry fileEntry) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("groupId", fileEntry.getGroupId());
        jsonObject.put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }

    protected boolean hasFileUploadFields(DDMStructure structure) throws Exception {
        Map fieldsMap = structure.getFieldsMap();
        for (Map field : fieldsMap.values()) {
            String dataType = (String)field.get("dataType");
            if (!dataType.equals("file-upload")) continue;
            return true;
        }
        return false;
    }

    protected void updateDDLFileUploadReferences(long ddlRecordSetId) throws Exception {
        List ddlRecords = DDLRecordLocalServiceUtil.getRecords((long)ddlRecordSetId);
        for (DDLRecord ddlRecord : ddlRecords) {
            this.updateFileUploadReferences(ddlRecord.getCompanyId(), ddlRecord.getDDMStorageId(), ddlRecord.getUserId(), ddlRecord.getGroupId(), (BaseModel<?>)ddlRecord, ddlRecord.getStatus());
        }
    }

    protected void updateDLFileUploadReferences(long dlFileEntryMetadataId) throws Exception {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)dlFileEntryMetadataId);
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntryMetadata.getFileEntryId());
        FileVersion fileVersion = fileEntry.getFileVersion();
        this.updateFileUploadReferences(fileEntry.getCompanyId(), dlFileEntryMetadata.getDDMStorageId(), fileEntry.getUserId(), fileEntry.getGroupId(), (BaseModel<?>)dlFileEntryMetadata, fileVersion.getStatus());
    }

    protected void updateFieldValues(long storageId, Map<String, String> fieldValues) throws Exception {
        Fields fields = new Fields();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            Field field = new Field(storageId, entry.getKey(), (Serializable)((Object)entry.getValue()));
            fields.put(field);
        }
        ServiceContext serviceContext = new ServiceContext();
        StorageEngineUtil.update((long)storageId, (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
    }

    protected void updateFileEntryStatus(FileEntry fileEntry, int status, ServiceContext serviceContext) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("event", "add");
        DLFileEntryLocalServiceUtil.updateStatus((long)fileVersion.getUserId(), (long)fileVersion.getFileVersionId(), (int)status, workflowContext, (ServiceContext)serviceContext);
    }

    protected void updateFileUploadReferences(DDMStructure structure) throws Exception {
        if (!this.hasFileUploadFields(structure)) {
            return;
        }
        List structureLinks = DDMStructureLinkLocalServiceUtil.getStructureLinks((long)structure.getStructureId(), (int)-1, (int)-1);
        for (DDMStructureLink structureLink : structureLinks) {
            this.updateFileUploadReferences(structureLink);
        }
        this.updateStructure(structure);
    }

    protected void updateFileUploadReferences(DDMStructureLink structureLink) throws Exception {
        long classNameId = structureLink.getClassNameId();
        if (classNameId == this._ddlRecordSetClassNameId) {
            this.updateDDLFileUploadReferences(structureLink.getClassPK());
        } else if (classNameId == this._dlFileEntryMetadataClassNameId) {
            this.updateDLFileUploadReferences(structureLink.getClassPK());
        }
    }

    protected void updateFileUploadReferences(long companyId, long storageId, long userId, long groupId, BaseModel<?> baseModel, int status) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Fields fields = StorageEngineUtil.getFields((long)storageId);
        for (Field field : fields) {
            String dataType = field.getDataType();
            if (!dataType.equals("file-upload") || field.getValue() == null) continue;
            String valueString = String.valueOf(field.getValue());
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String filePath = String.valueOf(this.getFileUploadPath(baseModel)) + "/" + field.getName();
            FileEntry fileEntry = this.addFileEntry(companyId, userId, groupId, 0L, jsonObject.getString("name"), filePath, status);
            fieldValues.put(field.getName(), this.getJSON(fileEntry));
        }
        this.updateFieldValues(storageId, fieldValues);
    }

    protected void updateStructure(DDMStructure structure) throws Exception {
        String xsd = this.updateXSD(structure.getXsd());
        structure.setXsd(xsd);
        DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)structure);
    }

    protected String updateXSD(String xsd) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
        return DDMXMLUtil.formatXML((Document)document);
    }

    protected void updateXSDDynamicElement(Element element) {
        String dataType = element.attributeValue("dataType");
        if (Validator.equals((Object)dataType, (Object)"file-upload")) {
            element.addAttribute("dataType", "document-library");
            element.addAttribute("type", "ddm-documentlibrary");
        }
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
    }
}

