/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import java.util.List;

public class VerifyBlogs
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyBlogs.class);

    @Override
    protected void doVerify() throws Exception {
        List entries = BlogsEntryLocalServiceUtil.getNoAssetEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries with no asset"));
        }
        for (BlogsEntry entry : entries) {
            try {
                BlogsEntryLocalServiceUtil.updateAsset((long)entry.getUserId(), (BlogsEntry)entry, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for entry " + entry.getEntryId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for entries");
        }
    }
}

