/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.template.AbstractTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;

public class VelocityTemplate
extends AbstractTemplate {
    private VelocityContext _velocityContext;
    private VelocityEngine _velocityEngine;

    public VelocityTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, VelocityContext velocityContext, VelocityEngine velocityEngine, TemplateContextHelper templateContextHelper) {
        super(templateResource, errorTemplateResource, templateContextHelper, "vm", PropsValues.VELOCITY_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL);
        this._velocityContext = velocityContext == null ? new VelocityContext() : new VelocityContext((Context)velocityContext);
        this._velocityEngine = velocityEngine;
    }

    public Object get(String key) {
        return this._velocityContext.get(key);
    }

    public String[] getKeys() {
        Object[] keyObjects = this._velocityContext.getKeys();
        Context context = this._velocityContext.getChainedContext();
        Object[] innerKeyObjects = context.getKeys();
        Object[] keys = new String[keyObjects.length + innerKeyObjects.length];
        ArrayUtil.combine((Object[])keyObjects, (Object[])innerKeyObjects, (Object[])keys);
        return keys;
    }

    public void put(String key, Object value) {
        if (value == null) {
            return;
        }
        this._velocityContext.put(key, value);
    }

    @Override
    protected void handleException(Exception exception, Writer writer) throws TemplateException {
        this.put("exception", exception.getMessage());
        if (this.templateResource instanceof StringTemplateResource) {
            StringTemplateResource stringTemplateResource = (StringTemplateResource)this.templateResource;
            this.put("script", stringTemplateResource.getContent());
        }
        if (exception instanceof ParseErrorException) {
            ParseErrorException pee = (ParseErrorException)exception;
            this.put("column", pee.getColumnNumber());
            this.put("line", pee.getLineNumber());
        }
        try {
            this.processTemplate(this.errorTemplateResource, writer);
        }
        catch (Exception e2) {
            throw new TemplateException("Unable to process Velocity template " + this.errorTemplateResource.getTemplateId(), (Throwable)e2);
        }
    }

    @Override
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource("vm", templateResource);
        try {
            try {
                Template template = AccessController.doPrivileged(new TemplatePrivilegedExceptionAction(templateResource));
                template.merge((Context)this._velocityContext, writer);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource("vm", null);
        }
    }

    private class TemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Template> {
        private TemplateResource _templateResource;

        public TemplatePrivilegedExceptionAction(TemplateResource templateResource) {
            this._templateResource = templateResource;
        }

        @Override
        public Template run() throws Exception {
            return VelocityTemplate.this._velocityEngine.getTemplate(VelocityTemplate.this.getTemplateResourceUUID(this._templateResource), "UTF-8");
        }
    }
}

