/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.URLResourceParser;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;

public class VelocityServletResourceParser
extends URLResourceParser {
    private static Log _log = LogFactoryUtil.getLog(VelocityServletResourceParser.class);

    @Override
    public URL getURL(String source) throws IOException {
        URL url;
        ServletContext servletContext;
        int pos = source.indexOf("_SERVLET_CONTEXT_");
        if (pos == -1) {
            return null;
        }
        String servletContextName = source.substring(0, pos);
        if (Validator.isNull((String)servletContextName)) {
            servletContextName = PortalUtil.getPathContext();
        }
        if ((servletContext = ServletContextPool.get((String)servletContextName)) == null) {
            _log.error((Object)(String.valueOf(source) + " is not valid because " + servletContextName + " does not map to a servlet context"));
            return null;
        }
        String name = source.substring(pos + "_SERVLET_CONTEXT_".length());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(name) + " is associated with the servlet context " + servletContextName + " " + servletContext));
        }
        if ((url = servletContext.getResource(name)) == null && name.endsWith("/init_custom.vm")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("The template " + name + " should be created"));
            }
            String portalServletContextName = PortalUtil.getPathContext();
            ServletContext portalServletContext = ServletContextPool.get((String)portalServletContextName);
            url = portalServletContext.getResource("/html/themes/_unstyled/template/init_custom.vm");
        }
        return url;
    }
}

