/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static final String _GET_COMPANY_IDS = "select companyId from Company, Shard where Company.companyId = Shard.classPK and Shard.name = ?";
    private static Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static PortalInstances _instance = new PortalInstances();
    private Set<String> _autoLoginIgnoreHosts;
    private Set<String> _autoLoginIgnorePaths;
    private long[] _companyIds = new long[0];
    private Set<String> _virtualHostsIgnoreHosts;
    private Set<String> _virtualHostsIgnorePaths;
    private String[] _webIds;

    public static void addCompanyId(long companyId) {
        _instance._addCompanyId(companyId);
    }

    public static long getCompanyId(HttpServletRequest request) {
        return _instance._getCompanyId(request);
    }

    public static long[] getCompanyIds() {
        return _instance._getCompanyIds();
    }

    public static long[] getCompanyIdsBySQL() throws SQLException {
        return _instance._getCompanyIdsBySQL();
    }

    public static long getDefaultCompanyId() {
        return _instance._getDefaultCompanyId();
    }

    public static String[] getWebIds() {
        return _instance._getWebIds();
    }

    public static long initCompany(ServletContext servletContext, String webId) {
        return _instance._initCompany(servletContext, webId);
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _instance._isAutoLoginIgnoreHost(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _instance._isAutoLoginIgnorePath(path);
    }

    public static boolean isCompanyActive(long companyId) {
        return _instance._isCompanyActive(companyId);
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _instance._isVirtualHostsIgnoreHost(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _instance._isVirtualHostsIgnorePath(path);
    }

    public static void reload(ServletContext servletContext) {
        _instance._reload(servletContext);
    }

    public static void removeCompany(long companyId) {
        _instance._removeCompanyId(companyId);
    }

    private PortalInstances() {
        this._autoLoginIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.hosts"));
        this._autoLoginIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.paths"));
        this._virtualHostsIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.hosts"));
        this._virtualHostsIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.paths"));
    }

    private void _addCompanyId(long companyId) {
        if (ArrayUtil.contains((long[])this._companyIds, (long)companyId)) {
            return;
        }
        long[] companyIds = new long[this._companyIds.length + 1];
        System.arraycopy(this._companyIds, 0, companyIds, 0, this._companyIds.length);
        companyIds[this._companyIds.length] = companyId;
        this._companyIds = companyIds;
    }

    private long _getCompanyId(HttpServletRequest request) {
        long cookieCompanyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        Long companyIdObj = (Long)request.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from request " + companyIdObj));
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        long companyId = this._getCompanyIdByVirtualHosts(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from host " + companyId));
        }
        if (companyId <= 0L && (cookieCompanyId = GetterUtil.getLong((String)CookieKeys.getCookie((HttpServletRequest)request, (String)"COMPANY_ID", (boolean)false))) > 0L) {
            try {
                CompanyLocalServiceUtil.getCompanyById((long)cookieCompanyId);
                companyId = cookieCompanyId;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Company id from cookie " + companyId));
                }
            }
            catch (NoSuchCompanyException noSuchCompanyException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Company id from cookie " + cookieCompanyId + " does not exist"));
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (companyId <= 0L) {
            companyId = this._getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Default company id " + companyId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set company id " + companyId));
        }
        request.setAttribute("COMPANY_ID", (Object)new Long(companyId));
        CompanyThreadLocal.setCompanyId((Long)companyId);
        if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && request.getAttribute("VIRTUAL_HOST_LAYOUT_SET") == null) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                if (Validator.isNull((String)layoutSet.getVirtualHostname())) {
                    request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
        return companyId;
    }

    private long _getCompanyIdByVirtualHosts(HttpServletRequest request) {
        VirtualHost virtualHost;
        block10: {
            String host = PortalUtil.getHost((HttpServletRequest)request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Host " + host));
            }
            if (Validator.isNull((String)host) || this._isVirtualHostsIgnoreHost(host)) {
                return 0L;
            }
            try {
                virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
                if (virtualHost != null) break block10;
                return 0L;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return 0L;
            }
        }
        if (virtualHost.getLayoutSetId() != 0L) {
            LayoutSet layoutSet = null;
            try {
                ShardUtil.pushCompanyService((long)virtualHost.getCompanyId());
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
            }
            finally {
                ShardUtil.popCompanyService();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Company " + virtualHost.getCompanyId() + " is associated with layout set " + virtualHost.getLayoutSetId()));
            }
            request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
        }
        return virtualHost.getCompanyId();
    }

    private long[] _getCompanyIds() {
        return this._companyIds;
    }

    private long[] _getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        String currentShardName = ShardUtil.setTargetSource((String)PropsValues.SHARD_DEFAULT_NAME);
        if (Validator.isNotNull((String)currentShardName)) {
            ShardUtil.pushCompanyService((String)PropsValues.SHARD_DEFAULT_NAME);
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_COMPANY_IDS);
            ps.setString(1, currentShardName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                companyIds.add(companyId);
            }
        }
        catch (Throwable throwable) {
            if (Validator.isNotNull((String)currentShardName)) {
                ShardUtil.popCompanyService();
                ShardUtil.setTargetSource((String)currentShardName);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        if (Validator.isNotNull((String)currentShardName)) {
            ShardUtil.popCompanyService();
            ShardUtil.setTargetSource((String)currentShardName);
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[companyIds.size()]));
    }

    private long _getDefaultCompanyId() {
        return this._companyIds[0];
    }

    private String[] _getWebIds() {
        if (this._webIds != null) {
            return this._webIds;
        }
        if (Validator.isNull((String)PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new RuntimeException("Default web id must not be null");
        }
        try {
            List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
            ArrayList<String> webIdsList = new ArrayList<String>(companies.size());
            for (Company company : companies) {
                String webId = company.getWebId();
                if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                    webIdsList.add(0, webId);
                    continue;
                }
                webIdsList.add(webId);
            }
            this._webIds = webIdsList.toArray(new String[webIdsList.size()]);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (this._webIds == null || this._webIds.length == 0) {
            this._webIds = new String[]{PropsValues.COMPANY_DEFAULT_WEB_ID};
        }
        return this._webIds;
    }

    private long _initCompany(ServletContext servletContext, String webId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Begin initializing company with web id " + webId));
        }
        long companyId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.checkCompany((String)webId);
            companyId = company.getCompanyId();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        CompanyThreadLocal.setCompanyId((Long)companyId);
        LuceneHelperUtil.startup(companyId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize display");
        }
        try {
            String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory == null) {
                portletCategory = new PortletCategory();
            }
            PortletCategory newPortletCategory = PortletLocalServiceUtil.getEARDisplay((String)xml);
            portletCategory.merge(newPortletCategory);
            int i2 = 0;
            while (i2 < this._companyIds.length) {
                long currentCompanyId = this._companyIds[i2];
                PortletCategory currentPortletCategory = (PortletCategory)WebAppPool.get(currentCompanyId, "PORTLET_CATEGORY");
                if (currentPortletCategory != null) {
                    portletCategory.merge(currentPortletCategory);
                }
                ++i2;
            }
            WebAppPool.put(companyId, "PORTLET_CATEGORY", portletCategory);
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check journal content search");
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("journal.sync.content.search.on.startup"))) {
            try {
                JournalContentSearchLocalServiceUtil.checkContentSearches((long)companyId);
            }
            catch (Exception e4) {
                _log.error((Object)e4, (Throwable)e4);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process application startup events");
        }
        try {
            EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e5) {
            _log.error((Object)e5, (Throwable)e5);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("End initializing company with web id " + webId + " and company id " + companyId));
        }
        PortalInstances.addCompanyId(companyId);
        return companyId;
    }

    private boolean _isAutoLoginIgnoreHost(String host) {
        return this._autoLoginIgnoreHosts.contains(host);
    }

    private boolean _isAutoLoginIgnorePath(String path) {
        return this._autoLoginIgnorePaths.contains(path);
    }

    private boolean _isCompanyActive(long companyId) {
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company != null) {
                return company.isActive();
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return false;
    }

    private boolean _isVirtualHostsIgnoreHost(String host) {
        return this._virtualHostsIgnoreHosts.contains(host);
    }

    private boolean _isVirtualHostsIgnorePath(String path) {
        return this._virtualHostsIgnorePaths.contains(path);
    }

    private void _reload(ServletContext servletContext) {
        String[] webIds;
        this._companyIds = new long[0];
        this._webIds = null;
        String[] stringArray = webIds = this._getWebIds();
        int n = webIds.length;
        int n2 = 0;
        while (n2 < n) {
            String webId = stringArray[n2];
            this._initCompany(servletContext, webId);
            ++n2;
        }
    }

    private void _removeCompanyId(long companyId) {
        this._companyIds = ArrayUtil.remove((long[])this._companyIds, (long)companyId);
        this._webIds = null;
        this._getWebIds();
        LuceneHelperUtil.delete(companyId);
        LuceneHelperUtil.shutdown(companyId);
        WebAppPool.remove(companyId, "PORTLET_CATEGORY");
    }
}

