/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletSecurityUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.DeterminateKeyGenerator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InheritableMap;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURLComposite;
import com.liferay.portal.model.LayoutQueryStringComposite;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.TicketLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadPortletRequestImpl;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalPortEventListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PortletCategoryKeys;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletControlPanelWeightComparator;
import com.liferay.portal.webserver.WebServerServlet;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.StateAwareResponseImpl;
import com.liferay.portlet.admin.util.OmniadminUtil;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.expando.ValueDataException;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.NoSuchFeedException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.login.util.LoginUtil;
import com.liferay.portlet.messageboards.action.EditDiscussionAction;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.social.util.FacebookUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.util.Encryptor;
import com.liferay.util.JS;
import com.liferay.util.PwdGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

@DoPrivileged
public class PortalImpl
implements Portal {
    private static final String _J_SECURITY_CHECK = "j_security_check";
    private static final String _JSESSIONID = ";jsessionid=";
    private static final String _LOCALHOST = "localhost";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static Log _log = LogFactoryUtil.getLog(PortalImpl.class);
    private static Log _logWebServerServlet = LogFactoryUtil.getLog(WebServerServlet.class);
    private static Map<Long, String> _cdnHostHttpMap = new ConcurrentHashMap<Long, String>();
    private static Map<Long, String> _cdnHostHttpsMap = new ConcurrentHashMap<Long, String>();
    private static MethodHandler _resetCDNHostsMethodHandler = new MethodHandler(new MethodKey(PortalUtil.class, "resetCDNHosts", new Class[0]), new Object[0]);
    private static Date _upTime = new Date();
    private String[] _allSystemGroups;
    private String[] _allSystemOrganizationRoles;
    private String[] _allSystemRoles;
    private String[] _allSystemSiteRoles;
    private Set<String> _authTokenIgnoreActions;
    private Set<String> _authTokenIgnorePortlets;
    private Pattern _bannedResourceIdPattern = Pattern.compile(PropsValues.PORTLET_RESOURCE_ID_BANNED_PATHS_REGEXP, 2);
    private String _computerAddress;
    private String _computerName;
    private String[] _customSqlKeys;
    private String[] _customSqlValues;
    private EditDiscussionAction _editDiscussionAction = new EditDiscussionAction();
    private String _pathContext;
    private String _pathFriendlyURLPrivateGroup;
    private String _pathFriendlyURLPrivateUser;
    private String _pathFriendlyURLPublic;
    private String _pathImage;
    private String _pathMain;
    private String _pathModule;
    private String _pathProxy;
    private Map<String, Long> _plidToPortletIdMap = new ConcurrentHashMap<String, Long>();
    private final AtomicInteger _portalPort = new AtomicInteger(-1);
    private List<PortalPortEventListener> _portalPortEventListeners = new ArrayList<PortalPortEventListener>();
    private Set<String> _reservedParams;
    private final AtomicInteger _securePortalPort = new AtomicInteger(-1);
    private String[] _sortedSystemGroups;
    private String[] _sortedSystemOrganizationRoles;
    private String[] _sortedSystemRoles;
    private String[] _sortedSystemSiteRoles;

    public PortalImpl() {
        this._computerName = System.getProperty("env.COMPUTERNAME");
        if (Validator.isNull((String)this._computerName)) {
            this._computerName = System.getProperty("env.HOST");
        }
        if (Validator.isNull((String)this._computerName)) {
            this._computerName = System.getProperty("env.HOSTNAME");
        }
        if (Validator.isNull((String)this._computerName)) {
            try {
                this._computerName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        try {
            this._computerAddress = InetAddress.getByName(this._computerName).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        if (Validator.isNull((String)this._computerAddress)) {
            try {
                this._computerAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        this._pathProxy = PropsValues.PORTAL_PROXY_PATH;
        this._pathContext = ContextPathUtil.getContextPath((String)PortalContextLoaderListener.getPortalServletContextPath());
        this._pathContext = this._pathProxy.concat(this._pathContext);
        this._pathFriendlyURLPrivateGroup = String.valueOf(this._pathContext) + _PRIVATE_GROUP_SERVLET_MAPPING;
        this._pathFriendlyURLPrivateUser = String.valueOf(this._pathContext) + _PRIVATE_USER_SERVLET_MAPPING;
        this._pathFriendlyURLPublic = String.valueOf(this._pathContext) + _PUBLIC_GROUP_SERVLET_MAPPING;
        this._pathImage = String.valueOf(this._pathContext) + "/image";
        this._pathMain = String.valueOf(this._pathContext) + "/c";
        this._pathModule = String.valueOf(this._pathContext) + "/o";
        Object[] customSystemGroups = PropsUtil.getArray("system.groups");
        this._allSystemGroups = customSystemGroups == null || customSystemGroups.length == 0 ? GroupConstants.SYSTEM_GROUPS : (String[])ArrayUtil.append((Object[])GroupConstants.SYSTEM_GROUPS, (Object[])customSystemGroups);
        this._sortedSystemGroups = new String[this._allSystemGroups.length];
        System.arraycopy(this._allSystemGroups, 0, this._sortedSystemGroups, 0, this._allSystemGroups.length);
        Arrays.sort(this._sortedSystemGroups, new StringComparator());
        Object[] customSystemRoles = PropsUtil.getArray("system.roles");
        this._allSystemRoles = customSystemRoles == null || customSystemRoles.length == 0 ? RoleConstants.SYSTEM_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ROLES, (Object[])customSystemRoles);
        this._sortedSystemRoles = new String[this._allSystemRoles.length];
        System.arraycopy(this._allSystemRoles, 0, this._sortedSystemRoles, 0, this._allSystemRoles.length);
        Arrays.sort(this._sortedSystemRoles, new StringComparator());
        Object[] customSystemOrganizationRoles = PropsUtil.getArray("system.organization.roles");
        this._allSystemOrganizationRoles = customSystemOrganizationRoles == null || customSystemOrganizationRoles.length == 0 ? RoleConstants.SYSTEM_ORGANIZATION_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ORGANIZATION_ROLES, (Object[])customSystemOrganizationRoles);
        this._sortedSystemOrganizationRoles = new String[this._allSystemOrganizationRoles.length];
        System.arraycopy(this._allSystemOrganizationRoles, 0, this._sortedSystemOrganizationRoles, 0, this._allSystemOrganizationRoles.length);
        Arrays.sort(this._sortedSystemOrganizationRoles, new StringComparator());
        Object[] customSystemSiteRoles = PropsUtil.getArray("system.site.roles");
        this._allSystemSiteRoles = customSystemSiteRoles == null || customSystemSiteRoles.length == 0 ? RoleConstants.SYSTEM_SITE_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_SITE_ROLES, (Object[])customSystemSiteRoles);
        this._sortedSystemSiteRoles = new String[this._allSystemSiteRoles.length];
        System.arraycopy(this._allSystemSiteRoles, 0, this._sortedSystemSiteRoles, 0, this._allSystemSiteRoles.length);
        Arrays.sort(this._sortedSystemSiteRoles, new StringComparator());
        this._authTokenIgnoreActions = SetUtil.fromArray((Object[])PropsValues.AUTH_TOKEN_IGNORE_ACTIONS);
        this._authTokenIgnorePortlets = SetUtil.fromArray((Object[])PropsValues.AUTH_TOKEN_IGNORE_PORTLETS);
        this._reservedParams = new HashSet<String>();
        this._reservedParams.add("p_auth");
        this._reservedParams.add("p_auth_secret");
        this._reservedParams.add("p_l_id");
        this._reservedParams.add("p_l_reset");
        this._reservedParams.add("p_p_auth");
        this._reservedParams.add("p_p_id");
        this._reservedParams.add("p_p_i_id");
        this._reservedParams.add("p_p_lifecycle");
        this._reservedParams.add("p_p_url_type");
        this._reservedParams.add("p_p_state");
        this._reservedParams.add("p_p_state_rcv");
        this._reservedParams.add("p_p_mode");
        this._reservedParams.add("p_p_resource_id");
        this._reservedParams.add("p_p_cacheability");
        this._reservedParams.add("p_p_width");
        this._reservedParams.add("p_p_col_id");
        this._reservedParams.add("p_p_col_pos");
        this._reservedParams.add("p_p_col_count");
        this._reservedParams.add("p_p_static");
        this._reservedParams.add("p_p_isolated");
        this._reservedParams.add("p_t_lifecycle");
        this._reservedParams.add("p_v_l_s_g_id");
        this._reservedParams.add("p_f_id");
        this._reservedParams.add("p_j_a_id");
        this._reservedParams.add("saveLastPath");
        this._reservedParams.add("scroll");
    }

    public void addPageDescription(String description, HttpServletRequest request) {
        ListMergeable descriptionListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION");
        if (descriptionListMergeable == null) {
            descriptionListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
        }
        descriptionListMergeable.add((Object)description);
    }

    public void addPageKeywords(String keywords, HttpServletRequest request) {
        String[] keywordsArray;
        ListMergeable keywordsListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        if (keywordsListMergeable == null) {
            keywordsListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_KEYWORDS", (Object)keywordsListMergeable);
        }
        String[] stringArray = keywordsArray = StringUtil.split((String)keywords);
        int n = keywordsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (!keywordsListMergeable.contains((Object)keyword.toLowerCase())) {
                keywordsListMergeable.add((Object)keyword.toLowerCase());
            }
            ++n2;
        }
    }

    public void addPageSubtitle(String subtitle, HttpServletRequest request) {
        ListMergeable subtitleListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_SUBTITLE");
        if (subtitleListMergeable == null) {
            subtitleListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
        }
        subtitleListMergeable.add((Object)subtitle);
    }

    public void addPageTitle(String title, HttpServletRequest request) {
        ListMergeable titleListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_TITLE");
        if (titleListMergeable != null) {
            titleListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
        }
        titleListMergeable.add((Object)title);
    }

    public void addPortalPortEventListener(PortalPortEventListener portalPortEventListener) {
        if (!this._portalPortEventListeners.contains(portalPortEventListener)) {
            this._portalPortEventListeners.add(portalPortEventListener);
        }
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest request, String title, String url) {
        this.addPortletBreadcrumbEntry(request, title, url, null);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest request, String title, String url, Map<String, Object> data) {
        ArrayList<BreadcrumbEntry> breadcrumbEntries;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        if (Validator.isNotNull((String)portletDisplay.getId()) && !portletDisplay.isFocused()) {
            name = String.valueOf(name) + "_" + portletDisplay.getId();
        }
        if ((breadcrumbEntries = (ArrayList<BreadcrumbEntry>)request.getAttribute(name)) == null) {
            breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
            request.setAttribute(name, breadcrumbEntries);
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setData(data);
        breadcrumbEntry.setTitle(title);
        breadcrumbEntry.setURL(url);
        breadcrumbEntries.add(breadcrumbEntry);
    }

    public void addPortletDefaultResource(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long groupId = 0L;
        groupId = layout.isTypeControlPanel() ? themeDisplay.getScopeGroupId() : this.getScopeGroupId(layout, portlet.getPortletId());
        this.addDefaultResource(themeDisplay.getCompanyId(), groupId, layout, portlet, true);
        this.addDefaultResource(themeDisplay.getCompanyId(), groupId, layout, portlet, false);
    }

    public void addPortletDefaultResource(long companyId, Layout layout, Portlet portlet) throws PortalException, SystemException {
        this.addDefaultResource(companyId, layout, portlet, true);
        this.addDefaultResource(companyId, layout, portlet, false);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, Layout layout, String url, boolean doAsUser) {
        if (doAsUser) {
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                url = HttpUtil.addParameter((String)url, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                url = HttpUtil.addParameter((String)url, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
            }
        }
        if (layout.isTypeControlPanel()) {
            if (themeDisplay.getDoAsGroupId() > 0L) {
                url = HttpUtil.addParameter((String)url, (String)"doAsGroupId", (long)themeDisplay.getDoAsGroupId());
            }
            if (themeDisplay.getRefererPlid() != 0L) {
                url = HttpUtil.addParameter((String)url, (String)"refererPlid", (long)themeDisplay.getRefererPlid());
            }
            if (Validator.isNotNull((String)themeDisplay.getControlPanelCategory())) {
                url = HttpUtil.addParameter((String)url, (String)"controlPanelCategory", (String)themeDisplay.getControlPanelCategory());
            }
        }
        return url;
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, String url) {
        return this.addPreservedParameters(themeDisplay, themeDisplay.getLayout(), url, true);
    }

    public void clearRequestParameters(RenderRequest renderRequest) {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)renderRequest;
        if (renderRequestImpl.isTriggeredByActionURL()) {
            Map<String, String[]> renderParameters = renderRequestImpl.getRenderParameters();
            renderParameters.clear();
        }
    }

    public void copyRequestParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        StateAwareResponseImpl stateAwareResponseImpl;
        if (actionResponse instanceof StateAwareResponseImpl && (stateAwareResponseImpl = (StateAwareResponseImpl)actionResponse).getRedirectLocation() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Cannot copy parameters on a redirected StateAwareResponseImpl");
            }
            return;
        }
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        Map<String, String[]> renderParameters = actionResponseImpl.getRenderParameterMap();
        actionResponse.setRenderParameter("p_p_lifecycle", "1");
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = actionRequest.getParameterValues(param);
            if (renderParameters.get(String.valueOf(actionResponseImpl.getNamespace()) + param) != null) continue;
            actionResponse.setRenderParameter(param, values);
        }
    }

    public String escapeRedirect(String url) {
        if (Validator.isNull((String)url) || !HttpUtil.hasDomain((String)url)) {
            return url;
        }
        String domain = HttpUtil.getDomain((String)url);
        int pos = domain.indexOf(58);
        if (pos != -1) {
            domain = domain.substring(0, pos);
        }
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyByVirtualHost((String)domain);
            if (company != null) {
                return url;
            }
        }
        catch (Exception exception) {}
        try {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet((String)domain);
            if (layoutSet != null) {
                return url;
            }
        }
        catch (Exception exception) {}
        try {
            String securityMode = PropsValues.REDIRECT_URL_SECURITY_MODE;
            if (securityMode.equals("domain")) {
                Object[] allowedDomains = PropsValues.REDIRECT_URL_DOMAINS_ALLOWED;
                if (allowedDomains.length > 0 && !ArrayUtil.contains((Object[])allowedDomains, (Object)domain)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Redirect URL " + url + " is not allowed"));
                    }
                    url = null;
                }
            } else if (securityMode.equals("ip")) {
                String[] allowedIps = PropsValues.REDIRECT_URL_IPS_ALLOWED;
                if (allowedIps.length == 0) {
                    return url;
                }
                InetAddress inetAddress = InetAddress.getByName(domain);
                String hostAddress = inetAddress.getHostAddress();
                String serverIp = this.getComputerAddress();
                boolean serverIpIsHostAddress = serverIp.equals(hostAddress);
                String[] stringArray = allowedIps;
                int n = allowedIps.length;
                int n2 = 0;
                while (n2 < n) {
                    String ip = stringArray[n2];
                    if (serverIpIsHostAddress && ip.equals("SERVER_IP") || ip.equals(hostAddress)) {
                        return url;
                    }
                    ++n2;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect URL " + url + " is not allowed"));
                }
                url = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to determine IP for redirect URL " + url));
            }
            url = null;
        }
        return url;
    }

    public String generateRandomKey(HttpServletRequest request, String input) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isAjax() || themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
            return PwdGenerator.getPassword((String)"abcdefghijklmnopqrstuvwxyz", (int)4);
        }
        return DeterminateKeyGenerator.generate((String)input);
    }

    public LayoutQueryStringComposite getActualLayoutQueryStringComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        Layout layout = null;
        String queryString = "";
        if (Validator.isNull((String)friendlyURL)) {
            layout = LayoutLocalServiceUtil.fetchFirstLayout((long)groupId, (boolean)privateLayout, (long)0L);
            if (layout == null) {
                throw new NoSuchLayoutException("{groupId=" + groupId + ", privateLayout=" + privateLayout + "}");
            }
        } else {
            LayoutQueryStringComposite layoutQueryStringComposite = this.getPortletFriendlyURLMapperLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
            layout = layoutQueryStringComposite.getLayout();
            queryString = layoutQueryStringComposite.getQueryString();
        }
        return new LayoutQueryStringComposite(layout, queryString);
    }

    public String getActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        String actualURL = null;
        if (friendlyURL != null) {
            if (friendlyURL.startsWith("/-/")) {
                try {
                    actualURL = this.getJournalArticleActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
                }
                catch (Exception e2) {
                    throw new NoSuchLayoutException((Throwable)e2);
                }
            }
            if (friendlyURL.startsWith("/~")) {
                try {
                    actualURL = this.getVirtualLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
                }
                catch (Exception e3) {
                    throw new NoSuchLayoutException((Throwable)e3);
                }
            }
        }
        if (actualURL == null) {
            actualURL = this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
        }
        return actualURL;
    }

    public Locale[] getAlternateLocales(HttpServletRequest request) throws PortalException, SystemException {
        Locale[] availableLocales = LanguageUtil.getAvailableLocales();
        long mainJournalArticleId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_j_a_id");
        if (mainJournalArticleId <= 0L) {
            return availableLocales;
        }
        JournalArticle mainJournalArticle = JournalArticleLocalServiceUtil.getJournalArticle((long)mainJournalArticleId);
        if (mainJournalArticle == null) {
            return availableLocales;
        }
        Object[] articleLocales = mainJournalArticle.getAvailableLocales();
        if (articleLocales.length > 1) {
            Locale[] alternateLocales = new Locale[availableLocales.length - articleLocales.length];
            int i2 = 0;
            Locale[] localeArray = availableLocales;
            int n = availableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale = localeArray[n2];
                if (!ArrayUtil.contains((Object[])articleLocales, (Object)LocaleUtil.toLanguageId((Locale)locale))) {
                    alternateLocales[i2] = locale;
                    ++i2;
                }
                ++n2;
            }
            return alternateLocales;
        }
        return availableLocales;
    }

    public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale) {
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        String virtualHost = null;
        if (Validator.isNotNull((String)layoutSet.getVirtualHostname())) {
            virtualHost = layoutSet.getVirtualHostname();
        } else {
            Company company = themeDisplay.getCompany();
            virtualHost = company.getVirtualHostname();
        }
        String i18nPath = this.buildI18NPath(locale);
        if (Validator.isNull((String)virtualHost)) {
            return canonicalURL.replaceFirst(_PUBLIC_GROUP_SERVLET_MAPPING, i18nPath.concat(_PUBLIC_GROUP_SERVLET_MAPPING));
        }
        int pos = canonicalURL.indexOf(virtualHost);
        if (pos > 0) {
            pos = canonicalURL.indexOf(47, pos + virtualHost.length());
            if (Validator.isNotNull((String)this._pathContext)) {
                pos = canonicalURL.indexOf(47, pos + this._pathContext.length());
            }
            if (pos > 0 && pos < canonicalURL.length()) {
                return canonicalURL.substring(0, pos).concat(i18nPath).concat(canonicalURL.substring(pos));
            }
        }
        return canonicalURL.concat(i18nPath);
    }

    public Set<String> getAuthTokenIgnoreActions() {
        return this._authTokenIgnoreActions;
    }

    public Set<String> getAuthTokenIgnorePortlets() {
        return this._authTokenIgnorePortlets;
    }

    public BaseModel<?> getBaseModel(ResourcePermission resourcePermission) throws PortalException, SystemException {
        String modelName = resourcePermission.getName();
        String primKey = resourcePermission.getPrimKey();
        return this.getBaseModel(modelName, primKey);
    }

    public BaseModel<?> getBaseModel(String modelName, String primKey) throws PortalException, SystemException {
        if (!modelName.contains(".model.")) {
            return null;
        }
        Object[] parts = StringUtil.split((String)modelName, (char)'.');
        if (parts.length <= 2 || !parts[parts.length - 2].equals("model")) {
            return null;
        }
        parts[parts.length - 2] = "service";
        String serviceName = String.valueOf(StringUtil.merge((Object[])parts, (String)".")) + "LocalServiceUtil";
        String methodName = "get" + (String)parts[parts.length - 1];
        Method method = null;
        try {
            Class<?> serviceUtil = Class.forName(serviceName);
            if (Validator.isNumber((String)primKey)) {
                method = serviceUtil.getMethod(methodName, Long.TYPE);
                return (BaseModel)method.invoke(null, new Long(primKey));
            }
            method = serviceUtil.getMethod(methodName, String.class);
            return (BaseModel)method.invoke(null, primKey);
        }
        catch (Exception e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof PortalException) {
                throw (PortalException)cause;
            }
            if (cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            throw new SystemException(cause);
        }
    }

    public long getBasicAuthUserId(HttpServletRequest request) throws PortalException, SystemException {
        long companyId = PortalInstances.getCompanyId(request);
        return this.getBasicAuthUserId(request, companyId);
    }

    public long getBasicAuthUserId(HttpServletRequest request, long companyId) throws PortalException, SystemException {
        long userId = 0L;
        String authorizationHeader = request.getHeader("Authorization");
        if (Validator.isNull((String)authorizationHeader)) {
            return userId;
        }
        String[] authorizationArray = authorizationHeader.split("\\s+");
        String authorization = authorizationArray[0];
        String credentials = new String(Base64.decode((String)authorizationArray[1]));
        if (!authorization.equalsIgnoreCase("BASIC")) {
            return userId;
        }
        String[] loginAndPassword = StringUtil.split((String)credentials, (char)':');
        String login = HttpUtil.decodeURL((String)loginAndPassword[0].trim());
        String password = null;
        if (loginAndPassword.length > 1) {
            password = loginAndPassword[1].trim();
        }
        if (login.endsWith("@uid")) {
            int pos = login.indexOf("@uid");
            login = login.substring(0, pos);
        } else if (login.endsWith("@sn")) {
            int pos = login.indexOf("@sn");
            login = login.substring(0, pos);
        }
        try {
            userId = LoginUtil.getAuthenticatedUserId(request, login, password, null);
        }
        catch (AuthException authException) {}
        return userId;
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException, SystemException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, false);
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL) throws PortalException, SystemException {
        String groupFriendlyURL = "";
        String parametersURL = "";
        if (Validator.isNotNull((String)completeURL)) {
            int pos = (completeURL = this.removeRedirectParameter(completeURL)).indexOf("/-/");
            if (pos == -1) {
                pos = completeURL.indexOf("?");
            }
            groupFriendlyURL = completeURL;
            if (pos != -1) {
                groupFriendlyURL = completeURL.substring(0, pos);
                parametersURL = completeURL.substring(pos);
            }
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String canonicalLayoutFriendlyURL = "";
        String layoutFriendlyURL = layout.getFriendlyURL(themeDisplay.getLocale());
        if ((groupFriendlyURL.contains(layoutFriendlyURL) || groupFriendlyURL.contains("/" + layout.getLayoutId())) && (!layout.isFirstParent() || Validator.isNotNull((String)parametersURL))) {
            canonicalLayoutFriendlyURL = layoutFriendlyURL;
        } else if (forceLayoutFriendlyURL) {
            canonicalLayoutFriendlyURL = layoutFriendlyURL;
        }
        Group group = layout.getGroup();
        groupFriendlyURL = this.getGroupFriendlyURL(group, layout.isPrivateLayout(), themeDisplay, true);
        return groupFriendlyURL.concat(canonicalLayoutFriendlyURL).concat(parametersURL);
    }

    public String getCDNHost() {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.getCDNHostHttp(companyId);
    }

    public String getCDNHost(boolean secure) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (secure) {
            return this.getCDNHostHttps(companyId);
        }
        return this.getCDNHostHttp(companyId);
    }

    public String getCDNHost(HttpServletRequest request) throws PortalException, SystemException {
        boolean cdnEnabled = ParamUtil.getBoolean((HttpServletRequest)request, (String)"cdn_enabled", (boolean)true);
        if (!cdnEnabled) {
            return "";
        }
        String cdnHost = null;
        Company company = this.getCompany(request);
        cdnHost = request.isSecure() ? this.getCDNHostHttps(company.getCompanyId()) : this.getCDNHostHttp(company.getCompanyId());
        if (Validator.isUrl((String)cdnHost)) {
            return cdnHost;
        }
        return "";
    }

    public String getCDNHostHttp(long companyId) {
        String cdnHostHttp = _cdnHostHttpMap.get(companyId);
        if (cdnHostHttp != null) {
            return cdnHostHttp;
        }
        try {
            cdnHostHttp = PrefsPropsUtil.getString(companyId, "cdn.host.http", PropsValues.CDN_HOST_HTTP);
        }
        catch (Exception exception) {}
        if (cdnHostHttp == null || cdnHostHttp.startsWith("${") || !Validator.isUrl((String)cdnHostHttp)) {
            cdnHostHttp = "";
        }
        _cdnHostHttpMap.put(companyId, cdnHostHttp);
        return cdnHostHttp;
    }

    public String getCDNHostHttps(long companyId) {
        String cdnHostHttps = _cdnHostHttpsMap.get(companyId);
        if (cdnHostHttps != null) {
            return cdnHostHttps;
        }
        try {
            cdnHostHttps = PrefsPropsUtil.getString(companyId, "cdn.host.https", PropsValues.CDN_HOST_HTTPS);
        }
        catch (SystemException systemException) {}
        if (cdnHostHttps == null || cdnHostHttps.startsWith("${") || !Validator.isUrl((String)cdnHostHttps)) {
            cdnHostHttps = "";
        }
        _cdnHostHttpsMap.put(companyId, cdnHostHttps);
        return cdnHostHttps;
    }

    public String getClassName(long classNameId) {
        try {
            ClassName className = ClassNameLocalServiceUtil.getClassName((long)classNameId);
            return className.getValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get class name from id " + classNameId);
        }
    }

    public long getClassNameId(Class<?> clazz) {
        return ClassNameLocalServiceUtil.getClassNameId(clazz);
    }

    public long getClassNameId(String value) {
        return ClassNameLocalServiceUtil.getClassNameId((String)value);
    }

    public String getClassNamePortletId(String className) {
        String portletId = "";
        if (className.startsWith("com.liferay.portlet.blogs")) {
            portletId = "33";
        } else if (className.startsWith("com.liferay.portlet.bookmarks")) {
            portletId = "28";
        } else if (className.startsWith("com.liferay.portlet.documentlibrary")) {
            portletId = "20";
        } else if (className.startsWith("com.liferay.portlet.imagegallery")) {
            portletId = "31";
        } else if (className.startsWith("com.liferay.portlet.journal")) {
            portletId = "15";
        } else if (className.startsWith("com.liferay.portlet.messageboards")) {
            portletId = "19";
        } else if (className.startsWith("com.liferay.portlet.wiki")) {
            portletId = "36";
        }
        return portletId;
    }

    public Company getCompany(HttpServletRequest request) throws PortalException, SystemException {
        long companyId = this.getCompanyId(request);
        if (companyId <= 0L) {
            return null;
        }
        Company company = (Company)request.getAttribute("COMPANY");
        if (company == null) {
            try {
                company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            }
            catch (NoSuchCompanyException noSuchCompanyException) {
                company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
            }
            request.setAttribute("COMPANY", (Object)company);
        }
        return company;
    }

    public Company getCompany(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getCompany(this.getHttpServletRequest(portletRequest));
    }

    public long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId(request);
    }

    public long getCompanyId(PortletRequest portletRequest) {
        return this.getCompanyId(this.getHttpServletRequest(portletRequest));
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public String getComputerAddress() {
        return this._computerAddress;
    }

    public String getComputerName() {
        return this._computerName;
    }

    public String getControlPanelCategory(String portletId, ThemeDisplay themeDisplay) throws SystemException {
        String[] stringArray = PortletCategoryKeys.ALL;
        int n = PortletCategoryKeys.ALL.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            List<Portlet> portlets = this.getControlPanelPortlets(category, themeDisplay);
            for (Portlet portlet : portlets) {
                if (!portlet.getPortletId().equals(portletId)) continue;
                return category;
            }
            ++n2;
        }
        return "";
    }

    public String getControlPanelFullURL(long scopeGroupId, String ppid, Map<String, String[]> params) throws PortalException, SystemException {
        StringBundler sb = new StringBundler(6);
        Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        sb.append(this.getPortalURL(company.getVirtualHostname(), this.getPortalPort(false), false));
        sb.append(this.getPathFriendlyURLPrivateGroup());
        sb.append("/control_panel");
        sb.append(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        params = params != null ? new HashMap<String, String[]>(params) : new HashMap<String, String[]>();
        params.put("p_p_id", new String[]{ppid});
        params.put("p_p_lifecycle", new String[]{"0"});
        params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        sb.append(HttpUtil.parameterMapToString(params, (boolean)true));
        return sb.toString();
    }

    public long getControlPanelPlid(long companyId) throws PortalException, SystemException {
        Group controlPanelGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Control Panel");
        return LayoutLocalServiceUtil.getDefaultPlid((long)controlPanelGroup.getGroupId(), (boolean)true);
    }

    public long getControlPanelPlid(PortletRequest portletRequest) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    public Set<Portlet> getControlPanelPortlets(long companyId, String category) throws SystemException {
        TreeSet<Portlet> portletsSet = new TreeSet<Portlet>((Comparator<Portlet>)new PortletControlPanelWeightComparator());
        if (Validator.isNull((String)category)) {
            return portletsSet;
        }
        List portletsList = PortletLocalServiceUtil.getPortlets((long)companyId);
        for (Portlet portlet : portletsList) {
            String portletCategory = portlet.getControlPanelEntryCategory();
            if (!category.equals(portletCategory) && (!category.endsWith(".") || !StringUtil.startsWith((String)portletCategory, (String)category))) continue;
            portletsSet.add(portlet);
        }
        return portletsSet;
    }

    public List<Portlet> getControlPanelPortlets(String category, ThemeDisplay themeDisplay) throws SystemException {
        Set<Portlet> portlets = this.getControlPanelPortlets(themeDisplay.getCompanyId(), category);
        return this.filterControlPanelPortlets(portlets, themeDisplay);
    }

    public PortletURL getControlPanelPortletURL(HttpServletRequest request, String portletId, long referrerPlid, String lifecycle) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = 0L;
        try {
            plid = this.getControlPanelPlid(themeDisplay.getCompanyId());
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine control panel layout id", (Throwable)e2);
        }
        PortletURLImpl liferayPortletURL = new PortletURLImpl(request, portletId, plid, lifecycle);
        liferayPortletURL.setDoAsGroupId(themeDisplay.getScopeGroupId());
        liferayPortletURL.setRefererPlid(themeDisplay.getPlid());
        return liferayPortletURL;
    }

    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, String portletId, long referrerPlid, String lifecycle) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = 0L;
        try {
            plid = this.getControlPanelPlid(themeDisplay.getCompanyId());
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine control panel layout id", (Throwable)e2);
        }
        PortletURLImpl liferayPortletURL = new PortletURLImpl(portletRequest, portletId, plid, lifecycle);
        liferayPortletURL.setDoAsGroupId(themeDisplay.getScopeGroupId());
        liferayPortletURL.setRefererPlid(themeDisplay.getPlid());
        return liferayPortletURL;
    }

    public String getCreateAccountURL(HttpServletRequest request, ThemeDisplay themeDisplay) throws Exception {
        if (Validator.isNull((String)PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
            LiferayPortletURL createAccountURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"58", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
            createAccountURL.setParameter("saveLastPath", Boolean.FALSE.toString());
            createAccountURL.setParameter("struts_action", "/login/create_account");
            createAccountURL.setPortletMode(PortletMode.VIEW);
            createAccountURL.setWindowState(WindowState.MAXIMIZED);
            if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
                return createAccountURL.toString();
            }
            String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
            String portalURLSecure = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true);
            return StringUtil.replaceFirst((String)createAccountURL.toString(), (String)portalURL, (String)portalURLSecure);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (String)PropsValues.COMPANY_SECURITY_STRANGERS_URL);
            return this.getLayoutURL(layout, themeDisplay);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            return "";
        }
    }

    public String getCurrentCompleteURL(HttpServletRequest request) {
        String currentCompleteURL = (String)request.getAttribute("CURRENT_COMPLETE_URL");
        if (currentCompleteURL == null) {
            currentCompleteURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            request.setAttribute("CURRENT_COMPLETE_URL", (Object)currentCompleteURL);
        }
        return currentCompleteURL;
    }

    public String getCurrentURL(HttpServletRequest request) {
        String currentURL = (String)request.getAttribute("CURRENT_URL");
        if (currentURL != null) {
            return currentURL;
        }
        currentURL = ParamUtil.getString((HttpServletRequest)request, (String)"currentURL");
        if (Validator.isNull((String)currentURL)) {
            String[] facebookData;
            currentURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            if (Validator.isNotNull((String)currentURL) && !currentURL.contains(_J_SECURITY_CHECK)) {
                currentURL = currentURL.substring(currentURL.indexOf("://") + "://".length());
                currentURL = currentURL.substring(currentURL.indexOf(47));
            }
            if (Validator.isNotNull((String)currentURL) && FacebookUtil.isFacebook(currentURL) && (facebookData = FacebookUtil.getFacebookData(request)) != null) {
                currentURL = "http://apps.facebook.com/" + facebookData[0] + facebookData[2];
            }
        }
        if (Validator.isNull((String)currentURL)) {
            currentURL = this.getPathMain();
        }
        request.setAttribute("CURRENT_URL", (Object)currentURL);
        return currentURL;
    }

    public String getCurrentURL(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("CURRENT_URL");
    }

    public String getCustomSQLFunctionIsNotNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNOTNULL;
    }

    public String getCustomSQLFunctionIsNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNULL;
    }

    public Date getDate(int month, int day, int year) {
        try {
            return this.getDate(month, day, year, null);
        }
        catch (PortalException portalException) {
            throw new RuntimeException();
        }
    }

    public Date getDate(int month, int day, int year, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, hour, min, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        if (!Validator.isGregorianDate((int)month, (int)day, (int)year)) {
            if (clazz != null) {
                try {
                    throw clazz.newInstance();
                }
                catch (Exception e2) {
                    throw new PortalException((Throwable)e2);
                }
            }
            return null;
        }
        Calendar cal = null;
        cal = timeZone == null ? CalendarFactoryUtil.getCalendar() : CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
        if (hour == -1 || min == -1) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, hour, min, 0);
        }
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public Date getDate(int month, int day, int year, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, -1, -1, timeZone, clazz);
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    public long getDigestAuthUserId(HttpServletRequest request) throws PortalException, SystemException {
        long userId = 0L;
        String authorizationHeader = request.getHeader("Authorization");
        if (Validator.isNull((String)authorizationHeader) || !authorizationHeader.startsWith("Digest ")) {
            return userId;
        }
        authorizationHeader = authorizationHeader.substring("Digest ".length());
        authorizationHeader = StringUtil.replace((String)authorizationHeader, (char)',', (char)'\n');
        UnicodeProperties authorizationProperties = new UnicodeProperties();
        authorizationProperties.fastLoad(authorizationHeader);
        String username = StringUtil.unquote((String)authorizationProperties.getProperty("username"));
        String realm = StringUtil.unquote((String)authorizationProperties.getProperty("realm"));
        String nonce = StringUtil.unquote((String)authorizationProperties.getProperty("nonce"));
        String uri = StringUtil.unquote((String)authorizationProperties.getProperty("uri"));
        String response = StringUtil.unquote((String)authorizationProperties.getProperty("response"));
        if (Validator.isNull((String)username) || Validator.isNull((String)realm) || Validator.isNull((String)nonce) || Validator.isNull((String)uri) || Validator.isNull((String)response)) {
            return userId;
        }
        if (!realm.equals("PortalRealm") || !uri.equals(request.getRequestURI())) {
            return userId;
        }
        if (!NonceUtil.verify(nonce)) {
            return userId;
        }
        long companyId = PortalInstances.getCompanyId(request);
        userId = UserLocalServiceUtil.authenticateForDigest((long)companyId, (String)username, (String)realm, (String)nonce, (String)request.getMethod(), (String)uri, (String)response);
        return userId;
    }

    public String getEmailFromAddress(PortletPreferences preferences, long companyId, String defaultValue) throws SystemException {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        return preferences.getValue("emailFromAddress", defaultValue);
    }

    public String getEmailFromName(PortletPreferences preferences, long companyId, String defaultValue) throws SystemException {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        return preferences.getValue("emailFromName", defaultValue);
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException, SystemException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString((PortletRequest)portletRequest, (String)param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString((String)properties.getProperty("display-type"), (String)"text-box");
            Serializable value = this.getExpandoValue(portletRequest, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, UploadPortletRequest uploadPortletRequest) throws PortalException, SystemException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = uploadPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString((String)properties.getProperty("display-type"), (String)"text-box");
            Serializable value = this.getExpandoValue(uploadPortletRequest, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    public Serializable getExpandoValue(PortletRequest portletRequest, String name, int type, String displayType) throws PortalException, SystemException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Month"));
                int valueDateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Day"));
                int valueDateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Year"));
                int valueDateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = this.getUser(portletRequest);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = this.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((PortletRequest)portletRequest, (String)name);
                } else if (type == 6) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((PortletRequest)portletRequest, (String)name));
                } else if (type == 8) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((PortletRequest)portletRequest, (String)name);
                } else if (type == 10) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((PortletRequest)portletRequest, (String)name);
                } else if (type == 12) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber((PortletRequest)portletRequest, (String)name);
                } else if (type == 18) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((PortletRequest)portletRequest, (String)name);
                } else if (type == 14) {
                    String[] values = portletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else {
                    value = type == 16 ? portletRequest.getParameterValues(name) : ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                }
            }
        }
        return value;
    }

    public Serializable getExpandoValue(UploadPortletRequest uploadPortletRequest, String name, int type, String displayType) throws PortalException, SystemException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "Month"));
                int valueDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "Day"));
                int valueDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "Year"));
                int valueDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)(String.valueOf(name) + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = this.getUser((HttpServletRequest)uploadPortletRequest);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = this.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)name);
                } else if (type == 6) {
                    String[] values = uploadPortletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((HttpServletRequest)uploadPortletRequest, (String)name));
                } else if (type == 8) {
                    String[] values = uploadPortletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)name);
                } else if (type == 10) {
                    String[] values = uploadPortletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)name);
                } else if (type == 12) {
                    String[] values = uploadPortletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((HttpServletRequest)uploadPortletRequest, (String)name);
                } else if (type == 14) {
                    String[] values = uploadPortletRequest.getParameterValues(name);
                    if (displayType.equals("text-box")) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else {
                    value = type == 16 ? uploadPortletRequest.getParameterValues(name) : ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)name);
                }
            }
        }
        return value;
    }

    public String getFacebookURL(Portlet portlet, String facebookCanvasPageURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String facebookURL = this.getServletURL(portlet, "/facebook/" + facebookCanvasPageURL, themeDisplay);
        if (!facebookURL.endsWith("/")) {
            facebookURL = String.valueOf(facebookURL) + "/";
        }
        return facebookURL;
    }

    public Portlet getFirstMyAccountPortlet(ThemeDisplay themeDisplay) throws SystemException {
        List portlets = PortalUtil.getControlPanelPortlets((String)"my", (ThemeDisplay)themeDisplay);
        if (portlets.isEmpty()) {
            return null;
        }
        return (Portlet)portlets.get(0);
    }

    public String getFirstPageLayoutTypes(PageContext pageContext) {
        StringBundler sb = new StringBundler();
        String[] stringArray = PropsValues.LAYOUT_TYPES;
        int n = PropsValues.LAYOUT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (this.isLayoutFirstPageable(type)) {
                sb.append(LanguageUtil.get((PageContext)pageContext, (String)("layout.types." + type)));
                sb.append(",");
                sb.append(" ");
            }
            ++n2;
        }
        if (sb.index() >= 2) {
            sb.setIndex(sb.index() - 2);
        }
        return sb.toString();
    }

    public Portlet getFirstSiteAdministrationPortlet(ThemeDisplay themeDisplay) throws SystemException {
        Portlet siteAdministrationPortlet = null;
        String[] stringArray = PortletCategoryKeys.SITE_ADMINISTRATION_ALL;
        int n = PortletCategoryKeys.SITE_ADMINISTRATION_ALL.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            List portlets = PortalUtil.getControlPanelPortlets((String)category, (ThemeDisplay)themeDisplay);
            if (!portlets.isEmpty()) {
                return (Portlet)portlets.get(0);
            }
            ++n2;
        }
        return siteAdministrationPortlet;
    }

    public String getFullName(String firstName, String middleName, String lastName) {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(firstName, middleName, lastName);
    }

    public String getGlobalLibDir() {
        return PropsValues.LIFERAY_LIB_GLOBAL_DIR;
    }

    public String getGoogleGadgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getServletURL(portlet, PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, themeDisplay);
    }

    public String getGroupFriendlyURL(Group group, boolean privateLayoutSet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getGroupFriendlyURL(group, privateLayoutSet, themeDisplay, false);
    }

    public String getGroupFriendlyURL(Group group, boolean privateLayoutSet, ThemeDisplay themeDisplay, Locale locale) throws PortalException, SystemException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getGroupFriendlyURL(group, privateLayoutSet, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath);
        }
    }

    public String[] getGroupPermissions(HttpServletRequest request) {
        return request.getParameterValues("groupPermissions");
    }

    public String[] getGroupPermissions(HttpServletRequest request, String className) {
        return request.getParameterValues("groupPermissions_" + className);
    }

    public String[] getGroupPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("groupPermissions");
    }

    public String[] getGroupPermissions(PortletRequest portletRequest, String className) {
        return portletRequest.getParameterValues("groupPermissions_" + className);
    }

    public String[] getGuestPermissions(HttpServletRequest request) {
        return request.getParameterValues("guestPermissions");
    }

    public String[] getGuestPermissions(HttpServletRequest request, String className) {
        return request.getParameterValues("guestPermissions_" + className);
    }

    public String[] getGuestPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("guestPermissions");
    }

    public String[] getGuestPermissions(PortletRequest portletRequest, String className) {
        return portletRequest.getParameterValues("guestPermissions_" + className);
    }

    public String getHomeURL(HttpServletRequest request) throws PortalException, SystemException {
        String portalURL = this.getPortalURL(request);
        return String.valueOf(portalURL) + this._pathContext + this.getRelativeHomeURL(request);
    }

    public String getHost(HttpServletRequest request) {
        String host = (request = this.getOriginalServletRequest(request)).getHeader("Host");
        if (host != null) {
            int pos = (host = host.trim().toLowerCase()).indexOf(58);
            if (pos >= 0) {
                host = host.substring(0, pos);
            }
        } else {
            host = null;
        }
        return host;
    }

    public String getHost(PortletRequest portletRequest) {
        return this.getHost(this.getHttpServletRequest(portletRequest));
    }

    public HttpServletRequest getHttpServletRequest(PortletRequest portletRequest) {
        PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
        return portletRequestImpl.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse(PortletResponse portletResponse) {
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return portletResponseImpl.getHttpServletResponse();
    }

    public String getI18nPathLanguageId(Locale locale, String defaultI18nPathLanguageId) {
        String i18nPathLanguageId = defaultI18nPathLanguageId;
        if (!LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            i18nPathLanguageId = locale.getLanguage();
        } else {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                i18nPathLanguageId = locale.getLanguage();
            }
        }
        return i18nPathLanguageId;
    }

    public String getJournalArticleActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        String defaultAssetPublisherPortletId;
        String urlTitle = friendlyURL.substring("/-/".length());
        JournalArticle journalArticle = JournalArticleLocalServiceUtil.getArticleByUrlTitle((long)groupId, (String)urlTitle);
        Layout layout = this.getJournalArticleLayout(groupId, privateLayout, friendlyURL);
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        InheritableMap actualParams = new InheritableMap();
        if (params != null) {
            actualParams.setParentMap(params);
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String currentDefaultAssetPublisherPortletId = defaultAssetPublisherPortletId = (String)typeSettingsProperties.get((Object)"default-asset-publisher-portlet-id");
        if (Validator.isNull((String)defaultAssetPublisherPortletId)) {
            String instanceId = LayoutTypePortletImpl.generateInstanceId();
            defaultAssetPublisherPortletId = PortletConstants.assemblePortletId((String)"101", (String)instanceId);
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        if (Validator.isNull((String)currentDefaultAssetPublisherPortletId)) {
            String actualPortletAuthenticationToken = AuthTokenUtil.getToken((HttpServletRequest)request, (long)layout.getPlid(), (String)defaultAssetPublisherPortletId);
            actualParams.put((Object)"p_p_auth", (Object)new String[]{actualPortletAuthenticationToken});
        }
        actualParams.put((Object)"p_p_id", (Object)new String[]{defaultAssetPublisherPortletId});
        actualParams.put((Object)"p_p_lifecycle", (Object)new String[]{"0"});
        if (Validator.isNull((String)currentDefaultAssetPublisherPortletId)) {
            actualParams.put((Object)"p_p_state", (Object)new String[]{WindowState.MAXIMIZED.toString()});
        }
        actualParams.put((Object)"p_p_mode", (Object)new String[]{"view"});
        actualParams.put((Object)"p_j_a_id", (Object)new String[]{String.valueOf(journalArticle.getId())});
        String namespace = this.getPortletNamespace(defaultAssetPublisherPortletId);
        actualParams.put((Object)(String.valueOf(namespace) + "struts_action"), (Object)new String[]{"/asset_publisher/view_content"});
        actualParams.put((Object)(String.valueOf(namespace) + "type"), (Object)new String[]{"content"});
        actualParams.put((Object)(String.valueOf(namespace) + "urlTitle"), (Object)new String[]{journalArticle.getUrlTitle()});
        String queryString = HttpUtil.parameterMapToString((Map)actualParams, (boolean)false);
        layoutActualURL = layoutActualURL.contains("?") ? String.valueOf(layoutActualURL) + "&" + queryString : String.valueOf(layoutActualURL) + "?" + queryString;
        Locale locale = this.getLocale(request);
        this.addPageSubtitle(journalArticle.getTitle(locale), request);
        this.addPageDescription(journalArticle.getDescription(locale), request);
        List assetTags = AssetTagLocalServiceUtil.getTags((String)JournalArticle.class.getName(), (long)journalArticle.getPrimaryKey());
        if (!assetTags.isEmpty()) {
            this.addPageKeywords(ListUtil.toString((List)assetTags, (Accessor)AssetTag.NAME_ACCESSOR), request);
        }
        return layoutActualURL;
    }

    public Layout getJournalArticleLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException, SystemException {
        String urlTitle = friendlyURL.substring("/-/".length());
        JournalArticle journalArticle = JournalArticleLocalServiceUtil.getArticleByUrlTitle((long)groupId, (String)urlTitle);
        return LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)journalArticle.getLayoutUuid(), (long)groupId, (boolean)privateLayout);
    }

    public String getJsSafePortletId(String portletId) {
        return JS.getSafeName((String)portletId);
    }

    public String getLayoutActualURL(Layout layout) {
        return this.getLayoutActualURL(layout, this.getPathMain());
    }

    public String getLayoutActualURL(Layout layout, String mainPath) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("liferay:groupId", String.valueOf(layout.getGroupId()));
        variables.put("liferay:mainPath", mainPath);
        variables.put("liferay:plid", String.valueOf(layout.getPlid()));
        if (layout instanceof VirtualLayout) {
            variables.put("liferay:pvlsgid", String.valueOf(layout.getGroupId()));
        } else {
            variables.put("liferay:pvlsgid", "0");
        }
        LayoutType layoutType = layout.getLayoutType();
        UnicodeProperties typeSettingsProperties = layoutType.getTypeSettingsProperties();
        variables.putAll((Map<String, String>)typeSettingsProperties);
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
        return layoutSettings.getURL(variables);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL) throws PortalException, SystemException {
        return this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, null, null);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        LayoutType layoutType;
        UnicodeProperties typeSettingsProperties;
        LayoutQueryStringComposite actualLayoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        Layout layout = actualLayoutQueryStringComposite.getLayout();
        String queryString = actualLayoutQueryStringComposite.getQueryString();
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        if (Validator.isNotNull((String)queryString)) {
            layoutActualURL = layoutActualURL.concat(queryString);
        } else if (params.isEmpty() && Validator.isNotNull((String)(queryString = (typeSettingsProperties = (layoutType = layout.getLayoutType()).getTypeSettingsProperties()).getProperty("query-string"))) && layoutActualURL.contains("?")) {
            layoutActualURL = layoutActualURL.concat("&").concat(queryString);
        }
        return layoutActualURL;
    }

    public String getLayoutEditPage(Layout layout) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout.getType());
        return layoutSettings.getEditPage();
    }

    public String getLayoutEditPage(String type) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(type);
        return layoutSettings.getEditPage();
    }

    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        if (!this.isLayoutFriendliable(layout)) {
            return null;
        }
        String groupFriendlyURL = this.getGroupFriendlyURL(layout.getGroup(), layout.isPrivateLayout(), themeDisplay);
        return groupFriendlyURL.concat(layout.getFriendlyURL(themeDisplay.getLocale()));
    }

    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException, SystemException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutFriendlyURL(layout, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath);
        }
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        Layout layout = null;
        String layoutFriendlyURL = friendlyURL;
        if (friendlyURL != null) {
            if (friendlyURL.startsWith("/-/")) {
                try {
                    layout = this.getJournalArticleLayout(groupId, privateLayout, friendlyURL);
                }
                catch (Exception e2) {
                    throw new NoSuchLayoutException((Throwable)e2);
                }
            }
            if (friendlyURL.startsWith("/~")) {
                try {
                    LayoutFriendlyURLComposite layoutFriendlyURLComposite = this.getVirtualLayoutFriendlyURLComposite(privateLayout, friendlyURL, params, requestContext);
                    layout = layoutFriendlyURLComposite.getLayout();
                    layoutFriendlyURL = layoutFriendlyURLComposite.getFriendlyURL();
                }
                catch (Exception e3) {
                    throw new NoSuchLayoutException((Throwable)e3);
                }
            }
        }
        if (layout == null) {
            LayoutQueryStringComposite layoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
            layout = layoutQueryStringComposite.getLayout();
        }
        return new LayoutFriendlyURLComposite(layout, layoutFriendlyURL);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getLayoutFullURL(layout, themeDisplay, true);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException, SystemException {
        String portalURL;
        String layoutURL = this.getLayoutURL(layout, themeDisplay, doAsUser);
        if (StringUtil.startsWith((String)layoutURL, (String)(portalURL = this.getPortalURL(layout, themeDisplay)))) {
            return layoutURL;
        }
        return String.valueOf(portalURL) + layoutURL;
    }

    public String getLayoutFullURL(long groupId, String portletId) throws PortalException, SystemException {
        return this.getLayoutFullURL(groupId, portletId, false);
    }

    public String getLayoutFullURL(long groupId, String portletId, boolean secure) throws PortalException, SystemException {
        long parentGroupId;
        long plid = this.getPlidFromPortletId(groupId, portletId);
        if (plid == 0L) {
            return null;
        }
        StringBundler sb = new StringBundler(4);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        String virtualHostname = null;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)layoutSet.getVirtualHostname())) {
            virtualHostname = layoutSet.getVirtualHostname();
        } else {
            Company company = CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId());
            virtualHostname = company.getVirtualHostname();
        }
        String portalURL = this.getPortalURL(virtualHostname, this.getPortalPort(secure), secure);
        sb.append(portalURL);
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(this.getPathFriendlyURLPrivateUser());
            } else {
                sb.append(this.getPathFriendlyURLPrivateGroup());
            }
        } else {
            sb.append(this.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutFullURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getLayoutFullURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutSetFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Group group;
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && !layoutSet.isPrivateLayout()) {
            try {
                group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                if (layoutSet.getGroupId() == group.getGroupId()) {
                    Company company = themeDisplay.getCompany();
                    virtualHostname = company.getVirtualHostname();
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (Validator.isNotNull((String)virtualHostname)) {
            String portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
            long curLayoutSetId = themeDisplay.getLayout().getLayoutSet().getLayoutSetId();
            if (layoutSet.getLayoutSetId() != curLayoutSetId || portalURL.startsWith(themeDisplay.getURLPortal())) {
                String layoutSetFriendlyURL = "";
                if (themeDisplay.isI18n()) {
                    layoutSetFriendlyURL = themeDisplay.getI18nPath();
                }
                return String.valueOf(portalURL) + this._pathContext + layoutSetFriendlyURL;
            }
        }
        group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isI18n()) {
            friendlyURL = String.valueOf(themeDisplay.getI18nPath()) + friendlyURL;
        }
        return String.valueOf(this._pathContext) + friendlyURL + group.getFriendlyURL();
    }

    public String getLayoutTarget(Layout layout) {
        UnicodeProperties typeSettingsProps = layout.getTypeSettingsProperties();
        String target = typeSettingsProps.getProperty("target");
        target = Validator.isNull((String)target) ? "" : "target=\"" + HtmlUtil.escapeAttribute((String)target) + "\"";
        return target;
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getLayoutURL(layout, themeDisplay, true);
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException, SystemException {
        String layoutFriendlyURL;
        if (layout == null) {
            return String.valueOf(themeDisplay.getPathMain()) + "/portal/layout";
        }
        if (!layout.isTypeURL() && Validator.isNotNull((String)(layoutFriendlyURL = this.getLayoutFriendlyURL(layout, themeDisplay)))) {
            layoutFriendlyURL = this.addPreservedParameters(themeDisplay, layout, layoutFriendlyURL, doAsUser);
            return layoutFriendlyURL;
        }
        String layoutURL = this.getLayoutActualURL(layout);
        layoutURL = this.addPreservedParameters(themeDisplay, layout, layoutURL, doAsUser);
        return layoutURL;
    }

    public String getLayoutURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getLayoutURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutViewPage(Layout layout) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout.getType());
        return layoutSettings.getViewPage();
    }

    public String getLayoutViewPage(String type) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(type);
        return layoutSettings.getViewPage();
    }

    public LiferayPortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
        return DoPrivilegedUtil.wrap(portletRequestImpl, true);
    }

    public LiferayPortletResponse getLiferayPortletResponse(PortletResponse portletResponse) {
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return DoPrivilegedUtil.wrap(portletResponseImpl, true);
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.getLocale(request, null, false);
    }

    public Locale getLocale(HttpServletRequest request, HttpServletResponse response, boolean initialize) {
        Locale cookieLocale;
        Locale userLocale;
        ThemeDisplay themeDisplay;
        User user = null;
        if (initialize) {
            try {
                user = this.initUser(request);
            }
            catch (NoSuchUserException noSuchUserException) {
                return null;
            }
            catch (Exception exception) {}
        }
        if ((themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null) {
            return themeDisplay.getLocale();
        }
        String i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID");
        if (Validator.isNotNull((String)i18nLanguageId)) {
            return LocaleUtil.fromLanguageId((String)i18nLanguageId);
        }
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            return LocaleUtil.fromLanguageId((String)doAsUserLanguageId);
        }
        HttpSession session = request.getSession();
        if (session.getAttribute("org.apache.struts.action.LOCALE") != null) {
            return (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (user == null) {
            try {
                user = this.getUser(request);
            }
            catch (Exception exception) {}
        }
        if (user != null && !user.isDefaultUser() && (userLocale = this.getAvailableLocale(user.getLocale())) != null) {
            if (initialize) {
                this.setLocale(request, response, userLocale);
            }
            return userLocale;
        }
        String languageId = CookieKeys.getCookie((HttpServletRequest)request, (String)"GUEST_LANGUAGE_ID", (boolean)false);
        if (Validator.isNotNull((String)languageId) && (cookieLocale = this.getAvailableLocale(LocaleUtil.fromLanguageId((String)languageId))) != null) {
            if (initialize) {
                this.setLocale(request, response, cookieLocale);
            }
            return cookieLocale;
        }
        if (PropsValues.LOCALE_DEFAULT_REQUEST) {
            Enumeration locales = request.getLocales();
            while (locales.hasMoreElements()) {
                Locale requestLocale = this.getAvailableLocale((Locale)locales.nextElement());
                if (requestLocale == null) continue;
                if (initialize) {
                    this.setLocale(request, response, requestLocale);
                }
                return requestLocale;
            }
        }
        Company company = null;
        try {
            company = this.getCompany(request);
        }
        catch (Exception exception) {}
        if (company == null) {
            return null;
        }
        User defaultUser = null;
        try {
            defaultUser = company.getDefaultUser();
        }
        catch (Exception exception) {}
        if (defaultUser == null) {
            return null;
        }
        Locale defaultUserLocale = this.getAvailableLocale(defaultUser.getLocale());
        if (defaultUserLocale == null) {
            return null;
        }
        if (initialize) {
            this.setLocale(request, response, defaultUserLocale);
        }
        return defaultUserLocale;
    }

    public Locale getLocale(RenderRequest renderRequest) {
        return this.getLocale(this.getHttpServletRequest((PortletRequest)renderRequest));
    }

    public String getLocalizedFriendlyURL(HttpServletRequest request, Layout layout, Locale locale) throws Exception {
        int y;
        String contextPath = PortalUtil.getPathContext();
        String requestURI = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String path = request.getPathInfo();
        int x = path.indexOf(47, 1);
        String layoutFriendlyURL = null;
        if (x != -1 && x + 1 != path.length()) {
            layoutFriendlyURL = path.substring(x);
        }
        if ((y = layoutFriendlyURL.indexOf("/~")) != -1 && (y = layoutFriendlyURL.indexOf(47, 3)) != -1 && y + 1 != layoutFriendlyURL.length()) {
            layoutFriendlyURL = layoutFriendlyURL.substring(y);
        }
        if ((y = layoutFriendlyURL.indexOf("/-/")) != -1) {
            layoutFriendlyURL = layoutFriendlyURL.substring(0, y);
        }
        if (requestURI.contains(layoutFriendlyURL)) {
            requestURI = StringUtil.replaceFirst((String)requestURI, (String)layoutFriendlyURL, (String)layout.getFriendlyURL(locale));
        }
        String i18nPath = this.getI18nPathLanguageId(locale, LocaleUtil.toLanguageId((Locale)locale));
        String localizedFriendlyURL = String.valueOf(contextPath) + "/" + i18nPath + requestURI;
        String queryString = request.getQueryString();
        if (Validator.isNotNull((String)queryString)) {
            localizedFriendlyURL = String.valueOf(localizedFriendlyURL) + "?" + request.getQueryString();
        }
        return localizedFriendlyURL;
    }

    public String getMailId(String mx, String popPortletPrefix, Object ... ids) {
        StringBundler sb = new StringBundler(ids.length * 2 + 7);
        sb.append("<");
        sb.append(popPortletPrefix);
        if (!popPortletPrefix.endsWith(".")) {
            sb.append(".");
        }
        int i2 = 0;
        while (i2 < ids.length) {
            Object id = ids[i2];
            if (i2 != 0) {
                sb.append(".");
            }
            sb.append(id);
            ++i2;
        }
        sb.append("@");
        if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public String getNetvibesURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getServletURL(portlet, PropsValues.NETVIBES_SERVLET_MAPPING, themeDisplay);
    }

    public String getNewPortletTitle(String portletTitle, String oldScopeName, String newScopeName) {
        if (portletTitle.endsWith(" (" + oldScopeName + ")")) {
            int pos = portletTitle.lastIndexOf(" (" + oldScopeName + ")");
            portletTitle = portletTitle.substring(0, pos);
        }
        if (Validator.isNull((String)newScopeName)) {
            return portletTitle;
        }
        StringBundler sb = new StringBundler(5);
        sb.append(portletTitle);
        sb.append(" ");
        sb.append("(");
        sb.append(newScopeName);
        sb.append(")");
        return sb.toString();
    }

    public HttpServletRequest getOriginalServletRequest(HttpServletRequest request) {
        ArrayList<PersistentHttpServletRequestWrapper> persistentHttpServletRequestWrappers = new ArrayList<PersistentHttpServletRequestWrapper>();
        HttpServletRequest originalRequest = request;
        while (originalRequest.getClass().getName().startsWith("com.liferay.")) {
            if (originalRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)originalRequest;
                persistentHttpServletRequestWrappers.add(persistentHttpServletRequestWrapper.clone());
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)originalRequest;
            originalRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        int i2 = persistentHttpServletRequestWrappers.size() - 1;
        while (i2 >= 0) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)persistentHttpServletRequestWrappers.get(i2);
            httpServletRequestWrapper.setRequest((ServletRequest)originalRequest);
            originalRequest = httpServletRequestWrapper;
            --i2;
        }
        return originalRequest;
    }

    public long getParentGroupId(long groupId) throws PortalException, SystemException {
        return this.getSiteGroupId(groupId);
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public String getPathModule() {
        return this._pathModule;
    }

    public String getPathProxy() {
        return this._pathProxy;
    }

    public long getPlidFromFriendlyURL(long companyId, String friendlyURL) {
        Layout layout;
        block14: {
            if (Validator.isNull((String)friendlyURL)) {
                return 0L;
            }
            String[] urlParts = friendlyURL.split("\\/", 4);
            if (friendlyURL.charAt(0) != '/' && urlParts.length != 4) {
                return 0L;
            }
            boolean privateLayout = true;
            String urlPrefix = "/" + urlParts[1];
            if (_PUBLIC_GROUP_SERVLET_MAPPING.equals(urlPrefix)) {
                privateLayout = false;
            } else if (_PRIVATE_GROUP_SERVLET_MAPPING.equals(urlPrefix) || _PRIVATE_USER_SERVLET_MAPPING.equals(urlPrefix)) {
                privateLayout = true;
            } else {
                return 0L;
            }
            Group group = null;
            try {
                group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + urlParts[2]));
            }
            catch (Exception exception) {}
            if (group == null) {
                return 0L;
            }
            layout = null;
            try {
                String layoutFriendlyURL = null;
                if (urlParts.length == 4) {
                    layoutFriendlyURL = "/" + urlParts[3];
                    layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)group.getGroupId(), (boolean)privateLayout, (String)layoutFriendlyURL);
                    break block14;
                }
                List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)privateLayout, (long)0L, (boolean)true, (int)0, (int)1);
                if (!layouts.isEmpty()) {
                    layout = (Layout)layouts.get(0);
                    break block14;
                }
                return 0L;
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return layout.getPlid();
    }

    public long getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        long plid = 0L;
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append(" ");
        sb.append(privateLayout);
        sb.append(" ");
        sb.append(portletId);
        String key = sb.toString();
        Long plidObj = this._plidToPortletIdMap.get(key);
        if (plidObj == null) {
            plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdMap.put(key, plid);
            }
        } else {
            plid = plidObj;
            boolean validPlid = false;
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasDefaultScopePortletId(groupId, portletId)) {
                    validPlid = true;
                }
            }
            catch (Exception exception) {}
            if (!validPlid) {
                this._plidToPortletIdMap.remove(key);
                plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
                if (plid != 0L) {
                    this._plidToPortletIdMap.put(key, plid);
                }
            }
        }
        return plid;
    }

    public long getPlidFromPortletId(long groupId, String portletId) throws PortalException, SystemException {
        long plid = this.getPlidFromPortletId(groupId, false, portletId);
        if (plid == 0L) {
            plid = this.getPlidFromPortletId(groupId, true, portletId);
        }
        if (plid == 0L && _log.isDebugEnabled()) {
            _log.debug((Object)("Portlet " + portletId + " does not exist on a page in group " + groupId));
        }
        return plid;
    }

    public String getPortalLibDir() {
        return PropsValues.LIFERAY_LIB_PORTAL_DIR;
    }

    public int getPortalPort() {
        return this._portalPort.get();
    }

    public int getPortalPort(boolean secure) {
        if (secure) {
            return this._securePortalPort.get();
        }
        return this._portalPort.get();
    }

    public Properties getPortalProperties() {
        return PropsUtil.getProperties();
    }

    public String getPortalURL(HttpServletRequest request) {
        return this.getPortalURL(request, this.isSecure(request));
    }

    public String getPortalURL(HttpServletRequest request, boolean secure) {
        return this.getPortalURL(request.getServerName(), request.getServerPort(), secure);
    }

    public String getPortalURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String serverName = themeDisplay.getServerName();
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        if (layout != null) {
            LayoutSet layoutSet = layout.getLayoutSet();
            String virtualHostname = layoutSet.getVirtualHostname();
            String domain = HttpUtil.getDomain((String)themeDisplay.getURLPortal());
            if (Validator.isNotNull((String)virtualHostname) && domain.startsWith(virtualHostname)) {
                serverName = virtualHostname;
            }
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest) {
        return this.getPortalURL(portletRequest, portletRequest.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest, boolean secure) {
        return this.getPortalURL(portletRequest.getServerName(), portletRequest.getServerPort(), secure);
    }

    public String getPortalURL(String serverName, int serverPort, boolean secure) {
        boolean https;
        StringBundler sb = new StringBundler();
        boolean bl = https = secure || "https".equals(PropsValues.WEB_SERVER_PROTOCOL);
        if (https) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            sb.append(serverName);
        } else {
            sb.append(PropsValues.WEB_SERVER_HOST);
        }
        if (!https) {
            if (PropsValues.WEB_SERVER_HTTP_PORT == -1) {
                if (serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTP_PORT != 80) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTP_PORT);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT == -1) {
            if (serverPort != 80 && serverPort != 443) {
                sb.append(":");
                sb.append(serverPort);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT != 443) {
            sb.append(":");
            sb.append(PropsValues.WEB_SERVER_HTTPS_PORT);
        }
        return sb.toString();
    }

    public String getPortalURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getPortalURL(null, themeDisplay);
    }

    public String getPortalWebDir() {
        return PropsValues.LIFERAY_WEB_PORTAL_DIR;
    }

    public Set<String> getPortletAddDefaultResourceCheckWhitelist() {
        return PortletSecurityUtil.getWhitelist();
    }

    public Set<String> getPortletAddDefaultResourceCheckWhitelistActions() {
        return PortletSecurityUtil.getWhitelistActions();
    }

    public List<BreadcrumbEntry> getPortletBreadcrumbList(HttpServletRequest request) {
        return this.getPortletBreadcrumbs(request);
    }

    public List<BreadcrumbEntry> getPortletBreadcrumbs(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        String portletName = portletDisplay.getPortletName();
        if (Validator.isNotNull((String)portletDisplay.getId()) && !portletName.equals("73") && !portletDisplay.isFocused()) {
            name = name.concat("_".concat(portletDisplay.getId()));
        }
        return (List)request.getAttribute(name);
    }

    public PortletConfig getPortletConfig(long companyId, String portletId, ServletContext servletContext) throws PortletException, SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        return invokerPortlet.getPortletConfig();
    }

    public String getPortletDescription(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletDescription = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.description".concat(".").concat(portlet.getRootPortletId()));
        if (Validator.isNull((String)portletDescription)) {
            portletDescription = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.description");
        }
        return portletDescription;
    }

    public String getPortletDescription(Portlet portlet, User user) {
        return this.getPortletDescription(portlet.getPortletId(), user);
    }

    public String getPortletDescription(String portletId, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"javax.portlet.description".concat(".").concat(portletId));
    }

    public String getPortletDescription(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletDescription(portletId, locale);
    }

    public String getPortletDescription(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)"javax.portlet.description".concat(".").concat(portletId));
    }

    public LayoutQueryStringComposite getPortletFriendlyURLMapperLayoutQueryStringComposite(long groupId, boolean privateLayout, String url, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        int x;
        boolean foundFriendlyURLMapper = false;
        String friendlyURL = url;
        String queryString = "";
        List portlets = PortletLocalServiceUtil.getFriendlyURLMapperPortlets();
        for (Portlet portlet : portlets) {
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (url.endsWith("/" + friendlyURLMapper.getMapping())) {
                url = String.valueOf(url) + "/";
            }
            int pos = -1;
            pos = friendlyURLMapper.isCheckMappingWithPrefix() ? url.indexOf("/-/" + friendlyURLMapper.getMapping() + "/") : url.indexOf("/" + friendlyURLMapper.getMapping() + "/");
            if (pos == -1) continue;
            foundFriendlyURLMapper = true;
            friendlyURL = url.substring(0, pos);
            InheritableMap actualParams = new InheritableMap();
            if (params != null) {
                actualParams.setParentMap(params);
            }
            HashMap<String, String> prpIdentifiers = new HashMap<String, String>();
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                QName qName = publicRenderParameter.getQName();
                String publicRenderParameterIdentifier = qName.getLocalPart();
                String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
                prpIdentifiers.put(publicRenderParameterIdentifier, publicRenderParameterName);
            }
            FriendlyURLMapperThreadLocal.setPRPIdentifiers(prpIdentifiers);
            if (friendlyURLMapper.isCheckMappingWithPrefix()) {
                friendlyURLMapper.populateParams(url.substring(pos + 2), (Map)actualParams, requestContext);
            } else {
                friendlyURLMapper.populateParams(url.substring(pos), (Map)actualParams, requestContext);
            }
            queryString = "&" + HttpUtil.parameterMapToString((Map)actualParams, (boolean)false);
            break;
        }
        if (!foundFriendlyURLMapper && (x = url.indexOf("/-/")) != -1) {
            String ppid;
            int y = url.indexOf(47, x + 3);
            if (y == -1) {
                y = url.length();
            }
            if (Validator.isNotNull((String)(ppid = url.substring(x + 3, y)))) {
                friendlyURL = url.substring(0, x);
                HashMap<Object, Object> actualParams = null;
                actualParams = params != null ? new HashMap<String, String[]>(params) : new HashMap();
                actualParams.put("p_p_id", new String[]{ppid});
                actualParams.put("p_p_lifecycle", new String[]{"0"});
                actualParams.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
                actualParams.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
                queryString = "&" + HttpUtil.parameterMapToString(actualParams, (boolean)false);
            }
        }
        if ((friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/")).endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)privateLayout, (String)friendlyURL);
        return new LayoutQueryStringComposite(layout, queryString);
    }

    public String getPortletId(HttpServletRequest request) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)request.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletId(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletLongTitle(Portlet portlet, Locale locale) {
        return this.getPortletLongTitle(portlet.getPortletId(), locale);
    }

    public String getPortletLongTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        try {
            String portletLongTitle = resourceBundle.getString("javax.portlet.long-title");
            if (portletLongTitle.startsWith("javax.portlet.long-title")) {
                portletLongTitle = this.getPortletTitle(portlet, servletContext, locale);
            }
            return portletLongTitle;
        }
        catch (Exception exception) {
            return this.getPortletTitle(portlet, servletContext, locale);
        }
    }

    public String getPortletLongTitle(Portlet portlet, String languageId) {
        return this.getPortletLongTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletLongTitle(Portlet portlet, User user) {
        return this.getPortletLongTitle(portlet.getPortletId(), user);
    }

    public String getPortletLongTitle(String portletId, Locale locale) {
        String portletLongTitle = LanguageUtil.get((Locale)locale, (String)"javax.portlet.long-title".concat(".").concat(portletId), (String)"");
        if (Validator.isNull((String)portletLongTitle)) {
            portletLongTitle = this.getPortletTitle(portletId, locale);
        }
        return portletLongTitle;
    }

    public String getPortletLongTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletLongTitle(portletId, locale);
    }

    public String getPortletLongTitle(String portletId, User user) {
        return this.getPortletLongTitle(portletId, user.getLocale());
    }

    public String getPortletNamespace(String portletId) {
        return "_".concat(portletId).concat("_");
    }

    public String getPortletTitle(Portlet portlet, Locale locale) {
        return this.getPortletTitle(portlet.getPortletId(), locale);
    }

    public String getPortletTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.title".concat(".").concat(portlet.getRootPortletId()));
        if (Validator.isNull((String)portletTitle)) {
            portletTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.title");
        }
        return portletTitle;
    }

    public String getPortletTitle(Portlet portlet, String languageId) {
        return this.getPortletTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletTitle(Portlet portlet, User user) {
        return this.getPortletTitle(portlet.getPortletId(), user);
    }

    public String getPortletTitle(RenderRequest renderRequest) {
        String portletId = (String)renderRequest.getAttribute("PORTLET_ID");
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        Locale locale = renderRequest.getLocale();
        return this.getPortletTitle(portlet, servletContext, locale);
    }

    public String getPortletTitle(RenderResponse renderResponse) {
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl((PortletResponse)renderResponse);
        return ((RenderResponseImpl)portletResponseImpl).getTitle();
    }

    public String getPortletTitle(String portletId, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"javax.portlet.title".concat(".").concat(portletId));
    }

    public String getPortletTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletTitle(portletId, locale);
    }

    public String getPortletTitle(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)"javax.portlet.title".concat(".").concat(portletId));
    }

    public String getPortletXmlFileName() throws SystemException {
        if (PrefsPropsUtil.getBoolean("auto.deploy.custom.portlet.xml", PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML)) {
            return "portlet-custom.xml";
        }
        return "portlet.xml";
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (renderRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)renderRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
        return portletBag.getPreferencesValidatorInstance();
    }

    public String getRelativeHomeURL(HttpServletRequest request) throws PortalException, SystemException {
        Company company = this.getCompany(request);
        String homeURL = company.getHomeURL();
        if (Validator.isNull((String)homeURL)) {
            homeURL = PropsValues.COMPANY_DEFAULT_HOME_URL;
        }
        return homeURL;
    }

    public long getScopeGroupId(HttpServletRequest request) throws PortalException, SystemException {
        String portletId = this.getPortletId(request);
        return this.getScopeGroupId(request, portletId);
    }

    public long getScopeGroupId(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        return this.getScopeGroupId(request, portletId, false);
    }

    public long getScopeGroupId(HttpServletRequest request, String portletId, boolean checkStagingGroup) throws PortalException, SystemException {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long scopeGroupId = 0L;
        if (layout != null) {
            Group group = layout.getGroup();
            if (group.isControlPanel()) {
                long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
                Group doAsGroup = GroupLocalServiceUtil.fetchGroup((long)doAsGroupId);
                if (doAsGroupId <= 0L || doAsGroup == null) {
                    doAsGroupId = this.getDefaultScopeGroupId(group.getCompanyId());
                }
                if (doAsGroupId > 0L) {
                    scopeGroupId = doAsGroupId;
                }
                if ((group = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId)) != null && group.hasStagingGroup()) {
                    try {
                        Group stagingGroup = group.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    }
                    catch (Exception exception) {}
                }
            }
            if (portletId != null && (group.isStaged() || group.isStagingGroup())) {
                Group liveGroup = group;
                if (group.isStagingGroup()) {
                    liveGroup = group.getLiveGroup();
                }
                if (liveGroup.isStaged() && !liveGroup.isStagedPortlet(portletId)) {
                    Layout liveGroupLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)liveGroup.getGroupId(), (boolean)layout.isPrivateLayout());
                    if (liveGroupLayout != null && liveGroupLayout.hasScopeGroup()) {
                        scopeGroupId = this.getScopeGroupId(liveGroupLayout, portletId);
                    } else if (checkStagingGroup && !liveGroup.isStagedRemotely()) {
                        Group stagingGroup = liveGroup.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    } else {
                        scopeGroupId = liveGroup.getGroupId();
                    }
                }
            }
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = this.getScopeGroupId(layout, portletId);
        }
        return scopeGroupId;
    }

    public long getScopeGroupId(Layout layout) {
        if (layout == null) {
            return 0L;
        }
        return layout.getGroupId();
    }

    public long getScopeGroupId(Layout layout, String portletId) {
        if (layout == null) {
            return 0L;
        }
        if (Validator.isNull((String)portletId)) {
            return layout.getGroupId();
        }
        try {
            PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup((Layout)layout, (String)portletId);
            String scopeType = GetterUtil.getString((String)portletSetup.getValue("lfrScopeType", null));
            if (Validator.isNull((String)scopeType)) {
                return layout.getGroupId();
            }
            if (scopeType.equals("company")) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                return companyGroup.getGroupId();
            }
            String scopeLayoutUuid = GetterUtil.getString((String)portletSetup.getValue("lfrScopeLayoutUuid", null));
            Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
            Group scopeGroup = scopeLayout.getScopeGroup();
            return scopeGroup.getGroupId();
        }
        catch (Exception exception) {
            return layout.getGroupId();
        }
    }

    public long getScopeGroupId(long plid) {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        }
        catch (Exception exception) {}
        return this.getScopeGroupId(layout);
    }

    public long getScopeGroupId(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getScopeGroupId(this.getHttpServletRequest(portletRequest));
    }

    public User getSelectedUser(HttpServletRequest request) throws PortalException, SystemException {
        return this.getSelectedUser(request, true);
    }

    public User getSelectedUser(HttpServletRequest request, boolean checkPermission) throws PortalException, SystemException {
        long userId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_u_i_d");
        User user = null;
        try {
            user = checkPermission ? UserServiceUtil.getUserById((long)userId) : UserLocalServiceUtil.getUserById((long)userId);
        }
        catch (NoSuchUserException noSuchUserException) {}
        return user;
    }

    public User getSelectedUser(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getSelectedUser(portletRequest, true);
    }

    public User getSelectedUser(PortletRequest portletRequest, boolean checkPermission) throws PortalException, SystemException {
        return this.getSelectedUser(this.getHttpServletRequest(portletRequest), checkPermission);
    }

    public PortletURL getSiteAdministrationURL(PortletResponse portletResponse, ThemeDisplay themeDisplay) throws SystemException {
        Portlet portlet = this.getFirstSiteAdministrationPortlet(themeDisplay);
        if (portlet == null) {
            return null;
        }
        return this.getSiteAdministrationURL(portletResponse, themeDisplay, portlet.getPortletName());
    }

    public PortletURL getSiteAdministrationURL(PortletResponse portletResponse, ThemeDisplay themeDisplay, String portletName) {
        LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)portletResponse;
        LiferayPortletURL siteAdministrationURL = liferayPortletResponse.createRenderURL(portletName);
        siteAdministrationURL.setControlPanelCategory("sites");
        siteAdministrationURL.setDoAsGroupId(themeDisplay.getScopeGroupId());
        siteAdministrationURL.setParameter("redirect", themeDisplay.getURLCurrent());
        return siteAdministrationURL;
    }

    public long[] getSiteAndCompanyGroupIds(long groupId) throws PortalException, SystemException {
        Group scopeGroup = GroupLocalServiceUtil.getGroup((long)groupId);
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)scopeGroup.getCompanyId());
        if (scopeGroup.isLayout()) {
            return new long[]{groupId, scopeGroup.getParentGroupId(), companyGroup.getGroupId()};
        }
        if (scopeGroup.isLayoutSetPrototype() || scopeGroup.isRegularSite()) {
            return new long[]{groupId, companyGroup.getGroupId()};
        }
        return new long[]{companyGroup.getGroupId()};
    }

    public long[] getSiteAndCompanyGroupIds(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getSiteAndCompanyGroupIds(themeDisplay.getScopeGroupId());
    }

    public long getSiteGroupId(long groupId) throws PortalException, SystemException {
        if (groupId <= 0L) {
            return 0L;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        long siteGroupId = groupId;
        if (group.isLayout()) {
            siteGroupId = group.getParentGroupId();
        }
        return siteGroupId;
    }

    public String getSiteLoginURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        if (Validator.isNull((String)PropsValues.AUTH_LOGIN_SITE_URL)) {
            return null;
        }
        List layouts = themeDisplay.getUnfilteredLayouts();
        if (layouts == null) {
            return null;
        }
        for (Layout layout : layouts) {
            String friendlyURL = layout.getFriendlyURL(themeDisplay.getLocale());
            if (!friendlyURL.equals(PropsValues.AUTH_LOGIN_SITE_URL)) continue;
            if (themeDisplay.getLayout() == null) break;
            String layoutSetFriendlyURL = this.getLayoutSetFriendlyURL(layout.getLayoutSet(), themeDisplay);
            return String.valueOf(layoutSetFriendlyURL) + PropsValues.AUTH_LOGIN_SITE_URL;
        }
        return null;
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri) {
        return this.getStaticResourceURL(request, uri, null, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, long timestamp) {
        return this.getStaticResourceURL(request, uri, null, timestamp);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString) {
        return this.getStaticResourceURL(request, uri, queryString, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString, long timestamp) {
        if (uri.indexOf(63) != -1) {
            return uri;
        }
        if (uri.startsWith("//")) {
            uri = uri.substring(1);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        Map parameterMap = null;
        if (Validator.isNotNull((String)queryString)) {
            parameterMap = HttpUtil.getParameterMap((String)queryString);
        }
        StringBundler sb = new StringBundler();
        sb.append(uri);
        sb.append("?");
        if (parameterMap == null || !parameterMap.containsKey("browserId")) {
            sb.append("&browserId=");
            sb.append(BrowserSnifferUtil.getBrowserId((HttpServletRequest)request));
        }
        if (!(!uri.endsWith(".css") && !uri.endsWith(".jsp") || parameterMap != null && parameterMap.containsKey("themeId"))) {
            sb.append("&themeId=");
            sb.append(theme.getThemeId());
        }
        if (uri.endsWith(".jsp") && (parameterMap == null || !parameterMap.containsKey("colorSchemeId"))) {
            sb.append("&colorSchemeId=");
            sb.append(colorScheme.getColorSchemeId());
        }
        if (parameterMap == null || !parameterMap.containsKey("minifierType")) {
            String minifierType = "";
            if (uri.endsWith(".css") || uri.endsWith("css.jsp") || uri.endsWith(".jsp") && uri.contains("/css/")) {
                if (themeDisplay.isThemeCssFastLoad()) {
                    minifierType = "css";
                }
            } else if (themeDisplay.isThemeJsFastLoad()) {
                minifierType = "js";
            }
            if (Validator.isNotNull((String)minifierType)) {
                sb.append("&minifierType=");
                sb.append(minifierType);
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            if (!queryString.startsWith("&")) {
                sb.append("&");
            }
            sb.append(queryString);
        }
        sb.append("&languageId=");
        sb.append(themeDisplay.getLanguageId());
        sb.append("&b=");
        sb.append(ReleaseInfo.getBuildNumber());
        if (parameterMap == null || !parameterMap.containsKey("t")) {
            if (timestamp == 0L && uri.startsWith("/html")) {
                ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
                timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext, (String)uri, (boolean)true);
            }
            if (timestamp == 0L) {
                timestamp = theme.getTimestamp();
            }
            sb.append("&t=");
            sb.append(timestamp);
        }
        String url = sb.toString();
        url = StringUtil.replace((String)url, (String)"?&", (String)"?");
        return url;
    }

    public String getStrutsAction(HttpServletRequest request) {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        if (Validator.isNotNull((String)strutsAction)) {
            return "";
        }
        return this.getPortletParam(request, "struts_action");
    }

    public String[] getSystemGroups() {
        return this._allSystemGroups;
    }

    public String[] getSystemOrganizationRoles() {
        return this._allSystemOrganizationRoles;
    }

    public String[] getSystemRoles() {
        return this._allSystemRoles;
    }

    public String[] getSystemSiteRoles() {
        return this._allSystemSiteRoles;
    }

    public String getUniqueElementId(HttpServletRequest request, String namespace, String elementId) {
        String uniqueElementId = elementId;
        HashSet<String> uniqueElementIds = (HashSet<String>)request.getAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS");
        if (uniqueElementIds == null) {
            uniqueElementIds = new HashSet<String>();
            request.setAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS", uniqueElementIds);
        } else {
            int i2 = 1;
            while (uniqueElementIds.contains(namespace.concat(uniqueElementId))) {
                uniqueElementId = Validator.isNull((String)elementId) || elementId.endsWith("_") ? elementId.concat(String.valueOf(i2)) : elementId.concat("_").concat(String.valueOf(i2));
                ++i2;
            }
        }
        uniqueElementIds.add(namespace.concat(uniqueElementId));
        return uniqueElementId;
    }

    public String getUniqueElementId(PortletRequest request, String namespace, String elementId) {
        return this.getUniqueElementId(this.getHttpServletRequest(request), namespace, elementId);
    }

    public UploadPortletRequest getUploadPortletRequest(PortletRequest portletRequest) {
        PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)portletRequestImpl.getHttpServletRequest();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)dynamicRequest.getRequest();
        UploadServletRequest uploadServletRequest = this.getUploadServletRequest((HttpServletRequest)requestWrapper);
        return new UploadPortletRequestImpl(uploadServletRequest, this.getPortletNamespace(portletRequestImpl.getPortletName()));
    }

    public UploadServletRequest getUploadServletRequest(HttpServletRequest request) {
        HttpServletRequestWrapper requestWrapper = null;
        if (request instanceof HttpServletRequestWrapper) {
            requestWrapper = (HttpServletRequestWrapper)request;
        }
        UploadServletRequest uploadServletRequest = null;
        while (uploadServletRequest == null) {
            if (requestWrapper instanceof UploadServletRequest) {
                uploadServletRequest = (UploadServletRequest)requestWrapper;
                continue;
            }
            Object parentRequest = (HttpServletRequest)requestWrapper.getRequest();
            if (!(parentRequest instanceof HttpServletRequestWrapper)) {
                if (ServerDetector.isWebLogic()) {
                    parentRequest = requestWrapper instanceof NonSerializableObjectRequestWrapper ? requestWrapper : new NonSerializableObjectRequestWrapper(parentRequest);
                }
                uploadServletRequest = new UploadServletRequestImpl((HttpServletRequest)parentRequest);
                break;
            }
            requestWrapper = (HttpServletRequestWrapper)parentRequest;
        }
        return uploadServletRequest;
    }

    public Date getUptime() {
        return _upTime;
    }

    public String getURLWithSessionId(String url, String sessionId) {
        int y;
        if (!PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID) {
            return url;
        }
        if (Validator.isNull((String)url)) {
            return url;
        }
        int x = url.indexOf(59);
        if (x != -1) {
            return url;
        }
        x = url.indexOf(63);
        if (x != -1) {
            StringBundler sb = new StringBundler(4);
            sb.append(url.substring(0, x));
            sb.append(_JSESSIONID);
            sb.append(sessionId);
            sb.append(url.substring(x));
            return sb.toString();
        }
        x = url.indexOf("//");
        StringBundler sb = new StringBundler(4);
        sb.append(url);
        if (x != -1 && x + 1 == (y = url.lastIndexOf(47))) {
            sb.append("/");
        }
        sb.append(_JSESSIONID);
        sb.append(sessionId);
        return sb.toString();
    }

    public User getUser(HttpServletRequest request) throws PortalException, SystemException {
        User user = (User)request.getAttribute("USER");
        if (user != null) {
            return user;
        }
        long userId = this.getUserId(request);
        if (userId <= 0L) {
            String remoteUser = request.getRemoteUser();
            if (remoteUser == null) {
                return null;
            }
            userId = GetterUtil.getLong((String)remoteUser);
        }
        if (userId > 0L) {
            user = UserLocalServiceUtil.getUserById((long)userId);
            request.setAttribute("USER", (Object)user);
        }
        return user;
    }

    public User getUser(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getUser(this.getHttpServletRequest(portletRequest));
    }

    public String getUserEmailAddress(long userId) throws SystemException {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return user.getEmailAddress();
        }
        catch (PortalException portalException) {
            return "";
        }
    }

    public long getUserId(HttpServletRequest request) {
        HttpSession session;
        Long userIdObj = (Long)request.getAttribute("USER_ID");
        if (userIdObj != null) {
            return userIdObj;
        }
        String path = GetterUtil.getString((String)request.getPathInfo());
        String strutsAction = this.getStrutsAction(request);
        String actionName = this.getPortletParam(request, "actionName");
        boolean alwaysAllowDoAsUser = false;
        if (path.equals("/portal/session_click") || strutsAction.equals("/document_library/edit_file_entry") || strutsAction.equals("/document_library_display/edit_file_entry") || strutsAction.equals("/image_gallery_display/edit_file_entry") || strutsAction.equals("/image_gallery_display/edit_image") || strutsAction.equals("/wiki/edit_page_attachment") || strutsAction.equals("/wiki_admin/edit_page_attachment") || strutsAction.equals("/wiki_display/edit_page_attachment") || actionName.equals("addFile")) {
            try {
                alwaysAllowDoAsUser = this.isAlwaysAllowDoAsUser(request);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (!PropsValues.PORTAL_JAAS_ENABLE && PropsValues.PORTAL_IMPERSONATION_ENABLE || alwaysAllowDoAsUser) {
            String doAsUserIdString = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
            try {
                long doAsUserId = this.getDoAsUserId(request, doAsUserIdString, alwaysAllowDoAsUser);
                if (doAsUserId > 0L) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Impersonating user " + doAsUserId));
                    }
                    return doAsUserId;
                }
            }
            catch (Exception e3) {
                _log.error((Object)("Unable to impersonate user " + doAsUserIdString), (Throwable)e3);
            }
        }
        if ((userIdObj = (Long)(session = request.getSession()).getAttribute("USER_ID")) != null) {
            request.setAttribute("USER_ID", (Object)userIdObj);
            return userIdObj;
        }
        return 0L;
    }

    public long getUserId(PortletRequest portletRequest) {
        return this.getUserId(this.getHttpServletRequest(portletRequest));
    }

    public String getUserName(BaseModel<?> baseModel) {
        long userId = 0L;
        String userName = "";
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)baseModel;
            userId = auditedModel.getUserId();
            userName = auditedModel.getUserName();
        } else {
            userId = BeanPropertiesUtil.getLongSilent(baseModel, (String)"userId");
            userName = BeanPropertiesUtil.getStringSilent(baseModel, (String)"userName");
        }
        if (userId == 0L) {
            return "";
        }
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.unescape((String)userName);
        }
        userName = this.getUserName(userId, userName);
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.escape((String)userName);
        }
        return userName;
    }

    public String getUserName(long userId, String defaultUserName) {
        return this.getUserName(userId, defaultUserName, "user.name.full");
    }

    public String getUserName(long userId, String defaultUserName, HttpServletRequest request) {
        return this.getUserName(userId, defaultUserName, "user.name.full", request);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute) {
        return this.getUserName(userId, defaultUserName, userAttribute, null);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute, HttpServletRequest request) {
        String userName = defaultUserName;
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            userName = userAttribute.equals("user.name.full") ? user.getFullName() : user.getScreenName();
            if (request != null) {
                Layout layout = (Layout)request.getAttribute("LAYOUT");
                PortletURLImpl portletURL = new PortletURLImpl(request, "11", layout.getPlid(), "RENDER_PHASE");
                portletURL.setParameter("struts_action", "/directory/view_user");
                portletURL.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
                portletURL.setPortletMode(PortletMode.VIEW);
                portletURL.setWindowState(WindowState.MAXIMIZED);
                userName = "<a href=\"" + portletURL.toString() + "\">" + HtmlUtil.escape((String)userName) + "</a>";
            }
        }
        catch (Exception exception) {}
        return userName;
    }

    public String getUserPassword(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return this.getUserPassword(session);
    }

    public String getUserPassword(HttpSession session) {
        return (String)session.getAttribute("USER_PASSWORD");
    }

    public String getUserPassword(PortletRequest portletRequest) {
        return this.getUserPassword(this.getHttpServletRequest(portletRequest));
    }

    public String getUserValue(long userId, String param, String defaultValue) throws SystemException {
        if (Validator.isNotNull((String)defaultValue)) {
            return defaultValue;
        }
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return BeanPropertiesUtil.getString((Object)user, (String)param, (String)defaultValue);
        }
        catch (PortalException portalException) {
            return "";
        }
    }

    public long getValidUserId(long companyId, long userId) throws PortalException, SystemException {
        User user = UserLocalServiceUtil.fetchUser((long)userId);
        if (user == null) {
            return UserLocalServiceUtil.getDefaultUserId((long)companyId);
        }
        if (user.getCompanyId() == companyId) {
            return user.getUserId();
        }
        return userId;
    }

    public String getVirtualLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        if (Validator.isNull(groupFriendlyURL)) {
            return mainPath;
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        long companyId = PortalInstances.getCompanyId(request);
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)companyId, (String)groupFriendlyURL);
        if (group == null) {
            return mainPath;
        }
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        if (Validator.isNull(layoutFriendlyURL)) {
            return mainPath;
        }
        String actualURL = this.getActualURL(group.getGroupId(), privateLayout, mainPath, layoutFriendlyURL, params, requestContext);
        return HttpUtil.addParameter((String)HttpUtil.removeParameter((String)actualURL, (String)"p_v_l_s_g_id"), (String)"p_v_l_s_g_id", (long)groupId);
    }

    public LayoutFriendlyURLComposite getVirtualLayoutFriendlyURLComposite(boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException, SystemException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        long companyId = PortalInstances.getCompanyId(request);
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)companyId, (String)groupFriendlyURL);
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        LayoutQueryStringComposite layoutQueryStringComposite = this.getActualLayoutQueryStringComposite(group.getGroupId(), privateLayout, layoutFriendlyURL, params, requestContext);
        return new LayoutFriendlyURLComposite(layoutQueryStringComposite.getLayout(), layoutFriendlyURL);
    }

    public String getWidgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getServletURL(portlet, PropsValues.WIDGET_SERVLET_MAPPING, themeDisplay);
    }

    public void initCustomSQL() {
        this._customSqlKeys = new String[]{"[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.GROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.LAYOUT$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ORGANIZATION$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ROLE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USERGROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.BLOGS.MODEL.BLOGSENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.BOOKMARKS.MODEL.BOOKMARKSENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.BOOKMARKS.MODEL.BOOKMARKSFOLDER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFILEENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFOLDER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.JOURNAL.MODEL.JOURNALFOLDER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.MESSAGEBOARDS.MODEL.MBMESSAGE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.MESSAGEBOARDS.MODEL.MBTHREAD$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.WIKI.MODEL.WIKIPAGE$]", "[$RESOURCE_SCOPE_COMPANY$]", "[$RESOURCE_SCOPE_GROUP$]", "[$RESOURCE_SCOPE_GROUP_TEMPLATE$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$SOCIAL_RELATION_TYPE_BI_COWORKER$]", "[$SOCIAL_RELATION_TYPE_BI_FRIEND$]", "[$SOCIAL_RELATION_TYPE_BI_ROMANTIC_PARTNER$]", "[$SOCIAL_RELATION_TYPE_BI_SIBLING$]", "[$SOCIAL_RELATION_TYPE_BI_SPOUSE$]", "[$SOCIAL_RELATION_TYPE_UNI_CHILD$]", "[$SOCIAL_RELATION_TYPE_UNI_ENEMY$]", "[$SOCIAL_RELATION_TYPE_UNI_FOLLOWER$]", "[$SOCIAL_RELATION_TYPE_UNI_PARENT$]", "[$SOCIAL_RELATION_TYPE_UNI_SUBORDINATE$]", "[$SOCIAL_RELATION_TYPE_UNI_SUPERVISOR$]", "[$FALSE$]", "[$TRUE$]"};
        DB db = DBFactoryUtil.getDB();
        Object[] customSqlValues = new Object[]{this.getClassNameId(Group.class), this.getClassNameId(Layout.class), this.getClassNameId(Organization.class), this.getClassNameId(Role.class), this.getClassNameId(User.class), this.getClassNameId(UserGroup.class), this.getClassNameId(BlogsEntry.class), this.getClassNameId(BookmarksEntry.class), this.getClassNameId(BookmarksFolder.class), this.getClassNameId(DLFileEntry.class), this.getClassNameId(DLFolder.class), this.getClassNameId(JournalFolder.class), this.getClassNameId(MBMessage.class), this.getClassNameId(MBThread.class), this.getClassNameId(WikiPage.class), 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 9, 8, 7, 10, 11, db.getTemplateFalse(), db.getTemplateTrue()};
        this._customSqlValues = ArrayUtil.toStringArray((Object[])customSqlValues);
    }

    public User initUser(HttpServletRequest request) throws Exception {
        User user = null;
        try {
            user = this.getUser(request);
        }
        catch (NoSuchUserException nsue) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsue.getMessage());
            }
            if ((userId = this.getUserId(request)) > 0L) {
                HttpSession session = request.getSession();
                session.invalidate();
            }
            throw nsue;
        }
        if (user != null) {
            return user;
        }
        Company company = this.getCompany(request);
        return company.getDefaultUser();
    }

    public void invokeTaglibDiscussion(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this._editDiscussionAction.processAction(null, null, portletConfig, actionRequest, actionResponse);
    }

    public boolean isAllowAddPortletDefaultResource(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        String actualPortletAuthenticationToken;
        Set whitelistActions;
        boolean runtimePortlet;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        String portletId = portlet.getPortletId();
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        if (renderPortletResource != null && (runtimePortlet = renderPortletResource.booleanValue())) {
            return true;
        }
        if (layout.isTypePanel() && this.isPanelSelectedPortlet(themeDisplay, portletId)) {
            return true;
        }
        if (layout.isTypeControlPanel() && this.isControlPanelPortlet(portletId, themeDisplay)) {
            return true;
        }
        if (layoutTypePortlet != null && layoutTypePortlet.hasPortletId(portletId)) {
            return true;
        }
        if (themeDisplay.isSignedIn() && portletId.equals("88")) {
            long scopeGroupId;
            long organizationId;
            long layoutSetPrototypeId;
            long layoutPrototypeId;
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            Group group = layout.getGroup();
            if (group.isSite() && (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE") || LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE"))) {
                return true;
            }
            if (group.isCompany() ? permissionChecker.isCompanyAdmin() : (group.isLayoutPrototype() ? LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)(layoutPrototypeId = group.getClassPK()), (String)"UPDATE") : (group.isLayoutSetPrototype() ? LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)(layoutSetPrototypeId = group.getClassPK()), (String)"UPDATE") : (group.isOrganization() ? OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(organizationId = group.getOrganizationId()), (String)"UPDATE") : (group.isUserGroup() ? GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(scopeGroupId = themeDisplay.getScopeGroupId()), (String)"UPDATE") : group.isUser()))))) {
                return true;
            }
        }
        if (!portlet.isAddDefaultResource()) {
            return false;
        }
        if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return true;
        }
        Set whiteList = PortletSecurityUtil.getWhitelist();
        if (whiteList.contains(portletId)) {
            return true;
        }
        String namespace = this.getPortletNamespace(portletId);
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)(String.valueOf(namespace) + "struts_action"));
        if (Validator.isNull((String)strutsAction)) {
            strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        }
        if ((whitelistActions = PortletSecurityUtil.getWhitelistActions()).contains(strutsAction)) {
            return true;
        }
        String requestPortletAuthenticationToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_auth");
        if (Validator.isNull((String)requestPortletAuthenticationToken)) {
            HttpServletRequest originalRequest = this.getOriginalServletRequest(request);
            requestPortletAuthenticationToken = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"p_p_auth");
        }
        return Validator.isNotNull((String)requestPortletAuthenticationToken) && requestPortletAuthenticationToken.equals(actualPortletAuthenticationToken = AuthTokenUtil.getToken((HttpServletRequest)request, (long)layout.getPlid(), (String)portletId));
    }

    public boolean isCDNDynamicResourcesEnabled(HttpServletRequest request) throws PortalException, SystemException {
        Company company = this.getCompany(request);
        return this.isCDNDynamicResourcesEnabled(company.getCompanyId());
    }

    public boolean isCDNDynamicResourcesEnabled(long companyId) {
        try {
            return PrefsPropsUtil.getBoolean(companyId, "cdn.dynamic.resources.enabled", PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED);
        }
        catch (SystemException systemException) {
            return PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED;
        }
    }

    public boolean isCommunityAdmin(User user, long groupId) throws Exception {
        return this.isGroupAdmin(user, groupId);
    }

    public boolean isCommunityOwner(User user, long groupId) throws Exception {
        return this.isGroupOwner(user, groupId);
    }

    public boolean isCompanyAdmin(User user) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isCompanyAdmin();
    }

    public boolean isCompanyControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, category, themeDisplay);
    }

    public boolean isCompanyControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, themeDisplay);
    }

    public boolean isCompanyControlPanelVisible(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        long scopeGroupId = themeDisplay.getScopeGroupId();
        try {
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
            themeDisplay.setScopeGroupId(companyGroup.getGroupId());
            List<Portlet> controlPanelPortlets = this.getControlPanelPortlets("site_administration.", themeDisplay);
            return !controlPanelPortlets.isEmpty();
            {
            }
        }
        finally {
            themeDisplay.setScopeGroupId(scopeGroupId);
        }
    }

    public boolean isControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (!controlPanelEntryCategory.equals(category)) {
            return false;
        }
        return this.isControlPanelPortlet(portletId, themeDisplay);
    }

    public boolean isControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) throws SystemException {
        try {
            return PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId);
        }
        catch (PortalException pe) {
            _log.warn((Object)"Unable to check control panel access permission", (Throwable)pe);
            return false;
        }
    }

    public boolean isGroupAdmin(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupAdmin(groupId);
    }

    public boolean isGroupFriendlyURL(String fullURL, String groupFriendlyURL, String layoutFriendlyURL) {
        return fullURL.endsWith(groupFriendlyURL) && !fullURL.endsWith(groupFriendlyURL.concat(layoutFriendlyURL));
    }

    public boolean isGroupOwner(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupOwner(groupId);
    }

    public boolean isLayoutDescendant(Layout layout, long layoutId) throws PortalException, SystemException {
        if (layout.getLayoutId() == layoutId) {
            return true;
        }
        for (Layout childLayout : layout.getChildren()) {
            if (!this.isLayoutDescendant(childLayout, layoutId)) continue;
            return true;
        }
        return false;
    }

    public boolean isLayoutFirstPageable(Layout layout) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
        return layoutSettings.isFirstPageable();
    }

    public boolean isLayoutFirstPageable(String type) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(type);
        return layoutSettings.isFirstPageable();
    }

    public boolean isLayoutFriendliable(Layout layout) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
        return layoutSettings.isURLFriendliable();
    }

    public boolean isLayoutFriendliable(String type) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(type);
        return layoutSettings.isURLFriendliable();
    }

    public boolean isLayoutParentable(Layout layout) {
        return this.isLayoutParentable(layout.getType());
    }

    public boolean isLayoutParentable(String type) {
        LayoutSettings layoutSettings = LayoutSettings.getInstance(type);
        return layoutSettings.isParentable();
    }

    public boolean isLayoutSitemapable(Layout layout) {
        if (layout.isPrivateLayout()) {
            return false;
        }
        LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
        return layoutSettings.isSitemapable();
    }

    public boolean isMethodGet(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return method.equalsIgnoreCase("GET");
    }

    public boolean isMethodPost(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return method.equalsIgnoreCase("POST");
    }

    public boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public boolean isOmniadmin(long userId) {
        return OmniadminUtil.isOmniadmin(userId);
    }

    public boolean isReservedParameter(String name) {
        return this._reservedParams.contains(name);
    }

    public boolean isRSSFeedsEnabled() {
        return PropsValues.RSS_FEEDS_ENABLED;
    }

    public boolean isSecure(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session == null) {
            return request.isSecure();
        }
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        boolean secure = false;
        secure = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? false : request.isSecure();
        return secure;
    }

    public boolean isSystemGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemGroups, groupName = groupName.trim(), new StringComparator());
        return pos >= 0;
    }

    public boolean isSystemRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemRoles, roleName = roleName.trim(), new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemSiteRoles, roleName, new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemOrganizationRoles, roleName, new StringComparator());
        return pos >= 0;
    }

    public boolean isUpdateAvailable() throws SystemException {
        return PluginPackageUtil.isUpdateAvailable();
    }

    public boolean isValidResourceId(String resourceId) {
        if (Validator.isNull((String)resourceId)) {
            return true;
        }
        Matcher matcher = this._bannedResourceIdPattern.matcher(resourceId);
        return !matcher.matches();
    }

    public void removePortalPortEventListener(PortalPortEventListener portalPortEventListener) {
        this._portalPortEventListeners.remove(portalPortEventListener);
    }

    public void resetCDNHosts() {
        _cdnHostHttpMap.clear();
        _cdnHostHttpsMap.clear();
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)_resetCDNHostsMethodHandler, (boolean)true);
        try {
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to clear cluster wide CDN hosts", (Throwable)e2);
        }
    }

    public Set<String> resetPortletAddDefaultResourceCheckWhitelist() {
        return PortletSecurityUtil.resetWhitelist();
    }

    public Set<String> resetPortletAddDefaultResourceCheckWhitelistActions() {
        return PortletSecurityUtil.resetWhitelistActions();
    }

    public void sendError(Exception e2, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendError(0, e2, actionRequest, actionResponse);
    }

    public void sendError(Exception e2, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.sendError(0, e2, request, response);
    }

    public void sendError(int status, Exception e2, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StringBundler sb = new StringBundler(7);
        sb.append(this._pathMain);
        sb.append("/portal/status?status=");
        sb.append(status);
        sb.append("&exception=");
        sb.append(e2.getClass().getName());
        sb.append("&previousURL=");
        sb.append(HttpUtil.encodeURL((String)this.getCurrentURL((PortletRequest)actionRequest)));
        actionResponse.sendRedirect(sb.toString());
    }

    public void sendError(int status, Exception e2, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session;
        if (_log.isDebugEnabled()) {
            String currentURL = (String)request.getAttribute("CURRENT_URL");
            _log.debug((Object)("Current URL " + currentURL + " generates exception: " + e2.getMessage()));
        }
        if (e2 instanceof NoSuchImageException) {
            if (_logWebServerServlet.isWarnEnabled()) {
                _logWebServerServlet.warn((Object)e2, (Throwable)e2);
            }
        } else if (e2 instanceof PortalException && _log.isDebugEnabled()) {
            if (e2 instanceof NoSuchLayoutException || e2 instanceof PrincipalException) {
                String msg = e2.getMessage();
                if (Validator.isNotNull((String)msg)) {
                    _log.debug((Object)msg);
                }
            } else {
                _log.debug((Object)e2, (Throwable)e2);
            }
        } else if (e2 instanceof SystemException && _log.isWarnEnabled()) {
            _log.warn((Object)e2, (Throwable)e2);
        }
        if (response.isCommitted()) {
            return;
        }
        if (status == 0) {
            if (e2 instanceof PrincipalException) {
                status = 403;
            } else {
                String name = e2.getClass().getName();
                if ((name = name.substring(name.lastIndexOf(46) + 1)).startsWith("NoSuch") && name.endsWith("Exception")) {
                    status = 404;
                }
            }
            if (status == 0) {
                status = PropsValues.TCK_URL ? 500 : 400;
            }
        }
        if ((session = PortalSessionThreadLocal.getHttpSession()) == null) {
            session = request.getSession();
        }
        ServletContext servletContext = session.getServletContext();
        String redirect = "/c/portal/status";
        if (e2 instanceof NoSuchLayoutException && Validator.isNotNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            response.setStatus(status);
            redirect = PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND;
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (PropsValues.LAYOUT_SHOW_HTTP_STATUS) {
            response.setStatus(status);
            SessionErrors.add((HttpSession)session, e2.getClass(), (Object)e2);
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (e2 != null) {
            response.sendError(status, e2.getMessage());
        } else {
            response.sendError(status);
        }
    }

    public void sendRSSFeedsDisabledError(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortalUtil.sendError((int)404, (Exception)new NoSuchFeedException(), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void sendRSSFeedsDisabledError(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ServletException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        this.sendRSSFeedsDisabledError(request, response);
    }

    public void setPageDescription(String description, HttpServletRequest request) {
        ListMergeable descriptionListMergeable = new ListMergeable();
        descriptionListMergeable.add((Object)description);
        request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
    }

    public void setPageKeywords(String keywords, HttpServletRequest request) {
        request.removeAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        this.addPageKeywords(keywords, request);
    }

    public void setPageSubtitle(String subtitle, HttpServletRequest request) {
        ListMergeable subtitleListMergeable = new ListMergeable();
        subtitleListMergeable.add((Object)subtitle);
        request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
    }

    public void setPageTitle(String title, HttpServletRequest request) {
        ListMergeable titleListMergeable = new ListMergeable();
        titleListMergeable.add((Object)title);
        request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
    }

    public void setPortalPort(HttpServletRequest request) {
        int portalPort;
        if (request.isSecure()) {
            if (this._securePortalPort.get() == -1) {
                int securePortalPort = request.getServerPort();
                this._securePortalPort.compareAndSet(-1, securePortalPort);
            }
        } else if (this._portalPort.get() == -1 && this._portalPort.compareAndSet(-1, portalPort = request.getServerPort())) {
            this.notifyPortalPortEventListeners(portalPort);
        }
    }

    public void storePreferences(PortletPreferences portletPreferences) throws IOException, ValidatorException {
        PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
        PortletPreferencesImpl portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        portletPreferencesImpl.store();
    }

    public String[] stripURLAnchor(String url, String separator) {
        String anchor = "";
        int pos = url.indexOf(separator);
        if (pos != -1) {
            anchor = url.substring(pos);
            url = url.substring(0, pos);
        }
        return new String[]{url, anchor};
    }

    public String transformCustomSQL(String sql) {
        if (this._customSqlKeys == null || this._customSqlValues == null) {
            this.initCustomSQL();
        }
        return StringUtil.replace((String)sql, (String[])this._customSqlKeys, (String[])this._customSqlValues);
    }

    public String transformSQL(String sql) {
        return SQLTransformer.transform(sql);
    }

    public PortletMode updatePortletMode(String portletId, User user, Layout layout, PortletMode portletMode, HttpServletRequest request) {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            if (layoutType.hasModeAboutPortletId(portletId)) {
                return LiferayPortletMode.ABOUT;
            }
            if (layoutType.hasModeConfigPortletId(portletId)) {
                return LiferayPortletMode.CONFIG;
            }
            if (layoutType.hasModeEditPortletId(portletId)) {
                return PortletMode.EDIT;
            }
            if (layoutType.hasModeEditDefaultsPortletId(portletId)) {
                return LiferayPortletMode.EDIT_DEFAULTS;
            }
            if (layoutType.hasModeEditGuestPortletId(portletId)) {
                return LiferayPortletMode.EDIT_GUEST;
            }
            if (layoutType.hasModeHelpPortletId(portletId)) {
                return PortletMode.HELP;
            }
            if (layoutType.hasModePreviewPortletId(portletId)) {
                return LiferayPortletMode.PREVIEW;
            }
            if (layoutType.hasModePrintPortletId(portletId)) {
                return LiferayPortletMode.PRINT;
            }
            return PortletMode.VIEW;
        }
        boolean updateLayout = false;
        if (portletMode.equals((Object)LiferayPortletMode.ABOUT) && !layoutType.hasModeAboutPortletId(portletId)) {
            layoutType.addModeAboutPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG) && !layoutType.hasModeConfigPortletId(portletId)) {
            layoutType.addModeConfigPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.EDIT) && !layoutType.hasModeEditPortletId(portletId)) {
            layoutType.addModeEditPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS) && !layoutType.hasModeEditDefaultsPortletId(portletId)) {
            layoutType.addModeEditDefaultsPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST) && !layoutType.hasModeEditGuestPortletId(portletId)) {
            layoutType.addModeEditGuestPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.HELP) && !layoutType.hasModeHelpPortletId(portletId)) {
            layoutType.addModeHelpPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW) && !layoutType.hasModePreviewPortletId(portletId)) {
            layoutType.addModePreviewPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT) && !layoutType.hasModePrintPortletId(portletId)) {
            layoutType.addModePrintPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.VIEW) && !layoutType.hasModeViewPortletId(portletId)) {
            layoutType.removeModesPortletId(portletId);
            updateLayout = true;
        }
        if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
        }
        return portletMode;
    }

    public String updateRedirect(String redirect, String oldPath, String newPath) {
        if (Validator.isNull((String)redirect) || oldPath == null || oldPath.equals(newPath)) {
            return redirect;
        }
        String queryString = HttpUtil.getQueryString((String)redirect);
        String redirectParam = HttpUtil.getParameter((String)redirect, (String)"redirect", (boolean)false);
        if (Validator.isNotNull((String)redirectParam)) {
            String newRedirectParam = StringUtil.replace((String)redirectParam, (String)HttpUtil.encodeURL((String)oldPath), (String)HttpUtil.encodeURL((String)newPath));
            queryString = StringUtil.replace((String)queryString, (String)redirectParam, (String)newRedirectParam);
        }
        String redirectPath = HttpUtil.getPath((String)redirect);
        int pos = redirect.indexOf(redirectPath);
        String prefix = redirect.substring(0, pos);
        pos = redirectPath.lastIndexOf(oldPath);
        if (pos != -1) {
            prefix = String.valueOf(prefix) + redirectPath.substring(0, pos);
            String suffix = redirectPath.substring(pos + oldPath.length());
            redirect = String.valueOf(prefix) + newPath + suffix;
        } else {
            redirect = String.valueOf(prefix) + redirectPath;
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = String.valueOf(redirect) + "?" + queryString;
        }
        return redirect;
    }

    public WindowState updateWindowState(String portletId, User user, Layout layout, WindowState windowState, HttpServletRequest request) {
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (windowState == null || Validator.isNull((String)windowState.toString())) {
            windowState = layoutType.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutType.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        } else {
            LayoutClone layoutClone;
            boolean updateLayout = false;
            if (windowState.equals((Object)WindowState.MAXIMIZED) && !layoutType.hasStateMaxPortletId(portletId)) {
                layoutType.addStateMaxPortletId(portletId);
                if (PropsValues.LAYOUT_REMEMBER_MAXIMIZED_WINDOW_STATE) {
                    updateLayout = true;
                }
            } else if (windowState.equals((Object)WindowState.MINIMIZED) && !layoutType.hasStateMinPortletId(portletId)) {
                layoutType.addStateMinPortletId(portletId);
                updateLayout = true;
            } else if (windowState.equals((Object)WindowState.NORMAL) && !layoutType.hasStateNormalPortletId(portletId)) {
                layoutType.removeStatesPortletId(portletId);
                updateLayout = true;
            }
            if (portletId.equals("88") || portletId.equals("86")) {
                updateLayout = false;
            }
            if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
                layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
            }
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setStateExclusive(windowState.equals((Object)LiferayWindowState.EXCLUSIVE));
        themeDisplay.setStateMaximized(windowState.equals((Object)WindowState.MAXIMIZED));
        themeDisplay.setStatePopUp(windowState.equals((Object)LiferayWindowState.POP_UP));
        if (themeDisplay.isStateMaximized() && themeDisplay.isShowAddContentIcon()) {
            themeDisplay.setShowAddContentIcon(false);
        } else if (!themeDisplay.isStateMaximized() && !themeDisplay.isShowAddContentIcon() && themeDisplay.isShowAddContentIconPermission()) {
            themeDisplay.setShowAddContentIcon(true);
        }
        request.setAttribute("WINDOW_STATE", (Object)windowState);
        return windowState;
    }

    protected void addDefaultResource(long companyId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException, SystemException {
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addDefaultResource(companyId, groupId, layout, portlet, portletActions);
    }

    protected void addDefaultResource(long companyId, long groupId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException, SystemException {
        String rootPortletId = portlet.getRootPortletId();
        String portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId());
        String name = null;
        String primaryKey = null;
        if (portletActions) {
            name = rootPortletId;
            primaryKey = portletPrimaryKey;
        } else {
            Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
            if (group != null && group.isStagingGroup()) {
                groupId = group.getLiveGroupId();
            }
            name = ResourceActionsUtil.getPortletBaseResource((String)rootPortletId);
            primaryKey = String.valueOf(groupId);
        }
        if (Validator.isNull((String)name)) {
            return;
        }
        int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)name, (int)4, (String)primaryKey);
        if (count > 0) {
            return;
        }
        boolean addGuestPermissions = true;
        if (portletActions) {
            Group layoutGroup = layout.getGroup();
            if (layout.isPrivateLayout() && !layoutGroup.isLayoutPrototype()) {
                addGuestPermissions = false;
            }
        }
        ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)0L, (String)name, (String)primaryKey, (boolean)portletActions, (boolean)true, (boolean)addGuestPermissions);
    }

    protected String buildI18NPath(Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        if (Validator.isNull((String)languageId)) {
            return null;
        }
        if (LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                languageId = locale.getLanguage();
            }
        } else {
            languageId = locale.getLanguage();
        }
        return "/".concat(languageId);
    }

    protected long doGetPlidFromPortletId(long groupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                groupId = scopeLayout.getGroupId();
            }
        }
        catch (Exception exception) {}
        long plid = 0L;
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String)"portlet");
        for (Layout layout : layouts) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            if (!layoutTypePortlet.hasPortletId(portletId) || this.getScopeGroupId(layout, portletId) != scopeGroupId) continue;
            plid = layout.getPlid();
            break;
        }
        return plid;
    }

    protected List<Portlet> filterControlPanelPortlets(Set<Portlet> portlets, ThemeDisplay themeDisplay) {
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>(portlets);
        Iterator itr = filteredPortlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            try {
                if (PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (Portlet)portlet)) continue;
                itr.remove();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                itr.remove();
            }
        }
        return filteredPortlets;
    }

    protected Locale getAvailableLocale(Locale locale) {
        if (Validator.isNull((String)locale.getCountry())) {
            locale = LanguageUtil.getLocale((String)locale.getLanguage());
        }
        if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
            return null;
        }
        return locale;
    }

    protected long getDefaultScopeGroupId(long companyId) throws PortalException, SystemException {
        long doAsGroupId = 0L;
        Set<Portlet> portlets = this.getControlPanelPortlets(companyId, "site_administration.");
        List groups = GroupServiceUtil.getManageableSites(portlets, (int)1);
        if (!groups.isEmpty()) {
            Group group = (Group)groups.get(0);
            doAsGroupId = group.getGroupId();
        } else {
            Group guestGroup = GroupLocalServiceUtil.fetchGroup((long)companyId, (String)"Guest");
            if (guestGroup != null) {
                doAsGroupId = guestGroup.getGroupId();
            }
        }
        return doAsGroupId;
    }

    protected long getDoAsUserId(HttpServletRequest request, String doAsUserIdString, boolean alwaysAllowDoAsUser) throws Exception {
        if (Validator.isNull((String)doAsUserIdString)) {
            return 0L;
        }
        long doAsUserId = 0L;
        try {
            Company company = this.getCompany(request);
            doAsUserId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted"));
            }
            return 0L;
        }
        if (_log.isDebugEnabled()) {
            if (alwaysAllowDoAsUser) {
                _log.debug((Object)"doAsUserId path or Struts action is always allowed");
            } else {
                _log.debug((Object)"doAsUserId path is Struts action not always allowed");
            }
        }
        if (alwaysAllowDoAsUser) {
            request.setAttribute("USER_ID", (Object)new Long(doAsUserId));
            return doAsUserId;
        }
        HttpSession session = request.getSession();
        Long realUserIdObj = (Long)session.getAttribute("USER_ID");
        if (realUserIdObj == null) {
            return 0L;
        }
        User doAsUser = UserLocalServiceUtil.getUserById((long)doAsUserId);
        long[] organizationIds = doAsUser.getOrganizationIds();
        User realUser = UserLocalServiceUtil.getUserById((long)realUserIdObj);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)realUser);
        if (doAsUser.isDefaultUser() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)doAsUserId, (long[])organizationIds, (String)"IMPERSONATE")) {
            request.setAttribute("USER_ID", (Object)new Long(doAsUserId));
            return doAsUserId;
        }
        _log.error((Object)("User " + realUserIdObj + " does not have the permission " + "to impersonate " + doAsUserId));
        return 0L;
    }

    protected String getGroupFriendlyURL(Group group, boolean privateLayoutSet, ThemeDisplay themeDisplay, boolean canonicalURL) throws PortalException, SystemException {
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)privateLayoutSet);
        String portalURL = themeDisplay.getPortalURL();
        if (canonicalURL || !themeDisplay.getServerName().equals(_LOCALHOST)) {
            Company company;
            String virtualHostname = layoutSet.getVirtualHostname();
            if (Validator.isNull((String)virtualHostname) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && !layoutSet.isPrivateLayout()) {
                try {
                    Group defaultGroup = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                    if (layoutSet.getGroupId() == defaultGroup.getGroupId()) {
                        company = themeDisplay.getCompany();
                        virtualHostname = company.getVirtualHostname();
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
            }
            if (Validator.isNotNull((String)virtualHostname) && (canonicalURL || !virtualHostname.equalsIgnoreCase(_LOCALHOST))) {
                virtualHostname = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                String portalDomain = HttpUtil.getDomain((String)themeDisplay.getPortalURL());
                if (canonicalURL || virtualHostname.contains(portalDomain)) {
                    String path = "";
                    if (themeDisplay.isWidget()) {
                        path = PropsValues.WIDGET_SERVLET_MAPPING;
                    }
                    if (themeDisplay.isI18n() && !canonicalURL) {
                        path = themeDisplay.getI18nPath();
                    }
                    return virtualHostname.concat(this._pathContext).concat(path);
                }
            } else {
                LayoutSet curLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)themeDisplay.getSiteGroupId(), (boolean)privateLayoutSet);
                if (canonicalURL || layoutSet.getLayoutSetId() != curLayoutSet.getLayoutSetId() && group.getClassPK() != themeDisplay.getUserId()) {
                    if (group.isControlPanel() && (Validator.isNull((String)(virtualHostname = themeDisplay.getServerName())) || virtualHostname.equalsIgnoreCase(_LOCALHOST))) {
                        virtualHostname = curLayoutSet.getVirtualHostname();
                    }
                    if (Validator.isNull((String)virtualHostname) || virtualHostname.equalsIgnoreCase(_LOCALHOST)) {
                        company = themeDisplay.getCompany();
                        virtualHostname = company.getVirtualHostname();
                    }
                    if (canonicalURL || !virtualHostname.equalsIgnoreCase(_LOCALHOST)) {
                        portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                    }
                }
            }
        }
        String friendlyURL = null;
        friendlyURL = privateLayoutSet ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        StringBundler sb = new StringBundler(6);
        sb.append(portalURL);
        sb.append(this._pathContext);
        if (themeDisplay.isI18n() && !canonicalURL) {
            sb.append(themeDisplay.getI18nPath());
        }
        if (themeDisplay.isWidget()) {
            sb.append(PropsValues.WIDGET_SERVLET_MAPPING);
        }
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    protected String getPortletParam(HttpServletRequest request, String name) {
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return "";
        }
        String value = null;
        int valueCount = 0;
        String keyName = "_".concat(name);
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String portletId1;
            String parameterName = (String)entry.getKey();
            int pos = parameterName.indexOf(keyName);
            if (pos == -1) continue;
            if (++valueCount > 1) {
                return "";
            }
            String[] parameterValues = (String[])entry.getValue();
            if (parameterValues == null || parameterValues.length == 0 || Validator.isNull((String)parameterValues[0]) || !portletId.equals(portletId1 = parameterName.substring(1, pos))) continue;
            value = parameterValues[0];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getServletURL(Portlet portlet, String servletPath, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Layout layout = themeDisplay.getLayout();
        StringBundler sb = new StringBundler();
        sb.append(themeDisplay.getPortalURL());
        if (Validator.isNotNull((String)this._pathContext)) {
            sb.append(this._pathContext);
        }
        if (themeDisplay.isI18n()) {
            sb.append(themeDisplay.getI18nPath());
        }
        sb.append(servletPath);
        Group group = layout.getGroup();
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
            } else {
                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
            }
        } else {
            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL(themeDisplay.getLocale()));
        sb.append("/-/");
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null && !portlet.isInstanceable()) {
            sb.append(friendlyURLMapper.getMapping());
        } else {
            sb.append(portlet.getPortletId());
        }
        return sb.toString();
    }

    protected boolean isAlwaysAllowDoAsUser(HttpServletRequest request) throws Exception {
        String ticketKey = ParamUtil.getString((HttpServletRequest)request, (String)"ticketKey");
        if (Validator.isNull((String)ticketKey)) {
            return false;
        }
        Ticket ticket = TicketLocalServiceUtil.fetchTicket((String)ticketKey);
        if (ticket == null || ticket.getType() != 2) {
            return false;
        }
        String className = ticket.getClassName();
        if (!className.equals(User.class.getName())) {
            return false;
        }
        long doAsUserId = 0L;
        try {
            Company company = this.getCompany(request);
            String doAsUserIdString = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
            if (Validator.isNotNull((String)doAsUserIdString)) {
                doAsUserId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (ticket.getClassPK() != doAsUserId) {
            return false;
        }
        if (ticket.isExpired()) {
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            return false;
        }
        Date expirationDate = new Date(System.currentTimeMillis() + (long)PropsValues.SESSION_TIMEOUT * 60000L);
        ticket.setExpirationDate(expirationDate);
        TicketLocalServiceUtil.updateTicket((Ticket)ticket);
        return true;
    }

    protected boolean isPanelSelectedPortlet(ThemeDisplay themeDisplay, String portletId) {
        Layout layout = themeDisplay.getLayout();
        String panelSelectedPortlets = layout.getTypeSettingsProperty("panelSelectedPortlets");
        if (Validator.isNotNull((String)panelSelectedPortlets)) {
            Object[] panelSelectedPortletsArray = StringUtil.split((String)panelSelectedPortlets);
            return ArrayUtil.contains((Object[])panelSelectedPortletsArray, (Object)portletId);
        }
        return false;
    }

    protected void notifyPortalPortEventListeners(int portalPort) {
        for (PortalPortEventListener portalPortEventListener : this._portalPortEventListeners) {
            portalPortEventListener.portalPortConfigured(portalPort);
        }
    }

    protected String removeRedirectParameter(String url) {
        String queryString = HttpUtil.getQueryString((String)url);
        Map parameterMap = HttpUtil.getParameterMap((String)queryString);
        for (String parameter : parameterMap.keySet()) {
            if (!parameter.endsWith("redirect")) continue;
            url = HttpUtil.removeParameter((String)url, (String)parameter);
        }
        return url;
    }

    protected void resetThemeDisplayI18n(ThemeDisplay themeDisplay, String languageId, String path) {
        themeDisplay.setI18nLanguageId(languageId);
        themeDisplay.setI18nPath(path);
    }

    protected void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        HttpSession session = request.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
    }

    protected void setThemeDisplayI18n(ThemeDisplay themeDisplay, Locale locale) {
        String i18nLanguageId = null;
        String i18nPath = null;
        if (I18nFilter.getLanguageIds().contains(locale.toString()) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && !locale.equals(LocaleUtil.getDefault()) || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nLanguageId = locale.toString();
            i18nPath = this.buildI18NPath(locale);
        }
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
    }
}

