/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.concurrent.ConcurrentLFUCache;
import java.io.File;

public class LimitedFilesCache<T> {
    private FileRemovingLFUCache<T> _fileRemovingLFUCache;

    public LimitedFilesCache(int maxSize) {
        this._fileRemovingLFUCache = new FileRemovingLFUCache(maxSize);
    }

    public File get(T key) {
        return (File)this._fileRemovingLFUCache.get(key);
    }

    public void put(T key) {
        this._fileRemovingLFUCache.put(key, null);
    }

    public void put(T key, File file) {
        this._fileRemovingLFUCache.put(key, file);
    }

    private class FileRemovingLFUCache<K>
    extends ConcurrentLFUCache<K, File> {
        public FileRemovingLFUCache(int maxSize) {
            super(maxSize);
        }

        protected void onRemove(K key, File cachedFile) {
            if (cachedFile != null) {
                cachedFile.delete();
            } else {
                File file = new File(key.toString());
                file.delete();
            }
        }
    }
}

