/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;

public class LayoutSettings {
    private static Map<String, LayoutSettings> _layoutSettingsMap = new HashMap<String, LayoutSettings>();
    private String[] _configurationActionDelete;
    private String[] _configurationActionUpdate;
    private String _editPage;
    private boolean _firstPageable;
    private boolean _parentable;
    private boolean _sitemapable;
    private String _type;
    private String _url;
    private boolean _urlFriendliable;
    private String _viewPage;

    static {
        new LayoutSettings("control_panel");
        String[] stringArray = PropsValues.LAYOUT_TYPES;
        int n = PropsValues.LAYOUT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            new LayoutSettings(type);
            ++n2;
        }
    }

    public static LayoutSettings getInstance(Layout layout) {
        return LayoutSettings.getInstance(layout.getType());
    }

    public static LayoutSettings getInstance(String type) {
        return _layoutSettingsMap.get(type);
    }

    public String[] getConfigurationActionDelete() {
        return this._configurationActionDelete;
    }

    public String[] getConfigurationActionUpdate() {
        return this._configurationActionUpdate;
    }

    public String getEditPage() {
        return this._editPage;
    }

    public String getType() {
        return this._type;
    }

    public String getURL() {
        return this._url;
    }

    public String getURL(Map<String, String> variables) {
        return StringUtil.replace((String)this._url, (String)"${", (String)"}", variables);
    }

    public String getViewPage() {
        return this._viewPage;
    }

    public boolean isFirstPageable() {
        return this._firstPageable;
    }

    public boolean isParentable() {
        return this._parentable;
    }

    public boolean isSitemapable() {
        return this._sitemapable;
    }

    public boolean isURLFriendliable() {
        return this._urlFriendliable;
    }

    private LayoutSettings(String type) {
        this._type = type;
        Filter filter = new Filter(type);
        this._configurationActionDelete = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.delete", filter)));
        this._configurationActionUpdate = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.update", filter)));
        this._editPage = GetterUtil.getString((String)PropsUtil.get("layout.edit.page", filter));
        this._firstPageable = GetterUtil.getBoolean((String)PropsUtil.get("layout.first.pageable", filter));
        this._parentable = GetterUtil.getBoolean((String)PropsUtil.get("layout.parentable", filter), (boolean)true);
        this._sitemapable = GetterUtil.getBoolean((String)PropsUtil.get("layout.sitemapable", filter), (boolean)true);
        this._url = GetterUtil.getString((String)PropsUtil.get("layout.url", filter));
        this._urlFriendliable = GetterUtil.getBoolean((String)PropsUtil.get("layout.url.friendliable", filter), (boolean)true);
        this._viewPage = GetterUtil.getString((String)PropsUtil.get("layout.view.page", filter));
        _layoutSettingsMap.put(type, this);
    }
}

