/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.servlet.ServletContext;

public class ClassLoaderUtil {
    public static ClassLoader getAggregatePluginsClassLoader(final String[] servletContextNames, final boolean addContextClassLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(servletContextNames.length + 2);
                if (addContextClassLoader) {
                    ClassLoader contextClassLoader = ClassLoaderUtil._getContextClassLoader();
                    classLoaders.add(contextClassLoader);
                }
                String[] stringArray = servletContextNames;
                int n = servletContextNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String servletContextName = stringArray[n2];
                    ClassLoader pluginClassLoader = ClassLoaderUtil._getPluginClassLoader(servletContextName);
                    classLoaders.add(pluginClassLoader);
                    ++n2;
                }
                ClassLoader[] classloaders = classLoaders.toArray(new ClassLoader[classLoaders.size()]);
                return AggregateClassLoader.getAggregateClassLoader((ClassLoader[])classloaders);
            }
        });
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoaderUtil._getContextClassLoader();
            }
        });
    }

    public static ClassLoader getPluginClassLoader(final String servletContextName) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader pluginClassLoader = ClassLoaderUtil._getPluginClassLoader(servletContextName);
                return pluginClassLoader;
            }
        });
    }

    public static ClassLoader getPortalClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return PortalClassLoaderUtil.getClassLoader();
            }
        });
    }

    public static void setContextClassLoader(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread thread = Thread.currentThread();
                thread.setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    private static ClassLoader _getContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }

    private static ClassLoader _getPluginClassLoader(String servletContextName) {
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        return (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
    }
}

