/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletInputStreamAdapter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LiferayInputStream
extends ServletInputStreamAdapter {
    public static final long THRESHOLD_SIZE = GetterUtil.getLong((String)PropsUtil.get(String.valueOf(LiferayInputStream.class.getName()) + ".threshold.size"));
    private static Log _log = LogFactoryUtil.getLog(LiferayInputStream.class);
    private UnsyncByteArrayOutputStream _cachedBytes = new UnsyncByteArrayOutputStream();
    private HttpSession _session;
    private long _totalRead;
    private long _totalSize;

    public LiferayInputStream(HttpServletRequest request) throws IOException {
        super((InputStream)request.getInputStream());
        this._session = request.getSession();
        this._totalSize = request.getContentLength();
        if (this._totalSize < 0L) {
            this._totalSize = GetterUtil.getLong((String)request.getHeader("Content-Length"), (long)this._totalSize);
        }
    }

    public ServletInputStream getCachedInputStream() {
        if (this._totalSize < THRESHOLD_SIZE) {
            return this;
        }
        return new ServletInputStreamAdapter((InputStream)new UnsyncByteArrayInputStream(this._cachedBytes.unsafeGetByteArray(), 0, this._cachedBytes.size()));
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int bytesRead = super.read(b2, off, len);
        if (bytesRead > 0) {
            this._totalRead += (long)bytesRead;
        } else {
            return bytesRead;
        }
        int percent = (int)(this._totalRead * 100L / this._totalSize);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(bytesRead) + "/" + this._totalRead + "=" + percent));
        }
        if (this._totalSize > 0L && this._totalSize < THRESHOLD_SIZE) {
            this._cachedBytes.write(b2, off, bytesRead);
        }
        ProgressTracker progressTracker = (ProgressTracker)this._session.getAttribute(LiferayFileUpload.PERCENT);
        Integer curPercent = null;
        if (progressTracker != null) {
            curPercent = progressTracker.getPercent();
        }
        if (curPercent == null || percent - curPercent >= 1) {
            if (progressTracker == null) {
                progressTracker = new ProgressTracker(this._session, "");
                progressTracker.initialize();
            }
            progressTracker.setPercent(percent);
        }
        return bytesRead;
    }
}

