/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeSocial
extends UpgradeProcess {
    protected void addActivity(long activityId, long groupId, long companyId, long userId, Timestamp createDate, long mirrorActivityId, long classNameId, long classPK, int type, String extraData, long receiverUserId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into SocialActivity (activityId, groupId, ");
            sb.append("companyId, userId, createDate, mirrorActivityId, ");
            sb.append("classNameId, classPK, type_, extraData, ");
            sb.append("receiverUserId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?)");
            ps = con.prepareStatement(sb.toString());
            ps.setLong(1, activityId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setLong(5, createDate.getTime());
            ps.setLong(6, mirrorActivityId);
            ps.setLong(7, classNameId);
            ps.setLong(8, classPK);
            ps.setInt(9, type);
            ps.setString(10, extraData);
            ps.setLong(11, receiverUserId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
    }

    protected void doUpgrade() throws Exception {
        this.updateJournalActivities();
        this.updateWikiPageActivities();
    }

    protected void updateJournalActivities() throws Exception {
        String[] tableNames;
        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
        String[] stringArray = tableNames = new String[]{"SocialActivity", "SocialActivityCounter"};
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            StringBundler sb = new StringBundler(7);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set classPK = (select resourcePrimKey ");
            sb.append("from JournalArticle where id_ = ");
            sb.append(tableName);
            sb.append(".classPK) where classNameId = ");
            sb.append(classNameId);
            this.runSQL(sb.toString());
            ++n2;
        }
    }

    protected void updateWikiPageActivities() throws Exception {
        long classNameId = PortalUtil.getClassNameId(WikiPage.class);
        this.runSQL("delete from SocialActivity where classNameId = " + classNameId);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, companyId, userId, modifiedDate, resourcePrimKey, version from WikiPage");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                double version = rs.getDouble("version");
                int type = 1;
                if (version > 1.0) {
                    type = 2;
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("version", version);
                this.addActivity(this.increment(), groupId, companyId, userId, modifiedDate, 0L, classNameId, resourcePrimKey, type, extraDataJSONObject.toString(), 0L);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

