/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import javax.portlet.PortletPreferences;

public class UpgradePortletPreferences
extends BaseUpgradePortletPreferences {
    protected String[] getPortletIds() {
        return new String[]{"3"};
    }

    protected JSONObject upgradeDataJSONObject(JSONObject dataJSONObject) throws Exception {
        JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
        boolean hasBookmarksEntry = false;
        boolean hasDLFileEntry = false;
        boolean hasJournalArticle = false;
        int i2 = 0;
        while (i2 < valuesJSONArray.length()) {
            String value = valuesJSONArray.getString(i2);
            if (value.equals(BookmarksEntry.class.getName())) {
                hasBookmarksEntry = true;
            }
            if (value.equals(DLFileEntryConstants.getClassName())) {
                hasDLFileEntry = true;
            }
            if (value.equals(JournalArticle.class.getName())) {
                hasJournalArticle = true;
            }
            ++i2;
        }
        if (!(hasBookmarksEntry || hasDLFileEntry || hasJournalArticle)) {
            return null;
        }
        if (hasBookmarksEntry) {
            valuesJSONArray.put(BookmarksFolder.class.getName());
        }
        if (hasDLFileEntry) {
            valuesJSONArray.put(DLFolderConstants.getClassName());
        }
        if (hasJournalArticle) {
            valuesJSONArray.put(JournalFolder.class.getName());
        }
        dataJSONObject.put("values", valuesJSONArray);
        return dataJSONObject;
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        String searchConfiguration = portletPreferences.getValue("searchConfiguration", null);
        if (Validator.isNull((String)searchConfiguration)) {
            return null;
        }
        JSONObject searchConfigurationJSONObject = JSONFactoryUtil.createJSONObject((String)searchConfiguration);
        JSONArray oldFacetsJSONArray = searchConfigurationJSONObject.getJSONArray("facets");
        if (oldFacetsJSONArray == null) {
            return null;
        }
        JSONArray newFacetsJSONArray = JSONFactoryUtil.createJSONArray();
        int i2 = 0;
        while (i2 < oldFacetsJSONArray.length()) {
            JSONObject oldFacetJSONObject = oldFacetsJSONArray.getJSONObject(i2);
            String fieldName = oldFacetJSONObject.getString("fieldName");
            if (fieldName.equals("entryClassName")) {
                JSONObject oldDataJSONObject = oldFacetJSONObject.getJSONObject("data");
                JSONObject newDataJSONObject = this.upgradeDataJSONObject(oldDataJSONObject);
                if (newDataJSONObject == null) {
                    return null;
                }
                oldFacetJSONObject.put("data", newDataJSONObject);
            }
            newFacetsJSONArray.put(oldFacetJSONObject);
            ++i2;
        }
        searchConfigurationJSONObject.put("facets", newFacetsJSONArray);
        portletPreferences.setValue("searchConfiguration", searchConfigurationJSONObject.toString());
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

