/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;

public class UpgradeLayoutFriendlyURL
extends UpgradeProcess {
    protected void addLayoutFriendlyURL(long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long plid, boolean privateLayout, String friendlyURL) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("insert into LayoutFriendlyURL (uuid_, ");
            sb.append("layoutFriendlyURLId, groupId, companyId, userId, ");
            sb.append("userName, createDate, modifiedDate, plid, ");
            sb.append("privateLayout, friendlyURL, languageId) values (?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, this.increment());
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setDate(7, createDate);
            ps.setDate(8, modifiedDate);
            ps.setLong(9, plid);
            ps.setBoolean(10, privateLayout);
            ps.setString(11, friendlyURL);
            ps.setString(12, LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select plid, groupId, companyId, userId, userName, createDate, modifiedDate, privateLayout, friendlyURL from Layout");
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Date createDate = rs.getDate("createDate");
                Date modifiedDate = rs.getDate("modifiedDate");
                boolean privateLayout = rs.getBoolean("privateLayout");
                String friendlyURL = rs.getString("friendlyURL");
                this.addLayoutFriendlyURL(groupId, companyId, userId, userName, createDate, modifiedDate, plid, privateLayout, friendlyURL);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

