/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.v6_2_0.util.DDMTemplateTable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class UpgradeDynamicDataMapping
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter table DDMTemplate add classNameId LONG");
            this.runSQL("alter table DDMTemplate add templateKey STRING");
            this.runSQL("alter_column_name DDMTemplate structureId classPK LONG");
        }
        catch (SQLException sQLException) {
            this.upgradeTable("DDMTemplate", DDMTemplateTable.TABLE_COLUMNS, "create table DDMTemplate (uuid_ VARCHAR(75) null,templateId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,templateKey VARCHAR(75) null,name STRING null,description STRING null,type_ VARCHAR(75) null,mode_ VARCHAR(75) null,language VARCHAR(75) null,script TEXT null,cacheable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL VARCHAR(75) null)", DDMTemplateTable.TABLE_SQL_ADD_INDEXES);
        }
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        this.runSQL("update DDMTemplate set classNameId = " + classNameId);
        this.updateStructures();
    }

    protected void updateMetadataElement(Element metadataElement, String[] relocatedMetadadaEntryNames, String[] removedMetadataEntryNames) {
        Element parentElement = metadataElement.getParent();
        List entryElements = metadataElement.elements("entry");
        for (Element entryElement : entryElements) {
            String name = entryElement.attributeValue("name");
            if (ArrayUtil.contains((Object[])removedMetadataEntryNames, (Object)name)) {
                metadataElement.remove(entryElement);
                continue;
            }
            if (!ArrayUtil.contains((Object[])relocatedMetadadaEntryNames, (Object)name)) continue;
            parentElement.addAttribute(name, entryElement.getText());
            metadataElement.remove(entryElement);
        }
    }

    protected void updateStructure(long structureId, String structureKey, String xsd) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DDMStructure set structureKey = ?, xsd = ? where structureId = ?");
            ps.setString(1, structureKey);
            ps.setString(2, xsd);
            ps.setLong(3, structureId);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    protected void updateStructures() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from DDMStructure");
            rs = ps.executeQuery();
            while (rs.next()) {
                long structureId = rs.getLong("structureId");
                String structureKey = rs.getString("structureKey");
                String xsd = rs.getString("xsd");
                this.updateStructure(structureId, structureKey.trim().toUpperCase(), this.updateXSD(xsd));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected String updateXSD(String xsd) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
        return DDMXMLUtil.formatXML((Document)document);
    }

    protected void updateXSDDynamicElement(Element element) {
        Element metadataElement = element.element("meta-data");
        this.updateMetadataElement(metadataElement, new String[]{"multiple", "readOnly", "repeatable", "required", "showLabel", "width"}, new String[]{"displayChildLabelAsValue", "fieldCssClass"});
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
    }
}

