/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select plid, name, title, typeSettings from Layout");
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String typeSettings = rs.getString("typeSettings");
                this.updateLayout(plid, name, title, typeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateJavaScript(UnicodeProperties typeSettingsProperties, String javaScript1, String javaScript2, String javaScript3) {
        String javascript;
        StringBundler sb = new StringBundler(6);
        if (Validator.isNotNull((String)javaScript1)) {
            sb.append("// Custom JavaScript 1\n\n");
            sb.append(javaScript1);
            typeSettingsProperties.remove((Object)"javascript-1");
        }
        if (Validator.isNotNull((String)javaScript2)) {
            sb.append("\n\n\n // Custom JavaScript 2\n\n");
            sb.append(javaScript2);
            typeSettingsProperties.remove((Object)"javascript-2");
        }
        if (Validator.isNotNull((String)javaScript3)) {
            sb.append("\n\n\n // Custom JavaScript 3\n\n");
            sb.append(javaScript3);
            typeSettingsProperties.remove((Object)"javascript-3");
        }
        if (Validator.isNotNull((String)(javascript = sb.toString()))) {
            typeSettingsProperties.put("javascript", javascript);
        }
    }

    protected void updateLayout(long plid, String name, String title, String typeSettings) throws Exception {
        String defaultRobots;
        String defaultKeywords;
        if (Validator.isNotNull((String)name)) {
            name = StringUtil.replace((String)name, (String[])new String[]{"<name", "</name>"}, (String[])new String[]{"<Name", "</Name>"});
            this.updateName(plid, name);
        }
        if (Validator.isNotNull((String)title)) {
            title = StringUtil.replace((String)title, (String[])new String[]{"<title", "</title>"}, (String[])new String[]{"<Title", "</Title>"});
            this.updateTitle(plid, title);
        }
        if (Validator.isNull((String)typeSettings)) {
            return;
        }
        Locale defaultLocale = LocaleUtil.getDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.load(typeSettings);
        String defaultDescription = typeSettingsProperties.getProperty("meta-description_" + defaultLanguageId);
        if (Validator.isNotNull((String)defaultDescription)) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-description_", "Description", "description");
        }
        if (Validator.isNotNull((String)(defaultKeywords = typeSettingsProperties.getProperty("meta-keywords_" + defaultLanguageId)))) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-keywords_", "Keywords", "keywords");
        }
        if (Validator.isNotNull((String)(defaultRobots = typeSettingsProperties.getProperty("meta-robots_" + defaultLanguageId)))) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-robots_", "Robots", "robots");
        }
        String javaScript1 = typeSettingsProperties.getProperty("javascript-1");
        String javaScript2 = typeSettingsProperties.getProperty("javascript-2");
        String javaScript3 = typeSettingsProperties.getProperty("javascript-3");
        if (javaScript1 != null || javaScript2 != null || javaScript3 != null) {
            this.updateJavaScript(typeSettingsProperties, javaScript1, javaScript2, javaScript3);
        }
        this.updateTypeSettings(plid, typeSettingsProperties.toString());
    }

    protected UnicodeProperties updateMetaField(long plid, UnicodeProperties typeSettingsProperties, String propertyName, String xmlName, String columName) throws Exception {
        Locale[] locales;
        String xml = null;
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = typeSettingsProperties.getProperty(String.valueOf(propertyName) + languageId);
            if (Validator.isNotNull((String)value)) {
                xml = LocalizationUtil.updateLocalization(xml, (String)xmlName, (String)value, (String)languageId);
                typeSettingsProperties.remove((Object)(String.valueOf(propertyName) + languageId));
            }
            ++n2;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set " + columName + " = ? where plid = " + plid);
            ps.setString(1, xml);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
        return typeSettingsProperties;
    }

    protected void updateName(long plid, String name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set name = ? where plid = " + plid);
            ps.setString(1, name);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateTitle(long plid, String title) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set title = ? where plid = " + plid);
            ps.setString(1, title);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

