/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.image.DLHook;
import com.liferay.portal.image.DatabaseHook;
import com.liferay.portal.image.FileSystemHook;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.upgrade.v6_1_0.UpgradeDocumentLibrary;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeImageGallery
extends UpgradeProcess {
    private static final String _IG_FOLDER_CLASS_NAME = "com.liferay.portlet.imagegallery.model.IGFolder";
    private static final String _IG_IMAGE_CLASS_NAME = "com.liferay.portlet.imagegallery.model.IGImage";
    private static Log _log = LogFactoryUtil.getLog(UpgradeImageGallery.class);
    private Hook _sourceHook;
    private String _sourceHookClassName;

    public UpgradeImageGallery() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        this._sourceHookClassName = FileSystemHook.class.getName();
        if (Validator.isNotNull((String)PropsValues.IMAGE_HOOK_IMPL)) {
            this._sourceHookClassName = PropsValues.IMAGE_HOOK_IMPL;
        }
        this._sourceHook = (Hook)classLoader.loadClass(this._sourceHookClassName).newInstance();
    }

    protected void addDLFileEntry(String uuid, long fileEntryId, long groupId, long companyId, long userId, String userName, long versionUserId, String versionUserName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long folderId, String name, String extension, String mimeType, String title, String description, String extraSettings, long fileEntryTypeId, String version, long size, int readCount, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(9);
            sb.append("insert into DLFileEntry (uuid_, fileEntryId, groupId, ");
            sb.append("companyId, userId, userName, versionUserId, ");
            sb.append("versionUserName, createDate, modifiedDate, ");
            sb.append("repositoryId, folderId, name, extension, mimeType, ");
            sb.append("title, description, extraSettings, fileEntryTypeId, ");
            sb.append("version, size_, readCount, smallImageId, ");
            sb.append("largeImageId, custom1ImageId, custom2ImageId) values (");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, fileEntryId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setLong(7, versionUserId);
            ps.setString(8, versionUserName);
            ps.setTimestamp(9, createDate);
            ps.setTimestamp(10, modifiedDate);
            ps.setLong(11, repositoryId);
            ps.setLong(12, folderId);
            ps.setString(13, name);
            ps.setString(14, extension);
            ps.setString(15, mimeType);
            ps.setString(16, title);
            ps.setString(17, description);
            ps.setString(18, extraSettings);
            ps.setLong(19, fileEntryTypeId);
            ps.setString(20, version);
            ps.setLong(21, size);
            ps.setInt(22, readCount);
            ps.setLong(23, smallImageId);
            ps.setLong(24, largeImageId);
            ps.setLong(25, custom1ImageId);
            ps.setLong(26, custom2ImageId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addDLFileVersion(long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long folderId, long fileEntryId, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, String version, long size, int status, long statusByUserId, String statusByUserName, Timestamp statusDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(9);
            sb.append("insert into DLFileVersion (fileVersionId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, folderId, fileEntryId, ");
            sb.append("extension, mimeType, title, description, changeLog, ");
            sb.append("extraSettings, fileEntryTypeId, version, size_, ");
            sb.append("status, statusByUserId, statusByUserName, statusDate) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, fileVersionId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, createDate);
            ps.setTimestamp(7, statusDate);
            ps.setLong(8, repositoryId);
            ps.setLong(9, folderId);
            ps.setLong(10, fileEntryId);
            ps.setString(11, extension);
            ps.setString(12, mimeType);
            ps.setString(13, title);
            ps.setString(14, description);
            ps.setString(15, changeLog);
            ps.setString(16, extraSettings);
            ps.setLong(17, fileEntryTypeId);
            ps.setString(18, version);
            ps.setLong(19, size);
            ps.setInt(20, status);
            ps.setLong(21, statusByUserId);
            ps.setString(22, statusByUserName);
            ps.setTimestamp(23, statusDate);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addDLFolderEntry(String uuid, long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long parentFolderId, String name, String description, Timestamp lastPostDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into DLFolder (uuid_, folderId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, mountPoint, ");
            sb.append("parentFolderId, name, description, lastPostDate) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, folderId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, repositoryId);
            ps.setBoolean(10, false);
            ps.setLong(11, parentFolderId);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setTimestamp(14, lastPostDate);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addIGImageDLFileEntryType() throws Exception {
        if (!PropsValues.DL_FILE_ENTRY_TYPE_IG_IMAGE_AUTO_CREATE_ON_UPGRADE) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select distinct companyId from IGImage");
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long groupId = this.getCompanyGroupId(companyId);
                long userId = this.getDefaultUserId(companyId);
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.addIGImageDLFileEntryType(groupId, companyId, userId, "", now, now);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void addIGImageDLFileEntryType(long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("insert into DLFileEntryType (uuid_, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, name, description, fileEntryTypeId) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, createDate);
            ps.setTimestamp(7, modifiedDate);
            ps.setString(8, "Image Gallery Image");
            ps.setString(9, "Image Gallery Image");
            ps.setLong(10, this.increment());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
    }

    protected void deleteConflictingIGPermissions(String igResourceName, String dlResourceName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            boolean supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
            ps = con.prepareStatement("select companyId, scope, primKey, roleId from ResourcePermission where name = ?");
            ps.setString(1, igResourceName);
            rs = ps.executeQuery();
            ps = con.prepareStatement("delete from ResourcePermission where name = ? and companyId = ? and scope = ? and primKey = ? and roleId = ?");
            int count = 0;
            while (rs.next()) {
                ps.setString(1, dlResourceName);
                ps.setLong(2, rs.getLong("companyId"));
                ps.setInt(3, rs.getInt("scope"));
                ps.setString(4, rs.getString("primKey"));
                ps.setLong(5, rs.getLong("roleId"));
                if (supportsBatchUpdates) {
                    ps.addBatch();
                    if (count == PropsValues.HIBERNATE_JDBC_BATCH_SIZE) {
                        ps.executeBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                    continue;
                }
                ps.executeUpdate();
            }
            if (supportsBatchUpdates && count > 0) {
                ps.executeBatch();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        this.addIGImageDLFileEntryType();
        this.updateIGFolderEntries();
        this.updateIGImageEntries();
        this.updateIGFolderPermissions();
        this.updateIGImagePermissions();
        this.migrateImageFiles();
        UpgradeDocumentLibrary upgradeDocumentLibrary = new UpgradeDocumentLibrary();
        upgradeDocumentLibrary.updateSyncs();
    }

    protected long getBitwiseValue(Map<String, Long> bitwiseValues, List<String> actionIds) {
        long bitwiseValue = 0L;
        for (String actionId : actionIds) {
            Long actionIdBitwiseValue = bitwiseValues.get(actionId);
            if (actionIdBitwiseValue == null) continue;
            bitwiseValue |= actionIdBitwiseValue.longValue();
        }
        return bitwiseValue;
    }

    protected Map<String, Long> getBitwiseValues(String name) throws Exception {
        HashMap<String, Long> hashMap;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String currentShardName = null;
        try {
            currentShardName = ShardUtil.setTargetSource((String)PropsValues.SHARD_DEFAULT_NAME);
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select actionId, bitwiseValue from ResourceAction where name = ?");
            ps.setString(1, name);
            rs = ps.executeQuery();
            HashMap<String, Long> bitwiseValues = new HashMap<String, Long>();
            while (rs.next()) {
                String actionId = rs.getString("actionId");
                long bitwiseValue = rs.getLong("bitwiseValue");
                bitwiseValues.put(actionId, bitwiseValue);
            }
            hashMap = bitwiseValues;
        }
        catch (Throwable throwable) {
            if (Validator.isNotNull((String)currentShardName)) {
                ShardUtil.setTargetSource((String)currentShardName);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        if (Validator.isNotNull((String)currentShardName)) {
            ShardUtil.setTargetSource((String)currentShardName);
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return hashMap;
    }

    protected long getCompanyGroupId(long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from Group_ where classNameId = ? and classPK = ?");
                ps.setLong(1, PortalUtil.getClassNameId((String)Company.class.getName()));
                ps.setLong(2, companyId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long getDefaultUserId(long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select userId from User_ where companyId = ? and defaultUser = ?");
                ps.setLong(1, companyId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("userId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected Object[] getImage(long imageId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            Object[] objectArray;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select type_, size_ from Image where imageId = " + imageId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                String type = rs.getString("type_");
                long size = rs.getInt("size_");
                objectArray = new Object[]{type, size};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return null;
    }

    protected List<String> getResourceActionIds(Map<String, Long> bitwiseValues, long actionIdsLong) {
        ArrayList<String> actionIds = new ArrayList<String>();
        for (String actionId : bitwiseValues.keySet()) {
            long bitwiseValue = bitwiseValues.get(actionId);
            if ((actionIdsLong & bitwiseValue) != bitwiseValue) continue;
            actionIds.add(actionId);
        }
        return actionIds;
    }

    protected void migrateFile(long repositoryId, long companyId, String name, Image image) throws Exception {
        InputStream is = this._sourceHook.getImageAsStream(image);
        byte[] bytes = FileUtil.getBytes((InputStream)is);
        if (name == null) {
            name = String.valueOf(image.getImageId()) + "." + image.getType();
        }
        if (DLStoreUtil.hasFile((long)companyId, (long)repositoryId, (String)name)) {
            DLStoreUtil.deleteFile((long)companyId, (long)repositoryId, (String)name);
        }
        DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)name, (boolean)false, (byte[])bytes);
    }

    protected void migrateImage(long imageId) throws Exception {
        Image image = ImageLocalServiceUtil.getImage((long)imageId);
        try {
            this.migrateFile(0L, 0L, null, image);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Ignoring exception for image " + imageId), (Throwable)e2);
            }
            return;
        }
        this._sourceHook.deleteImage(image);
    }

    protected void migrateImage(long fileEntryId, long companyId, long groupId, long folderId, String name, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        Image thumbnailImage;
        long thumbnailImageId;
        Image largeImage;
        block19: {
            block17: {
                largeImage = null;
                if (largeImageId != 0L) {
                    largeImage = ImageLocalServiceUtil.getImage((long)largeImageId);
                    long repositoryId = DLFolderConstants.getDataRepositoryId((long)groupId, (long)folderId);
                    try {
                        this.migrateFile(repositoryId, companyId, name, largeImage);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block17;
                        _log.warn((Object)("Ignoring exception for image " + largeImageId), (Throwable)e2);
                    }
                }
            }
            thumbnailImageId = 0L;
            if (smallImageId != 0L) {
                thumbnailImageId = smallImageId;
            } else if (custom1ImageId != 0L) {
                thumbnailImageId = custom1ImageId;
            } else if (custom2ImageId != 0L) {
                thumbnailImageId = custom2ImageId;
            }
            thumbnailImage = null;
            if (thumbnailImageId != 0L) {
                thumbnailImage = ImageLocalServiceUtil.getImage((long)thumbnailImageId);
                Connection con = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    try {
                        InputStream is = this._sourceHook.getImageAsStream(thumbnailImage);
                        con = DataAccess.getUpgradeOptimizedConnection();
                        ps = con.prepareStatement("select max(fileVersionId) from DLFileVersion where fileEntryId = " + fileEntryId);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            long fileVersionId = rs.getLong(1);
                            ImageProcessorUtil.storeThumbnail((long)companyId, (long)groupId, (long)fileEntryId, (long)fileVersionId, (long)custom1ImageId, (long)custom2ImageId, (InputStream)is, (String)thumbnailImage.getType());
                        }
                    }
                    catch (Exception e3) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Ignoring exception for image " + thumbnailImageId), (Throwable)e3);
                        }
                        DataAccess.cleanUp((Connection)con, ps, rs);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp(con, ps, rs);
                    throw throwable;
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            }
        }
        if (largeImageId != 0L) {
            this._sourceHook.deleteImage(largeImage);
            this.runSQL("delete from Image where imageId = " + largeImageId);
        }
        if (largeImageId != thumbnailImageId && thumbnailImageId != 0L) {
            this._sourceHook.deleteImage(thumbnailImage);
            this.runSQL("delete from Image where imageId = " + thumbnailImageId);
        }
    }

    protected void migrateImageFiles() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select fileEntryId, companyId, groupId, folderId, ");
            sb.append("name, smallImageId, largeImageId, custom1ImageId, ");
            sb.append("custom2ImageId from DLFileEntry where ((smallImageId ");
            sb.append("is not null) and (smallImageId != 0)) or ");
            sb.append("((largeImageId is not null) and (largeImageId != 0)) ");
            sb.append("or ((custom1ImageId is not null) and (custom1ImageId ");
            sb.append("!= 0)) or ((custom2ImageId is not null) and ");
            sb.append("(custom2ImageId != 0))");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                long companyId = rs.getLong("companyId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long smallImageId = rs.getLong("smallImageId");
                long largeImageId = rs.getLong("largeImageId");
                long custom1ImageId = rs.getLong("custom1ImageId");
                long custom2ImageId = rs.getLong("custom2ImageId");
                this.migrateImage(fileEntryId, companyId, groupId, folderId, name, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        if (this._sourceHookClassName.equals(DLHook.class.getName())) {
            return;
        }
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select imageId from Image");
            rs = ps.executeQuery();
            while (rs.next()) {
                long imageId = rs.getLong("imageId");
                this.migrateImage(imageId);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        if (this._sourceHookClassName.equals(DatabaseHook.class.getName())) {
            this.runSQL("update Image set text_ = ''");
        }
    }

    protected void updateIGFolderEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from IGFolder order by folderId asc");
            rs = ps.executeQuery();
            HashMap<Long, Long> folderIds = new HashMap<Long, Long>();
            while (rs.next()) {
                boolean update;
                String uuid = rs.getString("uuid_");
                long folderId = rs.getLong("folderId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long parentFolderId = rs.getLong("parentFolderId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                if (folderIds.containsKey(parentFolderId)) {
                    parentFolderId = (Long)folderIds.get(parentFolderId);
                }
                if (update = this.updateIGImageFolderId(groupId, name, parentFolderId, folderId, folderIds)) continue;
                this.addDLFolderEntry(uuid, folderId, groupId, companyId, userId, userName, createDate, modifiedDate, groupId, parentFolderId, name, description, modifiedDate);
            }
            this.runSQL("drop table IGFolder");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateIGFolderPermissions() throws Exception {
        this.deleteConflictingIGPermissions(_IG_FOLDER_CLASS_NAME, DLFolder.class.getName());
        this.updateIGtoDLPermissions(_IG_FOLDER_CLASS_NAME, DLFolder.class.getName());
    }

    protected void updateIGImageEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryTypeId, companyId from DLFileEntryType where name = ?");
            ps.setString(1, "Image Gallery Image");
            rs = ps.executeQuery();
            boolean hasIGImageFileEntryType = false;
            while (rs.next()) {
                long fileEntryTypeId = rs.getLong("fileEntryTypeId");
                long companyId = rs.getLong("companyId");
                this.updateIGImageEntries(companyId, fileEntryTypeId);
                hasIGImageFileEntryType = true;
            }
            if (!hasIGImageFileEntryType) {
                this.updateIGImageEntries(0L, 0L);
            }
            this.runSQL("drop table IGImage");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateIGImageEntries(long companyId, long fileEntryTypeId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            String sql = "select * from IGImage";
            if (companyId != 0L) {
                sql = "select * from IGImage where companyId = ?";
            }
            ps = con.prepareStatement(sql);
            if (companyId != 0L) {
                ps.setLong(1, companyId);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("uuid_");
                long imageId = rs.getLong("imageId");
                long groupId = rs.getLong("groupId");
                companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long folderId = rs.getLong("folderId");
                String title = rs.getString("name");
                String description = rs.getString("description");
                long smallImageId = rs.getLong("smallImageId");
                long largeImageId = rs.getLong("largeImageId");
                long custom1ImageId = rs.getLong("custom1ImageId");
                long custom2ImageId = rs.getLong("custom2ImageId");
                Object[] image = this.getImage(largeImageId);
                if (image == null) continue;
                String extension = (String)image[0];
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                String name = String.valueOf(this.increment(DLFileEntry.class.getName()));
                long size = (Long)image[1];
                try {
                    this.addDLFileEntry(uuid, imageId, groupId, companyId, userId, userName, userId, userName, createDate, modifiedDate, groupId, folderId, name, extension, mimeType, title, description, "", fileEntryTypeId, "1.0", size, 0, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                }
                catch (Exception exception) {
                    title = title.concat(" ").concat(String.valueOf(imageId));
                    this.addDLFileEntry(uuid, imageId, groupId, companyId, userId, userName, userId, userName, createDate, modifiedDate, groupId, folderId, name, extension, mimeType, title, description, "", fileEntryTypeId, "1.0", size, 0, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                }
                this.addDLFileVersion(this.increment(), groupId, companyId, userId, userName, createDate, groupId, folderId, imageId, extension, mimeType, title, description, "", "", fileEntryTypeId, "1.0", size, 0, userId, userName, modifiedDate);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected boolean updateIGImageFolderId(long groupId, String name, long parentFolderId, long folderId, Map<Long, Long> folderIds) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select folderId from DLFolder where groupId = " + groupId + " and parentFolderId = " + parentFolderId + " and name = ?");
                ps.setString(1, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                long newFolderId = rs.getLong("folderId");
                this.runSQL("update IGImage set folderId = " + newFolderId + " where folderId = " + folderId);
                folderIds.put(folderId, newFolderId);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return true;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return false;
    }

    protected void updateIGImagePermissions() throws Exception {
        this.deleteConflictingIGPermissions(_IG_IMAGE_CLASS_NAME, DLFileEntry.class.getName());
        this.updateIGtoDLPermissions(_IG_IMAGE_CLASS_NAME, DLFileEntry.class.getName());
    }

    protected void updateIGtoDLPermissions(String igResourceName, String dlResourceName) throws Exception {
        Map<String, Long> igBitwiseValues = this.getBitwiseValues(igResourceName);
        if (igBitwiseValues.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Resource actions do not exist for " + igResourceName));
            }
            return;
        }
        Map<String, Long> dlBitwiseValues = this.getBitwiseValues(dlResourceName);
        if (dlBitwiseValues.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Resource actions do not exist for " + dlResourceName));
            }
            return;
        }
        int i2 = 0;
        while ((double)i2 < Math.pow(2.0, igBitwiseValues.size())) {
            List<String> igActionIds = this.getResourceActionIds(igBitwiseValues, i2);
            if (igResourceName.equals(_IG_FOLDER_CLASS_NAME)) {
                Collections.replaceAll(igActionIds, "ADD_IMAGE", "ADD_DOCUMENT");
            }
            long dlActionIdsLong = this.getBitwiseValue(dlBitwiseValues, igActionIds);
            this.runSQL("update ResourcePermission set name = '" + dlResourceName + "', actionIds = " + dlActionIdsLong + " where name = '" + igResourceName + "'" + " and actionIds = " + i2);
            ++i2;
        }
    }
}

