/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePortletId
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradePortletId.class);

    protected void doUpgrade() throws Exception {
        String[] uninstanceablePortletIds;
        String[][] renamePortletIdsArray;
        String[][] stringArray = renamePortletIdsArray = this.getRenamePortletIdsArray();
        int n = renamePortletIdsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] renamePortletIds = stringArray[n2];
            String oldRootPortletId = renamePortletIds[0];
            String newRootPortletId = renamePortletIds[1];
            this.updatePortlet(oldRootPortletId, newRootPortletId);
            this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            ++n2;
        }
        String[] stringArray2 = uninstanceablePortletIds = this.getUninstanceablePortletIds();
        int n3 = uninstanceablePortletIds.length;
        n = 0;
        while (n < n3) {
            String portletId = stringArray2[n];
            if (portletId.contains("_INSTANCE_")) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Portlet " + portletId + " is already instanceable"));
                }
            } else {
                String instanceId = LayoutTypePortletImpl.generateInstanceId();
                String newPortletId = PortletConstants.assemblePortletId((String)portletId, (String)instanceId);
                this.updateResourcePermission(portletId, newPortletId, false);
                this.updateInstanceablePortletPreferences(portletId, newPortletId);
                this.updateLayouts(portletId, newPortletId, true);
            }
            ++n;
        }
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, boolean exactMatch) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        int i2 = 1;
        while (i2 <= 10) {
            String column = "column-" + i2;
            if (typeSettingsProperties.containsKey((Object)column)) {
                Object[] portletIds = StringUtil.split((String)typeSettingsProperties.getProperty(column));
                int j = 0;
                while (j < portletIds.length) {
                    String portletId = portletIds[j];
                    if (exactMatch) {
                        if (portletId.equals(oldRootPortletId)) {
                            portletIds[j] = newRootPortletId;
                        }
                    } else {
                        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                        if (rootPortletId.equals(oldRootPortletId)) {
                            long userId = PortletConstants.getUserId((String)portletId);
                            String instanceId = PortletConstants.getInstanceId((String)portletId);
                            portletIds[j] = PortletConstants.assemblePortletId((String)newRootPortletId, (long)userId, (String)instanceId);
                        }
                    }
                    ++j;
                }
                typeSettingsProperties.setProperty(column, StringUtil.merge((Object[])portletIds).concat(","));
            }
            ++i2;
        }
        return typeSettingsProperties.toString();
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[][]{{"109", "1_WAR_webformportlet"}, {"google_adsense_portlet_WAR_googleadsenseportlet", "1_WAR_googleadsenseportlet"}, {"google_gadget_portlet_WAR_googlegadgetportlet", "1_WAR_googlegadgetportlet"}, {"google_maps_portlet_WAR_googlemapsportlet", "1_WAR_googlemapsportlet"}};
    }

    protected String[] getUninstanceablePortletIds() {
        return new String[0];
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select portletPreferencesId, portletId from ");
            sb.append("PortletPreferences where portletId = '");
            sb.append(oldRootPortletId);
            sb.append("' OR portletId like '");
            sb.append(oldRootPortletId);
            sb.append("_INSTANCE_%' OR portletId like '");
            sb.append(oldRootPortletId);
            sb.append("_USER_%_INSTANCE_%'");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                String portletId = rs.getString("portletId");
                String newPortletId = StringUtil.replace((String)portletId, (String)oldRootPortletId, (String)newRootPortletId);
                this.updatePortletPreference(portletPreferencesId, newPortletId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select typeSettings from Layout where plid = " + plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                this.updateLayout(plid, newTypeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateLayouts(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(14);
            sb.append("select plid, typeSettings from Layout where ");
            sb.append("typeSettings like '%=");
            sb.append(oldRootPortletId);
            sb.append(",%' OR typeSettings like '%,");
            sb.append(oldRootPortletId);
            sb.append(",%' OR typeSettings like '%=");
            sb.append(oldRootPortletId);
            sb.append("_INSTANCE_%' OR typeSettings like '%,");
            sb.append(oldRootPortletId);
            sb.append("_INSTANCE_%' OR typeSettings like '%=");
            sb.append(oldRootPortletId);
            sb.append("_USER_%' OR typeSettings like '%,");
            sb.append(oldRootPortletId);
            sb.append("_USER_%'");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch);
                this.updateLayout(plid, newTypeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update Portlet set portletId = '" + newRootPortletId + "' where portletId = '" + oldRootPortletId + "'");
        this.runSQL("update ResourceAction set name = '" + newRootPortletId + "' where name = '" + oldRootPortletId + "'");
        this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
        this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
    }

    protected void updatePortletPreference(long portletPreferencesId, String portletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update PortletPreferences set portletId = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, portletId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateResourcePermission(long resourcePermissionId, String name, String primKey) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update ResourcePermission set name = ?, primKey = ? where resourcePermissionId = " + resourcePermissionId);
            ps.setString(1, name);
            ps.setString(2, primKey);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select resourcePermissionId, name, scope, primKey from ResourcePermission where name = '" + oldRootPortletId + "'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePermissionId = rs.getLong("resourcePermissionId");
                String name = rs.getString("name");
                int scope = rs.getInt("scope");
                String primKey = rs.getString("primKey");
                String newName = name;
                if (updateName) {
                    newName = newRootPortletId;
                }
                if (scope == 4) {
                    int pos = primKey.indexOf("_LAYOUT_");
                    long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
                    String portletId = primKey.substring(pos + "_LAYOUT_".length());
                    String instanceId = PortletConstants.getInstanceId((String)portletId);
                    long userId = PortletConstants.getUserId((String)portletId);
                    String newPortletId = PortletConstants.assemblePortletId((String)newRootPortletId, (long)userId, (String)instanceId);
                    primKey = PortletPermissionUtil.getPrimaryKey((long)plid, (String)newPortletId);
                }
                this.updateResourcePermission(resourcePermissionId, newName, primKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

