/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.util.PropsValues;

public class UpgradeProcessUtil {
    private static Log _log = LogFactoryUtil.getLog(UpgradeProcessUtil.class);
    private static boolean _createIGImageDocumentType = false;

    public static boolean isCreateIGImageDocumentType() {
        return _createIGImageDocumentType;
    }

    public static void setCreateIGImageDocumentType(boolean createIGImageDocumentType) {
        _createIGImageDocumentType = createIGImageDocumentType;
    }

    public static boolean upgradeProcess(int buildNumber, String[] upgradeProcessClassNames, ClassLoader classLoader) throws UpgradeException {
        return UpgradeProcessUtil.upgradeProcess(buildNumber, upgradeProcessClassNames, classLoader, PropsValues.INDEX_ON_UPGRADE);
    }

    public static boolean upgradeProcess(int buildNumber, String[] upgradeProcessClassNames, ClassLoader classLoader, boolean indexOnUpgrade) throws UpgradeException {
        boolean ranUpgradeProcess = false;
        boolean tempIndexReadOnly = SearchEngineUtil.isIndexReadOnly();
        if (indexOnUpgrade) {
            SearchEngineUtil.setIndexReadOnly((boolean)true);
        }
        try {
            String[] stringArray = upgradeProcessClassNames;
            int n = upgradeProcessClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String upgradeProcessClassName = stringArray[n2];
                boolean tempRanUpgradeProcess = UpgradeProcessUtil._upgradeProcess(buildNumber, upgradeProcessClassName, classLoader);
                if (tempRanUpgradeProcess) {
                    ranUpgradeProcess = true;
                }
                ++n2;
            }
        }
        finally {
            SearchEngineUtil.setIndexReadOnly((boolean)tempIndexReadOnly);
        }
        return ranUpgradeProcess;
    }

    private static boolean _upgradeProcess(int buildNumber, String upgradeProcessClassName, ClassLoader classLoader) throws UpgradeException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing upgrade " + upgradeProcessClassName));
        }
        UpgradeProcess upgradeProcess = null;
        try {
            upgradeProcess = (UpgradeProcess)classLoader.loadClass(upgradeProcessClassName).newInstance();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (upgradeProcess == null) {
            _log.error((Object)(String.valueOf(upgradeProcessClassName) + " cannot be found"));
            return false;
        }
        if (upgradeProcess.getThreshold() == 0 || upgradeProcess.getThreshold() > buildNumber) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running upgrade " + upgradeProcessClassName));
            }
            upgradeProcess.upgrade();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished upgrade " + upgradeProcessClassName));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrade threshold " + upgradeProcess.getThreshold() + " will not trigger upgrade"));
            _log.debug((Object)("Skipping upgrade " + upgradeProcessClassName));
        }
        return false;
    }
}

