/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ComparableRoute;
import com.liferay.portal.tools.sourceformatter.JavaTerm;
import com.liferay.portal.tools.sourceformatter.JavaTermComparator;
import com.liferay.portal.tools.sourceformatter.SourceFormatterHelper;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.ContentUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class SourceFormatter {
    public static final int _TYPE_CLASS_PRIVATE = 24;
    public static final int _TYPE_CLASS_PRIVATE_STATIC = 23;
    public static final int _TYPE_CLASS_PROTECTED = 16;
    public static final int _TYPE_CLASS_PROTECTED_STATIC = 15;
    public static final int _TYPE_CLASS_PUBLIC = 8;
    public static final int _TYPE_CLASS_PUBLIC_STATIC = 7;
    public static final int[] _TYPE_CONSTRUCTOR = new int[]{18, 10, 4};
    public static final int _TYPE_CONSTRUCTOR_PRIVATE = 18;
    public static final int _TYPE_CONSTRUCTOR_PROTECTED = 10;
    public static final int _TYPE_CONSTRUCTOR_PUBLIC = 4;
    public static final int[] _TYPE_METHOD = new int[]{19, 17, 11, 9, 5, 3};
    public static final int _TYPE_METHOD_PRIVATE = 19;
    public static final int _TYPE_METHOD_PRIVATE_STATIC = 17;
    public static final int _TYPE_METHOD_PROTECTED = 11;
    public static final int _TYPE_METHOD_PROTECTED_STATIC = 9;
    public static final int _TYPE_METHOD_PUBLIC = 5;
    public static final int _TYPE_METHOD_PUBLIC_STATIC = 3;
    public static final int[] _TYPE_VARIABLE = new int[]{22, 21, 20, 14, 13, 12, 6, 2, 1};
    public static final int _TYPE_VARIABLE_PRIVATE = 22;
    public static final int _TYPE_VARIABLE_PRIVATE_STATIC = 21;
    public static final int _TYPE_VARIABLE_PRIVATE_STATIC_FINAL = 20;
    public static final int _TYPE_VARIABLE_PROTECTED = 14;
    public static final int _TYPE_VARIABLE_PROTECTED_STATIC = 13;
    public static final int _TYPE_VARIABLE_PROTECTED_STATIC_FINAL = 12;
    public static final int _TYPE_VARIABLE_PUBLIC = 6;
    public static final int _TYPE_VARIABLE_PUBLIC_STATIC = 2;
    public static final int _TYPE_VARIABLE_PUBLIC_STATIC_FINAL = 1;
    private static final String[] _TAG_LIBRARIES = new String[]{"aui", "c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private static boolean _checkUnprocessedExceptions;
    private static List<String> _errorMessages;
    private static String[] _excludes;
    private static FileImpl _fileUtil;
    private static Pattern _javaImportPattern;
    private static Properties _javaTermSortExclusions;
    private static Pattern _jspAttributeNamePattern;
    private static Map<String, String> _jspContents;
    private static Pattern _jspImportPattern;
    private static Pattern _jspIncludeFilePattern;
    private static Pattern _languageKeyPattern;
    private static Properties _lineLengthExclusions;
    private static Properties _portalLanguageKeysProperties;
    private static boolean _portalSource;
    private static SAXReaderImpl _saxReaderUtil;
    private static Pattern _sessionKeyPattern;
    private static SourceFormatterHelper _sourceFormatterHelper;
    private static Pattern _taglibLanguageKeyPattern;
    private static Pattern _taglibSessionKeyPattern;
    private static boolean _throwException;
    private static Pattern _xssPattern;

    static {
        _errorMessages = new ArrayList<String>();
        _fileUtil = FileImpl.getInstance();
        _javaImportPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
        _jspAttributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
        _jspContents = new HashMap<String, String>();
        _jspImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
        _jspIncludeFilePattern = Pattern.compile("/.*[.]jsp[f]?");
        _languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
        _saxReaderUtil = SAXReaderImpl.getInstance();
        _sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|".concat("SessionMessages.(?:add|contains|get)\\([^;%&|!]+"), 8);
        _taglibLanguageKeyPattern = Pattern.compile("(?:confirmation|label|(?:M|m)essage|message key|names|title)=\"[^A-Z<=%\\[\\s]+\"");
        _taglibSessionKeyPattern = Pattern.compile("<liferay-ui:error [^>]+>|<liferay-ui:success [^>]+>", 8);
        _xssPattern = Pattern.compile("\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");
    }

    public static void main(String[] args) {
        try {
            new SourceFormatter(false, false);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        Matcher matcher = _javaImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String importClass;
            int importY;
            int importX;
            String importPackage;
            if (!line.contains("import ") || (importPackage = line.substring((importX = line.indexOf(" ")) + 1, importY = line.lastIndexOf("."))).equals(packageDir) || importPackage.equals("java.lang") || !(importClass = line.substring(importY + 1, line.length() - 1)).equals("*") && !classes.contains(importClass)) continue;
            sb.append(line);
            sb.append("\n");
        }
        imports = SourceFormatter._formatImports(sb.toString(), 7);
        content = String.valueOf(content.substring(0, matcher.start())) + imports + content.substring(matcher.end());
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    public SourceFormatter(boolean useProperties, boolean throwException) throws Exception {
        _checkUnprocessedExceptions = GetterUtil.getBoolean((String)System.getProperty("source.formatter.check.unprocessed.exceptions"));
        _excludes = StringUtil.split((String)GetterUtil.getString((String)System.getProperty("source.formatter.excludes")));
        _portalSource = SourceFormatter._isPortalSource();
        _throwException = throwException;
        _sourceFormatterHelper = new SourceFormatterHelper(useProperties);
        _sourceFormatterHelper.init();
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    SourceFormatter._formatJSP();
                    SourceFormatter._formatAntXML();
                    SourceFormatter._formatDDLStructuresXML();
                    SourceFormatter._formatFriendlyURLRoutesXML();
                    SourceFormatter._formatFTL();
                    SourceFormatter._formatJS();
                    SourceFormatter._formatPortalProperties();
                    SourceFormatter._formatPortletXML();
                    SourceFormatter._formatServiceXML();
                    SourceFormatter._formatSH();
                    SourceFormatter._formatSQL();
                    SourceFormatter._formatStrutsConfigXML();
                    SourceFormatter._formatTilesDefsXML();
                    SourceFormatter._formatTLD();
                    SourceFormatter._formatWebXML();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    SourceFormatter._formatJava();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        _sourceFormatterHelper.close();
        if (_throwException && !_errorMessages.isEmpty()) {
            throw new Exception(StringUtil.merge(_errorMessages, (String)"\n"));
        }
    }

    private static void _addJSPIncludeFileNames(String fileName, Set<String> includeFileNames) {
        int y;
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf("\"", x)) != -1 && (y = content.indexOf("\"", x + 1)) != -1) {
            String includeFileName = content.substring(x + 1, y);
            Matcher matcher = _jspIncludeFilePattern.matcher(includeFileName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
            includeFileName = String.valueOf(docrootPath) + includeFileName;
            if (!(!includeFileName.endsWith("jsp") && !includeFileName.endsWith("jspf") || includeFileName.endsWith("html/portlet/init.jsp") || includeFileName.endsWith("html/taglib/init.jsp") || includeFileNames.contains(includeFileName))) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
    }

    private static void _addJSPReferenceFileNames(String fileName, Set<String> includeFileNames) {
        for (Map.Entry<String, String> entry : _jspContents.entrySet()) {
            String referenceFileName = entry.getKey();
            String content = entry.getValue();
            if (!content.contains("<%@ include file=\"" + fileName) || includeFileNames.contains(referenceFileName)) continue;
            includeFileNames.add(referenceFileName);
        }
    }

    private static void _addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        for (String importLine : importLines) {
            HashSet<String> includeFileNames = new HashSet<String>();
            includeFileNames.add(fileName);
            HashSet<String> checkedFileNames = new HashSet<String>();
            int x = importLine.indexOf("\"");
            int y = importLine.indexOf("\"", x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            if (SourceFormatter._isJSPImportRequired(fileName, className = className.substring(className.lastIndexOf(".") + 1), includeFileNames, checkedFileNames)) continue;
            unneededImports.add(importLine);
        }
    }

    private static List<String> _addParameterTypes(String line, List<String> parameterTypes) {
        int x = line.indexOf("(");
        if (x != -1 && (Validator.isNull((String)(line = line.substring(x + 1))) || line.startsWith(")"))) {
            return parameterTypes;
        }
        x = 0;
        while ((x = line.indexOf(" ")) != -1) {
            String parameterType = line.substring(0, x);
            if (parameterType.equals("throws")) {
                return parameterTypes;
            }
            parameterTypes.add(parameterType);
            int y = line.indexOf(",");
            int z = line.indexOf(")");
            if (y == -1 || z != -1 && z < y) {
                return parameterTypes;
            }
            line = line.substring(y + 1);
            line = line.trim();
        }
        return parameterTypes;
    }

    private static String _checkIfClause(String ifClause, String fileName, int lineCount) throws IOException {
        String ifClauseSingleLine = StringUtil.replace((String)ifClause, (String[])new String[]{"\t ", "\t", "(\n", "\n"}, (String[])new String[]{"\t", "", "(", " "});
        SourceFormatter._checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return SourceFormatter._checkIfClauseTabsAndSpaces(ifClause);
    }

    private static void _checkIfClauseParentheses(String ifClause, String fileName, int lineCount) {
        int quoteCount = StringUtil.count((String)ifClause, (String)"\"");
        if (quoteCount % 2 == 1) {
            return;
        }
        ifClause = SourceFormatter._stripQuotes(ifClause, "\"");
        if ((ifClause = SourceFormatter._stripQuotes(ifClause, "'")).contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        ifClause = SourceFormatter._stripRedundantParentheses(ifClause);
        int level = 0;
        int max = StringUtil.count((String)ifClause, (String)"(");
        int previousParenthesisPos = -1;
        int[] levels = new int[max];
        int i2 = 0;
        while (i2 < ifClause.length()) {
            char c2 = ifClause.charAt(i2);
            if (c2 == '(' || c2 == ')') {
                String s;
                if (previousParenthesisPos != -1 && SourceFormatter._hasMissingParentheses(s = ifClause.substring(previousParenthesisPos + 1, i2))) {
                    SourceFormatter._processErrorMessage(fileName, "missing parentheses: " + fileName + " " + lineCount);
                }
                previousParenthesisPos = i2;
                if (c2 == '(') {
                    levels[level] = i2;
                    ++level;
                } else {
                    int posOpenParenthesis = levels[level - 1];
                    if (level > 1) {
                        String s2;
                        char nextChar = ifClause.charAt(i2 + 1);
                        char previousChar = ifClause.charAt(posOpenParenthesis - 1);
                        if (!Character.isLetterOrDigit(nextChar) && nextChar != '.' && !Character.isLetterOrDigit(previousChar) && SourceFormatter._hasRedundantParentheses(s2 = ifClause.substring(posOpenParenthesis + 1, i2))) {
                            SourceFormatter._processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                        if (previousChar == '(' && nextChar == ')') {
                            SourceFormatter._processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                    }
                    --level;
                }
            }
            ++i2;
        }
    }

    private static String _checkIfClauseTabsAndSpaces(String ifClause) throws IOException {
        if (ifClause.contains("!(") || ifClause.contains("\t//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLeadingWhiteSpace = 0;
        int lastCriteriumLineLeadingWhiteSpace = 0;
        int closeParenthesesCount = 0;
        int openParenthesesCount = 0;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int expectedLeadingWhiteSpace;
            String originalLine = line;
            line = StringUtil.replace((String)line, (String)"\t", (String)"    ");
            int leadingWhiteSpace = line.length() - StringUtil.trimLeading((String)line).length();
            if (Validator.isNull(previousLine)) {
                lastCriteriumLineLeadingWhiteSpace = line.indexOf("(");
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                expectedLeadingWhiteSpace = lastCriteriumLineLeadingWhiteSpace + openParenthesesCount - closeParenthesesCount;
                if (leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return SourceFormatter._fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
                lastCriteriumLineLeadingWhiteSpace = leadingWhiteSpace;
                closeParenthesesCount = 0;
                openParenthesesCount = 0;
            } else {
                expectedLeadingWhiteSpace = 0;
                if (previousLine.contains("\tif (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 8;
                } else if (previousLine.contains("\telse if (") || previousLine.contains("\twhile (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 12;
                }
                if (expectedLeadingWhiteSpace != 0 && leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return SourceFormatter._fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            line = SourceFormatter._stripQuotes(line, "\"");
            line = SourceFormatter._stripQuotes(line, "'");
            closeParenthesesCount += StringUtil.count((String)line, (String)")");
            openParenthesesCount += StringUtil.count((String)line, (String)"(");
            previousLine = originalLine;
            previousLineLeadingWhiteSpace = leadingWhiteSpace;
        }
        return ifClause;
    }

    private static void _checkLanguageKeys(String fileName, String content, Pattern pattern) throws IOException {
        String fileExtension = _fileUtil.getExtension(fileName);
        if (!_portalSource || fileExtension.equals("vm")) {
            return;
        }
        if (_portalLanguageKeysProperties == null) {
            _portalLanguageKeysProperties = new Properties();
            ClassLoader classLoader = SourceFormatter.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            _portalLanguageKeysProperties.load(inputStream);
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            String[] stringArray = languageKeys = SourceFormatter._getLanguageKeys(matcher);
            int n = languageKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String languageKey = stringArray[n2];
                if (!(Validator.isNumber((String)languageKey) || languageKey.endsWith("-") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || _portalLanguageKeysProperties.containsKey(languageKey))) {
                    SourceFormatter._processErrorMessage(fileName, "missing language key: " + languageKey + " " + fileName);
                }
                ++n2;
            }
        }
    }

    private static boolean _checkTaglibVulnerability(String jspContent, String vulnerability) {
        int pos1 = -1;
        do {
            if ((pos1 = jspContent.indexOf(vulnerability, pos1 + 1)) == -1) continue;
            int pos2 = jspContent.lastIndexOf(60, pos1);
            while (pos2 > 0 && jspContent.charAt(pos2 + 1) == '%') {
                pos2 = jspContent.lastIndexOf(60, pos2 - 1);
            }
            String tagContent = jspContent.substring(pos2, pos1);
            if (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:")) continue;
            return true;
        } while (pos1 != -1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void _checkUnprocessedExceptions(String content, File file, String packagePath, String fileName) throws IOException {
        List<String> importedExceptionClassNames = null;
        JavaDocBuilder javaDocBuilder = null;
        Pattern catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((.+Exception) (.+)\\) \\{\n");
        int lineCount = 1;
        Matcher catchExceptionMatcher;
        while ((catchExceptionMatcher = catchExceptionPattern.matcher(content)).find()) {
            void var18_18;
            String packageName;
            String beforeCatchCode = content.substring(0, catchExceptionMatcher.start());
            lineCount = lineCount + StringUtil.count((String)beforeCatchCode, (String)"\n") + 1;
            String exceptionClassName = catchExceptionMatcher.group(2);
            String exceptionVariableName = catchExceptionMatcher.group(3);
            String tabs = catchExceptionMatcher.group(1);
            int pos = content.indexOf("\n" + tabs + "}", catchExceptionMatcher.end() - 1);
            String insideCatchCode = content.substring(catchExceptionMatcher.end(), pos + 1);
            Pattern exceptionVariablePattern = Pattern.compile("\\W" + exceptionVariableName + "\\W");
            Matcher exceptionVariableMatcher = exceptionVariablePattern.matcher(insideCatchCode);
            if (exceptionVariableMatcher.find()) {
                content = content.substring(catchExceptionMatcher.start() + 1);
                continue;
            }
            if (javaDocBuilder == null) {
                javaDocBuilder = new JavaDocBuilder();
                javaDocBuilder.addSource(file);
            }
            if (importedExceptionClassNames == null) {
                importedExceptionClassNames = SourceFormatter._getImportedExceptionClassNames(javaDocBuilder);
            }
            String originalExceptionClassName = exceptionClassName;
            if (!exceptionClassName.contains(".")) {
                for (String string : importedExceptionClassNames) {
                    if (!string.endsWith("." + exceptionClassName)) continue;
                    exceptionClassName = string;
                    break;
                }
            }
            if (!exceptionClassName.contains(".")) {
                exceptionClassName = String.valueOf(packagePath) + "." + exceptionClassName;
            }
            JavaClass javaClass = javaDocBuilder.getClassByName(exceptionClassName);
            while ((packageName = var18_18.getPackageName()).contains("com.liferay")) {
                exceptionClassName = var18_18.getName();
                if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                    SourceFormatter._processErrorMessage(fileName, "Unprocessed " + originalExceptionClassName + ": " + fileName + " " + lineCount);
                    break;
                }
                JavaClass exceptionSuperClass = var18_18.getSuperJavaClass();
                if (exceptionSuperClass == null) break;
                JavaClass javaClass2 = exceptionSuperClass;
            }
            content = content.substring(catchExceptionMatcher.start() + 1);
        }
        return;
    }

    private static void _checkXSS(String fileName, String jspContent) {
        Matcher matcher = _xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String inputVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            if (SourceFormatter._checkTaglibVulnerability(jspContent, anchorVulnerability)) {
                xssVulnerable = true;
            }
            if (SourceFormatter._checkTaglibVulnerability(jspContent, inputVulnerability = " value=\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(documentIdVulnerability = ".<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            SourceFormatter._processErrorMessage(fileName, "(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    private static String _fixAntXMLProjectName(String basedir, String fileName, String content) {
        int x = 0;
        if (fileName.endsWith("-ext/build.xml")) {
            x = fileName.indexOf("ext/");
            x = x == -1 ? 0 : (x += 4);
        } else if (fileName.endsWith("-hook/build.xml")) {
            x = fileName.indexOf("hooks/");
            x = x == -1 ? 0 : (x += 6);
        } else if (fileName.endsWith("-layouttpl/build.xml")) {
            x = fileName.indexOf("layouttpl/");
            x = x == -1 ? 0 : (x += 10);
        } else if (fileName.endsWith("-portlet/build.xml")) {
            x = fileName.indexOf("portlets/");
            x = x == -1 ? 0 : (x += 9);
        } else if (fileName.endsWith("-theme/build.xml")) {
            x = fileName.indexOf("themes/");
            x = x == -1 ? 0 : (x += 7);
        } else if (fileName.endsWith("-web/build.xml") && !fileName.endsWith("/ext-web/build.xml")) {
            x = fileName.indexOf("webs/");
            x = x == -1 ? 0 : (x += 5);
        } else {
            return content;
        }
        int y = fileName.indexOf("/", x);
        String correctProjectElementText = "<project name=\"" + fileName.substring(x, y) + "\"";
        if (!content.contains(correctProjectElementText)) {
            x = content.indexOf("<project name=\"");
            y = content.indexOf("\"", x) + 1;
            y = content.indexOf("\"", y) + 1;
            content = String.valueOf(content.substring(0, x)) + correctProjectElementText + content.substring(y);
            SourceFormatter._processErrorMessage(fileName, String.valueOf(fileName) + " has an incorrect project name");
        }
        return content;
    }

    private static String _fixCopyright(String content, String copyright, String oldCopyright, File file, String fileName) throws IOException {
        int x;
        if (fileName.endsWith(".vm")) {
            return content;
        }
        if (oldCopyright != null && content.contains(oldCopyright)) {
            content = StringUtil.replace((String)content, (String)oldCopyright, (String)copyright);
            SourceFormatter._processErrorMessage(fileName, "old (c): " + fileName);
        }
        if (!content.contains(copyright)) {
            String customCopyright = SourceFormatter._getCustomCopyright(file);
            if (Validator.isNotNull((String)customCopyright)) {
                copyright = customCopyright;
            }
            if (!content.contains(copyright)) {
                SourceFormatter._processErrorMessage(fileName, "(c): " + fileName);
            }
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
            content = StringUtil.replace((String)content, (String)("<%\n" + copyright + "\n%>"), (String)("<%--\n" + copyright + "\n--%>"));
        }
        if ((x = content.indexOf("* Copyright (c) 2000-20")) == -1) {
            return content;
        }
        int y = copyright.indexOf("* Copyright (c) 2000-20");
        if (y == -1) {
            return content;
        }
        String contentCopyrightYear = content.substring(x, x + 25);
        String copyrightYear = copyright.substring(y, y + 25);
        return StringUtil.replace((String)content, (String)contentCopyrightYear, (String)copyrightYear);
    }

    private static String _fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace((String)content, (String)"DataAccess.getConnection", (String)"DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    private static String _fixIfClause(String ifClause, String line, int delta) {
        String newLine = line;
        String whiteSpace = "";
        int whiteSpaceLength = Math.abs(delta);
        while (whiteSpaceLength > 0) {
            if (whiteSpaceLength >= 4) {
                whiteSpace = String.valueOf(whiteSpace) + "\t";
                whiteSpaceLength -= 4;
                continue;
            }
            whiteSpace = String.valueOf(whiteSpace) + " ";
            --whiteSpaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whiteSpace)) {
                newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)"    ");
            }
            newLine = StringUtil.replaceLast((String)newLine, (String)("\t" + whiteSpace), (String)"\t");
        } else {
            newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)("\t" + whiteSpace));
        }
        return StringUtil.replace((String)ifClause, (String)line, (String)newLine);
    }

    private static String _fixJavaTermsDivider(String content, JavaTerm previousJavaTerm, JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.startsWith("\t//") || javaTermContent.contains("\tstatic {")) {
            return content;
        }
        String previousJavaTermContent = previousJavaTerm.getContent();
        if (previousJavaTermContent.startsWith("\t//") || previousJavaTermContent.contains("\tstatic {")) {
            return content;
        }
        String javaTermName = javaTerm.getName();
        String previousJavaTermName = previousJavaTerm.getName();
        boolean requiresEmptyLine = false;
        if (previousJavaTerm.getType() != javaTerm.getType()) {
            requiresEmptyLine = true;
        } else if (!SourceFormatter._isInJavaTermTypeGroup(javaTerm.getType(), _TYPE_VARIABLE)) {
            requiresEmptyLine = true;
        } else if (previousJavaTermName.equals(previousJavaTermName.toUpperCase()) || javaTermName.equals(javaTermName.toUpperCase())) {
            requiresEmptyLine = true;
        } else if (SourceFormatter._hasAnnotationCommentOrJavadoc(javaTermContent) || SourceFormatter._hasAnnotationCommentOrJavadoc(previousJavaTermContent)) {
            requiresEmptyLine = true;
        } else if (previousJavaTerm.getType() == 21 && (previousJavaTermName.equals("_log") || previousJavaTermName.equals("_instance"))) {
            requiresEmptyLine = true;
        } else if (previousJavaTermContent.contains("\n\n\t") || javaTermContent.contains("\n\n\t")) {
            requiresEmptyLine = true;
        }
        if (requiresEmptyLine) {
            if (!content.contains("\n\n" + javaTermContent)) {
                return StringUtil.replace((String)content, (String)("\n" + javaTermContent), (String)("\n\n" + javaTermContent));
            }
        } else if (content.contains("\n\n" + javaTermContent)) {
            return StringUtil.replace((String)content, (String)("\n\n" + javaTermContent), (String)("\n" + javaTermContent));
        }
        return content;
    }

    private static String _fixSessionKey(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            if (pattern.equals(_sessionKeyPattern)) {
                s = ",";
            } else if (pattern.equals(_taglibSessionKeyPattern)) {
                s = "key=";
            }
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = match.substring(x += s.length()).trim();
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            boolean alphaNumericKey = true;
            char[] cArray = oldKey.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c2 = cArray[n2];
                if (!Validator.isChar((char)c2) && !Validator.isDigit((char)c2) && c2 != '-' && c2 != '_') {
                    alphaNumericKey = false;
                }
                ++n2;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format((String)oldKey, (int)14);
            if ((newKey = TextFormatter.format((String)newKey, (int)12)).equals(oldKey)) continue;
            String oldSub = prefix.concat(oldKey).concat(suffix);
            String newSub = prefix.concat(newKey).concat(suffix);
            newContent = StringUtil.replaceFirst((String)newContent, (String)oldSub, (String)newSub);
        } while (matcher.find());
        return newContent;
    }

    private static void _formatAntXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\tools\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\b*.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, true);
            newContent = SourceFormatter._fixAntXMLProjectName(basedir, fileName, newContent);
            Document document = _saxReaderUtil.read(newContent);
            Element rootElement = document.getRootElement();
            String previousName = "";
            List targetElements = rootElement.elements("target");
            for (Element targetElement : targetElements) {
                String name = targetElement.attributeValue("name");
                if (name.equals("Test")) {
                    name = name.toLowerCase();
                }
                if (name.compareTo(previousName) < -1) {
                    SourceFormatter._processErrorMessage(fileName, String.valueOf(fileName) + " has an unordered target " + name);
                    break;
                }
                previousName = name;
            }
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static void _formatDDLStructuresXML() throws DocumentException, IOException {
        String basedir = "./portal-impl/src/com/liferay/portal/events/dependencies/";
        if (!_fileUtil.exists(basedir)) {
            return;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(_excludes);
        directoryScanner.setIncludes(new String[]{"**\\*structures.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            newContent = SourceFormatter._formatDDLStructuresXML(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatDDLStructuresXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        rootElement.sortElementsByChildElement("structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            structureRootElement.sortElementsByAttribute("dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                metaDataElement.sortElementsByAttribute("entry", "name");
            }
        }
        return document.formattedString();
    }

    private static void _formatFriendlyURLRoutesXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\classes\\**", "**\\bin\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*routes.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            if (content.contains("<!-- SourceFormatter.Ignore -->")) continue;
            String newContent = SourceFormatter._trimContent(content, false);
            newContent = SourceFormatter._formatFriendlyURLRoutesXML(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatFriendlyURLRoutesXML(String content) throws DocumentException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<ComparableRoute> comparableRoutes = new ArrayList<ComparableRoute>();
        for (Element routeElement : rootElement.elements("route")) {
            Object value;
            String pattern = routeElement.elementText("pattern");
            ComparableRoute comparableRoute = new ComparableRoute(pattern);
            for (Element element : routeElement.elements("generated-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addGeneratedParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("ignored-parameter")) {
                String string = element.attributeValue("name");
                comparableRoute.addIgnoredParameter(string);
            }
            for (Element element : routeElement.elements("implicit-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addImplicitParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("overridden-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addOverriddenParameter(string, (String)value);
            }
            comparableRoutes.add(comparableRoute);
        }
        Collections.sort(comparableRoutes);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes 6.2.0//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_6_2_0.dtd\">\n\n<routes>\n");
        for (ComparableRoute comparableRoute : comparableRoutes) {
            sb.append("\t<route>\n");
            sb.append("\t\t<pattern>");
            sb.append(comparableRoute.getPattern());
            sb.append("</pattern>\n");
            Map<String, String> generatedParameters = comparableRoute.getGeneratedParameters();
            for (Map.Entry entry : generatedParameters.entrySet()) {
                sb.append("\t\t<generated-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</generated-parameter>\n");
            }
            Set<String> set = comparableRoute.getIgnoredParameters();
            for (String entry : set) {
                sb.append("\t\t<ignored-parameter name=\"");
                sb.append(entry);
                sb.append("\" />\n");
            }
            Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
            for (Map.Entry entry : implicitParameters.entrySet()) {
                sb.append("\t\t<implicit-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</implicit-parameter>\n");
            }
            Map<String, String> map = comparableRoute.getOverriddenParameters();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append("\t\t<overridden-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</overridden-parameter>\n");
            }
            sb.append("\t</route>\n");
        }
        sb.append("</routes>");
        return sb.toString();
    }

    private static void _formatFTL() throws IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\journal\\dependencies\\template.ftl", "**\\servicebuilder\\dependencies\\props.ftl"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.ftl"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatImports(String imports, int classStartPos) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("//")) {
            return String.valueOf(imports) + "\n";
        }
        List<String> importsList = new ArrayList();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=") && !line.contains("import ") || importsList.contains(line)) continue;
            importsList.add(line);
        }
        importsList = ListUtil.sort(importsList);
        StringBundler sb = new StringBundler();
        String temp = null;
        int i2 = 0;
        while (i2 < importsList.size()) {
            String s = (String)importsList.get(i2);
            int pos = s.indexOf(".");
            if ((pos = s.indexOf(".", pos + 1)) == -1) {
                pos = s.indexOf(".");
            }
            String packageLevel = s.substring(classStartPos, pos);
            if (i2 != 0 && !packageLevel.equals(temp)) {
                sb.append("\n");
            }
            temp = packageLevel;
            sb.append(s);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    private static void _formatJava() throws IOException {
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        boolean portalJavaFiles = true;
        Collection<String> fileNames = null;
        Properties staticLogVariableExclusions = null;
        Properties upgradeServiceUtilExclusions = null;
        if (_portalSource) {
            fileNames = SourceFormatter._getPortalJavaFiles();
            _javaTermSortExclusions = SourceFormatter._getPortalExclusionsProperties("source_formatter_javaterm_sort_exclusions.properties");
            _lineLengthExclusions = SourceFormatter._getPortalExclusionsProperties("source_formatter_line_length_exclusions.properties");
            staticLogVariableExclusions = SourceFormatter._getPortalExclusionsProperties("source_formatter_static_log_exclusions.properties");
            upgradeServiceUtilExclusions = SourceFormatter._getPortalExclusionsProperties("source_formatter_upgrade_service_util_exclusions.properties");
        } else {
            portalJavaFiles = false;
            fileNames = SourceFormatter._getPluginJavaFiles();
            _javaTermSortExclusions = SourceFormatter._getPluginExclusionsProperties("source_formatter_javaterm_sort_exclusions.properties");
            _lineLengthExclusions = SourceFormatter._getPluginExclusionsProperties("source_formatter_line_length_exclusions.properties");
            staticLogVariableExclusions = SourceFormatter._getPluginExclusionsProperties("source_formatter_static_log_exclusions.properties");
        }
        for (String fileName : fileNames) {
            String logClassName;
            Matcher matcher;
            int packagePathY;
            File file = new File(fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            if (SourceFormatter._isGenerated(content) && !fileName.endsWith("JavadocFormatter.java")) continue;
            String className = file.getName();
            className = className.substring(0, className.length() - 5);
            String packagePath = fileName;
            int packagePathX = packagePath.indexOf("/src/");
            packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf("/")) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
            if ((packagePath = StringUtil.replace((String)packagePath, (String)"/", (String)".")).endsWith(".model") && content.contains("extends " + className + "Model")) continue;
            String newContent = content;
            if (newContent.contains("$\n */")) {
                SourceFormatter._processErrorMessage(fileName, "*: " + fileName);
                newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
            }
            if ((newContent = SourceFormatter._fixCopyright(newContent, copyright, oldCopyright, file, fileName)).contains(String.valueOf(className) + ".java.html")) {
                SourceFormatter._processErrorMessage(fileName, "Java2HTML: " + fileName);
            }
            if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
                newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
                SourceFormatter._processErrorMessage(fileName, "UTF-8: " + fileName);
            }
            newContent = SourceFormatter._fixDataAccessConnection(className, newContent);
            newContent = SourceFormatter._fixSessionKey(fileName, newContent, _sessionKeyPattern);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil", "private static final Log _log"}, (String[])new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil", "private static Log _log"});
            newContent = SourceFormatter.stripJavaImports(newContent, packagePath, className);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{";\n/**", "\t/*\n\t *", "catch(", "else{", "if(", "for(", "while(", "List <", "){\n", "]{\n"}, (String[])new String[]{";\n\n/**", "\t/**\n\t *", "catch (", "else {", "if (", "for (", "while (", "List<", ") {\n", "] {\n"});
            Pattern pattern = Pattern.compile("\t(catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
            while ((matcher = pattern.matcher(newContent)).find()) {
                String match = matcher.group();
                String replacement = StringUtil.replaceFirst((String)match, (String)"\n", (String)"");
                newContent = StringUtil.replaceFirst((String)newContent, (String)match, (String)replacement);
            }
            pattern = Pattern.compile("Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");
            matcher = pattern.matcher(newContent);
            if (matcher.find() && !(logClassName = matcher.group(1)).equals(className)) {
                newContent = StringUtil.replaceLast((String)newContent, (String)(String.valueOf(logClassName) + ".class)"), (String)(String.valueOf(className) + ".class)"));
            }
            String excluded = null;
            if (staticLogVariableExclusions != null) {
                excluded = staticLogVariableExclusions.getProperty(fileName);
            }
            if (excluded == null) {
                newContent = StringUtil.replace((String)newContent, (String)"private Log _log", (String)"private static Log _log");
            }
            if (newContent.contains("*/\npackage ")) {
                SourceFormatter._processErrorMessage(fileName, "package: " + fileName);
            }
            if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
                SourceFormatter._processErrorMessage(fileName, "}: " + fileName);
            }
            if (portalJavaFiles && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
                SourceFormatter._processErrorMessage(fileName, "ServiceUtil: " + fileName);
            }
            excluded = null;
            if (upgradeServiceUtilExclusions != null) {
                excluded = upgradeServiceUtilExclusions.getProperty(fileName);
            }
            if (excluded == null && portalJavaFiles && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && newContent.contains("ServiceUtil.")) {
                SourceFormatter._processErrorMessage(fileName, "ServiceUtil: " + fileName);
            }
            if (!className.equals("DeepNamedValueScanner") && !className.equals("ProxyUtil") && newContent.contains("import java.lang.reflect.Proxy;")) {
                SourceFormatter._processErrorMessage(fileName, "Proxy: " + fileName);
            }
            if (newContent.contains("import edu.emory.mathcs.backport.java")) {
                SourceFormatter._processErrorMessage(fileName, "edu.emory.mathcs.backport.java: " + fileName);
            }
            int pos1 = -1;
            while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
                int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
                int pos3 = newContent.indexOf("\"select count(", pos1);
                if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
                int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
                int pos5 = newContent.indexOf("\tfinally {", pos1);
                if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
                if (pos3 >= pos4 || pos4 >= pos5) continue;
                SourceFormatter._processErrorMessage(fileName, "Use getInt(1) for count: " + fileName);
            }
            if (content.contains("implements ProcessCallable") && !content.contains("private static final long serialVersionUID")) {
                SourceFormatter._processErrorMessage(fileName, "Assign ProcessCallable implementation a serialVersionUID: " + fileName);
            }
            SourceFormatter._checkLanguageKeys(fileName, newContent, _languageKeyPattern);
            if (_checkUnprocessedExceptions && !fileName.contains("/test/")) {
                SourceFormatter._checkUnprocessedExceptions(newContent, file, packagePath, fileName);
            }
            String oldContent = newContent;
            while (true) {
                newContent = SourceFormatter._formatJava(fileName, oldContent);
                if (oldContent.equals(newContent = StringUtil.replace((String)newContent, (String)"\n\n\n", (String)"\n\n"))) break;
                oldContent = newContent;
            }
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatJava(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int index = 0;
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        int lineToSkipIfEmpty = 0;
        TreeSet<JavaTerm> javaTerms = new TreeSet<JavaTerm>(new JavaTermComparator());
        JavaTerm javaTerm = null;
        String javaTermName = null;
        int javaTermLineCount = -1;
        int javaTermStartPosition = -1;
        int javaTermType = -1;
        boolean readParameterTypes = false;
        List<String> parameterTypes = new ArrayList<String>();
        int lastCommentOrAnnotationPos = -1;
        String ifClause = "";
        String packageName = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String trimmedLine;
            ++lineCount;
            if ((line = SourceFormatter._trimLine(line, false)).startsWith("package ")) {
                packageName = line.substring(8, line.length() - 1);
            }
            if (line.startsWith("import ")) {
                String importPackageName;
                int pos;
                if (line.endsWith(".*;")) {
                    SourceFormatter._processErrorMessage(fileName, "import: " + fileName + " " + lineCount);
                }
                if ((pos = line.lastIndexOf(".")) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
            }
            if (line.contains("\tfor (") && line.contains(":") && !line.contains(" :")) {
                line = StringUtil.replace((String)line, (String)":", (String)" :");
            }
            if ((trimmedLine = StringUtil.trimLeading((String)(line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount)))).startsWith("* @deprecated")) {
                if (!trimmedLine.startsWith("* @deprecated As of ")) {
                    line = StringUtil.replace((String)line, (String)"* @deprecated", (String)"* @deprecated As of 6.2.0");
                } else {
                    String version = trimmedLine.substring(20);
                    version = StringUtil.split((String)version, (String)" ")[0];
                    if (StringUtil.count((String)(version = StringUtil.replace((String)version, (String)",", (String)"")), (String)".") == 1) {
                        line = StringUtil.replaceFirst((String)line, (String)version, (String)(String.valueOf(version) + ".0"));
                    }
                }
            }
            if (trimmedLine.startsWith("=")) {
                SourceFormatter._processErrorMessage(fileName, "equal: " + fileName + " " + lineCount);
            }
            if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                line = StringUtil.replaceLast((String)line, (String)"{", (String)" {");
            }
            line = SourceFormatter._sortExceptions(line);
            if (trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull((String)ifClause)) {
                ifClause = String.valueOf(ifClause) + line + "\n";
                if (line.endsWith(") {")) {
                    String newIfClause = SourceFormatter._checkIfClause(ifClause, fileName, lineCount);
                    if (!ifClause.equals(newIfClause)) {
                        return StringUtil.replace((String)content, (String)ifClause, (String)newIfClause);
                    }
                    ifClause = "";
                } else if (line.endsWith(";")) {
                    ifClause = "";
                }
            }
            String excluded = null;
            if (line.startsWith("\tprivate ") || line.startsWith("\tprotected ") || line.startsWith("\tpublic ")) {
                Tuple tuple = SourceFormatter._getJavaTermTuple(line, content, index, 1, 3);
                if (tuple != null) {
                    int javaTermEndPosition = 0;
                    javaTermEndPosition = lastCommentOrAnnotationPos == -1 ? index : lastCommentOrAnnotationPos;
                    if (javaTermStartPosition != -1 && javaTermEndPosition < content.length()) {
                        String javaTermContent = content.substring(javaTermStartPosition, javaTermEndPosition);
                        if (Validator.isNotNull((String)javaTermName)) {
                            javaTerm = new JavaTerm(javaTermName, javaTermType, parameterTypes, javaTermContent, javaTermLineCount);
                            javaTerms.add(javaTerm);
                        }
                    }
                    javaTermLineCount = lineCount;
                    javaTermName = (String)tuple.getObject(0);
                    javaTermStartPosition = javaTermEndPosition;
                    javaTermType = (Integer)tuple.getObject(1);
                    if (Validator.isNotNull((String)javaTermName) && (SourceFormatter._isInJavaTermTypeGroup(javaTermType, _TYPE_CONSTRUCTOR) || SourceFormatter._isInJavaTermTypeGroup(javaTermType, _TYPE_METHOD))) {
                        readParameterTypes = true;
                        parameterTypes = new ArrayList();
                    }
                }
                lastCommentOrAnnotationPos = -1;
            } else if (SourceFormatter._hasAnnotationCommentOrJavadoc(line) && lastCommentOrAnnotationPos == -1) {
                lastCommentOrAnnotationPos = index;
            }
            if (readParameterTypes) {
                parameterTypes = SourceFormatter._addParameterTypes(trimmedLine, parameterTypes);
                if (trimmedLine.contains(")")) {
                    readParameterTypes = false;
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                int y;
                int x;
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                if (!(!line.contains("\t ") || previousLine.endsWith("&&") || previousLine.endsWith("||") || previousLine.contains("\t((") || previousLine.contains("\t ") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                    line = StringUtil.replace((String)line, (String)"\t ", (String)"\t");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.contains("Test")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
                if (!line.contains("\"")) {
                    String linePart;
                    int pos = line.indexOf(") ");
                    if (pos != -1 && Character.isLetter((linePart = line.substring(pos + 2)).charAt(0)) && !linePart.startsWith("default") && !linePart.startsWith("instanceof") && !linePart.startsWith("throws")) {
                        line = StringUtil.replaceLast((String)line, (String)(" " + linePart), (String)linePart);
                    }
                    if ((trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && line.contains(" (")) {
                        line = StringUtil.replace((String)line, (String)" (", (String)"(");
                    }
                    if (line.contains(" [")) {
                        line = StringUtil.replace((String)line, (String)" [", (String)"[");
                    }
                    int x2 = -1;
                    while (true) {
                        char previousChar;
                        char nextChar;
                        int posComma = line.indexOf(",", x2 + 1);
                        int posSemicolon = line.indexOf(";", x2 + 1);
                        if (posComma == -1 && posSemicolon == -1) break;
                        x2 = Math.min(posComma, posSemicolon);
                        if (x2 == -1) {
                            x2 = Math.max(posComma, posSemicolon);
                        }
                        if (line.length() > x2 + 1 && (nextChar = line.charAt(x2 + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                            line = StringUtil.insert((String)line, (String)" ", (int)(x2 + 1));
                        }
                        if (x2 <= 0 || (previousChar = line.charAt(x2 - 1)) != ' ') continue;
                        line = line.substring(0, x2 - 1).concat(line.substring(x2));
                    }
                }
                if ((line.contains(" && ") || line.contains(" || ")) && line.endsWith("(")) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.endsWith("+") && !trimmedLine.startsWith("(")) {
                    String strippedQuotesLine = SourceFormatter._stripQuotes(trimmedLine, "\"");
                    int closeParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)")");
                    int openParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)"(");
                    if (openParenthesisCount > closeParenthesisCount) {
                        SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                }
                if (line.contains(",") && !line.contains(")") && !line.contains(">") && !line.contains("\"") && line.endsWith("(")) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf("\"")) == -1 || x < y)) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (line.endsWith(" throws") || previousLine.endsWith("(") && line.contains(" throws ") && line.endsWith("{")) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith(".") || line.endsWith(".") && line.contains("=")) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith("}") && line.endsWith("{")) {
                    SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
            }
            if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                SourceFormatter._processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
            }
            if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                SourceFormatter._processErrorMessage(fileName, "{:" + fileName + " " + lineCount);
            }
            excluded = null;
            if (_lineLengthExclusions != null && (excluded = _lineLengthExclusions.getProperty(String.valueOf(fileName) + "@" + lineCount)) == null) {
                excluded = _lineLengthExclusions.getProperty(fileName);
            }
            Tuple combinedLines = null;
            int lineLength = SourceFormatter._getLineLength(line);
            if (!(excluded != null || line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                if (lineLength > 80) {
                    SourceFormatter._processErrorMessage(fileName, "> 80: " + fileName + " " + lineCount);
                } else {
                    int lineLeadingTabCount = SourceFormatter._getLeadingTabCount(line);
                    int previousLineLeadingTabCount = SourceFormatter._getLeadingTabCount(previousLine);
                    if (!trimmedLine.startsWith("//")) {
                        int x;
                        if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
                            SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        if (Validator.isNotNull((String)trimmedLine)) {
                            if ((previousLine.endsWith(":") && previousLine.contains("\tfor ") || previousLine.endsWith("(") && previousLine.contains("\tif ")) && previousLineLeadingTabCount + 2 != lineLeadingTabCount) {
                                SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            if (previousLine.endsWith("{") && !trimmedLine.startsWith("}") && previousLineLeadingTabCount + 1 != lineLeadingTabCount) {
                                SourceFormatter._processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                        }
                        if (previousLine.endsWith(".") && (x = trimmedLine.indexOf("(")) != -1 && SourceFormatter._getLineLength(previousLine) + x < 80 && (trimmedLine.endsWith("(") || trimmedLine.charAt(x + 1) != ')')) {
                            SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        if (trimmedLine.startsWith("throws ") && lineLeadingTabCount == previousLineLeadingTabCount) {
                            SourceFormatter._processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                        }
                        if ((previousLine.contains(" class ") || previousLine.contains(" enum ")) && previousLine.endsWith("{") && Validator.isNotNull((String)line) && !trimmedLine.startsWith("}")) {
                            SourceFormatter._processErrorMessage(fileName, "new line: " + fileName + " " + lineCount);
                        }
                    }
                    combinedLines = SourceFormatter._getCombinedLines(trimmedLine, previousLine, lineLeadingTabCount, previousLineLeadingTabCount);
                }
            }
            if (combinedLines != null) {
                previousLine = (String)combinedLines.getObject(0);
                if (combinedLines.getSize() > 1) {
                    String linePart = (String)combinedLines.getObject(1);
                    boolean addToPreviousLine = (Boolean)combinedLines.getObject(2);
                    if (addToPreviousLine) {
                        previousLine = String.valueOf(previousLine) + linePart;
                        line = StringUtil.replaceFirst((String)line, (String)linePart, (String)"");
                    } else if (linePart.length() + lineLength <= 80 && (line.endsWith("{") || line.endsWith(";"))) {
                        previousLine = StringUtil.replaceLast((String)previousLine, (String)StringUtil.trim((String)linePart), (String)"");
                        line = StringUtil.replaceLast((String)line, (String)"\t", (String)("\t" + linePart));
                    } else {
                        SourceFormatter._processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    sb.append(previousLine);
                    sb.append("\n");
                    previousLine = line;
                } else if (line.endsWith("{") && !previousLine.contains(" class ")) {
                    lineToSkipIfEmpty = lineCount + 1;
                }
            } else {
                if (lineCount > 1 && (Validator.isNotNull((String)previousLine) || lineToSkipIfEmpty != lineCount - 1)) {
                    sb.append(previousLine);
                    if (Validator.isNotNull((String)previousLine) && Validator.isNotNull((String)trimmedLine) && !previousLine.contains("/*") && !previousLine.endsWith("*/")) {
                        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
                        if (trimmedPreviousLine.startsWith("// ") && !trimmedLine.startsWith("// ") || !trimmedPreviousLine.startsWith("// ") && trimmedLine.startsWith("// ")) {
                            sb.append("\n");
                        } else if (!trimmedPreviousLine.endsWith("{") && !trimmedPreviousLine.endsWith(":") && (trimmedLine.startsWith("for (") || trimmedLine.startsWith("if ("))) {
                            sb.append("\n");
                        } else if (!(!previousLine.endsWith("\t}") || trimmedLine.startsWith("}") || trimmedLine.startsWith(")") || trimmedLine.startsWith("//") || trimmedLine.startsWith("catch ") || trimmedLine.startsWith("else ") || trimmedLine.startsWith("finally ") || trimmedLine.startsWith("while "))) {
                            sb.append("\n");
                        }
                    }
                    sb.append("\n");
                }
                previousLine = line;
            }
            index = index + line.length() + 1;
        }
        sb.append(previousLine);
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (content.equals(newContent)) {
            if (javaTermStartPosition != -1) {
                int javaTermEndPosition = content.length() - 2;
                String javaTermContent = content.substring(javaTermStartPosition, javaTermEndPosition);
                javaTerm = new JavaTerm(javaTermName, javaTermType, parameterTypes, javaTermContent, javaTermLineCount);
                javaTerms.add(javaTerm);
            }
            newContent = SourceFormatter._sortJavaTerms(fileName, content, javaTerms);
            newContent = SourceFormatter._sortAnnotations(newContent, javaTerms);
        }
        return newContent;
    }

    private static void _formatJS() throws IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\js\\aui\\**", "**\\js\\editor\\**", "**\\js\\misc\\**", "**\\tools\\**", "**\\VAADIN\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.js"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            Matcher matcher;
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"else{", "for(", "function (", "if(", "while(", "){\n", "= new Array();", "= new Object();"}, (String[])new String[]{"else {", "for (", "function(", "if (", "while (", ") {\n", "= [];", "= {};"});
            Pattern pattern = Pattern.compile("\t+var \\w+\\, ");
            while ((matcher = pattern.matcher(newContent)).find()) {
                String match = matcher.group();
                int pos = match.indexOf("var ");
                StringBundler sb = new StringBundler(4);
                sb.append(match.substring(0, match.length() - 2));
                sb.append(";");
                sb.append("\n");
                sb.append(match.substring(0, pos + 4));
                newContent = StringUtil.replace((String)newContent, (String)match, (String)sb.toString());
            }
            if (newContent.endsWith("\n")) {
                newContent = newContent.substring(0, newContent.length() - 1);
            }
            SourceFormatter._checkLanguageKeys(fileName, newContent, _languageKeyPattern);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static void _formatJSP() throws IOException {
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\portal\\aui\\**", "**\\bin\\**", "**\\null.jsp", "**\\tmp\\**", "**\\tools\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            _jspContents.put(fileName, content);
        }
        boolean stripJSPImports = true;
        for (String fileName : fileNames) {
            String content;
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String oldContent = content = _fileUtil.read(file);
            String newContent = "";
            while (!oldContent.equals(newContent = SourceFormatter._formatJSP(fileName, oldContent))) {
                oldContent = newContent;
            }
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "javascript: "}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "javascript:"});
            if (stripJSPImports) {
                try {
                    newContent = SourceFormatter._stripJSPImports(fileName, newContent);
                }
                catch (RuntimeException runtimeException) {
                    stripJSPImports = false;
                }
            }
            newContent = SourceFormatter._fixCopyright(newContent, copyright, oldCopyright, file, fileName);
            if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, (String[])new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.matches(".*template.*\\.vm$")) {
                SourceFormatter._processErrorMessage(fileName, "tab: " + fileName);
            }
            if (fileName.endsWith("init.jsp")) {
                boolean compressImports;
                int x = newContent.indexOf("<%@ page import=");
                int y = newContent.lastIndexOf("<%@ page import=");
                y = newContent.indexOf("%>", y);
                if (x != -1 && y != -1 && y > x && (compressImports = true)) {
                    String imports = newContent.substring(x, y);
                    imports = StringUtil.replace((String)imports, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, (String[])new String[]{"%><%@\r\n", "%><%@\n"});
                    newContent = String.valueOf(newContent.substring(0, x)) + imports + newContent.substring(y);
                }
            }
            newContent = SourceFormatter._fixSessionKey(fileName, newContent, _sessionKeyPattern);
            newContent = SourceFormatter._fixSessionKey(fileName, newContent, _taglibSessionKeyPattern);
            SourceFormatter._checkLanguageKeys(fileName, newContent, _languageKeyPattern);
            SourceFormatter._checkLanguageKeys(fileName, newContent, _taglibLanguageKeyPattern);
            SourceFormatter._checkXSS(fileName, newContent);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatJSP(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        String currentAttributeAndValue = null;
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean readAttributes = false;
        String currentException = null;
        String previousException = null;
        boolean hasUnsortedExceptions = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String includeFileName;
            Matcher matcher;
            int y;
            int x;
            ++lineCount;
            if (!fileName.contains("jsonw") || !fileName.endsWith("action.jsp")) {
                line = SourceFormatter._trimLine(line, false);
            }
            if (line.contains("<aui:button ") && line.contains("type=\"button\"")) {
                SourceFormatter._processErrorMessage(fileName, "aui:button " + fileName + " " + lineCount);
            }
            String trimmedLine = StringUtil.trimLeading((String)line);
            String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
            if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                line = StringUtil.replace((String)line, (String)"%>", (String)" %>");
            }
            if (line.contains("<%=") && !line.contains("<%= ")) {
                line = StringUtil.replace((String)line, (String)"<%=", (String)"<%= ");
            }
            if (trimmedPreviousLine.equals("%>") && Validator.isNotNull((String)line) && !trimmedLine.equals("-->")) {
                sb.append("\n");
            } else if (Validator.isNotNull((String)previousLine) && !trimmedPreviousLine.equals("<!--") && trimmedLine.equals("<%")) {
                sb.append("\n");
            } else {
                String lineBeforePreviousLine;
                if (trimmedPreviousLine.equals("<%") && Validator.isNull((String)line)) continue;
                if (trimmedPreviousLine.equals("<%") && trimmedLine.startsWith("//")) {
                    sb.append("\n");
                } else if (Validator.isNull((String)previousLine) && trimmedLine.equals("%>") && sb.index() > 2 && !(lineBeforePreviousLine = sb.stringAt(sb.index() - 3)).startsWith("//")) {
                    sb.setIndex(sb.index() - 1);
                }
            }
            if ((trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) && trimmedLine.endsWith(") {")) {
                SourceFormatter._checkIfClauseParentheses(trimmedLine, fileName, lineCount);
            }
            if (readAttributes) {
                if (!trimmedLine.startsWith("/") && !trimmedLine.startsWith(">")) {
                    int pos = trimmedLine.indexOf("=");
                    if (pos != -1) {
                        String attribute = trimmedLine.substring(0, pos);
                        if (!trimmedLine.endsWith("\"") && !trimmedLine.endsWith("'")) {
                            SourceFormatter._processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                            readAttributes = false;
                        } else if (trimmedLine.endsWith("'") && !trimmedLine.contains("\"")) {
                            line = StringUtil.replace((String)line, (String)"'", (String)"\"");
                            readAttributes = false;
                        } else if (Validator.isNotNull(previousAttribute)) {
                            if (!SourceFormatter._isJSPAttributName(attribute)) {
                                SourceFormatter._processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                                readAttributes = false;
                            } else if (Validator.isNull(previousAttributeAndValue) && previousAttribute.compareTo(attribute) > 0) {
                                previousAttributeAndValue = previousLine;
                                currentAttributeAndValue = line;
                            }
                        }
                        if (!readAttributes) {
                            previousAttribute = null;
                            previousAttributeAndValue = null;
                        } else {
                            previousAttribute = attribute;
                        }
                    }
                } else {
                    previousAttribute = null;
                    readAttributes = false;
                }
            }
            if (!hasUnsortedExceptions) {
                int i2 = line.indexOf("<liferay-ui:error exception=\"<%=");
                if (i2 != -1) {
                    currentException = line.substring(i2 + 33);
                    if (Validator.isNotNull((String)previousException) && previousException.compareTo(currentException) > 0) {
                        hasUnsortedExceptions = true;
                    }
                }
                if (!hasUnsortedExceptions) {
                    previousException = currentException;
                    currentException = null;
                }
            }
            if (trimmedLine.startsWith("<") && !trimmedLine.startsWith("<%") && !trimmedLine.startsWith("<!")) {
                if (!trimmedLine.contains(">") && !trimmedLine.contains(" ")) {
                    readAttributes = true;
                } else {
                    line = SourceFormatter._sortJSPAttributes(fileName, line, lineCount);
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
            }
            if (!fileName.endsWith("/touch.jsp") && (x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf("\"", (x = line.indexOf("\"", x)) + 1)) != -1 && !(matcher = _jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                SourceFormatter._processErrorMessage(fileName, "include: " + fileName + " " + lineCount);
            }
            previousLine = line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "\"");
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "'");
        if (Validator.isNotNull(previousAttributeAndValue)) {
            content = StringUtil.replaceFirst((String)content, (String)(String.valueOf(previousAttributeAndValue) + "\n" + currentAttributeAndValue), (String)(String.valueOf(currentAttributeAndValue) + "\n" + previousAttributeAndValue));
        }
        if (hasUnsortedExceptions) {
            if (StringUtil.count((String)content, currentException) > 1 || StringUtil.count((String)content, previousException) > 1) {
                SourceFormatter._processErrorMessage(fileName, "unsorted exceptions: " + fileName);
            } else {
                content = StringUtil.replaceFirst((String)content, previousException, currentException);
                content = StringUtil.replaceLast((String)content, currentException, previousException);
            }
        }
        return content;
    }

    private static void _formatPortalProperties() throws IOException {
        String basedir = "./";
        String portalPortalProperties = null;
        if (_portalSource) {
            File portalPortalPropertiesFile = new File(String.valueOf(basedir) + "portal-impl/src/portal.properties");
            portalPortalProperties = _fileUtil.read(portalPortalPropertiesFile);
        } else {
            portalPortalProperties = ContentUtil.get((String)"portal.properties");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = _excludes;
        if (_portalSource) {
            excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])new String[]{"**\\classes\\**", "**\\bin\\**"});
            directoryScanner.setIncludes(new String[]{"**\\portal-ext.properties", "**\\portal-legacy-*.properties"});
        } else {
            directoryScanner.setIncludes(new String[]{"**\\portal.properties", "**\\portal-ext.properties"});
        }
        directoryScanner.setExcludes((String[])excludes);
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            SourceFormatter._formatPortalProperties(fileName, content, portalPortalProperties);
        }
    }

    private static void _formatPortalProperties(String fileName, String content, String portalPortalProperties) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        int previousPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ++lineCount;
            int pos = line.indexOf("=");
            if (pos == -1) continue;
            String property = line.substring(0, pos + 1);
            pos = portalPortalProperties.indexOf("    " + (property = property.trim()));
            if (pos == -1) continue;
            if (pos < previousPos) {
                SourceFormatter._processErrorMessage(fileName, "sort " + fileName + " " + lineCount);
            }
            previousPos = pos;
        }
    }

    private static void _formatPortletXML() throws DocumentException, IOException {
        String basedir = "./";
        if (_portalSource) {
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/portlet-custom.xml");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatPortletXML(content);
            if (newContent != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(file.toString(), file);
            }
        } else {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setExcludes(_excludes);
            directoryScanner.setIncludes(new String[]{"**\\portlet.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                File file = new File(String.valueOf(basedir) + fileName);
                String content = _fileUtil.read(file);
                String newContent = SourceFormatter._trimContent(content, false);
                newContent = SourceFormatter._formatPortletXML(content);
                if (newContent == null || content.equals(newContent)) continue;
                _fileUtil.write(file, newContent);
                fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
                _sourceFormatterHelper.printError(fileName, file);
            }
        }
    }

    private static String _formatPortletXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            portletElement.sortElementsByChildElement("init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            portletPreferencesElement.sortElementsByChildElement("preference", "name");
        }
        return document.formattedString();
    }

    private static void _formatServiceXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(_excludes);
        directoryScanner.setIncludes(new String[]{"**\\service.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            SourceFormatter._formatServiceXML(fileName, content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static void _formatServiceXML(String fileName, String content) throws DocumentException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List entityElements = rootElement.elements("entity");
        String previousEntityName = "";
        for (Element entityElement : entityElements) {
            String entityName = entityElement.attributeValue("name");
            if (Validator.isNotNull((String)previousEntityName) && previousEntityName.compareToIgnoreCase(entityName) > 0) {
                SourceFormatter._processErrorMessage(fileName, "sort: " + fileName + " " + entityName);
            }
            String previousReferenceEntity = "";
            String previousReferencePackagePath = "";
            List referenceElements = entityElement.elements("reference");
            for (Element referenceElement : referenceElements) {
                String referenceEntity = referenceElement.attributeValue("entity");
                String referencePackagePath = referenceElement.attributeValue("package-path");
                if (Validator.isNotNull((String)previousReferencePackagePath) && (previousReferencePackagePath.compareToIgnoreCase(referencePackagePath) > 0 || previousReferencePackagePath.equals(referencePackagePath) && previousReferenceEntity.compareToIgnoreCase(referenceEntity) > 0)) {
                    SourceFormatter._processErrorMessage(fileName, "sort: " + fileName + " " + referencePackagePath);
                }
                previousReferenceEntity = referenceEntity;
                previousReferencePackagePath = referencePackagePath;
            }
            previousEntityName = entityName;
        }
        Element exceptionsElement = rootElement.element("exceptions");
        if (exceptionsElement == null) {
            return;
        }
        List exceptionElements = exceptionsElement.elements("exception");
        String previousException = "";
        for (Element exceptionElement : exceptionElements) {
            String exception = exceptionElement.getStringValue();
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                SourceFormatter._processErrorMessage(fileName, "sort: " + fileName + " " + exception);
            }
            previousException = exception;
        }
    }

    private static void _formatSH() throws IOException {
        SourceFormatter._formatSH("ext/create.sh");
        SourceFormatter._formatSH("hooks/create.sh");
        SourceFormatter._formatSH("layouttpl/create.sh");
        SourceFormatter._formatSH("portlets/create.sh");
        SourceFormatter._formatSH("themes/create.sh");
    }

    private static void _formatSH(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        String content = _fileUtil.read(new File(fileName), true);
        if (content.contains("\r")) {
            SourceFormatter._processErrorMessage(fileName, "Invalid new line character");
            content = StringUtil.replace((String)content, (String)"\r", (String)"");
            _fileUtil.write(fileName, content);
        }
    }

    private static void _formatSQL() throws IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(_excludes);
        directoryScanner.setIncludes(new String[]{"**\\sql\\*.sql"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatSQL(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatSQL(String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        String previousLineSqlCommand = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (Validator.isNotNull((String)(line = SourceFormatter._trimLine(line, false))) && !line.startsWith("\t")) {
                String sqlCommand = StringUtil.split((String)line, (char)' ')[0];
                if (Validator.isNotNull((String)previousLineSqlCommand) && !previousLineSqlCommand.equals(sqlCommand)) {
                    sb.append("\n");
                }
                previousLineSqlCommand = sqlCommand;
            } else {
                previousLineSqlCommand = "";
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private static void _formatStrutsConfigXML() throws DocumentException, IOException {
        String basedir = "./";
        if (!_portalSource) {
            return;
        }
        String fileName = "portal-web/docroot/WEB-INF/struts-config.xml";
        File file = new File(String.valueOf(basedir) + fileName);
        String content = _fileUtil.read(file);
        String newContent = SourceFormatter._trimContent(content, false);
        Document document = _saxReaderUtil.read(newContent);
        Element rootElement = document.getRootElement();
        Element actionMappingsElement = rootElement.element("action-mappings");
        List actionElements = actionMappingsElement.elements("action");
        String previousPath = "";
        for (Element actionElement : actionElements) {
            String path = actionElement.attributeValue("path");
            if (Validator.isNotNull((String)previousPath) && previousPath.compareTo(path) > 0 && (!previousPath.startsWith("/portal/") || path.startsWith("/portal/"))) {
                SourceFormatter._processErrorMessage(fileName, "sort: " + fileName + " " + path);
            }
            previousPath = path;
        }
        if (newContent != null && !content.equals(newContent)) {
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(SourceFormatter._getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            int x = content.indexOf(String.valueOf(quoteType) + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1) {
                String result = content.substring(x + 1, y + 2);
                if (result.contains(quoteType)) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    int i2 = 0;
                    while (i2 < x) {
                        if (contentCharArray[i2] == '\n') {
                            ++lineCount;
                        }
                        ++i2;
                    }
                    if (!result.contains(quoteFix)) {
                        StringBundler sb = new StringBundler(5);
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        SourceFormatter._processErrorMessage(fileName, "taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(String.valueOf(quoteType) + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    private static void _formatTilesDefsXML() throws DocumentException, IOException {
        String basedir = "./";
        if (!_portalSource) {
            return;
        }
        String fileName = "portal-web/docroot/WEB-INF/tiles-defs.xml";
        File file = new File(String.valueOf(basedir) + fileName);
        String content = _fileUtil.read(file);
        String newContent = SourceFormatter._trimContent(content, false);
        Document document = _saxReaderUtil.read(newContent);
        Element rootElement = document.getRootElement();
        List definitionElements = rootElement.elements("definition");
        String previousName = "";
        for (Element definitionElement : definitionElements) {
            String name = definitionElement.attributeValue("name");
            if (Validator.isNotNull((String)previousName) && previousName.compareTo(name) > 0 && !previousName.equals("portlet")) {
                SourceFormatter._processErrorMessage(fileName, "sort: " + fileName + " " + name);
            }
            previousName = name;
        }
        if (newContent != null && !content.equals(newContent)) {
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static void _formatTLD() throws IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\classes\\**", "**\\bin\\**", "**\\WEB-INF\\tld\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.tld"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void _formatWebXML() throws IOException {
        String basedir = "./";
        if (_portalSource) {
            void var6_13;
            Properties properties = new Properties();
            String propertiesContent = _fileUtil.read(String.valueOf(basedir) + "portal-impl/src/portal.properties");
            PropertiesUtil.load((Properties)properties, (String)propertiesContent);
            Object[] locales = StringUtil.split((String)properties.getProperty("locales"));
            Arrays.sort(locales);
            TreeSet<Object> urlPatterns = new TreeSet<Object>();
            Object[] objectArray = locales;
            int n = locales.length;
            boolean n2 = false;
            while (var6_13 < n) {
                Object locale = objectArray[var6_13];
                int pos = ((String)locale).indexOf("_");
                String languageCode = ((String)locale).substring(0, pos);
                urlPatterns.add(languageCode);
                urlPatterns.add(locale);
                ++var6_13;
            }
            StringBundler sb = new StringBundler();
            for (String string : urlPatterns) {
                sb.append("\t<servlet-mapping>\n");
                sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
                sb.append("\t\t<url-pattern>/" + string + "/*</url-pattern>\n");
                sb.append("\t</servlet-mapping>\n");
            }
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/web.xml");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._trimContent(content, false);
            int x = newContent.indexOf("<servlet-mapping>");
            x = newContent.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
            x = newContent.lastIndexOf("<servlet-mapping>", x) - 1;
            int y = newContent.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
            y = newContent.indexOf("</servlet-mapping>", y) + 19;
            newContent = String.valueOf(newContent.substring(0, x)) + sb.toString() + newContent.substring(y);
            x = newContent.indexOf("<security-constraint>");
            x = newContent.indexOf("<web-resource-name>/c/portal/protected</web-resource-name>", x);
            x = newContent.indexOf("<url-pattern>", x) - 3;
            y = newContent.indexOf("<http-method>", x);
            y = newContent.lastIndexOf("</url-pattern>", y) + 15;
            sb = new StringBundler();
            sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
            for (String string : urlPatterns) {
                sb.append("\t\t\t<url-pattern>/" + string + "/c/portal/protected</url-pattern>\n");
            }
            if ((newContent = String.valueOf(newContent.substring(0, x)) + sb.toString() + newContent.substring(y)) != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                System.out.println(file);
            }
        } else {
            String webXML = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/web.xml");
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setExcludes(_excludes);
            directoryScanner.setIncludes(new String[]{"**\\web.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                String string = _fileUtil.read(String.valueOf(basedir) + fileName);
                if (!string.equals(webXML)) continue;
                fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
                SourceFormatter._processErrorMessage(fileName, fileName);
            }
        }
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" implements ");
        if (pos == -1) {
            pos = line.indexOf(" extends ");
        }
        if (pos == -1) {
            pos = line.indexOf("{");
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(" ");
        return line.substring(pos + 1);
    }

    private static Tuple _getCombinedLines(String line, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        int pos;
        if (Validator.isNull((String)line) || Validator.isNull((String)previousLine)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
        int previousLineLength = SourceFormatter._getLineLength(previousLine);
        if (line.startsWith("// ") || trimmedPreviousLine.startsWith("// ")) {
            String linePart = line.substring(3);
            if (!linePart.startsWith("PLACEHOLDER") && !linePart.startsWith("[")) {
                int pos2 = linePart.indexOf(" ");
                if (pos2 == -1) {
                    pos2 = linePart.length();
                }
                if (previousLineLength + pos2 < 80) {
                    if (linePart.contains(" ")) {
                        return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart.substring(0, pos2 + 1), true});
                    }
                    return new Tuple(new Object[]{String.valueOf(previousLine) + " " + linePart});
                }
            }
            return null;
        }
        if (previousLine.endsWith(" extends")) {
            return new Tuple(new Object[]{previousLine, "extends ", false});
        }
        if (previousLine.endsWith(" implements")) {
            return new Tuple(new Object[]{previousLine, "implements ", false});
        }
        if (line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("|| ") || line.startsWith("&& ")) {
            int pos3 = line.indexOf(" ");
            String linePart = line.substring(0, pos3);
            return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart, true});
        }
        if (line.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((previousLine.endsWith("=") || previousLine.endsWith(".") || trimmedPreviousLine.equals("return")) && line.endsWith(";")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws")) && line.endsWith("{") && lineTabCount == previousLineTabCount + 1) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = line;
            int pos4 = 0;
            while (true) {
                int closeParenthesisCount;
                if ((pos4 = tempLine.indexOf("-")) == -1) {
                    pos4 = tempLine.indexOf("+");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("/");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("*");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("||");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("&&");
                }
                if (pos4 == -1) break;
                String linePart = tempLine.substring(0, pos4);
                int openParenthesisCount = StringUtil.count((String)linePart, (String)"(");
                if (openParenthesisCount == (closeParenthesisCount = StringUtil.count((String)linePart, (String)")"))) {
                    return null;
                }
                tempLine = String.valueOf(tempLine.substring(0, pos4)) + tempLine.substring(pos4 + 1);
            }
            int x = line.indexOf("(");
            if (x == 0) {
                x = line.indexOf("(", 1);
            }
            if (x != -1) {
                char previousChar;
                int y = line.indexOf(")", x);
                int z = line.indexOf("\"");
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = line.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart, true});
                }
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !previousLine.contains("}")) {
            int x = line.indexOf(",");
            if (x != -1) {
                while (previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (SourceFormatter._isValidJavaParameter(linePart)) {
                        if (line.equals(linePart)) {
                            return new Tuple(new Object[]{String.valueOf(previousLine) + " " + linePart});
                        }
                        return new Tuple(new Object[]{String.valueOf(previousLine) + " ", String.valueOf(linePart) + " ", true});
                    }
                    String partAfterComma = line.substring(x + 1);
                    int pos5 = partAfterComma.indexOf(",");
                    if (pos5 != -1) {
                        x = x + pos5 + 1;
                        continue;
                    }
                    break;
                }
            } else if (!(line.endsWith("(") || line.endsWith("+") || line.endsWith(".") || line.startsWith("new ") && line.endsWith("{") || line.length() + previousLineLength >= 80)) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (StringUtil.count((String)previousLine, (String)"(") > 1 && (pos = trimmedPreviousLine.lastIndexOf("(", trimmedPreviousLine.length() - 2)) > 0 && Character.isLetterOrDigit(trimmedPreviousLine.charAt(pos - 1)) && !(filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") && !filePart.contains("\"")) {
            return new Tuple(new Object[]{previousLine, filePart, false});
        }
        if (line.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(";")) {
            return new Tuple(new Object[]{String.valueOf(previousLine) + line});
        }
        if ((line.endsWith("{") && !line.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return new Tuple(new Object[]{String.valueOf(previousLine) + line});
        }
        return null;
    }

    private static String _getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(" ");
        return line.substring(x + 1);
    }

    private static String _getCopyright() throws IOException {
        String copyright = _fileUtil.read("copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../copyright.txt");
        }
        return copyright;
    }

    private static String _getCustomCopyright(File file) throws IOException {
        String absolutePath = _fileUtil.getAbsolutePath(file);
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf("/", x)) != -1) {
            String copyright = _fileUtil.read(String.valueOf(absolutePath.substring(0, x + 1)) + "copyright.txt");
            if (Validator.isNotNull((String)copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    private static List<String> _getImportedExceptionClassNames(JavaDocBuilder javaDocBuilder) {
        ArrayList<String> exceptionClassNames = new ArrayList<String>();
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        String[] stringArray = javaSource.getImports();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String importClassName = stringArray[n2];
            if (importClassName.endsWith("Exception") && !exceptionClassNames.contains(importClassName)) {
                exceptionClassNames.add(importClassName);
            }
            ++n2;
        }
        return exceptionClassNames;
    }

    private static Tuple _getJavaTermTuple(String line, String content, int index, int numLines, int maxLines) {
        int spaceCount;
        int pos = line.indexOf("(");
        if (line.startsWith("\tpublic static final ") && (line.contains("=") || line.endsWith(";") && pos == -1)) {
            return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 1});
        }
        if (line.startsWith("\tpublic static ")) {
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 2});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 3});
            }
            if (line.startsWith("\tpublic static class ") || line.startsWith("\tpublic static enum")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 7});
            }
        } else if (line.startsWith("\tpublic ")) {
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 6});
            }
            if (pos != -1) {
                spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                if (spaceCount == 1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 4});
                }
                if (spaceCount > 1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 5});
                }
            } else if (line.startsWith("\tpublic class ") || line.startsWith("\tpublic enum")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 8});
            }
        } else if (line.startsWith("\tprotected static final ")) {
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 12});
            }
        } else if (line.startsWith("\tprotected static ")) {
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 13});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 9});
            }
            if (line.startsWith("\tprotected static class ") || line.startsWith("\tprotected static enum ")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 15});
            }
        } else {
            if (line.startsWith("\tprotected ")) {
                if (pos != -1) {
                    if (!line.contains("=")) {
                        int spaceCount2 = StringUtil.count((String)line.substring(0, pos), (String)" ");
                        if (spaceCount2 == 1) {
                            return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 10});
                        }
                        if (spaceCount2 > 1) {
                            return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 11});
                        }
                    }
                } else if (line.startsWith("\tprotected class ") || line.startsWith("\tprotected enum ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 16});
                }
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 14});
            }
            if (line.startsWith("\tprivate static final ")) {
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 20});
                }
            } else if (line.startsWith("\tprivate static ")) {
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 21});
                }
                if (pos != -1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 17});
                }
                if (line.startsWith("\tprivate static class ") || line.startsWith("\tprivate static enum ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 23});
                }
            } else if (line.startsWith("\tprivate ")) {
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 22});
                }
                if (pos != -1) {
                    spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount == 1) {
                        return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 18});
                    }
                    if (spaceCount > 1) {
                        return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 19});
                    }
                } else if (line.startsWith("\tprivate class ") || line.startsWith("\tprivate enum ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 24});
                }
            }
        }
        if (numLines < maxLines) {
            int posEndNextline;
            int posStartNextLine = content.indexOf("\n", index) + 1;
            String nextLine = content.substring(posStartNextLine, posEndNextline = content.indexOf("\n", posStartNextLine));
            if (Validator.isNull((String)nextLine)) {
                return null;
            }
            nextLine = StringUtil.trimLeading((String)nextLine);
            return SourceFormatter._getJavaTermTuple(String.valueOf(line) + " " + nextLine, content, posStartNextLine, numLines + 1, maxLines);
        }
        return null;
    }

    private static List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !SourceFormatter._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] _getLanguageKeys(Matcher matcher) {
        String languageKey;
        if (matcher.groupCount() > 0 && Validator.isNotNull((String)(languageKey = matcher.group(1)))) {
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        int i2 = 0;
        while (i2 < match.length()) {
            char c2 = match.charAt(i2);
            switch (c2) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    break;
                }
                case '(': {
                    ++count;
                    break;
                }
                case '\"': {
                    if (count > 1) break;
                    while (i2 < match.length()) {
                        if (match.charAt(++i2) == '\"') {
                            String languageKey2 = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split((String)languageKey2);
                            }
                            return new String[]{languageKey2};
                        }
                        sb.append(match.charAt(i2));
                    }
                    break;
                }
            }
            ++i2;
        }
        return new String[0];
    }

    private static int _getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private static int _getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (c2 == '\t') {
                int i2 = 0;
                while (i2 < tabLength) {
                    ++lineLength;
                    ++i2;
                }
                tabLength = 4;
            } else {
                ++lineLength;
                if (--tabLength <= 0) {
                    tabLength = 4;
                }
            }
            ++n2;
        }
        return lineLength;
    }

    private static String _getOldCopyright() throws IOException {
        String copyright = _fileUtil.read("old-copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../old-copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../old-copyright.txt");
        }
        return copyright;
    }

    private static Properties _getPluginExclusionsProperties(String fileName) throws IOException {
        FileInputStream fileInputStream = null;
        int level = 0;
        try {
            fileInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (fileInputStream == null) {
            try {
                fileInputStream = new FileInputStream("../" + fileName);
                level = 1;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (fileInputStream == null) {
            try {
                fileInputStream = new FileInputStream("../../" + fileName);
                level = 2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        Properties properties = new Properties();
        properties.load(fileInputStream);
        if (level > 0) {
            properties = SourceFormatter._stripTopLevelDirectories(properties, level);
        }
        return properties;
    }

    private static Collection<String> _getPluginJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\bin\\**", "**\\model\\*Clp.java", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\**\\service\\*Service.java", "**\\service\\**\\service\\*ServiceClp.java", "**\\service\\**\\service\\*ServiceFactory.java", "**\\service\\**\\service\\*ServiceUtil.java", "**\\service\\**\\service\\*ServiceWrapper.java", "**\\service\\**\\service\\ClpSerializer.java", "**\\service\\**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\**\\service\\persistence\\*Finder.java", "**\\service\\**\\service\\persistence\\*Util.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\base\\*ServiceClpInvoker.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java", "**\\tmp\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static Properties _getPortalExclusionsProperties(String fileName) throws IOException {
        String sourceFormatterExclusions;
        Properties properties = new Properties();
        ClassLoader classLoader = SourceFormatter.class.getClassLoader();
        URL url = classLoader.getResource(sourceFormatterExclusions = System.getProperty("source-formatter-exclusions", "com/liferay/portal/tools/dependencies/" + fileName));
        if (url == null) {
            return null;
        }
        InputStream inputStream = url.openStream();
        properties.load(inputStream);
        inputStream.close();
        return properties;
    }

    private static Collection<String> _getPortalJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\*_IW.java", "**\\PropsValues.java", "**\\bin\\**", "**\\classes\\*", "**\\counter\\service\\**", "**\\jsp\\*", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-web\\classes\\**\\*.java", "**\\portal-web\\test\\**\\*Test.java", "**\\portal-web\\test\\**\\*Tests.java", "**\\portlet\\**\\service\\**", "**\\test\\*-generated\\**", "**\\tmp\\**", "**\\tools\\tck\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        excludes = new String[]{"**\\bin\\**", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\service\\Base*.java", "**\\service\\PersistedModelLocalService*.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\BasePersistenceImpl.java", "**\\portal-impl\\test\\**\\*.java", "**\\portal-service\\**\\liferay\\documentlibrary\\**.java", "**\\portal-service\\**\\liferay\\lock\\**.java", "**\\portal-service\\**\\liferay\\mail\\**.java", "**\\util-bridges\\**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static String _getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        int i2 = 0;
        while (i2 < _TAG_LIBRARIES.length) {
            sb.append(_TAG_LIBRARIES[i2]);
            sb.append("|");
            ++i2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf("=");
        int y = line.lastIndexOf(" ");
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim((String)line);
            y = line.lastIndexOf(" ");
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static boolean _hasAnnotationCommentOrJavadoc(String s) {
        return s.startsWith("\t@") || s.startsWith("\t/**") || s.startsWith("\t//");
    }

    private static boolean _hasMissingParentheses(String s) {
        boolean containsMathOperator;
        if (Validator.isNull((String)s)) {
            return false;
        }
        boolean containsAndOrOperator = s.contains("&&") || s.contains("||");
        boolean containsCompareOperator = s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ");
        boolean bl = containsMathOperator = s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ");
        return containsCompareOperator && (containsAndOrOperator || containsMathOperator && !s.contains("["));
    }

    private static boolean _hasRedundantParentheses(String s) {
        if (!s.contains("&&") && !s.contains("||")) {
            int y;
            int x = 0;
            while ((x = s.indexOf(")")) != -1 && (y = s.substring(0, x).lastIndexOf("(")) != -1) {
                s = String.valueOf(s.substring(0, y)) + s.substring(x + 1);
            }
        }
        return Validator.isNotNull((String)s) && !s.contains(" ");
    }

    private static boolean _isGenerated(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    private static boolean _isInJavaTermTypeGroup(int javaTermType, int[] javaTermTypeGroup) {
        int[] nArray = javaTermTypeGroup;
        int n = javaTermTypeGroup.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (javaTermType == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean _isJSPAttributName(String attributeName) {
        if (Validator.isNull((String)attributeName)) {
            return false;
        }
        Matcher matcher = _jspAttributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    private static boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf("\"", y)) == -1) {
            return false;
        }
        int z = content.indexOf("\"", y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        includeFileName = String.valueOf(docrootPath) + includeFileName;
        return SourceFormatter._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private static boolean _isJSPImportRequired(String fileName, String className, Set<String> includeFileNames, Set<String> checkedFileNames) {
        String[] includeFileNamesArray;
        if (checkedFileNames.contains(fileName)) {
            return false;
        }
        checkedFileNames.add(fileName);
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^A-Za-z0-9_]" + className + "[^A-Za-z0-9_\"]");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return true;
        }
        SourceFormatter._addJSPIncludeFileNames(fileName, includeFileNames);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        fileName = fileName.replaceFirst(docrootPath, "");
        if (fileName.endsWith("init.jsp") || fileName.contains("init-ext.jsp")) {
            SourceFormatter._addJSPReferenceFileNames(fileName, includeFileNames);
        }
        String[] stringArray = includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()]);
        int n = includeFileNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String includeFileName = stringArray[n2];
            if (!checkedFileNames.contains(includeFileName) && SourceFormatter._isJSPImportRequired(includeFileName, className, includeFileNames, checkedFileNames)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean _isPortalSource() {
        String basedir = "./";
        return _fileUtil.exists(String.valueOf(basedir) + "portal-impl");
    }

    private static boolean _isValidJavaParameter(String javaParameter) {
        int quoteCount = StringUtil.count((String)javaParameter, (String)"\"");
        if (quoteCount % 2 == 1) {
            return false;
        }
        javaParameter = SourceFormatter._stripQuotes(javaParameter, "\"");
        int openParenthesisCount = StringUtil.count((String)javaParameter, (String)"(");
        int closeParenthesisCount = StringUtil.count((String)javaParameter, (String)")");
        int lessThanCount = StringUtil.count((String)javaParameter, (String)"<");
        int greaterThanCount = StringUtil.count((String)javaParameter, (String)">");
        int openCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"{");
        int closeCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"}");
        return openParenthesisCount == closeParenthesisCount && lessThanCount == greaterThanCount && openCurlyBraceCount == closeCurlyBraceCount;
    }

    private static void _processErrorMessage(String fileName, String message) {
        if (_throwException) {
            _errorMessages.add(message);
        } else {
            _sourceFormatterHelper.printError(fileName, message);
        }
    }

    private static String _replacePrimitiveWrapperInstantiation(String fileName, String line, int lineCount) {
        return line;
    }

    private static String _sortAnnotations(String content, Set<JavaTerm> javaTerms) throws IOException {
        block0: for (JavaTerm javaTerm : javaTerms) {
            while (true) {
                String javaTermContent = javaTerm.getContent();
                javaTerm.sortAnnotations();
                String newJavaTermContent = javaTerm.getContent();
                if (javaTermContent.equals(newJavaTermContent)) continue block0;
                content = content.replace(javaTermContent, newJavaTermContent);
            }
        }
        return content;
    }

    private static String _sortExceptions(String line) {
        if (!line.endsWith("{") && !line.endsWith(";")) {
            return line;
        }
        int x = line.indexOf("throws ");
        if (x == -1) {
            return line;
        }
        String previousException = "";
        String[] exceptions = StringUtil.split((String)line.substring(x), (char)' ');
        int i2 = 1;
        while (i2 < exceptions.length) {
            String exception = exceptions[i2];
            if (exception.equals("{")) break;
            if (exception.endsWith(",") || exception.endsWith(";")) {
                exception = exception.substring(0, exception.length() - 1);
            }
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                return StringUtil.replace((String)line, (String)(String.valueOf(previousException) + ", " + exception), (String)(String.valueOf(exception) + ", " + previousException));
            }
            previousException = exception;
            ++i2;
        }
        return line;
    }

    private static String _sortJavaTerms(String fileName, String content, Set<JavaTerm> javaTerms) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            int javaTermLineCount = javaTerm.getLineCount();
            String javaTermName = javaTerm.getName();
            String excluded = null;
            if (_javaTermSortExclusions != null) {
                excluded = _javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTermLineCount);
                if (excluded == null) {
                    excluded = _javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTermName);
                }
                if (excluded == null) {
                    excluded = _javaTermSortExclusions.getProperty(fileName);
                }
            }
            if (excluded == null && previousJavaTerm != null) {
                String javaTermContent = javaTerm.getContent();
                String previousJavaTermContent = previousJavaTerm.getContent();
                if (previousJavaTerm.getLineCount() > javaTermLineCount) {
                    String previousJavaTermName = previousJavaTerm.getName();
                    String javaTermNameLowerCase = javaTermName.toLowerCase();
                    String previousJavaTermNameLowerCase = previousJavaTermName.toLowerCase();
                    if (!(fileName.contains("persistence") && (previousJavaTermName.startsWith("doCount") && javaTermName.startsWith("doCount") || previousJavaTermName.startsWith("doFind") && javaTermName.startsWith("doFind") || previousJavaTermNameLowerCase.startsWith("count") && javaTermNameLowerCase.startsWith("count") || previousJavaTermNameLowerCase.startsWith("filter") && javaTermNameLowerCase.startsWith("filter") || previousJavaTermNameLowerCase.startsWith("find") && javaTermNameLowerCase.startsWith("find") || previousJavaTermNameLowerCase.startsWith("join") && javaTermNameLowerCase.startsWith("join")))) {
                        content = StringUtil.replaceFirst((String)content, (String)javaTermContent, (String)previousJavaTermContent);
                        content = StringUtil.replaceLast((String)content, (String)previousJavaTermContent, (String)javaTermContent);
                        return content;
                    }
                }
                content = SourceFormatter._fixJavaTermsDivider(content, previousJavaTerm, javaTerm);
            }
            previousJavaTerm = javaTerm;
        }
        return content;
    }

    private static String _sortJSPAttributes(String fileName, String line, int lineCount) {
        String s = line;
        int x = s.indexOf(" ");
        if (x == -1) {
            return line;
        }
        s = s.substring(x + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        x = 0;
        while ((x = s.indexOf("=")) != -1 && s.length() > x + 1) {
            int lessThanCount;
            int greaterThanCount;
            int startJavaCodeSignCount;
            int endJavaCodeSignCount;
            char delimeter;
            String attribute = s.substring(0, x);
            if (!SourceFormatter._isJSPAttributName(attribute)) {
                return line;
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareTo(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                SourceFormatter._processErrorMessage(fileName, "delimeter: " + fileName + " " + lineCount);
                return line;
            }
            s = s.substring(1);
            String value = null;
            int y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? (endJavaCodeSignCount = StringUtil.count((String)value, (String)"%>")) == (startJavaCodeSignCount = StringUtil.count((String)value, (String)"<%")) : (greaterThanCount = StringUtil.count((String)value, (String)">")) == (lessThanCount = StringUtil.count((String)value, (String)"<"))));
            if (delimeter == '\'' && !value.contains("\"")) {
                return StringUtil.replace((String)line, (String)("'" + value + "'"), (String)("\"" + value + "\""));
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (wrongOrder) {
                if (StringUtil.count((String)line, (String)currentAttributeAndValue) == 1 && StringUtil.count((String)line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst((String)line, (String)previousAttributeAndValue, (String)currentAttributeAndValue);
                    line = StringUtil.replaceLast((String)line, (String)currentAttributeAndValue, (String)previousAttributeAndValue);
                }
                return line;
            }
            s = s.substring(y + 1);
            s = StringUtil.trimLeading((String)s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    private static String _stripJSPImports(String fileName, String content) throws IOException {
        String afterImports;
        if (!(fileName = fileName.replace('\\', '/')).contains("docroot") || fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _jspImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        imports = StringUtil.replace((String)imports, (String[])new String[]{"%><%@\r\n", "%><%@\n"}, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "});
        if (!fileName.endsWith("html/common/init.jsp") && !fileName.endsWith("html/portal/init.jsp")) {
            ArrayList<String> importLines = new ArrayList<String>();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!line.contains("import=")) continue;
                importLines.add(line);
            }
            List<String> unneededImports = SourceFormatter._getJSPDuplicateImports(fileName, content, importLines);
            SourceFormatter._addJSPUnusedImports(fileName, importLines, unneededImports);
            for (String unneededImport : unneededImports) {
                imports = StringUtil.replace((String)imports, (String)unneededImport, (String)"");
            }
        }
        imports = SourceFormatter._formatImports(imports, 17);
        String beforeImports = content.substring(0, matcher.start());
        if (Validator.isNull((String)imports)) {
            beforeImports = StringUtil.replaceLast((String)beforeImports, (String)"\n", (String)"");
        }
        if (Validator.isNull((String)(afterImports = content.substring(matcher.end())))) {
            imports = StringUtil.replaceLast((String)imports, (String)"\n", (String)"");
            content = String.valueOf(beforeImports) + imports;
            return content;
        }
        content = String.valueOf(beforeImports) + imports + "\n" + afterImports;
        return content;
    }

    private static String _stripQuotes(String s, String delimeter) {
        String[] parts = StringUtil.split((String)s, (String)delimeter);
        int i2 = 1;
        while (i2 < parts.length) {
            s = StringUtil.replaceFirst((String)s, (String)(String.valueOf(delimeter) + parts[i2] + delimeter), (String)"");
            i2 += 2;
        }
        return s;
    }

    private static String _stripRedundantParentheses(String s) {
        int x = 0;
        while (true) {
            x = s.indexOf("(", x + 1);
            int y = s.indexOf(")", x);
            if (x == -1 || y == -1) {
                return s;
            }
            String linePart = s.substring(x + 1, y);
            if (!Validator.isAlphanumericName((String)(linePart = StringUtil.replace((String)linePart, (String)",", (String)""))) && !Validator.isNull((String)linePart)) continue;
            s = String.valueOf(s.substring(0, x)) + s.substring(y + 1);
        }
    }

    private static Properties _stripTopLevelDirectories(Properties properties, int level) throws IOException {
        File dir = new File(".");
        String dirName = dir.getCanonicalPath();
        dirName = StringUtil.replace((String)dirName, (String)"\\", (String)"/");
        int pos = dirName.length();
        int i2 = 0;
        while (i2 < level) {
            pos = dirName.lastIndexOf("/", pos - 1);
            ++i2;
        }
        String topLevelDirNames = String.valueOf(dirName.substring(pos + 1)) + "/";
        Properties newProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(topLevelDirNames)) continue;
            key = StringUtil.replaceFirst((String)key, (String)topLevelDirNames, (String)"");
            String value = (String)entry.getValue();
            newProperties.setProperty(key, value);
        }
        return newProperties;
    }

    private static String _trimContent(String content, boolean allowLeadingSpaces) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            sb.append(SourceFormatter._trimLine(line, allowLeadingSpaces));
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private static String _trimLine(String line, boolean allowLeadingSpaces) {
        if (line.trim().length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing((String)line);
        if (allowLeadingSpaces || !line.startsWith(" ") || line.startsWith(" *")) {
            return line;
        }
        if (!line.startsWith("    ")) {
            while (line.startsWith(" ")) {
                line = StringUtil.replaceFirst((String)line, (String)" ", (String)"");
            }
        } else {
            int pos = 0;
            String temp = line;
            while (temp.startsWith("    ")) {
                line = StringUtil.replaceFirst((String)line, (String)"    ", (String)"\t");
                temp = line.substring(++pos);
            }
        }
        return line;
    }
}

