/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.seleniumbuilder;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.seleniumbuilder.ActionConverter;
import com.liferay.portal.tools.seleniumbuilder.FunctionConverter;
import com.liferay.portal.tools.seleniumbuilder.MacroConverter;
import com.liferay.portal.tools.seleniumbuilder.PathConverter;
import com.liferay.portal.tools.seleniumbuilder.SeleniumBuilderContext;
import com.liferay.portal.tools.seleniumbuilder.TestCaseConverter;
import com.liferay.portal.tools.seleniumbuilder.TestSuiteConverter;
import com.liferay.portal.util.InitUtil;
import java.util.Map;
import java.util.Set;

public class SeleniumBuilder {
    public static void main(String[] args) throws Exception {
        InitUtil.initWithSpring();
        new SeleniumBuilder(args);
    }

    public SeleniumBuilder(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String baseDir = arguments.get("selenium.base.dir");
        SeleniumBuilderContext seleniumBuilderContext = new SeleniumBuilderContext(baseDir);
        Set types = SetUtil.fromArray((Object[])StringUtil.split((String)arguments.get("selenium.types")));
        if (types.contains("action")) {
            ActionConverter actionConverter = new ActionConverter(seleniumBuilderContext);
            Set<String> actionNames = seleniumBuilderContext.getActionNames();
            for (String actionName : actionNames) {
                seleniumBuilderContext.validateActionElements(actionName);
                actionConverter.convert(actionName);
            }
        }
        if (types.contains("function")) {
            FunctionConverter functionConverter = new FunctionConverter(seleniumBuilderContext);
            Set<String> functionNames = seleniumBuilderContext.getFunctionNames();
            for (String functionName : functionNames) {
                seleniumBuilderContext.validateFunctionElements(functionName);
                functionConverter.convert(functionName);
            }
        }
        if (types.contains("macro")) {
            MacroConverter macroConverter = new MacroConverter(seleniumBuilderContext);
            Set<String> macroNames = seleniumBuilderContext.getMacroNames();
            for (String macroName : macroNames) {
                seleniumBuilderContext.validateMacroElements(macroName);
                macroConverter.convert(macroName);
            }
        }
        if (types.contains("path")) {
            PathConverter pathConverter = new PathConverter(seleniumBuilderContext);
            Set<String> pathNames = seleniumBuilderContext.getPathNames();
            for (String pathName : pathNames) {
                pathConverter.convert(pathName);
            }
        }
        if (types.contains("testcase")) {
            TestCaseConverter testCaseConverter = new TestCaseConverter(seleniumBuilderContext);
            Set<String> testCaseNames = seleniumBuilderContext.getTestCaseNames();
            for (String testCaseName : testCaseNames) {
                seleniumBuilderContext.validateTestCaseElements(testCaseName);
                testCaseConverter.convert(testCaseName);
            }
        }
        if (types.contains("testsuite")) {
            TestSuiteConverter testSuiteConverter = new TestSuiteConverter(seleniumBuilderContext);
            Set<String> testSuiteNames = seleniumBuilderContext.getTestSuiteNames();
            for (String testSuiteName : testSuiteNames) {
                seleniumBuilderContext.validateTestSuiteElements(testSuiteName);
                testSuiteConverter.convert(testSuiteName);
            }
        }
    }
}

