/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.DBLoader;
import com.liferay.portal.tools.samplesqlbuilder.SampleSQLBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;

public class TestSampleSQLBuilder {
    private String _outputDir;
    private String _sqlDir;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String sqlDir = arguments.get("sql.dir");
        String outputDir = arguments.get("sample.sql.output.dir");
        SampleSQLBuilder.main(args);
        new TestSampleSQLBuilder(sqlDir, outputDir);
    }

    public TestSampleSQLBuilder(String sqlDir, String outputDir) throws Exception {
        this._sqlDir = sqlDir;
        this._outputDir = outputDir;
        this._loadHypersonic();
    }

    private void _loadHypersonic() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        Connection con = DriverManager.getConnection("jdbc:hsqldb:mem:testSampleSQLBuilderDB;shutdown=true", "sa", "");
        DBLoader.loadHypersonic(con, String.valueOf(this._sqlDir) + "/portal-minimal/portal-minimal-hypersonic.sql");
        DBLoader.loadHypersonic(con, String.valueOf(this._sqlDir) + "/indexes/indexes-hypersonic.sql");
        DBLoader.loadHypersonic(con, String.valueOf(this._outputDir) + "/sample-hypersonic.sql");
        Statement statement = con.createStatement();
        statement.execute("SHUTDOWN COMPACT");
        statement.close();
        con.close();
    }
}

