/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.CharPipe;
import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncTeeWriter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.tools.samplesqlbuilder.SampleMySQLDB;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SampleSQLBuilder {
    private static final int _PIPE_BUFFER_SIZE = 0x1000000;
    private static final String _TPL_ROOT = "com/liferay/portal/tools/samplesqlbuilder/dependencies/";
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private DataFactory _dataFactory;
    private DB _db;
    private String _dbType;
    private Map<String, StringBundler> _insertSQLs = new ConcurrentHashMap<String, StringBundler>();
    private Map<String, Writer> _insertSQLWriters = new ConcurrentHashMap<String, Writer>();
    private int _maxAssetCategoryCount;
    private int _maxAssetEntryToAssetCategoryCount;
    private int _maxAssetEntryToAssetTagCount;
    private int _maxAssetTagCount;
    private int _maxAssetVocabularyCount;
    private int _maxBlogsEntryCommentCount;
    private int _maxBlogsEntryCount;
    private int _maxDDLCustomFieldCount;
    private int _maxDDLRecordCount;
    private int _maxDDLRecordSetCount;
    private int _maxDLFileEntryCount;
    private int _maxDLFileEntrySize;
    private int _maxDLFolderCount;
    private int _maxDLFolderDepth;
    private int _maxGroupCount;
    private int _maxJournalArticleCount;
    private int _maxJournalArticlePageCount;
    private int _maxJournalArticleSize;
    private int _maxJournalArticleVersionCount;
    private int _maxMBCategoryCount;
    private int _maxMBMessageCount;
    private int _maxMBThreadCount;
    private int _maxUserCount;
    private int _maxUserToGroupCount;
    private int _maxWikiNodeCount;
    private int _maxWikiPageCommentCount;
    private int _maxWikiPageCount;
    private int _optimizeBufferSize;
    private List<String> _otherSQLs = new ArrayList<String>();
    private String _outputDir;
    private boolean _outputMerge;
    private File _tempDir;
    private String _tplSample = "com/liferay/portal/tools/samplesqlbuilder/dependencies/sample.ftl";
    private Writer _writerBlogsCSV;
    private Writer _writerCompanyCSV;
    private Writer _writerDocumentLibraryCSV;
    private Writer _writerDynamicDataListsCSV;
    private Writer _writerLayoutCSV;
    private Writer _writerMessageBoardsCSV;
    private Writer _writerRepositoryCSV;
    private Writer _writerSampleSQL;
    private Writer _writerWikiCSV;

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> extraConfigLocations = new ArrayList<String>();
        extraConfigLocations.add("META-INF/portlet-container-spring.xml");
        InitUtil.initWithSpring(false, extraConfigLocations);
        try {
            new SampleSQLBuilder(arguments);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public SampleSQLBuilder(Map<String, String> arguments) throws Exception {
        String baseDir = arguments.get("sample.sql.base.dir");
        this._dbType = arguments.get("sample.sql.db.type");
        this._maxAssetCategoryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.asset.category.count"));
        this._maxAssetEntryToAssetCategoryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.asset.entry.to.asset.category.count"));
        this._maxAssetEntryToAssetTagCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.asset.entry.to.asset.tag.count"));
        this._maxAssetTagCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.asset.tag.count"));
        this._maxAssetVocabularyCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.asset.vocabulary.count"));
        this._maxBlogsEntryCommentCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.blogs.entry.comment.count"));
        this._maxBlogsEntryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.blogs.entry.count"));
        this._maxDDLCustomFieldCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.ddl.custom.field.count"));
        this._maxDDLRecordCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.ddl.record.count"));
        this._maxDDLRecordSetCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.ddl.record.set.count"));
        this._maxDLFileEntryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.file.entry.count"));
        this._maxDLFileEntrySize = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.file.entry.size"));
        this._maxDLFolderCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.folder.count"));
        this._maxDLFolderDepth = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.folder.depth"));
        this._maxGroupCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.group.count"));
        this._maxJournalArticleCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.count"));
        this._maxJournalArticlePageCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.page.count"));
        this._maxJournalArticleSize = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.size"));
        this._maxJournalArticleVersionCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.version.count"));
        this._maxMBCategoryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.category.count"));
        this._maxMBMessageCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.message.count"));
        this._maxMBThreadCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.thread.count"));
        this._maxUserCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.user.count"));
        this._maxUserToGroupCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.user.to.group.count"));
        this._maxWikiNodeCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.node.count"));
        this._maxWikiPageCommentCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.page.comment.count"));
        this._maxWikiPageCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.page.count"));
        this._optimizeBufferSize = GetterUtil.getInteger((String)arguments.get("sample.sql.optimize.buffer.size"));
        this._outputDir = arguments.get("sample.sql.output.dir");
        this._outputMerge = GetterUtil.getBoolean((String)arguments.get("sample.sql.output.merge"));
        this._dataFactory = new DataFactory(baseDir, this._maxAssetCategoryCount, this._maxAssetEntryToAssetCategoryCount, this._maxAssetEntryToAssetTagCount, this._maxAssetTagCount, this._maxAssetVocabularyCount, this._maxBlogsEntryCount, this._maxDDLCustomFieldCount, this._maxGroupCount, this._maxJournalArticleCount, this._maxJournalArticleSize, this._maxMBCategoryCount, this._maxMBThreadCount, this._maxMBMessageCount, this._maxUserToGroupCount);
        this._db = DBFactoryUtil.getDB((String)this._dbType);
        if (this._db instanceof MySQLDB) {
            this._db = new SampleMySQLDB();
        }
        FileUtil.delete((String)(String.valueOf(this._outputDir) + "/sample-" + this._dbType + ".sql"));
        FileUtil.deltree((String)(String.valueOf(this._outputDir) + "/output"));
        this._tempDir = new File(this._outputDir, "temp");
        this._tempDir.mkdirs();
        CharPipe charPipe = new CharPipe(0x1000000);
        this.generateSQL(charPipe);
        try {
            this.compressSQL(charPipe.getReader());
            this.mergeSQL();
        }
        finally {
            FileUtil.deltree((File)this._tempDir);
        }
        StringBundler sb = new StringBundler();
        List keys = ListUtil.fromMapKeys(arguments);
        Collections.sort(keys);
        for (String key : keys) {
            if (!key.startsWith("sample.sql")) continue;
            String value = arguments.get(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        FileUtil.write((File)new File(this._outputDir, "benchmarks-actual.properties"), (String)sb.toString());
    }

    protected void compressInsertSQL(String insertSQL) throws IOException {
        String tableName = insertSQL.substring(0, insertSQL.indexOf(32));
        int pos = insertSQL.indexOf(" values ") + 8;
        String values = insertSQL.substring(pos, insertSQL.length() - 1);
        StringBundler sb = this._insertSQLs.get(tableName);
        if (sb == null || sb.index() == 0) {
            sb = new StringBundler();
            this._insertSQLs.put(tableName, sb);
            sb.append("insert into ");
            sb.append(insertSQL.substring(0, pos));
            sb.append("\n");
        } else {
            sb.append(",\n");
        }
        sb.append(values);
        if (sb.index() >= this._optimizeBufferSize) {
            sb.append(";\n");
            String sql = this._db.buildSQL(sb.toString());
            sb.setIndex(0);
            this.writeToInsertSQLFile(tableName, sql);
        }
    }

    protected void compressSQL(Reader reader) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
        String s = null;
        while ((s = unsyncBufferedReader.readLine()) != null) {
            if ((s = s.trim()).length() <= 0) continue;
            if (s.startsWith("insert into ")) {
                this.compressInsertSQL(s.substring(12));
                continue;
            }
            if (s.length() <= 0) continue;
            this._otherSQLs.add(s);
        }
        unsyncBufferedReader.close();
    }

    protected Writer createFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream);
        return this.createUnsyncBufferedWriter((Writer)writer);
    }

    protected Writer createFileWriter(String fileName) throws IOException {
        File file = new File(fileName);
        return this.createFileWriter(file);
    }

    protected Writer createUnsyncBufferedWriter(Writer writer) {
        return new UnsyncBufferedWriter(writer, 16384){

            public void flush() {
            }
        };
    }

    protected void generateSQL(final CharPipe charPipe) {
        final Writer writer = this.createUnsyncBufferedWriter(charPipe.getWriter());
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    SampleSQLBuilder.this._writerSampleSQL = (Writer)new UnsyncTeeWriter(writer, SampleSQLBuilder.this.createFileWriter(String.valueOf(SampleSQLBuilder.this._outputDir) + "/sample.sql"));
                    this.createSample();
                    SampleSQLBuilder.this._writerSampleSQL.close();
                    charPipe.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }

            protected void createSample() throws Exception {
                SampleSQLBuilder.this._writerBlogsCSV = this.getWriter("blogs.csv");
                SampleSQLBuilder.this._writerCompanyCSV = this.getWriter("company.csv");
                SampleSQLBuilder.this._writerDocumentLibraryCSV = this.getWriter("document_library.csv");
                SampleSQLBuilder.this._writerDynamicDataListsCSV = this.getWriter("dynamic_data_lists.csv");
                SampleSQLBuilder.this._writerLayoutCSV = this.getWriter("layout.csv");
                SampleSQLBuilder.this._writerMessageBoardsCSV = this.getWriter("message_boards.csv");
                SampleSQLBuilder.this._writerRepositoryCSV = this.getWriter("repository.csv");
                SampleSQLBuilder.this._writerWikiCSV = this.getWriter("wiki.csv");
                Map<String, Object> context = SampleSQLBuilder.this.getContext();
                SampleSQLBuilder.this.processTemplate(SampleSQLBuilder.this._tplSample, context);
                SampleSQLBuilder.this._writerBlogsCSV.close();
                SampleSQLBuilder.this._writerCompanyCSV.close();
                SampleSQLBuilder.this._writerDocumentLibraryCSV.close();
                SampleSQLBuilder.this._writerDynamicDataListsCSV.close();
                SampleSQLBuilder.this._writerLayoutCSV.close();
                SampleSQLBuilder.this._writerMessageBoardsCSV.close();
                SampleSQLBuilder.this._writerRepositoryCSV.close();
                SampleSQLBuilder.this._writerWikiCSV.close();
            }

            protected Writer getWriter(String fileName) throws Exception {
                return SampleSQLBuilder.this.createFileWriter(new File(String.valueOf(SampleSQLBuilder.this._outputDir) + "/" + fileName));
            }
        };
        thread.start();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.put(context, "counter", this._dataFactory.getCounter());
        this.put(context, "dataFactory", this._dataFactory);
        this.put(context, "maxAssetCategoryCount", this._maxAssetCategoryCount);
        this.put(context, "maxAssetTagCount", this._maxAssetTagCount);
        this.put(context, "maxAssetVocabularyCount", this._maxAssetVocabularyCount);
        this.put(context, "maxDLFileEntrySize", this._maxDLFileEntrySize);
        this.put(context, "maxBlogsEntryCommentCount", this._maxBlogsEntryCommentCount);
        this.put(context, "maxBlogsEntryCount", this._maxBlogsEntryCount);
        this.put(context, "maxDDLRecordCount", this._maxDDLRecordCount);
        this.put(context, "maxDDLRecordSetCount", this._maxDDLRecordSetCount);
        this.put(context, "maxDLFileEntryCount", this._maxDLFileEntryCount);
        this.put(context, "maxDLFolderCount", this._maxDLFolderCount);
        this.put(context, "maxDLFolderDepth", this._maxDLFolderDepth);
        this.put(context, "maxGroupCount", this._maxGroupCount);
        this.put(context, "maxJournalArticleCount", this._maxJournalArticleCount);
        this.put(context, "maxJournalArticlePageCount", this._maxJournalArticlePageCount);
        this.put(context, "maxJournalArticleVersionCount", this._maxJournalArticleVersionCount);
        this.put(context, "maxMBCategoryCount", this._maxMBCategoryCount);
        this.put(context, "maxMBMessageCount", this._maxMBMessageCount);
        this.put(context, "maxMBThreadCount", this._maxMBThreadCount);
        this.put(context, "maxUserCount", this._maxUserCount);
        this.put(context, "maxUserToGroupCount", this._maxUserToGroupCount);
        this.put(context, "maxWikiNodeCount", this._maxWikiNodeCount);
        this.put(context, "maxWikiPageCommentCount", this._maxWikiPageCommentCount);
        this.put(context, "maxWikiPageCount", this._maxWikiPageCount);
        this.put(context, "writerBlogsCSV", this._writerBlogsCSV);
        this.put(context, "writerCompanyCSV", this._writerCompanyCSV);
        this.put(context, "writerDocumentLibraryCSV", this._writerDocumentLibraryCSV);
        this.put(context, "writerDynamicDataListsCSV", this._writerDynamicDataListsCSV);
        this.put(context, "writerLayoutCSV", this._writerLayoutCSV);
        this.put(context, "writerMessageBoardsCSV", this._writerMessageBoardsCSV);
        this.put(context, "writerRepositoryCSV", this._writerRepositoryCSV);
        this.put(context, "writerWikiCSV", this._writerWikiCSV);
        return context;
    }

    protected File getInsertSQLFile(String tableName) {
        return new File(this._tempDir, String.valueOf(tableName) + ".sql");
    }

    protected void mergeSQL() throws IOException {
        File outputFile = new File(String.valueOf(this._outputDir) + "/sample-" + this._dbType + ".sql");
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        if (this._outputMerge) {
            fileOutputStream = new FileOutputStream(outputFile);
            fileChannel = fileOutputStream.getChannel();
        }
        Set<Map.Entry<String, StringBundler>> insertSQLs = this._insertSQLs.entrySet();
        for (Map.Entry<String, StringBundler> entry : insertSQLs) {
            String tableName = entry.getKey();
            String sql = this._db.buildSQL(entry.getValue().toString());
            this.writeToInsertSQLFile(tableName, sql);
            Writer insertSQLWriter = this._insertSQLWriters.remove(tableName);
            insertSQLWriter.write(";\n");
            insertSQLWriter.close();
            if (!this._outputMerge) continue;
            File insertSQLFile = this.getInsertSQLFile(tableName);
            FileInputStream insertSQLFileInputStream = new FileInputStream(insertSQLFile);
            FileChannel insertSQLFileChannel = insertSQLFileInputStream.getChannel();
            insertSQLFileChannel.transferTo(0L, insertSQLFileChannel.size(), fileChannel);
            insertSQLFileChannel.close();
            insertSQLFile.delete();
        }
        Object writer = null;
        writer = this._outputMerge ? new OutputStreamWriter((OutputStream)fileOutputStream) : new FileWriter(this.getInsertSQLFile("others"));
        for (String sql : this._otherSQLs) {
            sql = this._db.buildSQL(sql);
            ((Writer)writer).write(sql);
            ((Writer)writer).write("\n");
        }
        ((Writer)writer).close();
        File outputFolder = new File(this._outputDir, "output");
        if (!this._outputMerge && !this._tempDir.renameTo(outputFolder)) {
            FileUtil.copyDirectory((File)this._tempDir, (File)outputFolder);
        }
    }

    protected void processTemplate(String name, Map<String, Object> context) throws Exception {
        FreeMarkerUtil.process(name, context, this._writerSampleSQL);
    }

    protected void put(Map<String, Object> context, String key, Object value) {
        context.put(key, value);
    }

    protected void writeToInsertSQLFile(String tableName, String sql) throws IOException {
        Writer writer = this._insertSQLWriters.get(tableName);
        if (writer == null) {
            File file = this.getInsertSQLFile(tableName);
            writer = this.createFileWriter(file);
            this._insertSQLWriters.put(tableName, writer);
        }
        writer.write(sql);
    }
}

