/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.impl.CounterImpl;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.LayoutFriendlyURLImpl;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.model.impl.ResourcePermissionImpl;
import com.liferay.portal.model.impl.RoleImpl;
import com.liferay.portal.model.impl.SubscriptionImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.model.impl.VirtualHostImpl;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.tools.samplesqlbuilder.SequentialUUID;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagStats;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.impl.AssetCategoryImpl;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.asset.model.impl.AssetTagImpl;
import com.liferay.portlet.asset.model.impl.AssetTagStatsImpl;
import com.liferay.portlet.asset.model.impl.AssetVocabularyImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryTypeImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordSetImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordVersionImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMContentImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStorageLinkImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureLinkImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.model.impl.JournalArticleResourceImpl;
import com.liferay.portlet.journal.model.impl.JournalContentSearchImpl;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBThreadFlag;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBDiscussionImpl;
import com.liferay.portlet.messageboards.model.impl.MBMailingListImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.model.impl.MBStatsUserImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadFlagImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadImpl;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.impl.SocialActivityImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageResourceImpl;
import com.liferay.util.PwdGenerator;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DataFactory {
    private static final long _CURRENT_TIME = System.currentTimeMillis();
    private static final String _DEPENDENCIES_DIR = "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/";
    private static final long _FUTURE_TIME = System.currentTimeMillis() + 31536000000L;
    private static final String _SAMPLE_USER_NAME = "Sample";
    private Account _account;
    private long _accountId;
    private Role _administratorRole;
    private List<AssetCategory> _assetCategories;
    private Map<Long, SimpleCounter> _assetCategoryCounters = new HashMap<Long, SimpleCounter>();
    private Map<Long, SimpleCounter> _assetTagCounters = new HashMap<Long, SimpleCounter>();
    private List<AssetTag> _assetTags;
    private List<AssetTagStats> _assetTagStatsList;
    private List<AssetVocabulary> _assetVocabularies;
    private String _baseDir;
    private List<ClassName> _classNames;
    private Map<String, Long> _classNamesMap = new HashMap<String, Long>();
    private Company _company;
    private long _companyId;
    private SimpleCounter _counter;
    private DDMStructure _defaultDLDDMStructure;
    private DLFileEntryType _defaultDLFileEntryType;
    private User _defaultUser;
    private long _defaultUserId;
    private String _dlDDMStructureContent;
    private List<String> _firstNames;
    private SimpleCounter _futureDateCounter;
    private Group _globalGroup;
    private long _globalGroupId;
    private List<Group> _groups;
    private Group _guestGroup;
    private long _guestGroupId;
    private Role _guestRole;
    private User _guestUser;
    private String _journalArticleContent;
    private List<String> _lastNames;
    private Map<Long, SimpleCounter> _layoutCounters = new HashMap<Long, SimpleCounter>();
    private int _maxAssetCategoryCount;
    private int _maxAssetEntryToAssetCategoryCount;
    private int _maxAssetEntryToAssetTagCount;
    private int _maxAssetTagCount;
    private int _maxAssetVocabularyCount;
    private int _maxBlogsEntryCount;
    private int _maxDDLCustomFieldCount;
    private int _maxDLFileEntrySize;
    private int _maxGroupsCount;
    private int _maxJournalArticleCount;
    private int _maxMBCategoryCount;
    private int _maxMBMessageCount;
    private int _maxMBThreadCount;
    private int _maxUserToGroupCount;
    private Role _ownerRole;
    private Role _powerUserRole;
    private SimpleCounter _resourcePermissionCounter;
    private List<Role> _roles;
    private User _sampleUser;
    private long _sampleUserId;
    private Format _simpleDateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private Role _siteMemberRole;
    private SimpleCounter _socialActivityCounter;
    private SimpleCounter _timeCounter;
    private Role _userRole;
    private SimpleCounter _userScreenNameCounter;
    private VirtualHost _virtualHost;

    public DataFactory(String baseDir, int maxAssetCategoryCount, int maxAssetEntryToAssetCategoryCount, int maxAssetEntryToAssetTagCount, int maxAssetTagCount, int maxAssetVocabularyCount, int maxBlogsEntryCount, int maxDDLCustomFieldCount, int maxGroupsCount, int maxJournalArticleCount, int maxJournalArticleSize, int maxMBCategoryCount, int maxMBThreadCount, int maxMBMessageCount, int maxUserToGroupCount) throws Exception {
        this._baseDir = baseDir;
        this._maxAssetCategoryCount = maxAssetCategoryCount;
        this._maxAssetEntryToAssetCategoryCount = maxAssetEntryToAssetCategoryCount;
        this._maxAssetEntryToAssetTagCount = maxAssetEntryToAssetTagCount;
        this._maxAssetTagCount = maxAssetTagCount;
        this._maxAssetVocabularyCount = maxAssetVocabularyCount;
        this._maxBlogsEntryCount = maxBlogsEntryCount;
        this._maxDDLCustomFieldCount = maxDDLCustomFieldCount;
        this._maxGroupsCount = maxGroupsCount;
        this._maxJournalArticleCount = maxJournalArticleCount;
        this._maxMBCategoryCount = maxMBCategoryCount;
        this._maxMBThreadCount = maxMBThreadCount;
        this._maxMBMessageCount = maxMBMessageCount;
        this._maxUserToGroupCount = maxUserToGroupCount;
        this._counter = new SimpleCounter((long)(this._maxGroupsCount + 1));
        this._timeCounter = new SimpleCounter();
        this._futureDateCounter = new SimpleCounter();
        this._resourcePermissionCounter = new SimpleCounter();
        this._socialActivityCounter = new SimpleCounter();
        this._userScreenNameCounter = new SimpleCounter();
        this._classNames = new ArrayList<ClassName>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            ClassNameImpl className = new ClassNameImpl();
            long classNameId = this._counter.get();
            className.setClassNameId(classNameId);
            className.setValue(model);
            this._classNames.add(className);
            this._classNamesMap.put(model, classNameId);
        }
        this._accountId = this._counter.get();
        this._companyId = this._counter.get();
        this._defaultUserId = this._counter.get();
        this._globalGroupId = this._counter.get();
        this._guestGroupId = this._counter.get();
        this._sampleUserId = this._counter.get();
        this._dlDDMStructureContent = StringUtil.read((InputStream)new FileInputStream(new File(this._baseDir, "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/ddm_structure_basic_document.xml")));
        this.initAssetCateogries();
        this.initAssetTags();
        this.initCompany();
        this.initDLFileEntryType();
        this.initGroups();
        this.initJournalArticle(maxJournalArticleSize);
        this.initRoles();
        this.initUserNames();
        this.initUsers();
        this.initVirtualHost();
    }

    public Account getAccount() {
        return this._account;
    }

    public Role getAdministratorRole() {
        return this._administratorRole;
    }

    public List<AssetCategory> getAssetCategories() {
        return this._assetCategories;
    }

    public List<Long> getAssetCategoryIds(long groupId) {
        SimpleCounter counter = this._assetCategoryCounters.get(groupId);
        if (counter == null) {
            counter = new SimpleCounter(0L);
            this._assetCategoryCounters.put(groupId, counter);
        }
        int maxAssetCategoryCount = this._maxAssetCategoryCount * this._maxAssetVocabularyCount;
        int startIndex = maxAssetCategoryCount * ((int)groupId - 1);
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>(this._maxAssetEntryToAssetCategoryCount);
        int i2 = 0;
        while (i2 < this._maxAssetEntryToAssetCategoryCount) {
            int index = startIndex + (int)counter.get() % maxAssetCategoryCount;
            AssetCategory assetCategory = this._assetCategories.get(index);
            assetCategoryIds.add(assetCategory.getCategoryId());
            ++i2;
        }
        return assetCategoryIds;
    }

    public List<Long> getAssetTagIds(long groupId) {
        SimpleCounter counter = this._assetTagCounters.get(groupId);
        if (counter == null) {
            counter = new SimpleCounter(0L);
            this._assetTagCounters.put(groupId, counter);
        }
        int startIndex = this._maxAssetTagCount * ((int)groupId - 1);
        ArrayList<Long> assetTagIds = new ArrayList<Long>(this._maxAssetEntryToAssetTagCount);
        int i2 = 0;
        while (i2 < this._maxAssetEntryToAssetTagCount) {
            int index = startIndex + (int)counter.get() % this._maxAssetTagCount;
            AssetTag assetTag = this._assetTags.get(index);
            assetTagIds.add(assetTag.getTagId());
            ++i2;
        }
        return assetTagIds;
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<AssetTagStats> getAssetTagStatsList() {
        return this._assetTagStatsList;
    }

    public List<AssetVocabulary> getAssetVocabularies() {
        return this._assetVocabularies;
    }

    public long getBlogsEntryClassNameId() {
        return this._classNamesMap.get(BlogsEntry.class.getName());
    }

    public List<ClassName> getClassNames() {
        return this._classNames;
    }

    public Company getCompany() {
        return this._company;
    }

    public SimpleCounter getCounter() {
        return this._counter;
    }

    public String getDateLong(Date date) {
        return String.valueOf(date.getTime());
    }

    public String getDateString(Date date) {
        if (date == null) {
            return null;
        }
        return this._simpleDateFormat.format(date);
    }

    public long getDDLRecordSetClassNameId() {
        return this._classNamesMap.get(DDLRecordSet.class.getName());
    }

    public DDMStructure getDefaultDLDDMStructure() {
        return this._defaultDLDDMStructure;
    }

    public long getDefaultDLDDMStructureId() {
        return this._defaultDLDDMStructure.getStructureId();
    }

    public DLFileEntryType getDefaultDLFileEntryType() {
        return this._defaultDLFileEntryType;
    }

    public User getDefaultUser() {
        return this._defaultUser;
    }

    public long getDLFileEntryClassNameId() {
        return this._classNamesMap.get(DLFileEntry.class.getName());
    }

    public Group getGlobalGroup() {
        return this._globalGroup;
    }

    public long getGroupClassNameId() {
        return this._classNamesMap.get(Group.class.getName());
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public Group getGuestGroup() {
        return this._guestGroup;
    }

    public User getGuestUser() {
        return this._guestUser;
    }

    public long getJournalArticleClassNameId() {
        return this._classNamesMap.get(JournalArticle.class.getName());
    }

    public String getJournalArticleLayoutColumn(String portletPrefix) {
        StringBundler sb = new StringBundler(3 * this._maxJournalArticleCount);
        int i2 = 1;
        while (i2 <= this._maxJournalArticleCount) {
            sb.append(portletPrefix);
            sb.append(i2);
            sb.append(",");
            ++i2;
        }
        return sb.toString();
    }

    public long getLayoutClassNameId() {
        return this._classNamesMap.get(Layout.class.getName());
    }

    public List<Long> getNewUserGroupIds(long groupId) {
        ArrayList<Long> groupIds = new ArrayList<Long>(this._maxUserToGroupCount + 1);
        groupIds.add(this._guestGroup.getGroupId());
        if (groupId + (long)this._maxUserToGroupCount > (long)this._maxGroupsCount) {
            groupId = groupId - (long)this._maxUserToGroupCount + 1L;
        }
        int i2 = 0;
        while (i2 < this._maxUserToGroupCount) {
            groupIds.add(groupId + (long)i2);
            ++i2;
        }
        return groupIds;
    }

    public Role getPowerUserRole() {
        return this._powerUserRole;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public User getSampleUser() {
        return this._sampleUser;
    }

    public Role getUserRole() {
        return this._userRole;
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public long getWikiPageClassNameId() {
        return this._classNamesMap.get(WikiPage.class.getName());
    }

    public void initAssetCateogries() {
        this._assetVocabularies = new ArrayList<AssetVocabulary>();
        this._assetCategories = new ArrayList<AssetCategory>();
        this._assetVocabularies.add(this.newAssetVocabulary(this._globalGroupId, this._defaultUserId, null, PropsValues.ASSET_VOCABULARY_DEFAULT));
        StringBundler sb = new StringBundler(4);
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            long lastRightCategoryId = 2L;
            int j = 0;
            while (j < this._maxAssetVocabularyCount) {
                sb.setIndex(0);
                sb.append("TestVocabulary_");
                sb.append(i2);
                sb.append("_");
                sb.append(j);
                AssetVocabulary assetVocabulary = this.newAssetVocabulary(i2, this._sampleUserId, _SAMPLE_USER_NAME, sb.toString());
                this._assetVocabularies.add(assetVocabulary);
                int k = 0;
                while (k < this._maxAssetCategoryCount) {
                    sb.setIndex(0);
                    sb.append("TestCategory_");
                    sb.append(assetVocabulary.getVocabularyId());
                    sb.append("_");
                    sb.append(k);
                    AssetCategory assetCategory = this.newAssetCategory(i2, lastRightCategoryId, sb.toString(), assetVocabulary.getVocabularyId());
                    lastRightCategoryId += 2L;
                    this._assetCategories.add(assetCategory);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void initAssetTags() {
        this._assetTags = new ArrayList<AssetTag>(this._maxAssetTagCount);
        this._assetTagStatsList = new ArrayList<AssetTagStats>(this._maxAssetTagCount * 3);
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            int j = 0;
            while (j < this._maxAssetTagCount) {
                AssetTagImpl assetTag = new AssetTagImpl();
                assetTag.setTagId(this._counter.get());
                assetTag.setGroupId(i2);
                assetTag.setCompanyId(this._companyId);
                assetTag.setUserId(this._sampleUserId);
                assetTag.setUserName(_SAMPLE_USER_NAME);
                assetTag.setCreateDate(new Date());
                assetTag.setModifiedDate(new Date());
                assetTag.setName("TestTag_" + i2 + "_" + j);
                this._assetTags.add(assetTag);
                AssetTagStats assetTagStats = this.newAssetTagStats(assetTag.getTagId(), this._classNamesMap.get(BlogsEntry.class.getName()));
                this._assetTagStatsList.add(assetTagStats);
                assetTagStats = this.newAssetTagStats(assetTag.getTagId(), this._classNamesMap.get(JournalArticle.class.getName()));
                this._assetTagStatsList.add(assetTagStats);
                assetTagStats = this.newAssetTagStats(assetTag.getTagId(), this._classNamesMap.get(WikiPage.class.getName()));
                this._assetTagStatsList.add(assetTagStats);
                ++j;
            }
            ++i2;
        }
    }

    public void initCompany() {
        this._company = new CompanyImpl();
        this._company.setCompanyId(this._companyId);
        this._company.setAccountId(this._accountId);
        this._company.setWebId("liferay.com");
        this._company.setMx("liferay.com");
        this._company.setActive(true);
        this._account = new AccountImpl();
        this._account.setAccountId(this._accountId);
        this._account.setCompanyId(this._companyId);
        this._account.setCreateDate(new Date());
        this._account.setModifiedDate(new Date());
        this._account.setName("Liferay");
        this._account.setLegalName("Liferay, Inc.");
    }

    public void initDLFileEntryType() {
        this._defaultDLFileEntryType = new DLFileEntryTypeImpl();
        this._defaultDLFileEntryType.setUuid(SequentialUUID.generate());
        this._defaultDLFileEntryType.setFileEntryTypeId(0L);
        this._defaultDLFileEntryType.setCreateDate(this.nextFutureDate());
        this._defaultDLFileEntryType.setModifiedDate(this.nextFutureDate());
        this._defaultDLFileEntryType.setFileEntryTypeKey("basic-document".toUpperCase());
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Name language-id=\"en_US\">");
        sb.append("basic-document");
        sb.append("</Name></root>");
        this._defaultDLFileEntryType.setName(sb.toString());
        this._defaultDLDDMStructure = this.newDDMStructure(this._guestGroupId, this.getDLFileEntryClassNameId(), "TIKARAWMETADATA", this._dlDDMStructureContent);
    }

    public void initGroups() throws Exception {
        long groupClassNameId = this.getGroupClassNameId();
        this._globalGroup = this.newGroup(this._globalGroupId, this._classNamesMap.get(Company.class.getName()), this._companyId, "Global", false);
        this._guestGroup = this.newGroup(this._guestGroupId, groupClassNameId, this._guestGroupId, "Guest", true);
        this._groups = new ArrayList<Group>(this._maxGroupsCount);
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            Group group = this.newGroup(i2, groupClassNameId, i2, "Site " + i2, true);
            this._groups.add(group);
            ++i2;
        }
    }

    public void initJournalArticle(int maxJournalArticleSize) {
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\"?><root available-locales=\"en_US\" ");
        sb.append("default-locale=\"en_US\"><static-content language-id=");
        sb.append("\"en_US\"><![CDATA[<p>");
        if (maxJournalArticleSize <= 0) {
            maxJournalArticleSize = 1;
        }
        char[] chars = new char[maxJournalArticleSize];
        int i2 = 0;
        while (i2 < maxJournalArticleSize) {
            chars[i2] = (char)(97 + i2 % 26);
            ++i2;
        }
        sb.append(new String(chars));
        sb.append("</p>]]></static-content></root>");
        this._journalArticleContent = sb.toString();
    }

    public void initRoles() {
        this._roles = new ArrayList<Role>();
        this._administratorRole = this.newRole("Administrator", 1);
        this._roles.add(this._administratorRole);
        this._guestRole = this.newRole("Guest", 1);
        this._roles.add(this._guestRole);
        Role organizationAdministratorRole = this.newRole("Organization Administrator", 3);
        this._roles.add(organizationAdministratorRole);
        Role organizationOwnerRole = this.newRole("Organization Owner", 3);
        this._roles.add(organizationOwnerRole);
        Role organizationUserRole = this.newRole("Organization User", 3);
        this._roles.add(organizationUserRole);
        this._ownerRole = this.newRole("Owner", 1);
        this._roles.add(this._ownerRole);
        this._powerUserRole = this.newRole("Power User", 1);
        this._roles.add(this._powerUserRole);
        Role siteAdministratorRole = this.newRole("Site Administrator", 2);
        this._roles.add(siteAdministratorRole);
        this._siteMemberRole = this.newRole("Site Member", 2);
        this._roles.add(this._siteMemberRole);
        Role siteOwnerRole = this.newRole("Site Owner", 2);
        this._roles.add(siteOwnerRole);
        this._userRole = this.newRole("User", 1);
        this._roles.add(this._userRole);
    }

    public void initUserNames() throws IOException {
        this._firstNames = ListUtil.fromFile((File)new File(this._baseDir, "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/first_names.txt"));
        this._lastNames = ListUtil.fromFile((File)new File(this._baseDir, "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/last_names.txt"));
    }

    public void initUsers() {
        this._defaultUser = this.newUser(this._defaultUserId, "", "", "", true);
        this._guestUser = this.newUser(this._counter.get(), "Test", "Test", "Test", false);
        this._sampleUser = this.newUser(this._sampleUserId, _SAMPLE_USER_NAME, _SAMPLE_USER_NAME, _SAMPLE_USER_NAME, false);
    }

    public void initVirtualHost() {
        this._virtualHost = new VirtualHostImpl();
        this._virtualHost.setVirtualHostId(this._counter.get());
        this._virtualHost.setCompanyId(this._companyId);
        this._virtualHost.setHostname("localhost");
    }

    public AssetEntry newAssetEntry(BlogsEntry blogsEntry) {
        return this.newAssetEntry(blogsEntry.getGroupId(), blogsEntry.getCreateDate(), blogsEntry.getModifiedDate(), this.getBlogsEntryClassNameId(), blogsEntry.getEntryId(), blogsEntry.getUuid(), 0L, true, "text/html", blogsEntry.getTitle());
    }

    public AssetEntry newAssetEntry(DLFileEntry dlFileEntry) {
        return this.newAssetEntry(dlFileEntry.getGroupId(), dlFileEntry.getCreateDate(), dlFileEntry.getModifiedDate(), this.getDLFileEntryClassNameId(), dlFileEntry.getFileEntryId(), dlFileEntry.getUuid(), dlFileEntry.getFileEntryTypeId(), true, dlFileEntry.getMimeType(), dlFileEntry.getTitle());
    }

    public AssetEntry newAssetEntry(DLFolder dlFolder) {
        return this.newAssetEntry(dlFolder.getGroupId(), dlFolder.getCreateDate(), dlFolder.getModifiedDate(), this._classNamesMap.get(DLFolder.class.getName()), dlFolder.getFolderId(), dlFolder.getUuid(), 0L, true, null, dlFolder.getName());
    }

    public AssetEntry newAssetEntry(JournalArticle journalArticle) {
        return this.newAssetEntry(journalArticle.getGroupId(), journalArticle.getCreateDate(), journalArticle.getModifiedDate(), this.getJournalArticleClassNameId(), journalArticle.getResourcePrimKey(), journalArticle.getUuid(), 0L, true, "text/html", journalArticle.getTitle());
    }

    public AssetEntry newAssetEntry(MBMessage mbMessage) {
        long classNameId = 0L;
        boolean visible = false;
        if (mbMessage.isDiscussion()) {
            classNameId = this._classNamesMap.get(MBDiscussion.class.getName());
        } else {
            classNameId = this._classNamesMap.get(MBMessage.class.getName());
            visible = true;
        }
        return this.newAssetEntry(mbMessage.getGroupId(), mbMessage.getCreateDate(), mbMessage.getModifiedDate(), classNameId, mbMessage.getMessageId(), mbMessage.getUuid(), 0L, visible, "text/html", mbMessage.getSubject());
    }

    public AssetEntry newAssetEntry(MBThread mbThread) {
        return this.newAssetEntry(mbThread.getGroupId(), mbThread.getCreateDate(), mbThread.getModifiedDate(), this._classNamesMap.get(MBThread.class.getName()), mbThread.getThreadId(), mbThread.getUuid(), 0L, false, "", String.valueOf(mbThread.getRootMessageId()));
    }

    public AssetEntry newAssetEntry(WikiPage wikiPage) {
        return this.newAssetEntry(wikiPage.getGroupId(), wikiPage.getCreateDate(), wikiPage.getModifiedDate(), this.getWikiPageClassNameId(), wikiPage.getResourcePrimKey(), wikiPage.getUuid(), 0L, true, "text/html", wikiPage.getTitle());
    }

    public BlogsEntry newBlogsEntry(long groupId, int index) {
        BlogsEntryImpl blogsEntry = new BlogsEntryImpl();
        blogsEntry.setUuid(SequentialUUID.generate());
        blogsEntry.setEntryId(this._counter.get());
        blogsEntry.setGroupId(groupId);
        blogsEntry.setCompanyId(this._companyId);
        blogsEntry.setUserId(this._sampleUserId);
        blogsEntry.setUserName(_SAMPLE_USER_NAME);
        blogsEntry.setCreateDate(new Date());
        blogsEntry.setModifiedDate(new Date());
        blogsEntry.setTitle("Test Blog " + index);
        blogsEntry.setUrlTitle("testblog" + index);
        blogsEntry.setContent("This is test blog " + index + ".");
        blogsEntry.setDisplayDate(new Date());
        blogsEntry.setStatusDate(new Date());
        return blogsEntry;
    }

    public BlogsStatsUser newBlogsStatsUser(long groupId) {
        BlogsStatsUserImpl blogsStatsUser = new BlogsStatsUserImpl();
        blogsStatsUser.setStatsUserId(this._counter.get());
        blogsStatsUser.setGroupId(groupId);
        blogsStatsUser.setCompanyId(this._companyId);
        blogsStatsUser.setUserId(this._sampleUserId);
        blogsStatsUser.setEntryCount(this._maxBlogsEntryCount);
        blogsStatsUser.setLastPostDate(new Date());
        return blogsStatsUser;
    }

    public Contact newContact(User user) {
        ContactImpl contact = new ContactImpl();
        contact.setContactId(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(user.getUserId());
        contact.setUserName(user.getFullName());
        contact.setCreateDate(new Date());
        contact.setModifiedDate(new Date());
        contact.setClassNameId(this._classNamesMap.get(User.class.getName()));
        contact.setClassPK(user.getUserId());
        contact.setAccountId(this._accountId);
        contact.setParentContactId(0L);
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(user.getFirstName());
        contact.setLastName(user.getLastName());
        contact.setMale(true);
        contact.setBirthday(new Date());
        return contact;
    }

    public List<Counter> newCounters() {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        CounterImpl counter = new CounterImpl();
        counter.setName(Counter.class.getName());
        counter.setCurrentId(this._counter.get());
        counters.add(counter);
        counter = new CounterImpl();
        counter.setName(ResourcePermission.class.getName());
        counter.setCurrentId(this._resourcePermissionCounter.get());
        counters.add(counter);
        counter = new CounterImpl();
        counter.setName(SocialActivity.class.getName());
        counter.setCurrentId(this._socialActivityCounter.get());
        counters.add(counter);
        return counters;
    }

    public DDMStructure newDDLDDMStructure(long groupId) {
        StringBundler sb = new StringBundler(3 + this._maxDDLCustomFieldCount * 10);
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<root available-locales=\"en_US\" default-locale=\"en_US\">");
        int i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append("<dynamic-element dataType=\"string\" indexType=\"keyword\"");
            sb.append(" name=\"");
            sb.append(this.nextDDLCustomFieldName(groupId, i2));
            sb.append("\" readOnly=\"false\" repeatable=\"false\" required=\"false");
            sb.append("\" showLabel=\"true\" type=\"text\" width=\"25\"><meta-data");
            sb.append(" locale=\"en_US\"><entry name=\"label\"><![CDATA[Text");
            sb.append(i2);
            sb.append("]]></entry><entry name=\"predefinedValue\"><![CDATA[]]>");
            sb.append("</entry><entry name=\"tip\"><![CDATA[]]></entry>");
            sb.append("</meta-data></dynamic-element>");
            ++i2;
        }
        sb.append("</root>");
        return this.newDDMStructure(groupId, this._classNamesMap.get(DDLRecordSet.class.getName()), "Test DDM Structure", sb.toString());
    }

    public DDLRecord newDDLRecord(DDLRecordSet ddlRecordSet) {
        DDLRecordImpl ddlRecord = new DDLRecordImpl();
        ddlRecord.setUuid(SequentialUUID.generate());
        ddlRecord.setRecordId(this._counter.get());
        ddlRecord.setGroupId(ddlRecordSet.getGroupId());
        ddlRecord.setCompanyId(this._companyId);
        ddlRecord.setUserId(this._sampleUserId);
        ddlRecord.setUserName(_SAMPLE_USER_NAME);
        ddlRecord.setVersionUserId(this._sampleUserId);
        ddlRecord.setVersionUserName(_SAMPLE_USER_NAME);
        ddlRecord.setCreateDate(new Date());
        ddlRecord.setModifiedDate(new Date());
        ddlRecord.setDDMStorageId(this._counter.get());
        ddlRecord.setRecordSetId(ddlRecordSet.getRecordSetId());
        ddlRecord.setVersion("1.0");
        ddlRecord.setDisplayIndex(0);
        return ddlRecord;
    }

    public DDLRecordSet newDDLRecordSet(DDMStructure ddmStructure, int currentIndex) {
        DDLRecordSetImpl ddlRecordSet = new DDLRecordSetImpl();
        ddlRecordSet.setUuid(SequentialUUID.generate());
        ddlRecordSet.setRecordSetId(this._counter.get());
        ddlRecordSet.setGroupId(ddmStructure.getGroupId());
        ddlRecordSet.setCompanyId(this._companyId);
        ddlRecordSet.setUserId(this._sampleUserId);
        ddlRecordSet.setUserName(_SAMPLE_USER_NAME);
        ddlRecordSet.setCreateDate(new Date());
        ddlRecordSet.setModifiedDate(new Date());
        ddlRecordSet.setDDMStructureId(ddmStructure.getStructureId());
        ddlRecordSet.setRecordSetKey(String.valueOf(this._counter.get()));
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Name language-id=\"en_US\">Test DDL Record Set ");
        sb.append(currentIndex);
        sb.append("</Name></root>");
        ddlRecordSet.setName(sb.toString());
        ddlRecordSet.setMinDisplayRows(20);
        ddlRecordSet.setScope(0);
        return ddlRecordSet;
    }

    public DDLRecordVersion newDDLRecordVersion(DDLRecord ddlRecord) {
        DDLRecordVersionImpl ddlRecordVersion = new DDLRecordVersionImpl();
        ddlRecordVersion.setRecordVersionId(this._counter.get());
        ddlRecordVersion.setGroupId(ddlRecord.getGroupId());
        ddlRecordVersion.setCompanyId(this._companyId);
        ddlRecordVersion.setUserId(this._sampleUserId);
        ddlRecordVersion.setUserName(_SAMPLE_USER_NAME);
        ddlRecordVersion.setCreateDate(ddlRecord.getModifiedDate());
        ddlRecordVersion.setDDMStorageId(ddlRecord.getDDMStorageId());
        ddlRecordVersion.setRecordSetId(ddlRecord.getRecordSetId());
        ddlRecordVersion.setRecordId(ddlRecord.getRecordId());
        ddlRecordVersion.setVersion(ddlRecord.getVersion());
        ddlRecordVersion.setDisplayIndex(ddlRecord.getDisplayIndex());
        ddlRecordVersion.setStatus(0);
        ddlRecordVersion.setStatusDate(ddlRecord.getModifiedDate());
        return ddlRecordVersion;
    }

    public DDMContent newDDMContent(DDLRecord ddlRecord, int currentIndex) {
        StringBundler sb = new StringBundler(3 + this._maxDDLCustomFieldCount * 10);
        sb.append("<?xml version=\"1.0\"?><root>");
        int i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append("<dynamic-element default-language-id=\"en_US\" name=\"");
            sb.append(this.nextDDLCustomFieldName(ddlRecord.getGroupId(), i2));
            sb.append("\"><dynamic-content language-id=\"en_US\">");
            sb.append("<![CDATA[Test Record ");
            sb.append(currentIndex);
            sb.append("]]></dynamic-content></dynamic-element>");
            ++i2;
        }
        sb.append("<dynamic-element default-language-id=\"en_US\" name=\"_");
        sb.append("fieldsDisplay\"><dynamic-content language-id=\"en_US\"><![CDATA[");
        i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append(this.nextDDLCustomFieldName(ddlRecord.getGroupId(), i2));
            sb.append("_INSTANCE_");
            sb.append(PwdGenerator.getPassword((int)4));
            sb.append(",");
            ++i2;
        }
        sb.setStringAt("]]></dynamic-content></dynamic-element></root>", sb.index() - 1);
        return this.newDDMContent(ddlRecord.getDDMStorageId(), ddlRecord.getGroupId(), sb.toString());
    }

    public DDMContent newDDMContent(DLFileEntry dlFileEntry) {
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\"?><root><dynamic-element ");
        sb.append("name=\"CONTENT_TYPE\"><dynamic-content>");
        sb.append("<![CDATA[text/plain]]></dynamic-content></dynamic-element>");
        sb.append("<dynamic-element <![CDATA[ISO-8859-1]]></dynamic-content>");
        sb.append("</dynamic-element></root>");
        return this.newDDMContent(this._counter.get(), dlFileEntry.getGroupId(), sb.toString());
    }

    public DDMStorageLink newDDMStorageLink(long ddmStorageLinkId, DDMContent ddmContent, long structureId) {
        DDMStorageLinkImpl ddmStorageLink = new DDMStorageLinkImpl();
        ddmStorageLink.setUuid(SequentialUUID.generate());
        ddmStorageLink.setStorageLinkId(ddmStorageLinkId);
        ddmStorageLink.setClassNameId(this._classNamesMap.get(DDMContent.class.getName()));
        ddmStorageLink.setClassPK(ddmContent.getContentId());
        ddmStorageLink.setStructureId(structureId);
        return ddmStorageLink;
    }

    public DDMStructureLink newDDMStructureLink(DDLRecordSet ddlRecordSet) {
        return this.newDDMStructureLink(this._classNamesMap.get(DDLRecordSet.class.getName()), ddlRecordSet.getRecordSetId(), ddlRecordSet.getDDMStructureId());
    }

    public DDMStructureLink newDDMStructureLink(DLFileEntryMetadata dLFileEntryMetadata) {
        return this.newDDMStructureLink(this._classNamesMap.get(DLFileEntryMetadata.class.getName()), dLFileEntryMetadata.getFileEntryMetadataId(), dLFileEntryMetadata.getDDMStructureId());
    }

    public DLFileEntry newDlFileEntry(DLFolder dlFoler, int index) {
        DLFileEntryImpl dlFileEntry = new DLFileEntryImpl();
        dlFileEntry.setUuid(SequentialUUID.generate());
        dlFileEntry.setFileEntryId(this._counter.get());
        dlFileEntry.setGroupId(dlFoler.getGroupId());
        dlFileEntry.setCompanyId(this._companyId);
        dlFileEntry.setUserId(this._sampleUserId);
        dlFileEntry.setUserName(_SAMPLE_USER_NAME);
        dlFileEntry.setVersionUserId(this._sampleUserId);
        dlFileEntry.setVersionUserName(_SAMPLE_USER_NAME);
        dlFileEntry.setCreateDate(this.nextFutureDate());
        dlFileEntry.setModifiedDate(this.nextFutureDate());
        dlFileEntry.setRepositoryId(dlFoler.getRepositoryId());
        dlFileEntry.setFolderId(dlFoler.getFolderId());
        dlFileEntry.setName("TestFile" + index);
        dlFileEntry.setExtension("txt");
        dlFileEntry.setMimeType("text/plain");
        dlFileEntry.setTitle("TestFile" + index + ".txt");
        dlFileEntry.setFileEntryTypeId(0L);
        dlFileEntry.setVersion("1.0");
        dlFileEntry.setSize(this._maxDLFileEntrySize);
        return dlFileEntry;
    }

    public DLFileEntryMetadata newDLFileEntryMetadata(long ddmStorageLinkId, long ddmStructureId, DLFileVersion dlFileVersion) {
        DLFileEntryMetadataImpl dlFileEntryMetadata = new DLFileEntryMetadataImpl();
        dlFileEntryMetadata.setUuid(SequentialUUID.generate());
        dlFileEntryMetadata.setFileEntryMetadataId(this._counter.get());
        dlFileEntryMetadata.setDDMStorageId(ddmStorageLinkId);
        dlFileEntryMetadata.setDDMStructureId(ddmStructureId);
        dlFileEntryMetadata.setFileEntryTypeId(dlFileVersion.getFileEntryTypeId());
        dlFileEntryMetadata.setFileEntryId(dlFileVersion.getFileEntryId());
        dlFileEntryMetadata.setFileVersionId(dlFileVersion.getFileVersionId());
        return dlFileEntryMetadata;
    }

    public DLFileVersion newDLFileVersion(DLFileEntry dlFileEntry) {
        DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
        dlFileVersion.setUuid(SequentialUUID.generate());
        dlFileVersion.setFileVersionId(this._counter.get());
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(this._companyId);
        dlFileVersion.setUserId(this._sampleUserId);
        dlFileVersion.setUserName(_SAMPLE_USER_NAME);
        dlFileVersion.setCreateDate(this.nextFutureDate());
        dlFileVersion.setModifiedDate(this.nextFutureDate());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(dlFileEntry.getExtension());
        dlFileVersion.setMimeType(dlFileEntry.getMimeType());
        dlFileVersion.setTitle(dlFileEntry.getTitle());
        dlFileVersion.setFileEntryTypeId(dlFileEntry.getFileEntryTypeId());
        dlFileVersion.setVersion(dlFileEntry.getVersion());
        dlFileVersion.setSize(dlFileEntry.getSize());
        return dlFileVersion;
    }

    public DLFolder newDLFolder(long groupId, long parentFolderId, int index) {
        DLFolderImpl dlFolder = new DLFolderImpl();
        dlFolder.setUuid(SequentialUUID.generate());
        dlFolder.setFolderId(this._counter.get());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(this._companyId);
        dlFolder.setUserId(this._sampleUserId);
        dlFolder.setUserName(_SAMPLE_USER_NAME);
        dlFolder.setCreateDate(this.nextFutureDate());
        dlFolder.setModifiedDate(this.nextFutureDate());
        dlFolder.setRepositoryId(groupId);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setName("Test Folder " + index);
        dlFolder.setLastPostDate(this.nextFutureDate());
        dlFolder.setDefaultFileEntryTypeId(this._defaultDLFileEntryType.getFileEntryTypeId());
        dlFolder.setStatusDate(this.nextFutureDate());
        return dlFolder;
    }

    public Group newGroup(User user) throws Exception {
        return this.newGroup(this._counter.get(), this._classNamesMap.get(User.class.getName()), user.getUserId(), user.getScreenName(), false);
    }

    public IntegerWrapper newInteger() {
        return new IntegerWrapper();
    }

    public JournalArticle newJournalArticle(JournalArticleResource journalArticleResource, int articleIndex, int versionIndex) {
        JournalArticleImpl journalArticle = new JournalArticleImpl();
        journalArticle.setUuid(SequentialUUID.generate());
        journalArticle.setId(this._counter.get());
        journalArticle.setResourcePrimKey(journalArticleResource.getResourcePrimKey());
        journalArticle.setGroupId(journalArticleResource.getGroupId());
        journalArticle.setCompanyId(this._companyId);
        journalArticle.setUserId(this._sampleUserId);
        journalArticle.setUserName(_SAMPLE_USER_NAME);
        journalArticle.setCreateDate(new Date());
        journalArticle.setModifiedDate(new Date());
        journalArticle.setClassNameId(0L);
        journalArticle.setArticleId(journalArticleResource.getArticleId());
        journalArticle.setVersion(versionIndex);
        StringBundler sb = new StringBundler(4);
        sb.append("TestJournalArticle_");
        sb.append(articleIndex);
        sb.append("_");
        sb.append(versionIndex);
        String urlTitle = sb.toString();
        sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(urlTitle);
        sb.append("</Title></root>");
        String title = sb.toString();
        journalArticle.setTitle(title);
        journalArticle.setUrlTitle(urlTitle);
        journalArticle.setContent(this._journalArticleContent);
        journalArticle.setType("general");
        journalArticle.setDisplayDate(new Date());
        journalArticle.setExpirationDate(this.nextFutureDate());
        journalArticle.setReviewDate(new Date());
        journalArticle.setIndexable(true);
        journalArticle.setStatusDate(new Date());
        return journalArticle;
    }

    public JournalArticleResource newJournalArticleResource(long groupId) {
        JournalArticleResourceImpl journalArticleResource = new JournalArticleResourceImpl();
        journalArticleResource.setUuid(SequentialUUID.generate());
        journalArticleResource.setResourcePrimKey(this._counter.get());
        journalArticleResource.setGroupId(groupId);
        journalArticleResource.setArticleId(String.valueOf(this._counter.get()));
        return journalArticleResource;
    }

    public JournalContentSearch newJournalContentSearch(JournalArticle journalArticle, long layoutId) {
        JournalContentSearchImpl journalContentSearch = new JournalContentSearchImpl();
        journalContentSearch.setContentSearchId(this._counter.get());
        journalContentSearch.setGroupId(journalArticle.getGroupId());
        journalContentSearch.setCompanyId(this._companyId);
        journalContentSearch.setLayoutId(layoutId);
        journalContentSearch.setPortletId("56");
        journalContentSearch.setArticleId(journalArticle.getArticleId());
        return journalContentSearch;
    }

    public Layout newLayout(long groupId, String name, String column1, String column2) {
        SimpleCounter simpleCounter = this._layoutCounters.get(groupId);
        if (simpleCounter == null) {
            simpleCounter = new SimpleCounter();
            this._layoutCounters.put(groupId, simpleCounter);
        }
        LayoutImpl layout = new LayoutImpl();
        layout.setUuid(SequentialUUID.generate());
        layout.setPlid(this._counter.get());
        layout.setGroupId(groupId);
        layout.setCompanyId(this._companyId);
        layout.setUserId(this._sampleUserId);
        layout.setUserName(_SAMPLE_USER_NAME);
        layout.setCreateDate(new Date());
        layout.setModifiedDate(new Date());
        layout.setLayoutId(simpleCounter.get());
        layout.setName("<?xml version=\"1.0\"?><root><name>" + name + "</name></root>");
        layout.setType("portlet");
        layout.setFriendlyURL("/" + name);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.setProperty("layout-template-id", "2_columns_ii");
        typeSettingsProperties.setProperty("column-1", column1);
        typeSettingsProperties.setProperty("column-2", column2);
        String typeSettings = StringUtil.replace((String)typeSettingsProperties.toString(), (String)"\n", (String)"\\n");
        layout.setTypeSettings(typeSettings);
        return layout;
    }

    public LayoutFriendlyURL newLayoutFriendlyURL(Layout layout) {
        LayoutFriendlyURLImpl layoutFriendlyURL = new LayoutFriendlyURLImpl();
        layoutFriendlyURL.setUuid(SequentialUUID.generate());
        layoutFriendlyURL.setLayoutFriendlyURLId(this._counter.get());
        layoutFriendlyURL.setGroupId(layout.getGroupId());
        layoutFriendlyURL.setCompanyId(this._companyId);
        layoutFriendlyURL.setUserId(this._sampleUserId);
        layoutFriendlyURL.setUserName(_SAMPLE_USER_NAME);
        layoutFriendlyURL.setCreateDate(new Date());
        layoutFriendlyURL.setModifiedDate(new Date());
        layoutFriendlyURL.setPlid(layout.getPlid());
        layoutFriendlyURL.setFriendlyURL(layout.getFriendlyURL());
        layoutFriendlyURL.setLanguageId("en_US");
        return layoutFriendlyURL;
    }

    public List<LayoutSet> newLayoutSets(long groupId, int publicLayoutSetPageCount) {
        ArrayList<LayoutSet> layoutSets = new ArrayList<LayoutSet>(2);
        layoutSets.add(this.newLayoutSet(groupId, true, 0));
        layoutSets.add(this.newLayoutSet(groupId, false, publicLayoutSetPageCount));
        return layoutSets;
    }

    public MBCategory newMBCategory(long groupId, int index) {
        MBCategoryImpl mbCategory = new MBCategoryImpl();
        mbCategory.setUuid(SequentialUUID.generate());
        mbCategory.setCategoryId(this._counter.get());
        mbCategory.setGroupId(groupId);
        mbCategory.setCompanyId(this._companyId);
        mbCategory.setUserId(this._sampleUserId);
        mbCategory.setUserName(_SAMPLE_USER_NAME);
        mbCategory.setCreateDate(new Date());
        mbCategory.setModifiedDate(new Date());
        mbCategory.setParentCategoryId(0L);
        mbCategory.setName("Test Category " + index);
        mbCategory.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        mbCategory.setThreadCount(this._maxMBThreadCount);
        mbCategory.setMessageCount(this._maxMBThreadCount * this._maxMBMessageCount);
        mbCategory.setLastPostDate(new Date());
        mbCategory.setStatusDate(new Date());
        return mbCategory;
    }

    public MBDiscussion newMBDiscussion(long groupId, long classNameId, long classPK, long threadId) {
        MBDiscussionImpl mbDiscussion = new MBDiscussionImpl();
        mbDiscussion.setUuid(SequentialUUID.generate());
        mbDiscussion.setDiscussionId(this._counter.get());
        mbDiscussion.setGroupId(groupId);
        mbDiscussion.setCompanyId(this._companyId);
        mbDiscussion.setUserId(this._sampleUserId);
        mbDiscussion.setUserName(_SAMPLE_USER_NAME);
        mbDiscussion.setCreateDate(new Date());
        mbDiscussion.setModifiedDate(new Date());
        mbDiscussion.setClassNameId(classNameId);
        mbDiscussion.setClassPK(classPK);
        mbDiscussion.setThreadId(threadId);
        return mbDiscussion;
    }

    public MBMailingList newMBMailingList(MBCategory mbCategory) {
        MBMailingListImpl mbMailingList = new MBMailingListImpl();
        mbMailingList.setUuid(SequentialUUID.generate());
        mbMailingList.setMailingListId(this._counter.get());
        mbMailingList.setGroupId(mbCategory.getGroupId());
        mbMailingList.setCompanyId(this._companyId);
        mbMailingList.setUserId(this._sampleUserId);
        mbMailingList.setUserName(_SAMPLE_USER_NAME);
        mbMailingList.setCreateDate(new Date());
        mbMailingList.setModifiedDate(new Date());
        mbMailingList.setCategoryId(mbCategory.getCategoryId());
        mbMailingList.setInProtocol("pop3");
        mbMailingList.setInServerPort(110);
        mbMailingList.setInUserName(this._sampleUser.getEmailAddress());
        mbMailingList.setInPassword(this._sampleUser.getPassword());
        mbMailingList.setInReadInterval(5);
        mbMailingList.setOutServerPort(25);
        return mbMailingList;
    }

    public MBMessage newMBMessage(MBThread mbThread, int index) {
        long messageId = 0L;
        long parentMessageId = 0L;
        if (index == 1) {
            messageId = mbThread.getRootMessageId();
            parentMessageId = 0L;
        } else {
            messageId = this._counter.get();
            parentMessageId = mbThread.getRootMessageId();
        }
        return this.newMBMessage(mbThread.getGroupId(), 0L, 0L, mbThread.getCategoryId(), mbThread.getThreadId(), messageId, mbThread.getRootMessageId(), parentMessageId, "Test Message " + index, "This is test message " + index + ".");
    }

    public MBMessage newMBMessage(MBThread mbThread, long classNameId, long classPK, int index) {
        long messageId = 0L;
        long parentMessageId = 0L;
        String subject = null;
        String body = null;
        if (index == 0) {
            messageId = mbThread.getRootMessageId();
            parentMessageId = 0L;
            subject = String.valueOf(classPK);
            body = String.valueOf(classPK);
        } else {
            messageId = this._counter.get();
            parentMessageId = mbThread.getRootMessageId();
            subject = "N/A";
            body = "This is test comment " + index + ".";
        }
        return this.newMBMessage(mbThread.getGroupId(), classNameId, classPK, -1L, mbThread.getThreadId(), messageId, mbThread.getRootMessageId(), parentMessageId, subject, body);
    }

    public MBStatsUser newMBStatsUser(long groupId) {
        MBStatsUserImpl mbStatsUser = new MBStatsUserImpl();
        mbStatsUser.setStatsUserId(this._counter.get());
        mbStatsUser.setGroupId(groupId);
        mbStatsUser.setUserId(this._sampleUserId);
        mbStatsUser.setMessageCount(this._maxMBCategoryCount * this._maxMBThreadCount * this._maxMBMessageCount);
        mbStatsUser.setLastPostDate(new Date());
        return mbStatsUser;
    }

    public MBThread newMBThread(long threadId, long groupId, long rootMessageId, int messageCount) {
        if (messageCount == 0) {
            messageCount = 1;
        }
        return this.newMBThread(threadId, groupId, -1L, rootMessageId, messageCount);
    }

    public MBThread newMBThread(MBCategory mbCategory) {
        return this.newMBThread(this._counter.get(), mbCategory.getGroupId(), mbCategory.getCategoryId(), this._counter.get(), this._maxMBMessageCount);
    }

    public MBThreadFlag newMBThreadFlag(MBThread mbThread) {
        MBThreadFlagImpl mbThreadFlag = new MBThreadFlagImpl();
        mbThreadFlag.setUuid(SequentialUUID.generate());
        mbThreadFlag.setThreadFlagId(this._counter.get());
        mbThreadFlag.setGroupId(mbThread.getGroupId());
        mbThreadFlag.setCompanyId(this._companyId);
        mbThreadFlag.setUserId(this._sampleUserId);
        mbThreadFlag.setUserName(_SAMPLE_USER_NAME);
        mbThreadFlag.setCreateDate(new Date());
        mbThreadFlag.setModifiedDate(new Date());
        mbThreadFlag.setThreadId(mbThread.getThreadId());
        return mbThreadFlag;
    }

    public List<com.liferay.portal.model.PortletPreferences> newPortletPreferences(long plid) {
        ArrayList<com.liferay.portal.model.PortletPreferences> portletPreferencesList = new ArrayList<com.liferay.portal.model.PortletPreferences>(2);
        portletPreferencesList.add(this.newPortletPreferences(plid, "145", "<portlet-preferences />"));
        portletPreferencesList.add(this.newPortletPreferences(plid, "86", "<portlet-preferences />"));
        return portletPreferencesList;
    }

    public com.liferay.portal.model.PortletPreferences newPortletPreferences(long plid, String portletId, DDLRecordSet ddlRecordSet) throws Exception {
        com.liferay.portlet.PortletPreferencesImpl jxPreferences = new com.liferay.portlet.PortletPreferencesImpl();
        jxPreferences.setValue("editable", "true");
        jxPreferences.setValue("recordSetId", String.valueOf(ddlRecordSet.getRecordSetId()));
        jxPreferences.setValue("spreadsheet", "false");
        return this.newPortletPreferences(plid, portletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPreferences));
    }

    public com.liferay.portal.model.PortletPreferences newPortletPreferences(long plid, String portletId, JournalArticleResource journalArticleResource) throws Exception {
        com.liferay.portlet.PortletPreferencesImpl jxPreferences = new com.liferay.portlet.PortletPreferencesImpl();
        jxPreferences.setValue("articleId", journalArticleResource.getArticleId());
        jxPreferences.setValue("enableCommentRatings", "false");
        jxPreferences.setValue("enableComments", "false");
        jxPreferences.setValue("enablePrint", "false");
        jxPreferences.setValue("enableRatings", "false");
        jxPreferences.setValue("enableRelatedAssets", "true");
        jxPreferences.setValue("enableViewCountIncrement", "false");
        jxPreferences.setValue("groupId", String.valueOf(journalArticleResource.getGroupId()));
        jxPreferences.setValue("showAvailableLocales", "false");
        return this.newPortletPreferences(plid, portletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPreferences));
    }

    public List<Layout> newPublicLayouts(long groupId) {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(this.newLayout(groupId, "welcome", "58,", "47,"));
        layouts.add(this.newLayout(groupId, "blogs", "", "33,"));
        layouts.add(this.newLayout(groupId, "document_library", "", "20,"));
        layouts.add(this.newLayout(groupId, "forums", "", "19,"));
        layouts.add(this.newLayout(groupId, "wiki", "", "36,"));
        return layouts;
    }

    public List<ResourcePermission> newResourcePermissions(AssetCategory assetCategory) {
        return this.newResourcePermissions(AssetCategory.class.getName(), String.valueOf(assetCategory.getCategoryId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(AssetTag assetTag) {
        return this.newResourcePermissions(AssetTag.class.getName(), String.valueOf(assetTag.getTagId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(AssetVocabulary assetVocabulary) {
        if (assetVocabulary.getUserId() == this._defaultUserId) {
            ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>(1);
            resourcePermissions.add(this.newResourcePermission(AssetVocabulary.class.getName(), String.valueOf(assetVocabulary.getVocabularyId()), this._ownerRole.getRoleId(), this._defaultUserId));
            return resourcePermissions;
        }
        return this.newResourcePermissions(AssetVocabulary.class.getName(), String.valueOf(assetVocabulary.getVocabularyId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(BlogsEntry blogsEntry) {
        return this.newResourcePermissions(BlogsEntry.class.getName(), String.valueOf(blogsEntry.getEntryId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(DDLRecordSet ddlRecordSet) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>(1);
        resourcePermissions.add(this.newResourcePermission(DDLRecordSet.class.getName(), String.valueOf(ddlRecordSet.getRecordSetId()), this._ownerRole.getRoleId(), this._defaultUserId));
        return resourcePermissions;
    }

    public List<ResourcePermission> newResourcePermissions(DDMStructure ddmStructure) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>(1);
        resourcePermissions.add(this.newResourcePermission(DDMStructure.class.getName(), String.valueOf(ddmStructure.getStructureId()), this._ownerRole.getRoleId(), this._defaultUserId));
        return resourcePermissions;
    }

    public List<ResourcePermission> newResourcePermissions(DLFileEntry dlFileEntry) {
        return this.newResourcePermissions(DLFileEntry.class.getName(), String.valueOf(dlFileEntry.getFileEntryId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(DLFolder dlFolder) {
        return this.newResourcePermissions(DLFolder.class.getName(), String.valueOf(dlFolder.getFolderId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(JournalArticleResource journalArticleResource) {
        return this.newResourcePermissions(JournalArticle.class.getName(), String.valueOf(journalArticleResource.getResourcePrimKey()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(Layout layout) {
        return this.newResourcePermissions(Layout.class.getName(), String.valueOf(layout.getPlid()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(MBCategory mbCategory) {
        return this.newResourcePermissions(MBCategory.class.getName(), String.valueOf(mbCategory.getCategoryId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(MBMessage mbMessage) {
        return this.newResourcePermissions(MBMessage.class.getName(), String.valueOf(mbMessage.getMessageId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(com.liferay.portal.model.PortletPreferences portletPreferences) {
        String portletId;
        String name = portletId = portletPreferences.getPortletId();
        int index = portletId.indexOf("_");
        if (index > 0) {
            name = portletId.substring(0, index);
        }
        String primKey = PortletPermissionUtil.getPrimaryKey((long)portletPreferences.getPlid(), (String)portletId);
        return this.newResourcePermissions(name, primKey, 0L);
    }

    public List<ResourcePermission> newResourcePermissions(WikiNode wikiNode) {
        return this.newResourcePermissions(WikiNode.class.getName(), String.valueOf(wikiNode.getNodeId()), this._sampleUserId);
    }

    public List<ResourcePermission> newResourcePermissions(WikiPage wikiPage) {
        return this.newResourcePermissions(WikiPage.class.getName(), String.valueOf(wikiPage.getResourcePrimKey()), this._sampleUserId);
    }

    public SocialActivity newSocialActivity(BlogsEntry blogsEntry) {
        return this.newSocialActivity(blogsEntry.getGroupId(), this._classNamesMap.get(BlogsEntry.class.getName()), blogsEntry.getEntryId(), 2, "{\"title\":\"" + blogsEntry.getTitle() + "\"}");
    }

    public SocialActivity newSocialActivity(DLFileEntry dlFileEntry) {
        return this.newSocialActivity(dlFileEntry.getGroupId(), this.getDLFileEntryClassNameId(), dlFileEntry.getFileEntryId(), 1, "");
    }

    public SocialActivity newSocialActivity(JournalArticle journalArticle) {
        int type = 2;
        if (journalArticle.getVersion() == 1.0) {
            type = 1;
        }
        return this.newSocialActivity(journalArticle.getGroupId(), this.getJournalArticleClassNameId(), journalArticle.getResourcePrimKey(), type, "{\"title\":\"" + journalArticle.getUrlTitle() + "\"}");
    }

    public SocialActivity newSocialActivity(MBMessage mbMessage) {
        long classNameId = mbMessage.getClassNameId();
        long classPk = mbMessage.getClassPK();
        int type = 0;
        String extraData = null;
        if (classNameId == this._classNamesMap.get(WikiPage.class.getName())) {
            extraData = "{\"version\":1}";
            type = 1;
        } else if (classNameId == 0L) {
            extraData = "{\"title\":\"" + mbMessage.getSubject() + "\"}";
            type = 1;
            classNameId = this._classNamesMap.get(MBMessage.class.getName());
            classPk = mbMessage.getMessageId();
        } else {
            StringBundler sb = new StringBundler(5);
            sb.append("{\"messageId\":\"");
            sb.append(mbMessage.getMessageId());
            sb.append("\", \"title\":");
            sb.append(mbMessage.getSubject());
            sb.append("}");
            extraData = sb.toString();
            type = 10005;
        }
        return this.newSocialActivity(mbMessage.getGroupId(), classNameId, classPk, type, extraData);
    }

    public Subscription newSubscription(BlogsEntry blogsEntry) {
        return this.newSubscription(this._classNamesMap.get(BlogsEntry.class.getName()), blogsEntry.getEntryId());
    }

    public Subscription newSubscription(MBThread mbThread) {
        return this.newSubscription(this._classNamesMap.get(MBThread.class.getName()), mbThread.getThreadId());
    }

    public Subscription newSubscription(WikiPage wikiPage) {
        return this.newSubscription(this._classNamesMap.get(WikiPage.class.getName()), wikiPage.getResourcePrimKey());
    }

    public User newUser(int index) {
        String[] userName = this.nextUserName(index - 1);
        return this.newUser(this._counter.get(), userName[0], userName[1], "test" + this._userScreenNameCounter.get(), false);
    }

    public WikiNode newWikiNode(long groupId, int index) {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setUuid(SequentialUUID.generate());
        wikiNode.setNodeId(this._counter.get());
        wikiNode.setGroupId(groupId);
        wikiNode.setCompanyId(this._companyId);
        wikiNode.setUserId(this._sampleUserId);
        wikiNode.setUserName(_SAMPLE_USER_NAME);
        wikiNode.setCreateDate(new Date());
        wikiNode.setModifiedDate(new Date());
        wikiNode.setName("Test Node " + index);
        wikiNode.setLastPostDate(new Date());
        wikiNode.setStatusDate(new Date());
        return wikiNode;
    }

    public WikiPage newWikiPage(WikiNode wikiNode, int index) {
        WikiPageImpl wikiPage = new WikiPageImpl();
        wikiPage.setUuid(SequentialUUID.generate());
        wikiPage.setPageId(this._counter.get());
        wikiPage.setResourcePrimKey(this._counter.get());
        wikiPage.setGroupId(wikiNode.getGroupId());
        wikiPage.setCompanyId(this._companyId);
        wikiPage.setUserId(this._sampleUserId);
        wikiPage.setUserName(_SAMPLE_USER_NAME);
        wikiPage.setCreateDate(new Date());
        wikiPage.setModifiedDate(new Date());
        wikiPage.setNodeId(wikiNode.getNodeId());
        wikiPage.setTitle("Test Page " + index);
        wikiPage.setVersion(1.0);
        wikiPage.setContent("This is test page " + index + ".");
        wikiPage.setFormat(WikiPageConstants.DEFAULT_FORMAT);
        wikiPage.setHead(true);
        return wikiPage;
    }

    public WikiPageResource newWikiPageResource(WikiPage wikiPage) {
        WikiPageResourceImpl wikiPageResource = new WikiPageResourceImpl();
        wikiPageResource.setUuid(SequentialUUID.generate());
        wikiPageResource.setResourcePrimKey(wikiPage.getResourcePrimKey());
        wikiPageResource.setNodeId(wikiPage.getNodeId());
        wikiPageResource.setTitle(wikiPage.getTitle());
        return wikiPageResource;
    }

    public String[] nextUserName(long index) {
        String[] userName = new String[]{this._firstNames.get((int)(index / (long)this._lastNames.size()) % this._firstNames.size()), this._lastNames.get((int)(index % (long)this._lastNames.size()))};
        return userName;
    }

    protected AssetCategory newAssetCategory(long groupId, long lastRightCategoryId, String name, long vocabularyId) {
        AssetCategoryImpl assetCategory = new AssetCategoryImpl();
        assetCategory.setUuid(SequentialUUID.generate());
        assetCategory.setCategoryId(this._counter.get());
        assetCategory.setGroupId(groupId);
        assetCategory.setCompanyId(this._companyId);
        assetCategory.setUserId(this._sampleUserId);
        assetCategory.setUserName(_SAMPLE_USER_NAME);
        assetCategory.setCreateDate(new Date());
        assetCategory.setModifiedDate(new Date());
        assetCategory.setParentCategoryId(0L);
        assetCategory.setLeftCategoryId(lastRightCategoryId++);
        assetCategory.setRightCategoryId(lastRightCategoryId++);
        assetCategory.setName(name);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(name);
        sb.append("</Title></root>");
        assetCategory.setTitle(sb.toString());
        assetCategory.setVocabularyId(vocabularyId);
        return assetCategory;
    }

    protected AssetEntry newAssetEntry(long groupId, Date createDate, Date modifiedDate, long classNameId, long classPK, String uuid, long classTypeId, boolean visible, String mimeType, String title) {
        AssetEntryImpl assetEntry = new AssetEntryImpl();
        assetEntry.setEntryId(this._counter.get());
        assetEntry.setGroupId(groupId);
        assetEntry.setCompanyId(this._companyId);
        assetEntry.setUserId(this._sampleUserId);
        assetEntry.setUserName(_SAMPLE_USER_NAME);
        assetEntry.setCreateDate(createDate);
        assetEntry.setModifiedDate(modifiedDate);
        assetEntry.setClassNameId(classNameId);
        assetEntry.setClassPK(classPK);
        assetEntry.setClassUuid(uuid);
        assetEntry.setClassTypeId(classTypeId);
        assetEntry.setVisible(visible);
        assetEntry.setStartDate(createDate);
        assetEntry.setEndDate(this.nextFutureDate());
        assetEntry.setPublishDate(createDate);
        assetEntry.setExpirationDate(this.nextFutureDate());
        assetEntry.setMimeType(mimeType);
        assetEntry.setTitle(title);
        return assetEntry;
    }

    protected AssetTagStats newAssetTagStats(long tagId, long classNameId) {
        AssetTagStatsImpl assetTagStats = new AssetTagStatsImpl();
        assetTagStats.setTagStatsId(this._counter.get());
        assetTagStats.setTagId(tagId);
        assetTagStats.setClassNameId(classNameId);
        return assetTagStats;
    }

    protected AssetVocabulary newAssetVocabulary(long grouId, long userId, String userName, String name) {
        AssetVocabularyImpl assetVocabulary = new AssetVocabularyImpl();
        assetVocabulary.setUuid(SequentialUUID.generate());
        assetVocabulary.setVocabularyId(this._counter.get());
        assetVocabulary.setGroupId(grouId);
        assetVocabulary.setCompanyId(this._companyId);
        assetVocabulary.setUserId(userId);
        assetVocabulary.setUserName(userName);
        assetVocabulary.setCreateDate(new Date());
        assetVocabulary.setModifiedDate(new Date());
        assetVocabulary.setName(name);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(name);
        sb.append("</Title></root>");
        assetVocabulary.setTitle(sb.toString());
        assetVocabulary.setSettings("multiValued=true\\nselectedClassNameIds=0");
        return assetVocabulary;
    }

    protected DDMContent newDDMContent(long contentId, long groupId, String xml) {
        DDMContentImpl ddmContent = new DDMContentImpl();
        ddmContent.setUuid(SequentialUUID.generate());
        ddmContent.setContentId(contentId);
        ddmContent.setGroupId(groupId);
        ddmContent.setCompanyId(this._companyId);
        ddmContent.setUserId(this._sampleUserId);
        ddmContent.setUserName(_SAMPLE_USER_NAME);
        ddmContent.setCreateDate(this.nextFutureDate());
        ddmContent.setModifiedDate(this.nextFutureDate());
        ddmContent.setName(DDMStorageLink.class.getName());
        ddmContent.setXml(xml);
        return ddmContent;
    }

    protected DDMStructure newDDMStructure(long groupId, long classNameId, String structureKey, String xsd) {
        DDMStructureImpl ddmStructure = new DDMStructureImpl();
        ddmStructure.setUuid(SequentialUUID.generate());
        ddmStructure.setStructureId(this._counter.get());
        ddmStructure.setGroupId(groupId);
        ddmStructure.setCompanyId(this._companyId);
        ddmStructure.setUserId(this._sampleUserId);
        ddmStructure.setUserName(_SAMPLE_USER_NAME);
        ddmStructure.setCreateDate(this.nextFutureDate());
        ddmStructure.setModifiedDate(this.nextFutureDate());
        ddmStructure.setClassNameId(classNameId);
        ddmStructure.setStructureKey(structureKey);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Name language-id=\"en_US\">");
        sb.append(structureKey);
        sb.append("</Name></root>");
        ddmStructure.setName(sb.toString());
        ddmStructure.setXsd(xsd);
        ddmStructure.setStorageType("xml");
        return ddmStructure;
    }

    protected DDMStructureLink newDDMStructureLink(long classNameId, long classPK, long structureId) {
        DDMStructureLinkImpl ddmStructureLink = new DDMStructureLinkImpl();
        ddmStructureLink.setStructureLinkId(this._counter.get());
        ddmStructureLink.setClassNameId(classNameId);
        ddmStructureLink.setClassPK(classPK);
        ddmStructureLink.setStructureId(structureId);
        return ddmStructureLink;
    }

    protected Group newGroup(long groupId, long classNameId, long classPK, String name, boolean site) throws Exception {
        GroupImpl group = new GroupImpl();
        group.setUuid(SequentialUUID.generate());
        group.setGroupId(groupId);
        group.setCompanyId(this._companyId);
        group.setCreatorUserId(this._sampleUserId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setTreePath(group.buildTreePath());
        group.setName(name);
        group.setFriendlyURL("/" + FriendlyURLNormalizerUtil.normalize((String)name));
        group.setSite(site);
        group.setActive(true);
        return group;
    }

    protected LayoutSet newLayoutSet(long groupId, boolean privateLayout, int pageCount) {
        LayoutSetImpl layoutSet = new LayoutSetImpl();
        layoutSet.setLayoutSetId(this._counter.get());
        layoutSet.setGroupId(groupId);
        layoutSet.setCompanyId(this._companyId);
        layoutSet.setCreateDate(new Date());
        layoutSet.setModifiedDate(new Date());
        layoutSet.setPrivateLayout(privateLayout);
        layoutSet.setThemeId("classic");
        layoutSet.setColorSchemeId("01");
        layoutSet.setWapThemeId("mobile");
        layoutSet.setWapColorSchemeId("01");
        layoutSet.setPageCount(pageCount);
        return layoutSet;
    }

    protected MBMessage newMBMessage(long groupId, long classNameId, long classPK, long categoryId, long threadId, long messageId, long rootMessageId, long parentMessageId, String subject, String body) {
        MBMessageImpl mbMessage = new MBMessageImpl();
        mbMessage.setUuid(SequentialUUID.generate());
        mbMessage.setMessageId(messageId);
        mbMessage.setGroupId(groupId);
        mbMessage.setCompanyId(this._companyId);
        mbMessage.setUserId(this._sampleUserId);
        mbMessage.setUserName(_SAMPLE_USER_NAME);
        mbMessage.setCreateDate(new Date());
        mbMessage.setModifiedDate(new Date());
        mbMessage.setClassNameId(classNameId);
        mbMessage.setClassPK(classPK);
        mbMessage.setCategoryId(categoryId);
        mbMessage.setThreadId(threadId);
        mbMessage.setRootMessageId(rootMessageId);
        mbMessage.setParentMessageId(parentMessageId);
        mbMessage.setSubject(subject);
        mbMessage.setBody(body);
        mbMessage.setFormat(MBMessageConstants.DEFAULT_FORMAT);
        mbMessage.setStatusDate(new Date());
        return mbMessage;
    }

    protected MBThread newMBThread(long threadId, long groupId, long categoryId, long rootMessageId, int messageCount) {
        MBThreadImpl mbThread = new MBThreadImpl();
        mbThread.setUuid(SequentialUUID.generate());
        mbThread.setThreadId(threadId);
        mbThread.setGroupId(groupId);
        mbThread.setCompanyId(this._companyId);
        mbThread.setUserId(this._sampleUserId);
        mbThread.setUserName(_SAMPLE_USER_NAME);
        mbThread.setCreateDate(new Date());
        mbThread.setModifiedDate(new Date());
        mbThread.setCategoryId(categoryId);
        mbThread.setRootMessageId(rootMessageId);
        mbThread.setRootMessageUserId(this._sampleUserId);
        mbThread.setMessageCount(messageCount);
        mbThread.setLastPostByUserId(this._sampleUserId);
        mbThread.setLastPostDate(new Date());
        mbThread.setStatusDate(new Date());
        return mbThread;
    }

    protected com.liferay.portal.model.PortletPreferences newPortletPreferences(long plid, String portletId, String preferences) {
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        portletPreferences.setPortletPreferencesId(this._counter.get());
        portletPreferences.setOwnerId(0L);
        portletPreferences.setOwnerType(3);
        portletPreferences.setPlid(plid);
        portletPreferences.setPortletId(portletId);
        portletPreferences.setPreferences(preferences);
        return portletPreferences;
    }

    protected ResourcePermission newResourcePermission(String name, String primKey, long roleId, long ownerId) {
        ResourcePermissionImpl resourcePermission = new ResourcePermissionImpl();
        resourcePermission.setResourcePermissionId(this._resourcePermissionCounter.get());
        resourcePermission.setCompanyId(this._companyId);
        resourcePermission.setName(name);
        resourcePermission.setScope(4);
        resourcePermission.setPrimKey(primKey);
        resourcePermission.setRoleId(roleId);
        resourcePermission.setOwnerId(ownerId);
        resourcePermission.setActionIds(1L);
        return resourcePermission;
    }

    protected List<ResourcePermission> newResourcePermissions(String name, String primKey, long ownerId) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>(3);
        resourcePermissions.add(this.newResourcePermission(name, primKey, this._guestRole.getRoleId(), 0L));
        resourcePermissions.add(this.newResourcePermission(name, primKey, this._ownerRole.getRoleId(), ownerId));
        resourcePermissions.add(this.newResourcePermission(name, primKey, this._siteMemberRole.getRoleId(), 0L));
        return resourcePermissions;
    }

    protected Role newRole(String name, int type) {
        RoleImpl role = new RoleImpl();
        role.setUuid(SequentialUUID.generate());
        role.setRoleId(this._counter.get());
        role.setCompanyId(this._companyId);
        role.setUserId(this._sampleUserId);
        role.setUserName(_SAMPLE_USER_NAME);
        role.setCreateDate(new Date());
        role.setModifiedDate(new Date());
        role.setClassNameId(this._classNamesMap.get(Role.class.getName()));
        role.setClassPK(role.getRoleId());
        role.setName(name);
        role.setType(type);
        return role;
    }

    protected SocialActivity newSocialActivity(long groupId, long classNameId, long classPK, int type, String extraData) {
        SocialActivityImpl socialActivity = new SocialActivityImpl();
        socialActivity.setActivityId(this._socialActivityCounter.get());
        socialActivity.setGroupId(groupId);
        socialActivity.setCompanyId(this._companyId);
        socialActivity.setUserId(this._sampleUserId);
        socialActivity.setCreateDate(_CURRENT_TIME + this._timeCounter.get());
        socialActivity.setClassNameId(classNameId);
        socialActivity.setClassPK(classPK);
        socialActivity.setType(type);
        socialActivity.setExtraData(extraData);
        return socialActivity;
    }

    protected Subscription newSubscription(long classNameId, long classPK) {
        SubscriptionImpl subscription = new SubscriptionImpl();
        subscription.setSubscriptionId(this._counter.get());
        subscription.setCompanyId(this._companyId);
        subscription.setUserId(this._sampleUserId);
        subscription.setUserName(_SAMPLE_USER_NAME);
        subscription.setCreateDate(new Date());
        subscription.setModifiedDate(new Date());
        subscription.setClassNameId(classNameId);
        subscription.setClassPK(classPK);
        subscription.setFrequency("instant");
        return subscription;
    }

    protected User newUser(long userId, String firstName, String lastName, String screenName, boolean defaultUser) {
        if (Validator.isNull((String)screenName)) {
            screenName = String.valueOf(userId);
        }
        UserImpl user = new UserImpl();
        user.setUuid(SequentialUUID.generate());
        user.setUserId(userId);
        user.setCompanyId(this._companyId);
        user.setCreateDate(new Date());
        user.setModifiedDate(new Date());
        user.setDefaultUser(defaultUser);
        user.setContactId(this._counter.get());
        user.setPassword("test");
        user.setPasswordModifiedDate(new Date());
        user.setReminderQueryQuestion("What is your screen name?");
        user.setReminderQueryAnswer(screenName);
        user.setEmailAddress(String.valueOf(screenName) + "@liferay.com");
        user.setScreenName(screenName);
        user.setLanguageId("en_US");
        user.setGreeting("Welcome " + screenName + "!");
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setLoginDate(new Date());
        user.setLastLoginDate(new Date());
        user.setLastFailedLoginDate(new Date());
        user.setLockoutDate(new Date());
        user.setAgreedToTermsOfUse(true);
        user.setEmailAddressVerified(true);
        return user;
    }

    protected String nextDDLCustomFieldName(long groupId, int customFieldIndex) {
        StringBundler sb = new StringBundler(4);
        sb.append("costom_field_text_");
        sb.append(groupId);
        sb.append("_");
        sb.append(customFieldIndex);
        return sb.toString();
    }

    protected Date nextFutureDate() {
        return new Date(_FUTURE_TIME + this._futureDateCounter.get() * 1000L);
    }
}

