/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scripting.ruby.RubyExecutor;
import com.liferay.portal.servlet.filters.aggregate.AggregateFilter;
import com.liferay.portal.servlet.filters.aggregate.FileAggregateContext;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsImpl;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;

public class SassToCssBuilder {
    private RubyExecutor _rubyExecutor;
    private String _rubyScript;
    private String _tempDir;

    public static File getCacheFile(String fileName) {
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        int pos = fileName.lastIndexOf("/");
        String cacheFileName = String.valueOf(fileName.substring(0, pos + 1)) + ".sass-cache/" + fileName.substring(pos + 1);
        return new File(cacheFileName);
    }

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> dirNames = new ArrayList<String>();
        String dirName = arguments.get("sass.dir");
        if (Validator.isNotNull((String)dirName)) {
            dirNames.add(dirName);
        } else {
            int i2 = 0;
            while (Validator.isNotNull((String)(dirName = arguments.get("sass.dir." + i2)))) {
                dirNames.add(dirName);
                ++i2;
            }
        }
        try {
            new SassToCssBuilder(dirNames);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String parseStaticTokens(String content) {
        return StringUtil.replace((String)content, (String[])new String[]{"@model_hints_constants_text_display_height@", "@model_hints_constants_text_display_width@", "@model_hints_constants_textarea_display_height@", "@model_hints_constants_textarea_display_width@"}, (String[])new String[]{"15", "350", "100", "500"});
    }

    public SassToCssBuilder(List<String> dirNames) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        this._initUtil(classLoader);
        this._rubyScript = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/servlet/filters/dynamiccss/main.rb");
        this._tempDir = SystemProperties.get((String)"java.io.tmpdir");
        for (String dirName : dirNames) {
            this._rubyExecutor = new RubyExecutor();
            this._rubyExecutor.setExecuteInSeparateThread(false);
            this._parseSassDirectory(dirName);
        }
    }

    private String _getContent(File file) throws Exception {
        String content = FileUtil.read((File)file);
        content = AggregateFilter.aggregateCss(new FileAggregateContext(file), content);
        return SassToCssBuilder.parseStaticTokens(content);
    }

    private String _getCssThemePath(String fileName) {
        int pos = fileName.lastIndexOf("/css/");
        return fileName.substring(0, pos + 4);
    }

    private void _initUtil(ClassLoader classLoader) {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        PortalClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal((Portal)new PortalImpl());
        PropsUtil.setProps((Props)new PropsImpl());
    }

    private boolean _isModified(String dirName, String[] fileNames) throws Exception {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            fileName = this._normalizeFileName(dirName, fileName);
            File file = new File(fileName);
            File cacheFile = SassToCssBuilder.getCacheFile(fileName);
            if (file.lastModified() != cacheFile.lastModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String _normalizeFileName(String dirName, String fileName) {
        return StringUtil.replace((String)(String.valueOf(dirName) + "/" + fileName), (String)"\\", (String)"/");
    }

    private void _parseSassDirectory(String dirName) throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dirName);
        directoryScanner.setExcludes(new String[]{"**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**"});
        directoryScanner.setIncludes(new String[]{"**\\*.css"});
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (!this._isModified(dirName, fileNames)) {
            return;
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            fileName = this._normalizeFileName(dirName, fileName);
            try {
                long start = System.currentTimeMillis();
                this._parseSassFile(fileName);
                long end = System.currentTimeMillis();
                System.out.println("Parsed " + fileName + " in " + (end - start) + " ms");
            }
            catch (Exception e2) {
                System.out.println("Unable to parse " + fileName);
                e2.printStackTrace();
            }
            ++n2;
        }
    }

    private void _parseSassFile(String fileName) throws Exception {
        File file = new File(fileName);
        File cacheFile = SassToCssBuilder.getCacheFile(fileName);
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        inputObjects.put("content", this._getContent(file));
        inputObjects.put("cssRealPath", fileName);
        inputObjects.put("cssThemePath", this._getCssThemePath(fileName));
        inputObjects.put("sassCachePath", this._tempDir);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        inputObjects.put("out", unsyncPrintWriter);
        this._rubyExecutor.eval(null, inputObjects, null, this._rubyScript, new ClassLoader[0]);
        unsyncPrintWriter.flush();
        String parsedContent = unsyncByteArrayOutputStream.toString();
        FileUtil.write((File)cacheFile, (String)parsedContent);
        cacheFile.setLastModified(file.lastModified());
    }
}

