/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.ant.Wsdl2JavaTask;
import java.io.File;
import java.util.List;

public class PortalClientBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 4) {
            throw new IllegalArgumentException();
        }
        new PortalClientBuilder(args[0], args[1], args[2], args[3]);
    }

    public PortalClientBuilder(String fileName, String outputDir, String mappingFile, String url) {
        try {
            Document document = SAXReaderUtil.read((File)new File(fileName));
            Element rootElement = document.getRootElement();
            List serviceElements = rootElement.elements("service");
            for (Element serviceElement : serviceElements) {
                String serviceName = serviceElement.attributeValue("name");
                if (serviceName.startsWith("Plugin_") && !FileUtil.exists((String)mappingFile)) {
                    this._writePluginMappingFile(mappingFile, serviceElement, serviceName);
                }
                if (!serviceName.startsWith("Plugin_") && !serviceName.startsWith("Portal_") && !serviceName.startsWith("Portlet_")) continue;
                Wsdl2JavaTask.generateJava((String)(String.valueOf(url) + "/" + serviceName + "?wsdl"), (String)outputDir, (String)mappingFile);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        File testNamespace = new File(String.valueOf(outputDir) + "/com/liferay/portal");
        if (testNamespace.exists()) {
            throw new RuntimeException("Please update " + mappingFile + " to namespace " + "com.liferay.portal to com.liferay.client.soap.portal");
        }
    }

    private void _writePluginMappingFile(String mappingFile, Element serviceElement, String serviceName) throws Exception {
        String wsdlTargetNamespace = null;
        List parameterElements = serviceElement.elements("parameter");
        for (Element parameterElement : parameterElements) {
            String parameterName = parameterElement.attributeValue("name");
            if (!parameterName.equals("wsdlTargetNamespace")) continue;
            wsdlTargetNamespace = parameterElement.attributeValue("value");
            break;
        }
        int pos = wsdlTargetNamespace.indexOf(".service.");
        String soapNamespace = wsdlTargetNamespace.substring(pos + 9);
        Object[] soapNamespaceArray = StringUtil.split((String)soapNamespace, (char)'.');
        ArrayUtil.reverse((String[])soapNamespaceArray);
        soapNamespace = StringUtil.merge((Object[])soapNamespaceArray, (String)".");
        pos = soapNamespace.lastIndexOf(".");
        soapNamespace = String.valueOf(soapNamespace.substring(0, pos)) + ".client.soap" + soapNamespace.substring(pos);
        StringBundler sb = new StringBundler(12);
        sb.append("com.liferay.client.soap.portal.kernel.util=");
        sb.append("http://util.kernel.portal.liferay.com\n");
        sb.append("com.liferay.client.soap.portal.model=");
        sb.append("http://model.portal.liferay.com\n");
        sb.append("com.liferay.client.soap.portal.service=");
        sb.append("http://service.portal.liferay.com\n");
        sb.append(soapNamespace);
        sb.append(".model=");
        sb.append("http://model.knowledgebase.liferay.com\n");
        sb.append(soapNamespace);
        sb.append(".service.http=");
        sb.append("urn:http.service.knowledgebase.liferay.com\n");
        FileUtil.write((String)mappingFile, (String)sb.toString());
    }
}

