/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.xml.DocUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;

public class JavadocBuilder {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();
    private String _basedir = "./";

    public static void main(String[] args) {
        try {
            new JavadocBuilder(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JavadocBuilder(String[] args) throws Exception {
        CmdLineParser cmdLineParser = new CmdLineParser();
        cmdLineParser.parse(args);
        CmdLineParser.Option commandOption = cmdLineParser.addStringOption("command");
        String command = (String)cmdLineParser.getOptionValue(commandOption);
        CmdLineParser.Option limitOption = cmdLineParser.addStringOption("limit");
        String limit = (String)cmdLineParser.getOptionValue(limitOption);
        CmdLineParser.Option ignoreAutogeneratedOption = cmdLineParser.addBooleanOption("ignoreAutogenerated");
        Boolean ignoreAutogenerated = (Boolean)cmdLineParser.getOptionValue(ignoreAutogeneratedOption);
        this._process(command, limit, ignoreAutogenerated);
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        Element commentElement = rootElement.addElement("comment");
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c) 2000-2010 Liferay, Inc.")) {
            comment = "";
        }
        if (comment.startsWith("<a href=\"" + javaClass.getName() + ".java.html\">")) {
            int pos = comment.indexOf("</a>");
            comment = comment.substring(pos + 4).trim();
        }
        commentElement.addCDATA(comment);
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) {
        DocletTag[] docletTags;
        DocletTag[] docletTagArray = docletTags = abstractJavaEntity.getTagsByName(name);
        int n = docletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag docletTag = docletTagArray[n2];
            String value = docletTag.getValue();
            if (name.equals("author") || name.equals("see") || name.equals("since") || name.equals("version")) {
                DocUtil.add((Element)parentElement, (String)name, (String)value);
            } else {
                Element element = parentElement.addElement(name);
                element.addCDATA(value);
            }
            ++n2;
        }
    }

    private void _addDocletTags(Element parentElement, String name, String indent, StringBuilder sb) {
        List elements = parentElement.elements(name);
        for (Element element : elements) {
            sb.append(indent);
            sb.append(" * @");
            sb.append(name);
            sb.append(" ");
            Element commentElement = element.element("comment");
            if (commentElement != null) {
                sb.append(element.elementText("name"));
                sb.append(" ");
                sb.append(this._getCDATA(element.elementText("comment")));
            } else {
                sb.append(this._getCDATA(element.getText()));
            }
            sb.append("\n");
        }
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        Element commentElement = fieldElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaField));
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        Element commentElement = methodElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        String type = javaParameter.getType().getValue();
        String value = null;
        DocletTag[] docletTagArray = paramDocletTags;
        int n = paramDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag paramDocletTag = docletTagArray[n2];
            String curValue = paramDocletTag.getValue();
            if (curValue.startsWith(name)) {
                curValue = value;
                break;
            }
            ++n2;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)type);
        if (value != null) {
            // empty if block
        }
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        JavaParameter[] javaParameterArray = javaParameters;
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
            ++n2;
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) {
        Type returns = javaMethod.getReturns();
        if (returns == null || returns.getValue().equals("void")) {
            return;
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "return");
    }

    private void _addThrowsElement(Element methodElement, Type exception, DocletTag[] throwsDocletTags) {
        String name = exception.getJavaClass().getName();
        String value = null;
        DocletTag[] docletTagArray = throwsDocletTags;
        int n = throwsDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag throwsDocletTag = docletTagArray[n2];
            String curValue = throwsDocletTag.getValue();
            if (curValue.startsWith(name)) {
                curValue = value;
                break;
            }
            ++n2;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exception.getValue());
        if (value != null) {
            // empty if block
        }
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptions = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        Type[] typeArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Type exception = typeArray[n2];
            this._addThrowsElement(methodElement, exception, throwsDocletTags);
            ++n2;
        }
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null) {
            return "";
        }
        cdata = StringUtil.replace((String)cdata, (String[])new String[]{"\n", "<p>", "</p>"}, (String[])new String[]{" ", " <p> ", " </p> "});
        while (cdata.contains("  ")) {
            cdata = StringUtil.replace((String)cdata, (String)"  ", (String)" ");
        }
        return cdata.trim();
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private JavaClass _getJavaClass(String fileName) throws Exception {
        return this._getJavaClass(fileName, null);
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        int pos = fileName.indexOf("src/");
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1);
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            builder.addSource(file);
        } else {
            builder.addSource(reader);
        }
        return builder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        sb.append(" * ");
        sb.append(this._getCDATA(rootElement.elementText("comment")));
        sb.append("\n");
        sb.append(" *\n");
        String indent = "";
        this._addDocletTags(rootElement, "author", indent, sb);
        this._addDocletTags(rootElement, "deprecated", indent, sb);
        this._addDocletTags(rootElement, "see", indent, sb);
        this._addDocletTags(rootElement, "serial", indent, sb);
        this._addDocletTags(rootElement, "since", indent, sb);
        this._addDocletTags(rootElement, "version", indent, sb);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getJavadocXml(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReaderUtil.createElement("javadoc");
        Document document = _saxReaderUtil.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            this._addMethodElement(rootElement, javaMethod);
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            this._addFieldElement(rootElement, javaField);
            ++n;
        }
        return document.formattedString();
    }

    private String _getJavaFieldComment(String[] lines, Map<String, Element> fieldElementsMap, JavaField javaField) {
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        String line = lines[javaField.getLineNumber() - 1];
        String indent = "";
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (!Character.isWhitespace(c2)) break;
            indent = String.valueOf(indent) + c2;
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        sb.append(indent);
        sb.append(" * ");
        sb.append(fieldElement.elementText("comment"));
        sb.append("\n");
        sb.append(indent);
        sb.append(" *\n");
        this._addDocletTags(fieldElement, "deprecated", indent, sb);
        this._addDocletTags(fieldElement, "see", indent, sb);
        this._addDocletTags(fieldElement, "since", indent, sb);
        this._addDocletTags(fieldElement, "version", indent, sb);
        sb.append(indent);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getJavaMethodComment(String[] lines, Map<String, Element> methodElementsMap, JavaMethod javaMethod) {
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        String line = lines[javaMethod.getLineNumber() - 1];
        String indent = "";
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (!Character.isWhitespace(c2)) break;
            indent = String.valueOf(indent) + c2;
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        sb.append(indent);
        sb.append(" * ");
        sb.append(methodElement.elementText("comment"));
        sb.append("\n");
        sb.append(indent);
        sb.append(" *\n");
        this._addDocletTags(methodElement, "deprecated", indent, sb);
        this._addDocletTags(methodElement, "param", indent, sb);
        this._addDocletTags(methodElement, "return", indent, sb);
        this._addDocletTags(methodElement, "see", indent, sb);
        this._addDocletTags(methodElement, "since", indent, sb);
        this._addDocletTags(methodElement, "throws", indent, sb);
        this._addDocletTags(methodElement, "version", indent, sb);
        sb.append(indent);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBuilder sb = new StringBuilder();
        sb.append(javaMethod.getName());
        sb.append("(");
        JavaParameter[] javaParameterArray = javaParameters = javaMethod.getParameters();
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(javaParameter.getType().getValue());
            sb.append(",");
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean _isGenerated(String content) {
        return content.contains("<javadoc autogenerated=\"true\">");
    }

    private void _process(String command, String limit, Boolean ignoreAutogenerated) throws Exception {
        int n;
        int n2;
        String[] stringArray;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this._basedir);
        ds.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**", "**\\portal-web\\**"});
        ArrayList<String> includes = new ArrayList<String>();
        if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            String[] limitArray;
            stringArray = limitArray = StringUtil.split((String)limit, (char)'/');
            n2 = limitArray.length;
            n = 0;
            while (n < n2) {
                String curLimit = stringArray[n];
                includes.add("**\\" + StringUtil.replace((String)curLimit, (String)".", (String)"\\") + "\\**\\*.java");
                includes.add("**\\" + curLimit + ".java");
                ++n;
            }
        } else {
            includes.add("**\\*.java");
        }
        ds.setIncludes(includes.toArray(new String[includes.size()]));
        ds.scan();
        String[] fileNames = ds.getIncludedFiles();
        stringArray = fileNames;
        n2 = fileNames.length;
        n = 0;
        while (n < n2) {
            String oldContent;
            File file;
            String fileName = stringArray[n];
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            if (!(ignoreAutogenerated != null && ignoreAutogenerated.booleanValue() && (file = new File(String.valueOf(this._basedir) + fileName)).exists() && this._isGenerated(oldContent = _fileUtil.read(String.valueOf(this._basedir) + fileName + "doc")))) {
                if (command.equals("cleanup")) {
                    this._processGet(fileName);
                    this._processSave(fileName);
                    this._processDelete(fileName);
                } else if (command.equals("commit")) {
                    this._processSave(fileName);
                    this._processDelete(fileName);
                } else if (command.equals("delete")) {
                    this._processDelete(fileName);
                } else if (command.equals("get")) {
                    this._processGet(fileName);
                } else if (command.equals("save")) {
                    this._processSave(fileName);
                }
            }
            ++n;
        }
    }

    private void _processDelete(String fileName) throws Exception {
        this._removeJavadocFromJava(fileName, true);
    }

    private void _processGet(String fileName) throws Exception {
        File javadocFile = new File(String.valueOf(this._basedir) + fileName + "doc");
        if (!javadocFile.exists()) {
            this._updateJavadocFromJava(fileName);
        }
        String javaWithoutJavadoc = this._removeJavadocFromJava(fileName, false);
        this._updateJavaFromJavadoc(fileName, javaWithoutJavadoc);
    }

    private void _processSave(String fileName) throws Exception {
        this._updateJavadocFromJava(fileName);
    }

    private String _removeJavadocFromJava(String fileName, boolean log) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        File file = new File(String.valueOf(this._basedir) + fileName);
        String oldContent = _fileUtil.read(file);
        String[] lines = StringUtil.splitLines((String)oldContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(oldContent));
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(javaClass.getLineNumber());
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            lineNumbers.add(javaMethod.getLineNumber());
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            lineNumbers.add(javaField.getLineNumber());
            ++n;
        }
        Iterator iterator = lineNumbers.iterator();
        block2: while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            int pos = lineNumber - 2;
            String line = lines[pos].trim();
            if (!line.endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBuilder sb = new StringBuilder(oldContent.length());
        String[] stringArray = lines;
        int n4 = lines.length;
        n3 = 0;
        while (n3 < n4) {
            String line = stringArray[n3];
            if (line != null) {
                sb.append(line);
                sb.append("\n");
            }
            ++n3;
        }
        String newContent = sb.toString().trim();
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent);
            if (log) {
                System.out.println("Writing " + file);
            }
        }
        return newContent;
    }

    private void _updateJavadocFromJava(String fileName) throws Exception {
        File file = new File(String.valueOf(this._basedir) + fileName + "doc");
        String oldContent = null;
        if (file.exists() && this._isGenerated(oldContent = _fileUtil.read(file))) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName);
        String newContent = this._getJavadocXml(javaClass);
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent.getBytes());
            System.out.println("Writing " + file);
        }
    }

    private void _updateJavaFromJavadoc(String fileName, String oldContent) throws Exception {
        JavaField[] javaFields;
        File javadocFile = new File(String.valueOf(this._basedir) + fileName + "doc");
        if (!javadocFile.exists()) {
            return;
        }
        File file = new File(String.valueOf(this._basedir) + fileName);
        if (oldContent == null) {
            oldContent = _fileUtil.read(file);
        }
        String[] lines = StringUtil.splitLines((String)oldContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(oldContent));
        Document document = _saxReaderUtil.read(javadocFile);
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        commentsMap.put(javaClass.getLineNumber(), this._getJavaClassComment(rootElement, javaClass));
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (Element methodElement : methodElements) {
            String methodKey = this._getMethodKey(methodElement);
            methodElementsMap.put(methodKey, methodElement);
        }
        JavaMethod[] javaMethods = javaClass.getMethods();
        JavaMethod[] javaMethodArray = javaMethods;
        int n = javaMethods.length;
        int methodKey = 0;
        while (methodKey < n) {
            JavaMethod javaMethod = javaMethodArray[methodKey];
            if (!commentsMap.containsKey(javaMethod.getLineNumber())) {
                commentsMap.put(javaMethod.getLineNumber(), this._getJavaMethodComment(lines, methodElementsMap, javaMethod));
            }
            ++methodKey;
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (Element fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey(fieldElement);
            fieldElementsMap.put(fieldKey, fieldElement);
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n2 = javaFields.length;
        int fieldKey = 0;
        while (fieldKey < n2) {
            JavaField javaField = javaFieldArray[fieldKey];
            if (!commentsMap.containsKey(javaField.getLineNumber())) {
                commentsMap.put(javaField.getLineNumber(), this._getJavaFieldComment(lines, fieldElementsMap, javaField));
            }
            ++fieldKey;
        }
        StringBuilder sb = new StringBuilder(oldContent.length());
        int lineNumber = 1;
        while (lineNumber <= lines.length) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
            ++lineNumber;
        }
        String newContent = sb.toString().trim();
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent);
            System.out.println("Writing " + file);
        }
    }
}

