/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.TemplateContextHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public abstract class BaseTemplateManager
implements TemplateManager {
    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, boolean restricted) {
        return this.getTemplate(templateResource, null, restricted);
    }

    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted) {
        TemplateContextHelper templateContextHelper = this.getTemplateContextHelper();
        Map<String, Object> helperUtilities = templateContextHelper.getHelperUtilities(restricted);
        return AccessController.doPrivileged(new DoGetTemplatePrivilegedAction(templateResource, errorTemplateResource, restricted, helperUtilities));
    }

    protected abstract Template doGetTemplate(TemplateResource var1, TemplateResource var2, boolean var3, Map<String, Object> var4);

    protected abstract TemplateContextHelper getTemplateContextHelper();

    private class DoGetTemplatePrivilegedAction
    implements PrivilegedAction<Template> {
        private TemplateResource _errorTemplateResource;
        private Map<String, Object> _helperUtilities;
        private boolean _restricted;
        private TemplateResource _templateResource;

        public DoGetTemplatePrivilegedAction(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities) {
            this._templateResource = templateResource;
            this._errorTemplateResource = errorTemplateResource;
            this._restricted = restricted;
            this._helperUtilities = helperUtilities;
        }

        @Override
        public Template run() {
            return BaseTemplateManager.this.doGetTemplate(this._templateResource, this._errorTemplateResource, this._restricted, this._helperUtilities);
        }
    }
}

