/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.AbstractProcessingTemplate;
import com.liferay.portal.template.CacheTemplateResource;
import com.liferay.portal.template.TemplateContextHelper;
import java.io.Serializable;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractTemplate
extends AbstractProcessingTemplate {
    protected TemplateResource errorTemplateResource;
    protected TemplateResource templateResource;
    private TemplateContextHelper _templateContextHelper;

    public AbstractTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, TemplateContextHelper templateContextHelper, String templateManagerName, long interval) {
        if (templateResource == null) {
            throw new IllegalArgumentException("Template resource is null");
        }
        if (templateContextHelper == null) {
            throw new IllegalArgumentException("Template context helper is null");
        }
        if (templateManagerName == null) {
            throw new IllegalArgumentException("Template manager name is null");
        }
        this.templateResource = templateResource;
        this.errorTemplateResource = errorTemplateResource;
        this._templateContextHelper = templateContextHelper;
        if (interval != 0L) {
            this._cacheTemplateResource(templateManagerName);
        }
    }

    @Override
    public TemplateContextHelper getTemplateContextHelper() {
        return this._templateContextHelper;
    }

    public void prepare(HttpServletRequest request) {
        this._templateContextHelper.prepare(this, request);
    }

    @Override
    protected void doProcessTemplate(Writer writer) throws TemplateException {
        if (this.errorTemplateResource == null) {
            try {
                this.processTemplate(this.templateResource, writer);
                return;
            }
            catch (Exception e2) {
                throw new TemplateException("Unable to process template " + this.templateResource.getTemplateId(), (Throwable)e2);
            }
        }
        Writer oldWriter = (Writer)this.get("writer");
        try {
            try {
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                this.put("writer", unsyncStringWriter);
                this.processTemplate(this.templateResource, (Writer)unsyncStringWriter);
                StringBundler sb = unsyncStringWriter.getStringBundler();
                sb.writeTo(writer);
            }
            catch (Exception e3) {
                this.put("writer", writer);
                this.handleException(e3, writer);
                this.put("writer", oldWriter);
            }
        }
        finally {
            this.put("writer", oldWriter);
        }
    }

    protected String getTemplateResourceUUID(TemplateResource templateResource) {
        return "TEMPLATE_RESOURCE_UUID".concat("#").concat(templateResource.getTemplateId());
    }

    protected abstract void handleException(Exception var1, Writer var2) throws TemplateException;

    protected abstract void processTemplate(TemplateResource var1, Writer var2) throws Exception;

    private void _cacheTemplateResource(String templateManagerName) {
        String templateId = this.templateResource.getTemplateId();
        if (templateManagerName.equals("vm") && templateId.contains("-SANDBOX-")) {
            return;
        }
        if (!(this.templateResource instanceof CacheTemplateResource) && !(this.templateResource instanceof StringTemplateResource)) {
            this.templateResource = new CacheTemplateResource(this.templateResource);
        }
        String cacheName = TemplateResourceLoader.class.getName();
        PortalCache portalCache = MultiVMPoolUtil.getCache((String)(cacheName = cacheName.concat(".").concat(templateManagerName)));
        Object object = portalCache.get((Serializable)((Object)this.templateResource.getTemplateId()));
        if (object == null || !this.templateResource.equals(object)) {
            portalCache.put((Serializable)((Object)this.templateResource.getTemplateId()), (Object)this.templateResource);
        }
        if (this.errorTemplateResource == null) {
            return;
        }
        String errorTemplateId = this.errorTemplateResource.getTemplateId();
        if (templateManagerName.equals("vm") && errorTemplateId.contains("-SANDBOX-")) {
            return;
        }
        if (!(this.errorTemplateResource instanceof CacheTemplateResource) && !(this.errorTemplateResource instanceof StringTemplateResource)) {
            this.errorTemplateResource = new CacheTemplateResource(this.errorTemplateResource);
        }
        if ((object = portalCache.get((Serializable)((Object)this.errorTemplateResource.getTemplateId()))) == null || !this.errorTemplateResource.equals(object)) {
            portalCache.put((Serializable)((Object)this.errorTemplateResource.getTemplateId()), (Object)this.errorTemplateResource);
        }
    }
}

