/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateControlContext;
import java.io.Writer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class AbstractProcessingTemplate
implements Template {
    public abstract TemplateContextHelper getTemplateContextHelper();

    public final void processTemplate(Writer writer) throws TemplateException {
        TemplateControlContext templateControlContext = this.getTemplateContextHelper().getTemplateControlContext();
        AccessControlContext accessControlContext = templateControlContext.getAccessControlContext();
        if (accessControlContext == null) {
            this.doProcessTemplate(writer);
            return;
        }
        try {
            AccessController.doPrivileged(new DoProcessTemplatePrivilegedExceptionAction(writer), accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            throw (TemplateException)pae.getException();
        }
    }

    protected abstract void doProcessTemplate(Writer var1) throws TemplateException;

    private class DoProcessTemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private Writer _writer;

        public DoProcessTemplatePrivilegedExceptionAction(Writer writer) {
            this._writer = writer;
        }

        @Override
        public Void run() throws Exception {
            AbstractProcessingTemplate.this.doProcessTemplate(this._writer);
            return null;
        }
    }
}

