/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;

public class PortletAction
extends Action {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = true;
    private static Log _log = LogFactoryUtil.getLog(PortletAction.class);

    public static String getForwardKey(HttpServletRequest request) {
        String portletId = (String)request.getAttribute("PORTLET_ID");
        String portletNamespace = PortalUtil.getPortletNamespace((String)portletId);
        return portletNamespace.concat("PORTLET_STRUTS_FORWARD");
    }

    public static String getForwardKey(PortletRequest portletRequest) {
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        String portletNamespace = PortalUtil.getPortletNamespace((String)portletId);
        return portletNamespace.concat("PORTLET_STRUTS_FORWARD");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        Boolean strutsExecute = (Boolean)request.getAttribute("PORTLET_STRUTS_EXECUTE");
        if (strutsExecute != null && strutsExecute.booleanValue()) {
            return this.strutsExecute(mapping, form, request, response);
        }
        if (portletRequest instanceof RenderRequest) {
            return this.render(mapping, form, portletConfig, (RenderRequest)portletRequest, (RenderResponse)portletResponse);
        }
        if (portletRequest instanceof EventRequest) {
            this.processEvent(mapping, form, portletConfig, (EventRequest)portletRequest, (EventResponse)portletResponse);
        } else {
            this.serveResource(mapping, form, portletConfig, (ResourceRequest)portletRequest, (ResourceResponse)portletResponse);
        }
        return mapping.findForward("/common/null.jsp");
    }

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
    }

    public void processEvent(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, EventRequest eventRequest, EventResponse eventResponse) throws Exception {
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward to " + this.getForward((PortletRequest)renderRequest)));
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest));
    }

    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String resourceId = resourceRequest.getResourceID();
        if (Validator.isNull((String)resourceId)) {
            return;
        }
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(resourceId);
        if (portletRequestDispatcher == null) {
            return;
        }
        portletRequestDispatcher.forward((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.execute(mapping, form, request, response);
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        boolean addProcessActionSuccessMessage = GetterUtil.getBoolean((String)portletConfig.getInitParameter("add-process-action-success-action"), (boolean)true);
        if (!addProcessActionSuccessMessage) {
            return;
        }
        String successMessage = ParamUtil.getString((PortletRequest)actionRequest, (String)"successMessage");
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)successMessage);
    }

    protected String getForward(PortletRequest portletRequest) {
        return this.getForward(portletRequest, null);
    }

    protected String getForward(PortletRequest portletRequest, String defaultValue) {
        String forward = (String)portletRequest.getAttribute(PortletAction.getForwardKey(portletRequest));
        if (forward == null) {
            return defaultValue;
        }
        return forward;
    }

    protected ModuleConfig getModuleConfig(PortletRequest portletRequest) {
        return (ModuleConfig)portletRequest.getAttribute("org.apache.struts.action.MODULE");
    }

    protected MessageResources getResources() {
        ServletContext servletContext = this.getServlet().getServletContext();
        return (MessageResources)servletContext.getAttribute("org.apache.struts.action.MESSAGE");
    }

    protected MessageResources getResources(HttpServletRequest request) {
        return this.getResources();
    }

    protected MessageResources getResources(PortletRequest portletRequest) {
        return this.getResources();
    }

    protected boolean isCheckMethodOnProcessAction() {
        return true;
    }

    protected boolean isDisplaySuccessMessage(PortletRequest portletRequest) throws SystemException {
        Portlet portlet;
        String portletId;
        ThemeDisplay themeDisplay;
        block5: {
            if (!SessionErrors.isEmpty((PortletRequest)portletRequest)) {
                return false;
            }
            themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            if (layout.isTypeControlPanel()) {
                return true;
            }
            portletId = (String)portletRequest.getAttribute("PORTLET_ID");
            try {
                LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    return true;
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return (portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId)).isAddDefaultResource();
    }

    protected boolean redirectToLogin(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        if (actionRequest.getRemoteUser() == null) {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            actionResponse.sendRedirect(themeDisplay.getURLSignIn());
            return true;
        }
        return false;
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, SystemException {
        this.sendRedirect(actionRequest, actionResponse, null);
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, String redirect) throws IOException, SystemException {
        this.sendRedirect(null, actionRequest, actionResponse, redirect, null);
    }

    protected void sendRedirect(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String redirect, String closeRedirect) throws IOException, SystemException {
        if (this.isDisplaySuccessMessage((PortletRequest)actionRequest)) {
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        if (Validator.isNull((String)redirect)) {
            redirect = (String)actionRequest.getAttribute("REDIRECT");
        }
        if (Validator.isNull((String)redirect)) {
            redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        }
        if (portletConfig != null && Validator.isNotNull((String)redirect) && Validator.isNotNull((String)closeRedirect)) {
            redirect = HttpUtil.setParameter((String)redirect, (String)"closeRedirect", (String)closeRedirect);
            LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".closeRedirect"), (Object)closeRedirect);
        }
        if (Validator.isNull((String)redirect)) {
            return;
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        if (BrowserSnifferUtil.isIe((HttpServletRequest)request) && (double)BrowserSnifferUtil.getMajorVersion((HttpServletRequest)request) == 6.0 && redirect.contains("#")) {
            String redirectToken = "&#";
            if (!redirect.contains("?")) {
                redirectToken = "?" + redirectToken;
            }
            redirect = StringUtil.replace((String)redirect, (String)"#", (String)redirectToken);
        }
        if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
            actionResponse.sendRedirect(redirect);
        }
    }

    protected void setForward(PortletRequest portletRequest, String forward) {
        portletRequest.setAttribute(PortletAction.getForwardKey(portletRequest), (Object)forward);
    }

    protected void writeJSON(PortletRequest portletRequest, ActionResponse actionResponse, Object json) throws IOException {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType("application/json");
        ServletResponseUtil.write((HttpServletResponse)response, (String)json.toString());
        response.flushBuffer();
        this.setForward(portletRequest, "/common/null.jsp");
    }

    protected void writeJSON(PortletRequest portletRequest, MimeResponse mimeResponse, Object json) throws IOException {
        mimeResponse.setContentType("application/json");
        PortletResponseUtil.write((MimeResponse)mimeResponse, (String)json.toString());
        mimeResponse.flushBuffer();
    }
}

