/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class FindAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(FindAction.class);
    private String[] _portletIds = this.initPortletIds();

    public FindAction() {
        if (this._portletIds == null || this._portletIds.length == 0) {
            throw new RuntimeException("Portlet IDs cannot be null or empty");
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
            long primaryKey = ParamUtil.getLong((HttpServletRequest)request, (String)this.getPrimaryKeyParameterName());
            Object[] plidAndPortletId = this.getPlidAndPortletId(request, plid, primaryKey);
            plid = (Long)plidAndPortletId[0];
            String portletId = (String)plidAndPortletId[1];
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
            portletURL.setParameter("struts_action", this.getStrutsAction(request, portletId));
            boolean inheritRedirect = ParamUtil.getBoolean((HttpServletRequest)request, (String)"inheritRedirect");
            String redirect = null;
            if (inheritRedirect) {
                String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
                redirect = HttpUtil.getParameter((String)noSuchEntryRedirect, (String)"redirect", (boolean)false);
                redirect = HttpUtil.decodeURL((String)redirect);
            } else {
                redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
            }
            if (Validator.isNotNull((String)redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            this.setPrimaryKeyParameter((PortletURL)portletURL, primaryKey);
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(WindowState.NORMAL);
            portletURL = this.processPortletURL(request, (PortletURL)portletURL);
            response.setHeader("Location", portletURL.toString());
            response.setStatus(301);
            return null;
        }
        catch (Exception e2) {
            String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
            if (Validator.isNotNull((String)noSuchEntryRedirect) && e2 instanceof NoSuchLayoutException) {
                response.setHeader("Location", noSuchEntryRedirect);
                response.setStatus(301);
            } else {
                PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return null;
        }
    }

    protected abstract long getGroupId(long var1) throws Exception;

    protected Object[] getPlidAndPortletId(HttpServletRequest request, long plid, long primaryKey) throws Exception {
        long groupId;
        PermissionChecker permissionChecker;
        ThemeDisplay themeDisplay;
        block10: {
            themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            permissionChecker = themeDisplay.getPermissionChecker();
            groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            if (primaryKey > 0L) {
                try {
                    groupId = this.getGroupId(primaryKey);
                }
                catch (Exception e2) {
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
        }
        if (plid != 0L && groupId == themeDisplay.getScopeGroupId()) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                String[] stringArray = this._portletIds;
                int n = this._portletIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String portletId = stringArray[n2];
                    if (layoutTypePortlet.hasPortletId(portletId) && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) {
                        portletId = this.getPortletId(layoutTypePortlet, portletId);
                        return new Object[]{plid, portletId};
                    }
                    ++n2;
                }
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        String[] stringArray = this._portletIds;
        int n = this._portletIds.length;
        int n3 = 0;
        while (n3 < n) {
            Layout layout;
            String portletId = stringArray[n3];
            plid = PortalUtil.getPlidFromPortletId((long)groupId, (String)portletId);
            if (plid != 0L && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)(layout = LayoutLocalServiceUtil.getLayout((long)plid)), (String)"VIEW")) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                portletId = this.getPortletId(layoutTypePortlet, portletId);
                return new Object[]{plid, portletId};
            }
            ++n3;
        }
        throw new NoSuchLayoutException();
    }

    protected String getPortletId(LayoutTypePortlet layoutTypePortlet, String portletId) {
        for (String curPortletId : layoutTypePortlet.getPortletIds()) {
            String curRootPortletId = PortletConstants.getRootPortletId((String)curPortletId);
            if (!portletId.equals(curRootPortletId)) continue;
            return curPortletId;
        }
        return portletId;
    }

    protected abstract String getPrimaryKeyParameterName();

    protected abstract String getStrutsAction(HttpServletRequest var1, String var2);

    protected abstract String[] initPortletIds();

    protected PortletURL processPortletURL(HttpServletRequest request, PortletURL portletURL) throws Exception {
        return portletURL;
    }

    protected void setPrimaryKeyParameter(PortletURL portletURL, long primaryKey) throws Exception {
        portletURL.setParameter(this.getPrimaryKeyParameterName(), String.valueOf(primaryKey));
    }
}

