/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.staging.permission.StagingPermission;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;

@DoPrivileged
public class StagingPermissionImpl
implements StagingPermission {
    private static Log _log = LogFactoryUtil.getLog(StagingPermissionImpl.class);

    public Boolean hasPermission(PermissionChecker permissionChecker, Group group, String className, long classPK, String portletId, String actionId) {
        try {
            return this.doHasPermission(permissionChecker, group, className, classPK, portletId, actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    public Boolean hasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String portletId, String actionId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return this.doHasPermission(permissionChecker, group, className, classPK, portletId, actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    protected Boolean doHasPermission(PermissionChecker permissionChecker, Group group, String className, long classPK, String portletId, String actionId) throws Exception {
        if (!actionId.equals("VIEW") && !actionId.equals("DELETE") && group.hasStagingGroup() && group.isStagedPortlet(portletId)) {
            return false;
        }
        return null;
    }
}

