/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.LayoutSetBranchNameException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutBranchException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutRevisionException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.Staging;
import com.liferay.portal.kernel.staging.StagingConstants;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portal.messaging.LayoutsRemotePublisherRequest;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowInstanceLink;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SessionClicks;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class StagingImpl
implements Staging {
    private static Log _log = LogFactoryUtil.getLog(StagingImpl.class);

    public String buildRemoteURL(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean privateLayout) {
        StringBundler sb = new StringBundler(remoteGroupId > 0L ? 4 : 9);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        if (remotePort > 0) {
            sb.append(":");
            sb.append(remotePort);
        }
        if (Validator.isNotNull((String)remotePathContext)) {
            sb.append(remotePathContext);
        }
        if (remoteGroupId > 0L) {
            sb.append("/c/my_sites/view?");
            sb.append("groupId=");
            sb.append(remoteGroupId);
            sb.append("&amp;privateLayout=");
            sb.append(privateLayout);
        }
        return sb.toString();
    }

    public void copyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, false);
    }

    public void copyFromLive(PortletRequest portletRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = targetLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout sourceLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)targetLayout.getUuid(), (long)liveGroup.getGroupId(), (boolean)targetLayout.isPrivateLayout());
        this.copyPortlet(portletRequest, liveGroup.getGroupId(), stagingGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void copyPortlet(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId) throws Exception {
        long userId = PortalUtil.getUserId((PortletRequest)portletRequest);
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        File file = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)sourcePlid, (long)sourceGroupId, (String)portletId, parameterMap, null, null);
        try {
            LayoutLocalServiceUtil.importPortletInfo((long)userId, (long)targetPlid, (long)targetGroupId, (String)portletId, parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public void copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        StringBundler sb = new StringBundler(4);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        sb.append(":");
        sb.append(remotePort);
        sb.append(remotePathContext);
        String url = sb.toString();
        HttpPrincipal httpPrincipal = new HttpPrincipal(url, user.getEmailAddress(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.checkRemoteStagingGroup(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (SystemException systemException) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(url);
            throw ree;
        }
        byte[] bytes = null;
        if (layoutIdMap == null) {
            bytes = LayoutLocalServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, parameterMap, (Date)startDate, (Date)endDate);
        } else {
            ArrayList<Layout> layouts = new ArrayList<Layout>();
            for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
                long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
                boolean includeChildren = entry.getValue();
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (!layouts.contains(layout)) {
                    layouts.add(layout);
                }
                List<Layout> parentLayouts = this.getMissingRemoteParentLayouts(httpPrincipal, layout, remoteGroupId);
                for (Layout parentLayout : parentLayouts) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
                if (!includeChildren) continue;
                for (Layout childLayout : layout.getAllChildren()) {
                    if (layouts.contains(childLayout)) continue;
                    layouts.add(childLayout);
                }
            }
            long[] layoutIds = this.getLayoutIds(layouts);
            if (layoutIds.length <= 0) {
                throw new RemoteExportException(3);
            }
            bytes = LayoutLocalServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
        }
        LayoutServiceHttp.importLayouts(httpPrincipal, remoteGroupId, remotePrivateLayout, parameterMap, bytes);
    }

    public void deleteLastImportSettings(Group liveGroup, boolean privateLayout) throws Exception {
        List layouts = LayoutLocalServiceUtil.getLayouts((long)liveGroup.getGroupId(), (boolean)privateLayout);
        for (Layout layout : layouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            HashSet<String> keys = new HashSet<String>();
            for (String key : typeSettingsProperties.keySet()) {
                if (!key.startsWith("last-import-")) continue;
                keys.add(key);
            }
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                typeSettingsProperties.remove((Object)key);
            }
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.getPrivateLayout(), (long)layout.getLayoutId(), (String)typeSettingsProperties.toString());
        }
    }

    public void deleteRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid) throws SystemException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public void deleteRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) throws SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    @Deprecated
    public void disableStaging(Group scopeGroup, Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging((PortletRequest)null, liveGroup, serviceContext);
    }

    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging((PortletRequest)null, liveGroup, serviceContext);
    }

    @Deprecated
    public void disableStaging(PortletRequest portletRequest, Group scopeGroup, Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging(portletRequest, liveGroup, serviceContext);
    }

    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws Exception {
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.remove((Object)"branchingPrivate");
        typeSettingsProperties.remove((Object)"branchingPublic");
        typeSettingsProperties.remove((Object)"remoteAddress");
        typeSettingsProperties.remove((Object)"remoteGroupId");
        typeSettingsProperties.remove((Object)"remotePathContext");
        typeSettingsProperties.remove((Object)"remotePort");
        typeSettingsProperties.remove((Object)"secureConnection");
        typeSettingsProperties.remove((Object)"staged");
        typeSettingsProperties.remove((Object)"stagedRemotely");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsProperties.remove((Object)key);
        }
        this.deleteLastImportSettings(liveGroup, true);
        this.deleteLastImportSettings(liveGroup, false);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)stagingGroup.getGroupId(), (boolean)true, (boolean)true);
            LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)stagingGroup.getGroupId(), (boolean)false, (boolean)true);
            GroupLocalServiceUtil.deleteGroup((long)stagingGroup.getGroupId());
        } else {
            LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)liveGroup.getGroupId(), (boolean)true, (boolean)true);
            LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)liveGroup.getGroupId(), (boolean)false, (boolean)true);
        }
        GroupLocalServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
    }

    public void enableLocalStaging(long userId, Group scopeGroup, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws Exception {
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", String.valueOf(false));
        this.setCommonStagingOptions(liveGroup, typeSettingsProperties, serviceContext);
        if (!liveGroup.hasStagingGroup()) {
            Map<String, String[]> parameterMap;
            serviceContext.setAttribute("staging", (Serializable)((Object)String.valueOf(true)));
            Group stagingGroup = GroupLocalServiceUtil.addGroup((long)userId, (long)0L, (String)liveGroup.getClassName(), (long)liveGroup.getClassPK(), (long)liveGroup.getGroupId(), (String)liveGroup.getDescriptiveName(), (String)liveGroup.getDescription(), (int)liveGroup.getType(), (String)liveGroup.getFriendlyURL(), (boolean)false, (boolean)liveGroup.isActive(), (ServiceContext)serviceContext);
            GroupLocalServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
            if (liveGroup.hasPrivateLayouts()) {
                parameterMap = this.getStagingParameters();
                this.publishLayouts(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), true, parameterMap, null, null);
            }
            if (liveGroup.hasPublicLayouts()) {
                parameterMap = this.getStagingParameters();
                this.publishLayouts(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), false, parameterMap, null, null);
            }
            this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
        } else {
            GroupLocalServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
            this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
            if (!branchingPublic) {
                LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)liveGroup.getStagingGroup().getGroupId(), (boolean)false, (boolean)true);
            }
            if (!branchingPrivate) {
                LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)liveGroup.getStagingGroup().getGroupId(), (boolean)true, (boolean)true);
            }
        }
    }

    public void enableRemoteStaging(long userId, Group scopeGroup, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws Exception {
        this.validate(remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        if (liveGroup.hasStagingGroup()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
        this.setCommonStagingOptions(liveGroup, typeSettingsProperties, serviceContext);
        GroupLocalServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, true, serviceContext);
    }

    public Group getLiveGroup(long groupId) throws PortalException, SystemException {
        if (groupId == 0L) {
            return null;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if (group.isStagingGroup()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public long getLiveGroupId(long groupId) throws PortalException, SystemException {
        if (groupId == 0L) {
            return groupId;
        }
        Group group = this.getLiveGroup(groupId);
        return group.getGroupId();
    }

    public List<Layout> getMissingParentLayouts(Layout layout, long liveGroupId) throws Exception {
        ArrayList<Layout> missingParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        Layout parentLayout = null;
        while (parentLayoutId > 0L) {
            parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
            try {
                LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)parentLayout.getUuid(), (long)liveGroupId, (boolean)parentLayout.isPrivateLayout());
                break;
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                missingParentLayouts.add(parentLayout);
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        return missingParentLayouts;
    }

    public long getRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid) throws PortalException, SystemException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        return this.getRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public long getRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) throws PortalException, SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        return this.getRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public long getRecentLayoutSetBranchId(HttpServletRequest request, long layoutSetId) {
        return GetterUtil.getLong((String)SessionClicks.get((HttpServletRequest)request, (String)Staging.class.getName(), (String)this.getRecentLayoutSetBranchIdKey(layoutSetId)));
    }

    public long getRecentLayoutSetBranchId(User user, long layoutSetId) throws SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        return GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutSetBranchIdKey(layoutSetId)));
    }

    public String getSchedulerGroupName(String destinationName, long groupId) {
        return destinationName.concat("/").concat(String.valueOf(groupId));
    }

    public Map<String, String[]> getStagingParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    public Map<String, String[]> getStagingParameters(PortletRequest portletRequest) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>(portletRequest.getParameterMap());
        if (!parameterMap.containsKey("DATA_STRATEGY")) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        }
        if (!parameterMap.containsKey("DELETE_PORTLET_DATA")) {
            parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LAYOUT_SET_PROTOTYPE_LINK_ENABLED")) {
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LAYOUT_SET_SETTINGS")) {
            parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LOGO")) {
            parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA")) {
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA_ALL")) {
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_SETUP")) {
            parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_USER_PREFERENCES")) {
            parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("THEME")) {
            parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("THEME_REFERENCE")) {
            parameterMap.put("THEME_REFERENCE", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("UPDATE_LAST_PUBLISH_DATE")) {
            parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("USER_ID_STRATEGY")) {
            parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        }
        return parameterMap;
    }

    public WorkflowTask getWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException, SystemException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink((long)layoutRevision.getCompanyId(), (long)layoutRevision.getGroupId(), (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId());
        if (workflowInstanceLink == null) {
            return null;
        }
        List workflowTasks = WorkflowTaskManagerUtil.getWorkflowTasksByWorkflowInstance((long)layoutRevision.getCompanyId(), (Long)userId, (long)workflowInstanceLink.getWorkflowInstanceId(), (Boolean)false, (int)0, (int)1, null);
        if (!workflowTasks.isEmpty()) {
            return (WorkflowTask)workflowTasks.get(0);
        }
        return null;
    }

    public boolean hasWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException, SystemException {
        WorkflowTask workflowTask = this.getWorkflowTask(userId, layoutRevision);
        return workflowTask != null;
    }

    public boolean isIncomplete(Layout layout, long layoutSetBranchId) {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision == null) {
            try {
                layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layout.getPlid(), (boolean)true);
                return false;
            }
            catch (Exception exception) {}
        }
        try {
            layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layout.getPlid(), (boolean)false);
        }
        catch (Exception exception) {}
        return layoutRevision == null || layoutRevision.getStatus() == 6;
    }

    public void publishLayout(long userId, long plid, long liveGroupId, boolean includeChildren) throws Exception {
        Map<String, String[]> parameterMap = this.getStagingParameters();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        layouts.addAll(this.getMissingParentLayouts(layout, liveGroupId));
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        long[] layoutIds = this.getLayoutIds(layouts);
        this.publishLayouts(userId, layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), layoutIds, parameterMap, null, null);
    }

    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        this.lockGroup(userId, targetGroupId);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
        try {
            LayoutLocalServiceUtil.importLayouts((long)userId, (long)targetGroupId, (boolean)privateLayout, parameterMap, (File)file);
        }
        finally {
            file.delete();
            this.unlockGroup(targetGroupId);
        }
    }

    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            List<Layout> parentLayouts = this.getMissingParentLayouts(layout, targetGroupId);
            for (Layout parentLayout : parentLayouts) {
                if (layouts.contains(parentLayout)) continue;
                layouts.add(parentLayout);
            }
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        long[] layoutIds = this.getLayoutIds(layouts);
        this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, (long[])null, parameterMap, startDate, endDate);
    }

    public void publishToLive(PortletRequest portletRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)groupId);
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        if (liveGroup.isStaged()) {
            if (liveGroup.isStagedRemotely()) {
                this.publishToRemote(portletRequest);
            } else {
                Group stagingGroup = liveGroup.getStagingGroup();
                this.publishLayouts(portletRequest, stagingGroup.getGroupId(), groupId, parameterMap, false);
            }
        }
    }

    public void publishToLive(PortletRequest portletRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = null;
        Group liveGroup = null;
        Layout targetLayout = null;
        long scopeGroupId = PortalUtil.getScopeGroupId((PortletRequest)portletRequest);
        if (sourceLayout.hasScopeGroup() && sourceLayout.getScopeGroup().getGroupId() == scopeGroupId) {
            stagingGroup = sourceLayout.getScopeGroup();
            liveGroup = stagingGroup.getLiveGroup();
            targetLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getClassPK());
        } else {
            stagingGroup = sourceLayout.getGroup();
            liveGroup = stagingGroup.getLiveGroup();
            targetLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)sourceLayout.getUuid(), (long)liveGroup.getGroupId(), (boolean)sourceLayout.isPrivateLayout());
        }
        this.copyPortlet(portletRequest, stagingGroup.getGroupId(), liveGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void publishToRemote(PortletRequest portletRequest) throws Exception {
        this.publishToRemote(portletRequest, false);
    }

    public void scheduleCopyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, true);
    }

    public void schedulePublishToLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, stagingGroupId, liveGroupId, parameterMap, true);
    }

    public void schedulePublishToRemote(PortletRequest portletRequest) throws Exception {
        this.publishToRemote(portletRequest, true);
    }

    public void setRecentLayoutBranchId(HttpServletRequest request, long layoutSetBranchId, long plid, long layoutBranchId) throws SystemException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.setRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutBranchId(User user, long layoutSetBranchId, long plid, long layoutBranchId) throws SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.setRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid, long layoutRevisionId) throws SystemException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.setRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid, long layoutRevisionId) throws SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.setRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutSetBranchId(HttpServletRequest request, long layoutSetId, long layoutSetBranchId) {
        SessionClicks.put((HttpServletRequest)request, (String)Staging.class.getName(), (String)this.getRecentLayoutSetBranchIdKey(layoutSetId), (String)String.valueOf(layoutSetBranchId));
    }

    public void setRecentLayoutSetBranchId(User user, long layoutSetId, long layoutSetBranchId) throws SystemException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutSetBranchIdKey(layoutSetId), String.valueOf(layoutSetBranchId));
    }

    public void unscheduleCopyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)stagingGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)liveGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToRemote(PortletRequest portletRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
        LayoutServiceUtil.unschedulePublishToRemote((long)groupId, (String)jobName, (String)groupName);
    }

    public void updateLastImportSettings(Element layoutElement, Layout layout, PortletDataContext portletDataContext) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        String cmd = MapUtil.getString((Map)parameterMap, (String)"cmd");
        if (!cmd.equals("publish_to_live")) {
            return;
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("last-import-date", String.valueOf(System.currentTimeMillis()));
        String layoutRevisionId = GetterUtil.getString((String)layoutElement.attributeValue("layout-revision-id"));
        typeSettingsProperties.setProperty("last-import-layout-revision-id", layoutRevisionId);
        String layoutSetBranchId = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchId");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-id", layoutSetBranchId);
        String layoutSetBranchName = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchName");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-name", layoutSetBranchName);
        String lastImportUserName = MapUtil.getString((Map)parameterMap, (String)"lastImportUserName");
        typeSettingsProperties.setProperty("last-import-user-name", lastImportUserName);
        String lastImportUserUuid = MapUtil.getString((Map)parameterMap, (String)"lastImportUserUuid");
        typeSettingsProperties.setProperty("last-import-user-uuid", lastImportUserUuid);
        String layoutBranchId = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-id"));
        typeSettingsProperties.setProperty("last-import-layout-branch-id", layoutBranchId);
        String layoutBranchName = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-name"));
        typeSettingsProperties.setProperty("last-import-layout-branch-name", layoutBranchName);
        layout.setTypeSettingsProperties(typeSettingsProperties);
    }

    public void updateStaging(PortletRequest portletRequest, Group liveGroup) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long userId = permissionChecker.getUserId();
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)liveGroup.getGroupId(), (String)"MANAGE_STAGING")) {
            return;
        }
        int stagingType = this.getStagingType(portletRequest, liveGroup);
        boolean branchingPublic = this.getBoolean(portletRequest, liveGroup, "branchingPublic");
        boolean branchingPrivate = this.getBoolean(portletRequest, liveGroup, "branchingPrivate");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (stagingType == 0) {
            if (liveGroup.hasStagingGroup() || liveGroup.isStagedRemotely()) {
                this.disableStaging(portletRequest, liveGroup, serviceContext);
            }
        } else if (stagingType == 1) {
            this.enableLocalStaging(userId, scopeGroup, liveGroup, branchingPublic, branchingPrivate, serviceContext);
        } else if (stagingType == 2) {
            String remoteAddress = this.getString(portletRequest, liveGroup, "remoteAddress");
            remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
            int remotePort = this.getInteger(portletRequest, liveGroup, "remotePort");
            String remotePathContext = this.getString(portletRequest, liveGroup, "remotePathContext");
            boolean secureConnection = this.getBoolean(portletRequest, liveGroup, "secureConnection");
            long remoteGroupId = this.getLong(portletRequest, liveGroup, "remoteGroupId");
            this.enableRemoteStaging(userId, scopeGroup, liveGroup, branchingPublic, branchingPrivate, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, serviceContext);
        }
    }

    protected void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws Exception {
        block12: {
            List layoutRevisions;
            LayoutSetBranch layoutSetBranch;
            String description;
            Locale locale;
            long targetGroupId;
            block11: {
                targetGroupId = 0L;
                if (remote) {
                    targetGroupId = liveGroup.getGroupId();
                } else {
                    Group stagingGroup = liveGroup.getStagingGroup();
                    if (stagingGroup == null) {
                        return;
                    }
                    targetGroupId = stagingGroup.getGroupId();
                }
                if (branchingPublic) {
                    locale = LocaleUtil.getDefault();
                    description = LanguageUtil.format((Locale)locale, (String)"main-site-pages-variation-of-x", (Object)liveGroup.getDescriptiveName());
                    try {
                        layoutSetBranch = LayoutSetBranchLocalServiceUtil.addLayoutSetBranch((long)userId, (long)targetGroupId, (boolean)false, (String)"main-variation", (String)description, (boolean)true, (long)0L, (ServiceContext)serviceContext);
                        layoutRevisions = LayoutRevisionLocalServiceUtil.getLayoutRevisions((long)layoutSetBranch.getLayoutSetBranchId(), (boolean)false);
                        for (LayoutRevision layoutRevision : layoutRevisions) {
                            LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevision.getLayoutRevisionId(), (int)0, (ServiceContext)serviceContext);
                        }
                    }
                    catch (LayoutSetBranchNameException lsbne) {
                        if (!_log.isWarnEnabled()) break block11;
                        _log.warn((Object)"Unable to create master branch for public layouts", (Throwable)lsbne);
                    }
                }
            }
            if (branchingPrivate) {
                locale = LocaleUtil.getDefault();
                description = LanguageUtil.format((Locale)locale, (String)"main-site-pages-variation-of-x", (Object)liveGroup.getDescriptiveName());
                try {
                    layoutSetBranch = LayoutSetBranchLocalServiceUtil.addLayoutSetBranch((long)userId, (long)targetGroupId, (boolean)true, (String)"main-variation", (String)description, (boolean)true, (long)0L, (ServiceContext)serviceContext);
                    layoutRevisions = LayoutRevisionLocalServiceUtil.getLayoutRevisions((long)layoutSetBranch.getLayoutSetBranchId(), (boolean)false);
                    for (LayoutRevision layoutRevision : layoutRevisions) {
                        LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevision.getLayoutRevisionId(), (int)0, (ServiceContext)serviceContext);
                    }
                }
                catch (LayoutSetBranchNameException lsbne) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)"Unable to create master branch for private layouts", (Throwable)lsbne);
                }
            }
        }
    }

    protected void deleteRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) {
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid), null);
    }

    protected boolean getBoolean(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)param, (boolean)GetterUtil.getBoolean((String)group.getTypeSettingsProperty(param)));
    }

    protected int getInteger(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getInteger((PortletRequest)portletRequest, (String)param, (int)GetterUtil.getInteger((String)group.getTypeSettingsProperty(param)));
    }

    protected long[] getLayoutIds(List<Layout> layouts) {
        long[] layoutIds = new long[layouts.size()];
        int i2 = 0;
        while (i2 < layouts.size()) {
            Layout layout = layouts.get(i2);
            layoutIds[i2] = layout.getLayoutId();
            ++i2;
        }
        return layoutIds;
    }

    protected long getLong(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getLong((PortletRequest)portletRequest, (String)param, (long)GetterUtil.getLong((String)group.getTypeSettingsProperty(param)));
    }

    protected List<Layout> getMissingRemoteParentLayouts(HttpPrincipal httpPrincipal, Layout layout, long remoteGroupId) throws Exception {
        ArrayList<Layout> missingRemoteParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
            try {
                LayoutServiceHttp.getLayoutByUuidAndGroupId(httpPrincipal, parentLayout.getUuid(), remoteGroupId, parentLayout.getPrivateLayout());
                break;
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                missingRemoteParentLayouts.add(parentLayout);
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        return missingRemoteParentLayouts;
    }

    protected PortalPreferences getPortalPreferences(User user) throws SystemException {
        boolean signedIn = !user.isDefaultUser();
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((long)user.getCompanyId(), (long)user.getUserId(), (boolean)signedIn);
        return portalPreferences;
    }

    protected long getRecentLayoutBranchId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) {
        return GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid)));
    }

    protected String getRecentLayoutBranchIdKey(long layoutSetBranchId, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append("layoutBranchId-");
        sb.append(layoutSetBranchId);
        sb.append("-");
        sb.append(plid);
        return sb.toString();
    }

    protected long getRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) throws PortalException, SystemException {
        long layoutRevisionId = GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid)));
        if (layoutRevisionId > 0L) {
            return layoutRevisionId;
        }
        long layoutBranchId = this.getRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid);
        if (layoutBranchId > 0L) {
            try {
                LayoutBranchLocalServiceUtil.getLayoutBranch((long)layoutBranchId);
            }
            catch (NoSuchLayoutBranchException noSuchLayoutBranchException) {
                LayoutBranch layoutBranch = LayoutBranchLocalServiceUtil.getMasterLayoutBranch((long)layoutSetBranchId, (long)plid);
                layoutBranchId = layoutBranch.getLayoutBranchId();
            }
        }
        if (layoutBranchId > 0L) {
            try {
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layoutBranchId, (long)plid);
                if (layoutRevision != null) {
                    layoutRevisionId = layoutRevision.getLayoutRevisionId();
                }
            }
            catch (NoSuchLayoutRevisionException noSuchLayoutRevisionException) {}
        }
        return layoutRevisionId;
    }

    protected String getRecentLayoutRevisionIdKey(long layoutSetBranchId, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append("layoutRevisionId-");
        sb.append(layoutSetBranchId);
        sb.append("-");
        sb.append(plid);
        return sb.toString();
    }

    protected String getRecentLayoutSetBranchIdKey(long layoutSetId) {
        return "layoutSetBranchId_" + layoutSetId;
    }

    protected int getStagingType(PortletRequest portletRequest, Group liveGroup) {
        String stagingType = portletRequest.getParameter("stagingType");
        if (stagingType != null) {
            return GetterUtil.getInteger((String)stagingType);
        }
        if (liveGroup.isStagedRemotely()) {
            return 2;
        }
        if (liveGroup.hasStagingGroup()) {
            return 1;
        }
        return 0;
    }

    protected String getString(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)param, (String)GetterUtil.getString((String)group.getTypeSettingsProperty(param)));
    }

    protected void lockGroup(long userId, long groupId) throws Exception {
        if (!PropsValues.STAGING_LOCK_ENABLED) {
            return;
        }
        if (LockLocalServiceUtil.isLocked((String)Staging.class.getName(), (long)groupId)) {
            Lock lock = LockLocalServiceUtil.getLock((String)Staging.class.getName(), (long)groupId);
            throw new DuplicateLockException(lock);
        }
        LockLocalServiceUtil.lock((long)userId, (String)Staging.class.getName(), (String)String.valueOf(groupId), (String)StagingImpl.class.getName(), (boolean)false, (long)StagingConstants.LOCK_EXPIRATION_TIME);
    }

    protected void publishLayouts(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, Map<String, String[]> parameterMap, boolean schedule) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        String scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope");
        LinkedHashMap<Long, Boolean> layoutIdMap = new LinkedHashMap<Long, Boolean>();
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            long[] lArray = rowIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds");
            int n = rowIds.length;
            int n2 = 0;
            while (n2 < n) {
                long selPlid = lArray[n2];
                boolean delete = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("delete_" + selPlid));
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("includeChildren_" + selPlid));
                if (!delete && includeChildren) {
                    layoutIdMap.put(selPlid, true);
                } else {
                    layoutIdMap.put(selPlid, false);
                }
                ++n2;
            }
        }
        DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)portletRequest, (long)sourceGroupId, (boolean)privateLayout, (long)0L, null);
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", targetGroupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCal = ExportImportHelperUtil.getDate((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
            String cronText = SchedulerEngineHelperUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCal, (boolean)true, (int)recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = ExportImportHelperUtil.getDate((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToLive((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)scope, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate(), (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            String command = "SELECTED_PAGES";
            try {
                try {
                    if (scope.equals("all-pages")) {
                        command = "ALL_PAGES";
                        this.publishLayouts(themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, parameterMap, dateRange.getStartDate(), dateRange.getEndDate());
                    } else {
                        this.publishLayouts(themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, dateRange.getStartDate(), dateRange.getEndDate());
                    }
                }
                catch (Exception e2) {
                    messageStatus.setException(e2);
                    throw e2;
                }
            }
            finally {
                messageStatus.stopTimer();
                LayoutsLocalPublisherRequest publisherRequest = new LayoutsLocalPublisherRequest(command, themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, dateRange.getStartDate(), dateRange.getEndDate());
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }

    protected void publishToRemote(PortletRequest portletRequest, boolean schedule) throws Exception {
        String scope;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        if (Validator.isNull((String)(scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope")))) {
            scope = "all-pages";
        }
        LinkedHashMap<Long, Boolean> layoutIdMap = null;
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            layoutIdMap = new LinkedHashMap<Long, Boolean>();
            long[] lArray = rowIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds");
            int n = rowIds.length;
            int n2 = 0;
            while (n2 < n) {
                long selPlid = lArray[n2];
                boolean delete = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("delete_" + selPlid));
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("includeChildren_" + selPlid));
                if (!delete && includeChildren) {
                    layoutIdMap.put(selPlid, true);
                } else {
                    layoutIdMap.put(selPlid, false);
                }
                ++n2;
            }
        }
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        parameterMap.put("PUBLISH_TO_REMOTE", new String[]{Boolean.TRUE.toString()});
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UnicodeProperties groupTypeSettingsProperties = group.getTypeSettingsProperties();
        String remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        int remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
        String remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsProperties.getProperty("remotePathContext"));
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        boolean remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        this.validate(remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        if (group.isCompany()) {
            this.updateGroupTypeSettingsProperties(group, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        }
        DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)portletRequest, (long)groupId, (boolean)privateLayout, (long)0L, null);
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCal = ExportImportHelperUtil.getDate((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
            String cronText = SchedulerEngineHelperUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCal, (boolean)true, (int)recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = ExportImportHelperUtil.getDate((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToRemote((long)groupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate(), (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            try {
                try {
                    this.copyRemoteLayouts(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, dateRange.getStartDate(), dateRange.getEndDate());
                }
                catch (Exception e2) {
                    messageStatus.setException(e2);
                    throw e2;
                }
            }
            finally {
                messageStatus.stopTimer();
                LayoutsRemotePublisherRequest publisherRequest = new LayoutsRemotePublisherRequest(themeDisplay.getUserId(), groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, dateRange.getStartDate(), dateRange.getEndDate());
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }

    protected void setCommonStagingOptions(Group liveGroup, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws Exception {
        LayoutExporter.updateLastPublishDate(liveGroup.getPrivateLayoutSet(), 0L);
        LayoutExporter.updateLastPublishDate(liveGroup.getPublicLayoutSet(), 0L);
        Set parameterNames = serviceContext.getAttributes().keySet();
        for (String parameterName : parameterNames) {
            if (!parameterName.startsWith("staged-portlet_") || parameterName.endsWith("Checkbox")) continue;
            boolean staged = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)parameterName);
            typeSettingsProperties.setProperty(parameterName, String.valueOf(staged));
        }
    }

    protected void setRecentLayoutBranchId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid, long layoutBranchId) {
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid), String.valueOf(layoutBranchId));
    }

    protected void setRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid, long layoutRevisionId) throws SystemException {
        long layoutBranchId;
        block4: {
            layoutBranchId = 0L;
            try {
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
                layoutBranchId = layoutRevision.getLayoutBranchId();
                LayoutRevision lastLayoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layoutBranchId, (long)plid);
                if (lastLayoutRevision.getLayoutRevisionId() == layoutRevisionId) {
                    this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
                } else {
                    portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid), String.valueOf(layoutRevisionId));
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to set recent layout revision ID", (Throwable)pe);
            }
        }
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid), String.valueOf(layoutBranchId));
    }

    protected String stripProtocolFromRemoteAddress(String remoteAddress) {
        if (remoteAddress.startsWith("http://")) {
            remoteAddress = remoteAddress.substring("http://".length());
        } else if (remoteAddress.startsWith("https://")) {
            remoteAddress = remoteAddress.substring("https://".length());
        }
        return remoteAddress;
    }

    protected void unlockGroup(long groupId) throws SystemException {
        if (!PropsValues.STAGING_LOCK_ENABLED) {
            return;
        }
        LockLocalServiceUtil.unlock((String)Staging.class.getName(), (long)groupId);
    }

    protected void updateGroupTypeSettingsProperties(Group group, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) throws Exception {
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        group.setTypeSettingsProperties(typeSettingsProperties);
        GroupLocalServiceUtil.updateGroup((Group)group);
    }

    protected void validate(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) throws Exception {
        RemoteOptionsException roe = null;
        if (!Validator.isDomain((String)remoteAddress) && !Validator.isIPAddress((String)remoteAddress)) {
            roe = new RemoteOptionsException(1);
            roe.setRemoteAddress(remoteAddress);
            throw roe;
        }
        if (remotePort < 1 || remotePort > 65535) {
            roe = new RemoteOptionsException(2);
            roe.setRemotePort(remotePort);
            throw roe;
        }
        if (Validator.isNotNull((String)remotePathContext) && (!remotePathContext.startsWith("/") || remotePathContext.endsWith("/"))) {
            roe = new RemoteOptionsException(4);
            roe.setRemotePathContext(remotePathContext);
            throw roe;
        }
        if (remoteGroupId <= 0L) {
            roe = new RemoteOptionsException(3);
            roe.setRemoteGroupId(remoteGroupId);
            throw roe;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        String url = this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection, 0L, false);
        HttpPrincipal httpPrincipal = new HttpPrincipal(url, user.getEmailAddress(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.checkRemoteStagingGroup(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException principalException) {
            RemoteExportException ree = new RemoteExportException(4);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (SystemException systemException) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(url);
            throw ree;
        }
    }
}

