/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.jsonwebservice.spring.JSONWebServiceDetectorBeanPostProcessor;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import com.liferay.portal.spring.util.FilterClassLoader;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortletApplicationContext
extends XmlWebApplicationContext {
    private static Log _log = LogFactoryUtil.getLog(PortletApplicationContext.class);
    private static PACL _pacl = new NoPACL();

    public static ClassLoader getBeanClassLoader() {
        return _pacl.getBeanClassLoader();
    }

    protected String[] getDefaultConfigLocations() {
        return new String[0];
    }

    protected String[] getPortletConfigLocations() {
        Object[] configLocations = this.getConfigLocations();
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return configLocations;
        }
        return (String[])ArrayUtil.append((Object[])configLocations, (Object[])serviceBuilderPropertiesConfiguration.getArray("spring.configs"));
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        xmlBeanDefinitionReader.setBeanClassLoader(PortletApplicationContext.getBeanClassLoader());
    }

    protected void injectExplicitBean(Class<?> clazz, BeanDefinitionRegistry beanDefinitionRegistry) {
        beanDefinitionRegistry.registerBeanDefinition(clazz.getName(), (BeanDefinition)new RootBeanDefinition(clazz));
    }

    protected void injectExplicitBeans(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.injectExplicitBean(DoPrivilegedFactory.class, beanDefinitionRegistry);
        this.injectExplicitBean(JSONWebServiceDetectorBeanPostProcessor.class, beanDefinitionRegistry);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        String[] configLocations = this.getPortletConfigLocations();
        if (configLocations == null) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = xmlBeanDefinitionReader.getBeanFactory();
        this.injectExplicitBeans(beanDefinitionRegistry);
        String[] stringArray = configLocations;
        int n = configLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String configLocation = stringArray[n2];
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e2) {
                Throwable cause = e2.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)cause.getMessage());
                    }
                }
                _log.error((Object)e2, (Throwable)e2);
            }
            ++n2;
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public ClassLoader getBeanClassLoader() {
            ClassLoader beanClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{PortletClassLoaderUtil.getClassLoader(), ClassLoaderUtil.getPortalClassLoader()});
            return new FilterClassLoader(beanClassLoader);
        }
    }

    public static interface PACL {
        public ClassLoader getBeanClassLoader();
    }
}

