/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.bean;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;

public class BeanReferenceRefreshUtil {
    private static Log _log = LogFactoryUtil.getLog(BeanReferenceRefreshUtil.class);
    private static Map<Object, Object> _doPrivilegedBeans = new IdentityHashMap<Object, Object>();
    private static Map<Object, List<RefreshPoint>> _registeredRefreshPoints = new IdentityHashMap<Object, List<RefreshPoint>>();

    public static void refresh(BeanFactory beanFactory) throws Exception {
        for (Map.Entry<Object, List<RefreshPoint>> entry : _registeredRefreshPoints.entrySet()) {
            BeanReferenceRefreshUtil._refresh(beanFactory, entry.getKey(), entry.getValue());
        }
        _registeredRefreshPoints.clear();
    }

    public static void registerRefreshPoint(Object targetBean, Field field, String referencedBeanName) {
        List<RefreshPoint> refreshPoints = _registeredRefreshPoints.get(targetBean);
        if (refreshPoints == null) {
            refreshPoints = new ArrayList<RefreshPoint>();
            _registeredRefreshPoints.put(targetBean, refreshPoints);
        }
        refreshPoints.add(new RefreshPoint(field, referencedBeanName));
    }

    private static void _refresh(BeanFactory beanFactory, Object targetBean, List<RefreshPoint> refreshPoints) throws Exception {
        for (RefreshPoint refreshPoint : refreshPoints) {
            BeanReferenceRefreshUtil._refresh(beanFactory, targetBean, refreshPoint);
        }
    }

    private static void _refresh(BeanFactory beanFactory, Object targetBean, RefreshPoint refreshPoint) throws Exception {
        Field field = refreshPoint._field;
        Object oldReferenceBean = field.get(targetBean);
        String referencedBeanName = refreshPoint._referencedBeanName;
        Object newReferencedBean = beanFactory.getBean(referencedBeanName);
        Object doPrivilegedBean = _doPrivilegedBeans.get(newReferencedBean);
        if (doPrivilegedBean == null && DoPrivilegedFactory.isEarlyBeanReference(referencedBeanName)) {
            doPrivilegedBean = DoPrivilegedFactory.wrap(newReferencedBean);
            _doPrivilegedBeans.put(newReferencedBean, doPrivilegedBean);
        }
        if (doPrivilegedBean != null) {
            newReferencedBean = doPrivilegedBean;
        }
        if (oldReferenceBean == newReferencedBean) {
            return;
        }
        field.set(targetBean, newReferencedBean);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Refreshed field " + field + " with old value " + oldReferenceBean + " with new value " + newReferencedBean + " on bean " + targetBean));
        }
    }

    private static class RefreshPoint {
        private Field _field;
        private String _referencedBeanName;

        public RefreshPoint(Field field, String referencedBeanName) {
            this._field = field;
            this._referencedBeanName = referencedBeanName;
        }
    }
}

