/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointRequest {
    private byte[] _bytes;
    private Map<String, String[]> _params = new HashMap<String, String[]>();
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private String _rootPath = "";
    private SharepointStorage _storage;
    private User _user;

    public SharepointRequest(HttpServletRequest request, HttpServletResponse response, User user) throws SharepointException {
        this._request = request;
        this._response = response;
        this._user = user;
        this._params.putAll(request.getParameterMap());
        this.addParams();
    }

    public SharepointRequest(String rootPath) {
        this._rootPath = rootPath;
    }

    public void addParam(String key, String value) {
        this._params.put(key, new String[]{value});
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public long getCompanyId() {
        return this._user.getCompanyId();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public String getParameterValue(String name) {
        String[] values = this._params.get(name);
        if (values != null && values.length > 0) {
            return GetterUtil.getString((String)this._params.get(name)[0]);
        }
        return "";
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public SharepointStorage getSharepointStorage() {
        return this._storage;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public void setBytes(byte[] bytes) {
        this._bytes = bytes;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = SharepointUtil.replaceBackSlashes(rootPath);
    }

    public void setSharepointStorage(SharepointStorage storage) {
        this._storage = storage;
    }

    protected void addParams() throws SharepointException {
        String contentType = this._request.getContentType();
        if (!contentType.equals("application/x-vermeer-urlencoded")) {
            return;
        }
        try {
            String[] params;
            ServletInputStream is = this._request.getInputStream();
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            StreamUtil.transfer((InputStream)is, (OutputStream)unsyncByteArrayOutputStream);
            byte[] bytes = unsyncByteArrayOutputStream.toByteArray();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)));
            String url = unsyncBufferedReader.readLine();
            String[] stringArray = params = url.split("&");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] kvp = param.split("=");
                String key = HttpUtil.decodeURL((String)kvp[0]);
                String value = "";
                if (kvp.length > 1) {
                    value = HttpUtil.decodeURL((String)kvp[1]);
                }
                this.addParam(key, value);
                ++n2;
            }
            bytes = ArrayUtil.subset((byte[])bytes, (int)(url.length() + 1), (int)bytes.length);
            this.setBytes(bytes);
        }
        catch (Exception e2) {
            throw new SharepointException(e2);
        }
    }
}

