/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.monitoring;

import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleThreadLocal;
import com.liferay.portal.monitoring.statistics.portal.PortalRequestDataSample;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitoringFilter
extends BasePortalFilter {
    private static boolean _monitoringPortalRequest = PropsValues.MONITORING_PORTAL_REQUEST;

    public static boolean isMonitoringPortalRequest() {
        return _monitoringPortalRequest;
    }

    public static void setMonitoringPortalRequest(boolean monitoringPortalRequest) {
        _monitoringPortalRequest = monitoringPortalRequest;
    }

    @Override
    public boolean isFilterEnabled() {
        if (!super.isFilterEnabled()) {
            return false;
        }
        return _monitoringPortalRequest;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        PortalRequestDataSample portalRequestDataSample = new PortalRequestDataSample(companyId, request.getRemoteUser(), request.getRequestURI(), request.getRequestURL().toString());
        try {
            try {
                portalRequestDataSample.prepare();
                this.processFilter(MonitoringFilter.class, request, response, filterChain);
                portalRequestDataSample.capture(RequestStatus.SUCCESS);
            }
            catch (Exception e2) {
                portalRequestDataSample.capture(RequestStatus.ERROR);
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                if (e2 instanceof ServletException) {
                    throw (ServletException)((Object)e2);
                }
                throw new ServletException("Unable to execute request", (Throwable)e2);
            }
        }
        finally {
            MessageBusUtil.sendMessage((String)"liferay/monitoring", (Object)portalRequestDataSample);
            DataSampleThreadLocal.addDataSample((DataSample)portalRequestDataSample);
        }
    }
}

