/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.i18n;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.User;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class I18nFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(I18nFilter.class.getName()) + "SKIP_FILTER";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static Log _log = LogFactoryUtil.getLog(I18nFilter.class);
    private static Set<String> _languageIds;

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Set<String> languageIds) {
        _languageIds = new HashSet<String>();
        for (String languageId : languageIds) {
            languageId = languageId.substring(1);
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return !this.isAlreadyFiltered(request) && !this.isForwardedByI18nServlet(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getRedirect(HttpServletRequest request) throws Exception {
        String queryString;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
            return null;
        }
        String method = request.getMethod();
        if (method.equals("POST")) {
            return null;
        }
        String contextPath = PortalUtil.getPathContext();
        String requestURI = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String i18nLanguageId = requestURI.substring(1);
        int pos = requestURI.indexOf(47, 1);
        if (pos != -1) {
            i18nLanguageId = i18nLanguageId.substring(0, pos - 1);
        }
        if (_languageIds.contains(i18nLanguageId)) {
            return null;
        }
        String guestLanguageId = null;
        User user = (User)request.getAttribute("USER");
        if (user != null) {
            guestLanguageId = user.getLanguageId();
        }
        if (Validator.isNull(guestLanguageId)) {
            guestLanguageId = CookieKeys.getCookie((HttpServletRequest)request, (String)"GUEST_LANGUAGE_ID", (boolean)false);
        }
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (Validator.isNull((String)guestLanguageId)) {
            guestLanguageId = defaultLanguageId;
        }
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1) {
            if (defaultLanguageId.equals(guestLanguageId)) return null;
            i18nLanguageId = guestLanguageId;
        } else if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nLanguageId = LocaleUtil.toLanguageId((Locale)PortalUtil.getLocale((HttpServletRequest)request));
        }
        if (i18nLanguageId == null) {
            return null;
        }
        Locale locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
            return null;
        }
        String i18nPathLanguageId = PortalUtil.getI18nPathLanguageId((Locale)locale, (String)i18nLanguageId);
        String i18nPath = "/".concat(i18nPathLanguageId);
        if (requestURI.contains(i18nPath.concat("/"))) {
            return null;
        }
        String redirect = String.valueOf(contextPath) + i18nPath + requestURI;
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && (requestURI.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING) || requestURI.startsWith(_PRIVATE_USER_SERVLET_MAPPING) || requestURI.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING))) {
            int y;
            int x = requestURI.indexOf("/", 1);
            if (x == -1) {
                requestURI = String.valueOf(requestURI) + "/";
                x = requestURI.indexOf(47, 1);
            }
            if ((y = requestURI.indexOf(47, x + 1)) == -1) {
                requestURI = String.valueOf(requestURI) + "/";
                y = requestURI.indexOf(47, x + 1);
            }
            String groupFriendlyURL = requestURI.substring(x, y);
            Group group = layoutSet.getGroup();
            if (group.getFriendlyURL().equals(groupFriendlyURL)) {
                redirect = String.valueOf(contextPath) + i18nPath + requestURI.substring(y);
            }
        }
        if (!Validator.isNotNull((String)(queryString = request.getQueryString()))) return redirect;
        return String.valueOf(redirect) + "?" + request.getQueryString();
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isForwardedByI18nServlet(HttpServletRequest request) {
        return request.getAttribute("I18N_LANGUAGE_ID") != null || request.getAttribute("I18N_PATH") != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String redirect = this.getRedirect(request);
        if (redirect == null) {
            this.processFilter(I18nFilter.class, request, response, filterChain);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        response.sendRedirect(redirect);
    }
}

