/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import java.nio.ByteBuffer;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    private static final String _ETAG = "etag";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return ParamUtil.getBoolean((HttpServletRequest)request, (String)_ETAG, (boolean)true);
    }

    protected boolean isEligibleForEtag(int status) {
        return status >= 200 && status < 300;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        this.processFilter(ETagFilter.class, request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        ByteBuffer byteBuffer = bufferCacheServletResponse.getByteBuffer();
        if (!this.isEligibleForEtag(bufferCacheServletResponse.getStatus()) || !ETagUtil.processETag(request, response, byteBuffer)) {
            bufferCacheServletResponse.finishResponse();
            bufferCacheServletResponse.outputBuffer();
        }
    }
}

