/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.compoundsessionid;

import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitter;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;

public class CompoundSessionIdSplitterImpl
implements CompoundSessionIdSplitter {
    private static String _sessionIdDelimiter;

    static {
        String sessionIdDelimiter = PropsValues.SESSION_ID_DELIMITER;
        if (Validator.isNull((String)sessionIdDelimiter)) {
            _sessionIdDelimiter = PropsUtil.get((String)("session.id." + ServerDetector.getServerId() + " .delimiter"));
        }
        if (_sessionIdDelimiter == null) {
            _sessionIdDelimiter = "";
        }
        _sessionIdDelimiter = sessionIdDelimiter;
    }

    public String getSessionIdDelimiter() {
        return _sessionIdDelimiter;
    }

    public boolean hasSessionDelimiter() {
        return Validator.isNotNull((String)_sessionIdDelimiter);
    }

    public String parseSessionId(String sessionId) {
        if (Validator.isNull((String)_sessionIdDelimiter)) {
            return sessionId;
        }
        int pos = sessionId.indexOf(_sessionIdDelimiter);
        if (pos == -1) {
            return sessionId;
        }
        return sessionId.substring(0, pos);
    }
}

