/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.aggregate.AggregateContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import javax.servlet.ServletContext;

public class ServletAggregateContext
implements AggregateContext {
    private static Log _log = LogFactoryUtil.getLog(ServletAggregateContext.class);
    private ServletContext _servletContext;
    private Stack<String> _stack = new Stack();

    public ServletAggregateContext(ServletContext servletContext, String resourcePath) throws IOException {
        this._servletContext = servletContext;
        String rootPath = ServletContextUtil.getRootPath((ServletContext)this._servletContext);
        int pos = resourcePath.lastIndexOf("/");
        if (pos > 0) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        pos = resourcePath.lastIndexOf("/");
        if ((pos = (resourcePath = resourcePath.substring(0, pos)).lastIndexOf(rootPath)) == 0) {
            resourcePath = resourcePath.substring(rootPath.length());
        }
        this._stack.push(resourcePath);
    }

    @Override
    public String getContent(String path) {
        URL resourceURL;
        block3: {
            try {
                String stackPath = this._generatePathFromStack();
                resourceURL = null;
                resourceURL = Validator.isUrl((String)path) ? new URL(path) : this._servletContext.getResource(stackPath.concat(path));
                if (resourceURL != null) break block3;
                return null;
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
                return null;
            }
        }
        URLConnection urlConnection = resourceURL.openConnection();
        return StringUtil.read((InputStream)urlConnection.getInputStream());
    }

    @Override
    public String getFullPath(String path) {
        String stackPath = this._generatePathFromStack();
        return stackPath.concat(path);
    }

    @Override
    public void popPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._stack.pop();
        }
    }

    @Override
    public void pushPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._stack.push(path);
        }
    }

    private String _generatePathFromStack() {
        StringBundler sb = new StringBundler();
        for (String path : this._stack) {
            sb.append(path);
            if (path.endsWith("/")) continue;
            sb.append("/");
        }
        return StringUtil.replace((String)sb.toString(), (String)"//", (String)"/");
    }
}

