/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.aggregate.AggregateContext;
import java.io.File;
import java.io.IOException;

public class FileAggregateContext
implements AggregateContext {
    private static Log _log = LogFactoryUtil.getLog(FileAggregateContext.class);
    private File _file;

    public FileAggregateContext(File file) {
        this._file = file.getParentFile();
    }

    @Override
    public String getContent(String path) {
        try {
            File file = new File(this._file, path);
            return FileUtil.read((File)file);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            return null;
        }
    }

    @Override
    public String getFullPath(String path) {
        String absolutePath = this._file.getAbsolutePath();
        return absolutePath.concat(path);
    }

    @Override
    public void popPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._file = this._file.getParentFile();
        }
    }

    @Override
    public void pushPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._file = new File(this._file, path);
        }
    }
}

