/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.absoluteredirects;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.TryFilter;
import com.liferay.portal.kernel.servlet.WrapHttpServletResponseFilter;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AbsoluteRedirectsFilter
extends BasePortalFilter
implements TryFilter,
WrapHttpServletResponseFilter {
    private static final boolean _FILTER_ENABLED = true;
    private static Log _log = LogFactoryUtil.getLog(AbsoluteRedirectsFilter.class);

    public Object doFilterTry(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setCharacterEncoding("UTF-8");
        long companyId = PortalInstances.getCompanyId(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id " + companyId));
        }
        PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
        PortalUtil.getCurrentURL((HttpServletRequest)request);
        HttpSession session = request.getSession();
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null) {
            httpsInitial = request.isSecure();
            session.setAttribute("HTTPS_INITIAL", (Object)httpsInitial);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting httpsInitial to " + httpsInitial));
            }
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        return null;
    }

    public HttpServletResponse getWrappedHttpServletResponse(HttpServletRequest request, HttpServletResponse response) {
        return new AbsoluteRedirectsResponse(request, response);
    }

    @Override
    public boolean isFilterEnabled() {
        return true;
    }
}

