/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.security.ac.AccessControlThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(TunnelServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object returnObj;
        block17: {
            boolean remoteAccess;
            block15: {
                MethodHandler methodHandler;
                block16: {
                    ObjectInputStream ois;
                    try {
                        ois = new ObjectInputStream((InputStream)request.getInputStream());
                    }
                    catch (IOException ioe) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)ioe, (Throwable)ioe);
                        }
                        return;
                    }
                    returnObj = null;
                    remoteAccess = AccessControlThreadLocal.isRemoteAccess();
                    AccessControlThreadLocal.setRemoteAccess((boolean)true);
                    ObjectValuePair ovp = (ObjectValuePair)ois.readObject();
                    methodHandler = (MethodHandler)ovp.getValue();
                    if (methodHandler == null) break block15;
                    MethodKey methodKey = methodHandler.getMethodKey();
                    if (this.isValidRequest(methodKey.getDeclaringClass())) break block16;
                    AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
                    return;
                }
                try {
                    returnObj = methodHandler.invoke(true);
                }
                catch (InvocationTargetException ite) {
                    returnObj = ite.getCause();
                    if (!(returnObj instanceof PortalException)) {
                        ite.printStackTrace();
                        returnObj = new SystemException();
                    }
                    AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
                    break block17;
                }
                catch (Exception e2) {
                    try {
                        _log.error((Object)e2, (Throwable)e2);
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
                    }
                }
            }
            AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
        }
        if (returnObj != null) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
                oos.writeObject(returnObj);
                oos.flush();
                oos.close();
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
                throw ioe;
            }
        }
    }

    protected boolean isValidRequest(Class<?> clazz) {
        String className = clazz.getName();
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

