/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdHttpSession;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.servlet.JettySharedSessionWrapper;
import com.liferay.portal.servlet.SharedSessionWrapper;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SharedSessionServletRequest
extends HttpServletRequestWrapper {
    private HttpSession _portalSession;
    private boolean _shared;

    public SharedSessionServletRequest(HttpServletRequest request, boolean shared) {
        super(request);
        this._portalSession = request.getSession();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && !(this._portalSession instanceof CompoundSessionIdHttpSession)) {
            this._portalSession = new CompoundSessionIdHttpSession(this._portalSession);
        }
        this._shared = shared;
    }

    public HttpSession getSession() {
        this.checkPortalSession();
        if (this._shared || this.isPortletConfigurationPortlet()) {
            return this._portalSession;
        }
        return this.getSharedSessionWrapper(this._portalSession, super.getSession());
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            this.checkPortalSession();
        }
        if (this._shared || this.isPortletConfigurationPortlet()) {
            return this._portalSession;
        }
        HttpSession portletSession = super.getSession(create);
        if (portletSession != null) {
            return this.getSharedSessionWrapper(this._portalSession, portletSession);
        }
        return null;
    }

    public HttpSession getSharedSession() {
        return this._portalSession;
    }

    protected void checkPortalSession() {
        try {
            this._portalSession.isNew();
        }
        catch (IllegalStateException illegalStateException) {
            this._portalSession = super.getSession(true);
        }
    }

    protected HttpSession getSharedSessionWrapper(HttpSession portalSession, HttpSession portletSession) {
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && !(portalSession instanceof CompoundSessionIdHttpSession)) {
            portalSession = new CompoundSessionIdHttpSession(portalSession);
        }
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && !(portletSession instanceof CompoundSessionIdHttpSession)) {
            portletSession = new CompoundSessionIdHttpSession(portletSession);
        }
        if (ServerDetector.isJetty()) {
            return new JettySharedSessionWrapper(portalSession, portletSession);
        }
        return new SharedSessionWrapper(portalSession, portletSession);
    }

    protected boolean isPortletConfigurationPortlet() {
        String namespace = PortalUtil.getPortletNamespace((String)"86");
        String portletResource = ParamUtil.getString((HttpServletRequest)this, (String)(String.valueOf(namespace) + "portletResource"));
        if (Validator.isNull((String)portletResource)) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = null;
        try {
            portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
        }
        catch (Exception exception) {}
        if (portlet == null) {
            return false;
        }
        PortletApp portletApp = portlet.getPortletApp();
        return portletApp.isWARFile();
    }
}

