/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_DIR = "html/js";
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private static Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private PortalCache<String, byte[][]> _bytesArrayPortalCache = SingleVMPoolUtil.getCache((String)ComboServlet.class.getName());
    private PortalCache<String, FileContentBag> _fileContentBagPortalCache = SingleVMPoolUtil.getCache((String)FileContentBag.class.getName());
    private Set<String> _protectedParameters = SetUtil.fromArray((Object[])new String[]{"b", "browserId", "minifierType", "languageId", "t"});

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doService(request, response);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LinkedHashSet<String> modulePathsSet = new LinkedHashSet<String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (this._protectedParameters.contains(name)) continue;
            modulePathsSet.add(name);
        }
        if (modulePathsSet.size() == 0) {
            response.sendError(400);
            return;
        }
        Object[] modulePaths = modulePathsSet.toArray(new String[modulePathsSet.size()]);
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            bytesArray = (byte[][])this._bytesArrayPortalCache.get((Serializable)((Object)modulePathsString));
        }
        Object firstModulePath = modulePaths[0];
        String extension = FileUtil.getExtension((String)firstModulePath);
        if (bytesArray == null) {
            ServletContext servletContext = this.getServletContext();
            String rootPath = ServletContextUtil.getRootPath((ServletContext)servletContext);
            String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
            if (Validator.isNull((String)minifierType)) {
                minifierType = "js";
                if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
                    minifierType = _CSS_EXTENSION;
                }
            }
            if (!minifierType.equals(_CSS_EXTENSION) && !minifierType.equals("js")) {
                minifierType = "js";
            }
            bytesArray = new byte[modulePaths.length][];
            int i2 = 0;
            while (i2 < modulePaths.length) {
                Object modulePath = modulePaths[i2];
                if (!this.validateModuleExtension((String)modulePath)) {
                    response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    response.setStatus(404);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    URL url = this.getResourceURL(servletContext, rootPath, (String)(modulePath = StringUtil.replaceFirst((String)modulePath, (String)PortalUtil.getPathContext(), (String)"")));
                    if (url == null) {
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        response.setStatus(404);
                        return;
                    }
                    bytes = this.getResourceContent(request, response, url, (String)modulePath, minifierType);
                }
                bytesArray[i2] = bytes;
                ++i2;
            }
            if (modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                this._bytesArrayPortalCache.put((Serializable)((Object)modulePathsString), bytesArray);
            }
        }
        String contentType = "text/javascript";
        if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
            contentType = "text/css";
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected byte[] getResourceContent(HttpServletRequest request, HttpServletResponse response, URL resourceURL, String resourcePath, String minifierType) throws IOException {
        String fileContentKey = resourcePath.concat("?").concat(minifierType);
        FileContentBag fileContentBag = (FileContentBag)this._fileContentBagPortalCache.get((Serializable)((Object)fileContentKey));
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        URLConnection urlConnection = null;
        if (resourceURL != null) {
            urlConnection = resourceURL.openConnection();
        }
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (urlConnection != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && urlConnection.getLastModified() == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            this._fileContentBagPortalCache.remove((Serializable)((Object)fileContentKey));
        }
        if (resourceURL == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            String stringFileContent = StringUtil.read((InputStream)urlConnection.getInputStream());
            if (!StringUtil.endsWith((String)resourcePath, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    try {
                        stringFileContent = DynamicCSSUtil.parseSass(this.getServletContext(), request, resourcePath, stringFileContent);
                    }
                    catch (Exception e2) {
                        _log.error((Object)("Unable to parse SASS on CSS " + resourceURL.getPath()), (Throwable)e2);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(stringFileContent);
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), urlConnection.getLastModified());
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            this._fileContentBagPortalCache.put((Serializable)((Object)fileContentKey), (Object)fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected URL getResourceURL(ServletContext servletContext, String rootPath, String path) throws Exception {
        URL url = servletContext.getResource(path);
        if (url == null) {
            return null;
        }
        String filePath = ServletContextUtil.getResourcePath((URL)url);
        int pos = filePath.indexOf(rootPath.concat("/").concat(_JAVASCRIPT_DIR));
        if (pos == 0) {
            return url;
        }
        return null;
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        String[] fileExtensions;
        boolean validModuleExtension = false;
        String[] stringArray = fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",");
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension = stringArray[n2];
            if ("*".equals(fileExtension) || StringUtil.endsWith((String)moduleName, (String)fileExtension)) {
                validModuleExtension = true;
                break;
            }
            ++n2;
        }
        return validModuleExtension;
    }

    private static class FileContentBag
    implements Serializable {
        private byte[] _fileContent;
        private long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

